/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Organization;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.usersadmin.search.OrganizationDisplayTerms;
import com.liferay.portlet.usersadmin.search.OrganizationSearchTerms;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationSearch
extends SearchContainer<Organization> {
    static List<String> headerNames = new ArrayList<String>();
    static Map<String, String> orderableHeaders = new HashMap<String, String>();
    public static final String EMPTY_RESULTS_MESSAGE = "no-organizations-were-found";
    private static Log _log;

    static {
        headerNames.add("name");
        headerNames.add("parent-organization");
        headerNames.add("type");
        headerNames.add("city");
        headerNames.add("region");
        headerNames.add("country");
        orderableHeaders.put("name", "name");
        orderableHeaders.put("type", "type");
        _log = LogFactoryUtil.getLog(OrganizationSearch.class);
    }

    public OrganizationSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new OrganizationDisplayTerms(portletRequest), (DisplayTerms)new OrganizationSearchTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        OrganizationDisplayTerms displayTerms = (OrganizationDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("city", displayTerms.getCity());
        iteratorURL.setParameter("countryId", String.valueOf(displayTerms.getCountryId()));
        iteratorURL.setParameter("name", displayTerms.getName());
        iteratorURL.setParameter("parentOrganizationId", String.valueOf(displayTerms.getParentOrganizationId()));
        iteratorURL.setParameter("regionId", String.valueOf(displayTerms.getRegionId()));
        iteratorURL.setParameter("street", displayTerms.getStreet());
        iteratorURL.setParameter("zip", displayTerms.getZip());
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue("125", "organizations-order-by-col", orderByCol);
                preferences.setValue("125", "organizations-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue("125", "organizations-order-by-col", "name");
                orderByType = preferences.getValue("125", "organizations-order-by-type", "asc");
            }
            OrderByComparator orderByComparator = UsersAdminUtil.getOrganizationOrderByComparator((String)orderByCol, (String)orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }
}

