/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.action;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.usersadmin.search.UserSearch;
import com.liferay.portlet.usersadmin.search.UserSearchTerms;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportUsersAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            String csv = this.getUsersCSV(actionRequest, actionResponse);
            String fileName = "users.csv";
            byte[] bytes = csv.getBytes();
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (byte[])bytes, (String)"text/csv; charset=UTF-8");
            this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
        }
        catch (Exception e) {
            SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            this.setForward((PortletRequest)actionRequest, "portlet.users_admin.error");
        }
    }

    protected String getUserCSV(User user) {
        StringBundler sb = new StringBundler(PropsValues.USERS_EXPORT_CSV_FIELDS.length * 2);
        int i = 0;
        while (i < PropsValues.USERS_EXPORT_CSV_FIELDS.length) {
            String field = PropsValues.USERS_EXPORT_CSV_FIELDS[i];
            if (field.equals("fullName")) {
                sb.append(CSVUtil.encode((String)user.getFullName()));
            } else if (field.startsWith("expando:")) {
                String attributeName = field.substring(8);
                ExpandoBridge expandoBridge = user.getExpandoBridge();
                sb.append(CSVUtil.encode((Object)expandoBridge.getAttribute(attributeName)));
            } else {
                sb.append(CSVUtil.encode((String)BeanPropertiesUtil.getString((Object)user, (String)field)));
            }
            if (i + 1 < PropsValues.USERS_EXPORT_CSV_FIELDS.length) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("\n");
        return sb.toString();
    }

    protected List<User> getUsers(ActionRequest actionRequest, ActionResponse actionResponse, ThemeDisplay themeDisplay) throws Exception {
        long userGroupId;
        long roleId;
        LiferayPortletURL portletURL = ((ActionResponseImpl)actionResponse).createRenderURL("125");
        UserSearch userSearch = new UserSearch((PortletRequest)actionRequest, (PortletURL)portletURL);
        UserSearchTerms searchTerms = (UserSearchTerms)userSearch.getSearchTerms();
        searchTerms.setStatus(0);
        LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>();
        long organizationId = searchTerms.getOrganizationId();
        if (organizationId > 0L) {
            params.put("usersOrgs", new Long(organizationId));
        }
        if ((roleId = searchTerms.getRoleId()) > 0L) {
            params.put("usersRoles", new Long(roleId));
        }
        if ((userGroupId = searchTerms.getUserGroupId()) > 0L) {
            params.put("usersUserGroups", new Long(userGroupId));
        }
        if (searchTerms.isAdvancedSearch()) {
            return UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getFirstName(), (String)searchTerms.getMiddleName(), (String)searchTerms.getLastName(), (String)searchTerms.getScreenName(), (String)searchTerms.getEmailAddress(), (int)searchTerms.getStatus(), params, (boolean)searchTerms.isAndOperator(), (int)-1, (int)-1, null);
        }
        return UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), params, (int)-1, (int)-1, null);
    }

    protected String getUsersCSV(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"EXPORT_USER")) {
            return "";
        }
        String exportProgressId = ParamUtil.getString((PortletRequest)actionRequest, (String)"exportProgressId");
        ProgressTracker progressTracker = new ProgressTracker((PortletRequest)actionRequest, exportProgressId);
        progressTracker.start();
        List<User> users = this.getUsers(actionRequest, actionResponse, themeDisplay);
        int percentage = 10;
        int total = users.size();
        progressTracker.updateProgress(percentage);
        if (total == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(users.size() * 4);
        Iterator<User> itr = users.iterator();
        int i = 0;
        while (itr.hasNext()) {
            User user = itr.next();
            sb.append(this.getUserCSV(user));
            percentage = Math.min(10 + i * 90 / total, 99);
            progressTracker.updateProgress(percentage);
            ++i;
        }
        progressTracker.finish();
        return sb.toString();
    }
}

