/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.stagingbar.action;

import com.liferay.portal.LayoutBranchNameException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutBranchServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portlet.layoutsadmin.action.EditLayoutsAction;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditLayoutBranchAction
extends EditLayoutsAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.checkPermissions((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateLayoutBranch(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteLayoutBranch(actionRequest, portletConfig);
            }
            if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".refreshPortlet"), (Object)"170");
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("preventNotification", Boolean.TRUE.toString());
                SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".refreshPortletData"), data);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof LayoutBranchNameException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
                this.sendRedirect(actionRequest, actionResponse);
            }
            if (e instanceof PrincipalException || e instanceof SystemException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.staging_bar.error");
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            this.checkPermissions((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.staging_bar.error");
        }
        try {
            this.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.staging_bar.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.staging_bar.edit_layout_branch"));
    }

    protected void deleteLayoutBranch(ActionRequest actionRequest, PortletConfig portletConfig) throws Exception {
        long layoutBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutBranchId");
        long currentLayoutBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"currentLayoutBranchId");
        LayoutBranchServiceUtil.deleteLayoutBranch((long)layoutBranchId);
        SessionMessages.add((PortletRequest)actionRequest, (String)"pageVariationDeleted");
        if (layoutBranchId == currentLayoutBranchId) {
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".portletNotAjaxable"));
        }
    }

    protected void updateLayoutBranch(ActionRequest actionRequest) throws Exception {
        long layoutBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutBranchId");
        long layoutRevisionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"copyLayoutRevisionId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (layoutBranchId <= 0L) {
            LayoutBranchServiceUtil.addLayoutBranch((long)layoutRevisionId, (String)name, (String)description, (boolean)false, (ServiceContext)serviceContext);
            SessionMessages.add((PortletRequest)actionRequest, (String)"pageVariationAdded");
        } else {
            LayoutBranchServiceUtil.updateLayoutBranch((long)layoutBranchId, (String)name, (String)description, (ServiceContext)serviceContext);
            SessionMessages.add((PortletRequest)actionRequest, (String)"pageVariationUpdated");
        }
    }
}

