/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQueryFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.softwarecatalog.NoSuchProductVersionException;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.model.impl.SCFrameworkVersionImpl;
import com.liferay.portlet.softwarecatalog.model.impl.SCFrameworkVersionModelImpl;
import com.liferay.portlet.softwarecatalog.model.impl.SCProductVersionImpl;
import com.liferay.portlet.softwarecatalog.model.impl.SCProductVersionModelImpl;
import com.liferay.portlet.softwarecatalog.service.persistence.SCFrameworkVersionPersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCLicensePersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCProductEntryPersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCProductScreenshotPersistence;
import com.liferay.portlet.softwarecatalog.service.persistence.SCProductVersionPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCProductVersionPersistenceImpl
extends BasePersistenceImpl<SCProductVersion>
implements SCProductVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = SCProductVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_PRODUCTENTRYID = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED, SCProductVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByProductEntryId", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PRODUCTENTRYID = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED, SCProductVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByProductEntryId", new String[]{Long.class.getName()}, SCProductVersionModelImpl.PRODUCTENTRYID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_PRODUCTENTRYID = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByProductEntryId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED, SCProductVersionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByDirectDownloadURL", new String[]{String.class.getName()}, SCProductVersionModelImpl.DIRECTDOWNLOADURL_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_DIRECTDOWNLOADURL = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByDirectDownloadURL", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED, SCProductVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED, SCProductVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_GET_SCFRAMEWORKVERSIONS = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED_SCFRAMEWORKVERSI_SCPRODUCTVERS, SCFrameworkVersionImpl.class, "SCFrameworkVersi_SCProductVers", "getSCFrameworkVersions", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_GET_SCFRAMEWORKVERSIONS_SIZE = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED_SCFRAMEWORKVERSI_SCPRODUCTVERS, Long.class, "SCFrameworkVersi_SCProductVers", "getSCFrameworkVersionsSize", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_CONTAINS_SCFRAMEWORKVERSION = new FinderPath(SCFrameworkVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionModelImpl.FINDER_CACHE_ENABLED_SCFRAMEWORKVERSI_SCPRODUCTVERS, Boolean.class, "SCFrameworkVersi_SCProductVers", "containsSCFrameworkVersion", new String[]{Long.class.getName(), Long.class.getName()});
    @BeanReference(type=SCFrameworkVersionPersistence.class)
    protected SCFrameworkVersionPersistence scFrameworkVersionPersistence;
    @BeanReference(type=SCLicensePersistence.class)
    protected SCLicensePersistence scLicensePersistence;
    @BeanReference(type=SCProductEntryPersistence.class)
    protected SCProductEntryPersistence scProductEntryPersistence;
    @BeanReference(type=SCProductScreenshotPersistence.class)
    protected SCProductScreenshotPersistence scProductScreenshotPersistence;
    @BeanReference(type=SCProductVersionPersistence.class)
    protected SCProductVersionPersistence scProductVersionPersistence;
    @BeanReference(type=ResourcePersistence.class)
    protected ResourcePersistence resourcePersistence;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    protected ContainsSCFrameworkVersion containsSCFrameworkVersion;
    protected AddSCFrameworkVersion addSCFrameworkVersion;
    protected ClearSCFrameworkVersions clearSCFrameworkVersions;
    protected RemoveSCFrameworkVersion removeSCFrameworkVersion;
    private static final String _SQL_SELECT_SCPRODUCTVERSION = "SELECT scProductVersion FROM SCProductVersion scProductVersion";
    private static final String _SQL_SELECT_SCPRODUCTVERSION_WHERE = "SELECT scProductVersion FROM SCProductVersion scProductVersion WHERE ";
    private static final String _SQL_COUNT_SCPRODUCTVERSION = "SELECT COUNT(scProductVersion) FROM SCProductVersion scProductVersion";
    private static final String _SQL_COUNT_SCPRODUCTVERSION_WHERE = "SELECT COUNT(scProductVersion) FROM SCProductVersion scProductVersion WHERE ";
    private static final String _SQL_GETSCFRAMEWORKVERSIONS = "SELECT {SCFrameworkVersion.*} FROM SCFrameworkVersion INNER JOIN SCFrameworkVersi_SCProductVers ON (SCFrameworkVersi_SCProductVers.frameworkVersionId = SCFrameworkVersion.frameworkVersionId) WHERE (SCFrameworkVersi_SCProductVers.productVersionId = ?)";
    private static final String _SQL_GETSCFRAMEWORKVERSIONSSIZE = "SELECT COUNT(*) AS COUNT_VALUE FROM SCFrameworkVersi_SCProductVers WHERE productVersionId = ?";
    private static final String _SQL_CONTAINSSCFRAMEWORKVERSION = "SELECT COUNT(*) AS COUNT_VALUE FROM SCFrameworkVersi_SCProductVers WHERE productVersionId = ? AND frameworkVersionId = ?";
    private static final String _FINDER_COLUMN_PRODUCTENTRYID_PRODUCTENTRYID_2 = "scProductVersion.productEntryId = ?";
    private static final String _FINDER_COLUMN_DIRECTDOWNLOADURL_DIRECTDOWNLOADURL_1 = "scProductVersion.directDownloadURL IS NULL";
    private static final String _FINDER_COLUMN_DIRECTDOWNLOADURL_DIRECTDOWNLOADURL_2 = "lower(scProductVersion.directDownloadURL) = lower(CAST_TEXT(?))";
    private static final String _FINDER_COLUMN_DIRECTDOWNLOADURL_DIRECTDOWNLOADURL_3 = "(scProductVersion.directDownloadURL IS NULL OR lower(scProductVersion.directDownloadURL) = lower(CAST_TEXT(?)))";
    private static final String _ORDER_BY_ENTITY_ALIAS = "scProductVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No SCProductVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No SCProductVersion exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = PropsValues.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE;
    private static Log _log = LogFactoryUtil.getLog(SCProductVersionPersistenceImpl.class);
    private static SCProductVersion _nullSCProductVersion = new SCProductVersionImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<SCProductVersion> toCacheModel() {
            return _nullSCProductVersionCacheModel;
        }
    };
    private static CacheModel<SCProductVersion> _nullSCProductVersionCacheModel = new CacheModel<SCProductVersion>(){

        public SCProductVersion toEntityModel() {
            return _nullSCProductVersion;
        }
    };

    public void cacheResult(SCProductVersion scProductVersion) {
        EntityCacheUtil.putResult((boolean)SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionImpl.class, (Serializable)Long.valueOf(scProductVersion.getPrimaryKey()), (Object)scProductVersion);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL, (Object[])new Object[]{scProductVersion.getDirectDownloadURL()}, (Object)scProductVersion);
        scProductVersion.resetOriginalValues();
    }

    public void cacheResult(List<SCProductVersion> scProductVersions) {
        for (SCProductVersion scProductVersion : scProductVersions) {
            if (EntityCacheUtil.getResult((boolean)SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionImpl.class, (Serializable)Long.valueOf(scProductVersion.getPrimaryKey())) == null) {
                this.cacheResult(scProductVersion);
                continue;
            }
            scProductVersion.resetOriginalValues();
        }
    }

    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear((String)SCProductVersionImpl.class.getName());
        }
        EntityCacheUtil.clearCache((String)SCProductVersionImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(SCProductVersion scProductVersion) {
        EntityCacheUtil.removeResult((boolean)SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionImpl.class, (Serializable)Long.valueOf(scProductVersion.getPrimaryKey()));
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache(scProductVersion);
    }

    public void clearCache(List<SCProductVersion> scProductVersions) {
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (SCProductVersion scProductVersion : scProductVersions) {
            EntityCacheUtil.removeResult((boolean)SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionImpl.class, (Serializable)Long.valueOf(scProductVersion.getPrimaryKey()));
            this.clearUniqueFindersCache(scProductVersion);
        }
    }

    protected void clearUniqueFindersCache(SCProductVersion scProductVersion) {
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL, (Object[])new Object[]{scProductVersion.getDirectDownloadURL()});
    }

    public SCProductVersion create(long productVersionId) {
        SCProductVersionImpl scProductVersion = new SCProductVersionImpl();
        scProductVersion.setNew(true);
        scProductVersion.setPrimaryKey(productVersionId);
        return scProductVersion;
    }

    public SCProductVersion remove(long productVersionId) throws NoSuchProductVersionException, SystemException {
        return this.remove(Long.valueOf(productVersionId));
    }

    public SCProductVersion remove(Serializable primaryKey) throws NoSuchProductVersionException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            SCProductVersion scProductVersion = (SCProductVersion)session.get(SCProductVersionImpl.class, primaryKey);
            if (scProductVersion == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchProductVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            SCProductVersion sCProductVersion = (SCProductVersion)this.remove((BaseModel)scProductVersion);
            return sCProductVersion;
        }
        catch (NoSuchProductVersionException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected SCProductVersion removeImpl(SCProductVersion scProductVersion) throws SystemException {
        scProductVersion = this.toUnwrappedModel(scProductVersion);
        try {
            try {
                this.clearSCFrameworkVersions.clear(scProductVersion.getPrimaryKey());
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.delete((Session)session, (BaseModel)scProductVersion);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        this.clearCache(scProductVersion);
        return scProductVersion;
    }

    public SCProductVersion updateImpl(SCProductVersion scProductVersion, boolean merge) throws SystemException {
        Object[] args;
        scProductVersion = this.toUnwrappedModel(scProductVersion);
        boolean isNew = scProductVersion.isNew();
        SCProductVersionModelImpl scProductVersionModelImpl = (SCProductVersionModelImpl)scProductVersion;
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.update((Session)session, (BaseModel)scProductVersion, (boolean)merge);
                scProductVersion.setNew(false);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !SCProductVersionModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if ((scProductVersionModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PRODUCTENTRYID.getColumnBitmask()) != 0L) {
            args = new Object[]{scProductVersionModelImpl.getOriginalProductEntryId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_PRODUCTENTRYID, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PRODUCTENTRYID, (Object[])args);
            args = new Object[]{scProductVersionModelImpl.getProductEntryId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_PRODUCTENTRYID, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PRODUCTENTRYID, (Object[])args);
        }
        EntityCacheUtil.putResult((boolean)SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionImpl.class, (Serializable)Long.valueOf(scProductVersion.getPrimaryKey()), (Object)scProductVersion);
        if (isNew) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL, (Object[])new Object[]{scProductVersion.getDirectDownloadURL()}, (Object)scProductVersion);
        } else if ((scProductVersionModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL.getColumnBitmask()) != 0L) {
            args = new Object[]{scProductVersionModelImpl.getOriginalDirectDownloadURL()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_DIRECTDOWNLOADURL, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL, (Object[])args);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL, (Object[])new Object[]{scProductVersion.getDirectDownloadURL()}, (Object)scProductVersion);
        }
        return scProductVersion;
    }

    protected SCProductVersion toUnwrappedModel(SCProductVersion scProductVersion) {
        if (scProductVersion instanceof SCProductVersionImpl) {
            return scProductVersion;
        }
        SCProductVersionImpl scProductVersionImpl = new SCProductVersionImpl();
        scProductVersionImpl.setNew(scProductVersion.isNew());
        scProductVersionImpl.setPrimaryKey(scProductVersion.getPrimaryKey());
        scProductVersionImpl.setProductVersionId(scProductVersion.getProductVersionId());
        scProductVersionImpl.setCompanyId(scProductVersion.getCompanyId());
        scProductVersionImpl.setUserId(scProductVersion.getUserId());
        scProductVersionImpl.setUserName(scProductVersion.getUserName());
        scProductVersionImpl.setCreateDate(scProductVersion.getCreateDate());
        scProductVersionImpl.setModifiedDate(scProductVersion.getModifiedDate());
        scProductVersionImpl.setProductEntryId(scProductVersion.getProductEntryId());
        scProductVersionImpl.setVersion(scProductVersion.getVersion());
        scProductVersionImpl.setChangeLog(scProductVersion.getChangeLog());
        scProductVersionImpl.setDownloadPageURL(scProductVersion.getDownloadPageURL());
        scProductVersionImpl.setDirectDownloadURL(scProductVersion.getDirectDownloadURL());
        scProductVersionImpl.setRepoStoreArtifact(scProductVersion.isRepoStoreArtifact());
        return scProductVersionImpl;
    }

    public SCProductVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public SCProductVersion findByPrimaryKey(long productVersionId) throws NoSuchProductVersionException, SystemException {
        SCProductVersion scProductVersion = this.fetchByPrimaryKey(productVersionId);
        if (scProductVersion == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + productVersionId));
            }
            throw new NoSuchProductVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + productVersionId);
        }
        return scProductVersion;
    }

    public SCProductVersion fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public SCProductVersion fetchByPrimaryKey(long productVersionId) throws SystemException {
        SCProductVersion scProductVersion = (SCProductVersion)EntityCacheUtil.getResult((boolean)SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionImpl.class, (Serializable)Long.valueOf(productVersionId));
        if (scProductVersion == _nullSCProductVersion) {
            return null;
        }
        if (scProductVersion == null) {
            Session session = null;
            boolean hasException = false;
            try {
                try {
                    session = this.openSession();
                    scProductVersion = (SCProductVersion)session.get(SCProductVersionImpl.class, (Serializable)Long.valueOf(productVersionId));
                }
                catch (Exception e) {
                    hasException = true;
                    throw this.processException(e);
                }
            }
            finally {
                if (scProductVersion != null) {
                    this.cacheResult(scProductVersion);
                } else if (!hasException) {
                    EntityCacheUtil.putResult((boolean)SCProductVersionModelImpl.ENTITY_CACHE_ENABLED, SCProductVersionImpl.class, (Serializable)Long.valueOf(productVersionId), (Object)_nullSCProductVersion);
                }
                this.closeSession(session);
            }
        }
        return scProductVersion;
    }

    public List<SCProductVersion> findByProductEntryId(long productEntryId) throws SystemException {
        return this.findByProductEntryId(productEntryId, -1, -1, null);
    }

    public List<SCProductVersion> findByProductEntryId(long productEntryId, int start, int end) throws SystemException {
        return this.findByProductEntryId(productEntryId, start, end, null);
    }

    public List<SCProductVersion> findByProductEntryId(long productEntryId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PRODUCTENTRYID;
            finderArgs = new Object[]{productEntryId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_PRODUCTENTRYID;
            finderArgs = new Object[]{productEntryId, start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_SCPRODUCTVERSION_WHERE);
            query.append(_FINDER_COLUMN_PRODUCTENTRYID_PRODUCTENTRYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY scProductVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(productEntryId);
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public SCProductVersion findByProductEntryId_First(long productEntryId, OrderByComparator orderByComparator) throws NoSuchProductVersionException, SystemException {
        List<SCProductVersion> list = this.findByProductEntryId(productEntryId, 0, 1, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("productEntryId=");
            msg.append(productEntryId);
            msg.append("}");
            throw new NoSuchProductVersionException(msg.toString());
        }
        return list.get(0);
    }

    public SCProductVersion findByProductEntryId_Last(long productEntryId, OrderByComparator orderByComparator) throws NoSuchProductVersionException, SystemException {
        int count = this.countByProductEntryId(productEntryId);
        List<SCProductVersion> list = this.findByProductEntryId(productEntryId, count - 1, count, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("productEntryId=");
            msg.append(productEntryId);
            msg.append("}");
            throw new NoSuchProductVersionException(msg.toString());
        }
        return list.get(0);
    }

    public SCProductVersion[] findByProductEntryId_PrevAndNext(long productVersionId, long productEntryId, OrderByComparator orderByComparator) throws NoSuchProductVersionException, SystemException {
        SCProductVersion scProductVersion = this.findByPrimaryKey(productVersionId);
        Session session = null;
        try {
            session = this.openSession();
            SCProductVersion[] array = new SCProductVersionImpl[]{this.getByProductEntryId_PrevAndNext(session, scProductVersion, productEntryId, orderByComparator, true), scProductVersion, this.getByProductEntryId_PrevAndNext(session, scProductVersion, productEntryId, orderByComparator, false)};
            SCProductVersion[] sCProductVersionArray = array;
            return sCProductVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected SCProductVersion getByProductEntryId_PrevAndNext(Session session, SCProductVersion scProductVersion, long productEntryId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_SCPRODUCTVERSION_WHERE);
        query.append(_FINDER_COLUMN_PRODUCTENTRYID_PRODUCTENTRYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            int i = 0;
            while (i < orderByConditionFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i;
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            int i2 = 0;
            while (i2 < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i2]);
                if (i2 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i2;
            }
        } else {
            query.append(" ORDER BY scProductVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(productEntryId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByConditionValues((Object)scProductVersion);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (SCProductVersion)list.get(1);
        }
        return null;
    }

    public SCProductVersion findByDirectDownloadURL(String directDownloadURL) throws NoSuchProductVersionException, SystemException {
        SCProductVersion scProductVersion = this.fetchByDirectDownloadURL(directDownloadURL);
        if (scProductVersion == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("directDownloadURL=");
            msg.append(directDownloadURL);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchProductVersionException(msg.toString());
        }
        return scProductVersion;
    }

    public SCProductVersion fetchByDirectDownloadURL(String directDownloadURL) throws SystemException {
        return this.fetchByDirectDownloadURL(directDownloadURL, true);
    }

    public SCProductVersion fetchByDirectDownloadURL(String directDownloadURL, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{directDownloadURL};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SCPRODUCTVERSION_WHERE);
            if (directDownloadURL == null) {
                query.append(_FINDER_COLUMN_DIRECTDOWNLOADURL_DIRECTDOWNLOADURL_1);
            } else if (directDownloadURL.equals("")) {
                query.append(_FINDER_COLUMN_DIRECTDOWNLOADURL_DIRECTDOWNLOADURL_3);
            } else {
                query.append(_FINDER_COLUMN_DIRECTDOWNLOADURL_DIRECTDOWNLOADURL_2);
            }
            query.append(" ORDER BY scProductVersion.createDate DESC");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (directDownloadURL != null) {
                    qPos.add(directDownloadURL);
                }
                List list = q.list();
                result = list;
                SCProductVersion scProductVersion = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL, (Object[])finderArgs, (Object)list);
                } else {
                    scProductVersion = (SCProductVersion)list.get(0);
                    this.cacheResult(scProductVersion);
                    if (scProductVersion.getDirectDownloadURL() == null || !scProductVersion.getDirectDownloadURL().equals(directDownloadURL)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL, (Object[])finderArgs, (Object)scProductVersion);
                    }
                }
                SCProductVersion sCProductVersion = scProductVersion;
                return sCProductVersion;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_DIRECTDOWNLOADURL, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (SCProductVersion)result;
    }

    public List<SCProductVersion> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<SCProductVersion> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<SCProductVersion> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        FinderPath finderPath = null;
        Object[] finderArgs = new Object[]{start, end, orderByComparator};
        if (start == -1 && end == -1 && orderByComparator == null) {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_SCPRODUCTVERSION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_SCPRODUCTVERSION.concat(" ORDER BY scProductVersion.createDate DESC");
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (orderByComparator == null) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByProductEntryId(long productEntryId) throws SystemException {
        for (SCProductVersion scProductVersion : this.findByProductEntryId(productEntryId)) {
            this.remove((BaseModel)scProductVersion);
        }
    }

    public void removeByDirectDownloadURL(String directDownloadURL) throws NoSuchProductVersionException, SystemException {
        SCProductVersion scProductVersion = this.findByDirectDownloadURL(directDownloadURL);
        this.remove((BaseModel)scProductVersion);
    }

    public void removeAll() throws SystemException {
        for (SCProductVersion scProductVersion : this.findAll()) {
            this.remove((BaseModel)scProductVersion);
        }
    }

    public int countByProductEntryId(long productEntryId) throws SystemException {
        Object[] finderArgs = new Object[]{productEntryId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_PRODUCTENTRYID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SCPRODUCTVERSION_WHERE);
            query.append(_FINDER_COLUMN_PRODUCTENTRYID_PRODUCTENTRYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(productEntryId);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_PRODUCTENTRYID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByDirectDownloadURL(String directDownloadURL) throws SystemException {
        Object[] finderArgs = new Object[]{directDownloadURL};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_DIRECTDOWNLOADURL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SCPRODUCTVERSION_WHERE);
            if (directDownloadURL == null) {
                query.append(_FINDER_COLUMN_DIRECTDOWNLOADURL_DIRECTDOWNLOADURL_1);
            } else if (directDownloadURL.equals("")) {
                query.append(_FINDER_COLUMN_DIRECTDOWNLOADURL_DIRECTDOWNLOADURL_3);
            } else {
                query.append(_FINDER_COLUMN_DIRECTDOWNLOADURL_DIRECTDOWNLOADURL_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (directDownloadURL != null) {
                        qPos.add(directDownloadURL);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_DIRECTDOWNLOADURL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_SCPRODUCTVERSION);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<SCFrameworkVersion> getSCFrameworkVersions(long pk) throws SystemException {
        return this.getSCFrameworkVersions(pk, -1, -1);
    }

    public List<SCFrameworkVersion> getSCFrameworkVersions(long pk, int start, int end) throws SystemException {
        return this.getSCFrameworkVersions(pk, start, end, null);
    }

    public List<SCFrameworkVersion> getSCFrameworkVersions(long pk, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{pk, start, end, orderByComparator};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_GET_SCFRAMEWORKVERSIONS, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    String sql = null;
                    sql = orderByComparator != null ? _SQL_GETSCFRAMEWORKVERSIONS.concat(" ORDER BY ").concat(orderByComparator.getOrderBy()) : _SQL_GETSCFRAMEWORKVERSIONS.concat(" ORDER BY SCFrameworkVersion.name DESC");
                    SQLQuery q = session.createSQLQuery(sql);
                    q.addEntity("SCFrameworkVersion", SCFrameworkVersionImpl.class);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(pk);
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_GET_SCFRAMEWORKVERSIONS, (Object[])finderArgs);
                } else {
                    this.scFrameworkVersionPersistence.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_GET_SCFRAMEWORKVERSIONS, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public int getSCFrameworkVersionsSize(long pk) throws SystemException {
        Object[] finderArgs = new Object[]{pk};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_GET_SCFRAMEWORKVERSIONS_SIZE, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    SQLQuery q = session.createSQLQuery(_SQL_GETSCFRAMEWORKVERSIONSSIZE);
                    q.addScalar("COUNT_VALUE", Type.LONG);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(pk);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_GET_SCFRAMEWORKVERSIONS_SIZE, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public boolean containsSCFrameworkVersion(long pk, long scFrameworkVersionPK) throws SystemException {
        Object[] finderArgs = new Object[]{pk, scFrameworkVersionPK};
        Boolean value = (Boolean)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_CONTAINS_SCFRAMEWORKVERSION, (Object[])finderArgs, (SessionFactory)this);
        if (value == null) {
            try {
                try {
                    value = this.containsSCFrameworkVersion.contains(pk, scFrameworkVersionPK);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (value == null) {
                    value = Boolean.FALSE;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_CONTAINS_SCFRAMEWORKVERSION, (Object[])finderArgs, (Object)value);
            }
        }
        return value;
    }

    public boolean containsSCFrameworkVersions(long pk) throws SystemException {
        return this.getSCFrameworkVersionsSize(pk) > 0;
    }

    public void addSCFrameworkVersion(long pk, long scFrameworkVersionPK) throws SystemException {
        try {
            try {
                this.addSCFrameworkVersion.add(pk, scFrameworkVersionPK);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void addSCFrameworkVersion(long pk, SCFrameworkVersion scFrameworkVersion) throws SystemException {
        try {
            try {
                this.addSCFrameworkVersion.add(pk, scFrameworkVersion.getPrimaryKey());
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void addSCFrameworkVersions(long pk, long[] scFrameworkVersionPKs) throws SystemException {
        try {
            try {
                long[] lArray = scFrameworkVersionPKs;
                int n = scFrameworkVersionPKs.length;
                int n2 = 0;
                while (n2 < n) {
                    long scFrameworkVersionPK = lArray[n2];
                    this.addSCFrameworkVersion.add(pk, scFrameworkVersionPK);
                    ++n2;
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void addSCFrameworkVersions(long pk, List<SCFrameworkVersion> scFrameworkVersions) throws SystemException {
        try {
            try {
                for (SCFrameworkVersion scFrameworkVersion : scFrameworkVersions) {
                    this.addSCFrameworkVersion.add(pk, scFrameworkVersion.getPrimaryKey());
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void clearSCFrameworkVersions(long pk) throws SystemException {
        try {
            try {
                this.clearSCFrameworkVersions.clear(pk);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void removeSCFrameworkVersion(long pk, long scFrameworkVersionPK) throws SystemException {
        try {
            try {
                this.removeSCFrameworkVersion.remove(pk, scFrameworkVersionPK);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void removeSCFrameworkVersion(long pk, SCFrameworkVersion scFrameworkVersion) throws SystemException {
        try {
            try {
                this.removeSCFrameworkVersion.remove(pk, scFrameworkVersion.getPrimaryKey());
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void removeSCFrameworkVersions(long pk, long[] scFrameworkVersionPKs) throws SystemException {
        try {
            try {
                long[] lArray = scFrameworkVersionPKs;
                int n = scFrameworkVersionPKs.length;
                int n2 = 0;
                while (n2 < n) {
                    long scFrameworkVersionPK = lArray[n2];
                    this.removeSCFrameworkVersion.remove(pk, scFrameworkVersionPK);
                    ++n2;
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void removeSCFrameworkVersions(long pk, List<SCFrameworkVersion> scFrameworkVersions) throws SystemException {
        try {
            try {
                for (SCFrameworkVersion scFrameworkVersion : scFrameworkVersions) {
                    this.removeSCFrameworkVersion.remove(pk, scFrameworkVersion.getPrimaryKey());
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void setSCFrameworkVersions(long pk, long[] scFrameworkVersionPKs) throws SystemException {
        try {
            try {
                Set scFrameworkVersionPKSet = SetUtil.fromArray((long[])scFrameworkVersionPKs);
                List<SCFrameworkVersion> scFrameworkVersions = this.getSCFrameworkVersions(pk);
                for (SCFrameworkVersion scFrameworkVersion : scFrameworkVersions) {
                    if (scFrameworkVersionPKSet.remove(scFrameworkVersion.getPrimaryKey())) continue;
                    this.removeSCFrameworkVersion.remove(pk, scFrameworkVersion.getPrimaryKey());
                }
                for (Long scFrameworkVersionPK : scFrameworkVersionPKSet) {
                    this.addSCFrameworkVersion.add(pk, scFrameworkVersionPK);
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void setSCFrameworkVersions(long pk, List<SCFrameworkVersion> scFrameworkVersions) throws SystemException {
        try {
            try {
                long[] scFrameworkVersionPKs = new long[scFrameworkVersions.size()];
                int i = 0;
                while (i < scFrameworkVersions.size()) {
                    SCFrameworkVersion scFrameworkVersion = scFrameworkVersions.get(i);
                    scFrameworkVersionPKs[i] = scFrameworkVersion.getPrimaryKey();
                    ++i;
                }
                this.setSCFrameworkVersions(pk, scFrameworkVersionPKs);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            FinderCacheUtil.clearCache((String)"SCFrameworkVersi_SCProductVers");
        }
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.softwarecatalog.model.SCProductVersion")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
        this.containsSCFrameworkVersion = new ContainsSCFrameworkVersion();
        this.addSCFrameworkVersion = new AddSCFrameworkVersion();
        this.clearSCFrameworkVersions = new ClearSCFrameworkVersions();
        this.removeSCFrameworkVersion = new RemoveSCFrameworkVersion();
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)SCProductVersionImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    protected class AddSCFrameworkVersion {
        private SqlUpdate _sqlUpdate;

        protected AddSCFrameworkVersion() {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)SCProductVersionPersistenceImpl.this.getDataSource(), (String)"INSERT INTO SCFrameworkVersi_SCProductVers (productVersionId, frameworkVersionId) VALUES (?, ?)", (int[])new int[]{-5, -5});
        }

        protected void add(long productVersionId, long frameworkVersionId) throws SystemException {
            if (!SCProductVersionPersistenceImpl.this.containsSCFrameworkVersion.contains(productVersionId, frameworkVersionId)) {
                ModelListener listener;
                ModelListener[] scFrameworkVersionListeners = SCProductVersionPersistenceImpl.this.scFrameworkVersionPersistence.getListeners();
                ModelListener[] modelListenerArray = SCProductVersionPersistenceImpl.this.listeners;
                int n = modelListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onBeforeAddAssociation((Object)productVersionId, SCFrameworkVersion.class.getName(), (Object)frameworkVersionId);
                    ++n2;
                }
                modelListenerArray = scFrameworkVersionListeners;
                n = scFrameworkVersionListeners.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onBeforeAddAssociation((Object)frameworkVersionId, SCProductVersion.class.getName(), (Object)productVersionId);
                    ++n2;
                }
                this._sqlUpdate.update(new Object[]{new Long(productVersionId), new Long(frameworkVersionId)});
                modelListenerArray = SCProductVersionPersistenceImpl.this.listeners;
                n = modelListenerArray.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onAfterAddAssociation((Object)productVersionId, SCFrameworkVersion.class.getName(), (Object)frameworkVersionId);
                    ++n2;
                }
                modelListenerArray = scFrameworkVersionListeners;
                n = scFrameworkVersionListeners.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onAfterAddAssociation((Object)frameworkVersionId, SCProductVersion.class.getName(), (Object)productVersionId);
                    ++n2;
                }
            }
        }
    }

    protected class ClearSCFrameworkVersions {
        private SqlUpdate _sqlUpdate;

        protected ClearSCFrameworkVersions() {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)SCProductVersionPersistenceImpl.this.getDataSource(), (String)"DELETE FROM SCFrameworkVersi_SCProductVers WHERE productVersionId = ?", (int[])new int[]{-5});
        }

        protected void clear(long productVersionId) throws SystemException {
            ModelListener listener;
            int n;
            int n2;
            ModelListener[] modelListenerArray;
            ModelListener[] scFrameworkVersionListeners = SCProductVersionPersistenceImpl.this.scFrameworkVersionPersistence.getListeners();
            List<SCFrameworkVersion> scFrameworkVersions = null;
            if (SCProductVersionPersistenceImpl.this.listeners.length > 0 || scFrameworkVersionListeners.length > 0) {
                scFrameworkVersions = SCProductVersionPersistenceImpl.this.getSCFrameworkVersions(productVersionId);
                for (SCFrameworkVersion scFrameworkVersion : scFrameworkVersions) {
                    modelListenerArray = SCProductVersionPersistenceImpl.this.listeners;
                    n2 = modelListenerArray.length;
                    n = 0;
                    while (n < n2) {
                        listener = modelListenerArray[n];
                        listener.onBeforeRemoveAssociation((Object)productVersionId, SCFrameworkVersion.class.getName(), (Object)scFrameworkVersion.getPrimaryKey());
                        ++n;
                    }
                    modelListenerArray = scFrameworkVersionListeners;
                    n2 = scFrameworkVersionListeners.length;
                    n = 0;
                    while (n < n2) {
                        listener = modelListenerArray[n];
                        listener.onBeforeRemoveAssociation((Object)scFrameworkVersion.getPrimaryKey(), SCProductVersion.class.getName(), (Object)productVersionId);
                        ++n;
                    }
                }
            }
            this._sqlUpdate.update(new Object[]{new Long(productVersionId)});
            if (SCProductVersionPersistenceImpl.this.listeners.length > 0 || scFrameworkVersionListeners.length > 0) {
                for (SCFrameworkVersion scFrameworkVersion : scFrameworkVersions) {
                    modelListenerArray = SCProductVersionPersistenceImpl.this.listeners;
                    n2 = modelListenerArray.length;
                    n = 0;
                    while (n < n2) {
                        listener = modelListenerArray[n];
                        listener.onAfterRemoveAssociation((Object)productVersionId, SCFrameworkVersion.class.getName(), (Object)scFrameworkVersion.getPrimaryKey());
                        ++n;
                    }
                    modelListenerArray = scFrameworkVersionListeners;
                    n2 = scFrameworkVersionListeners.length;
                    n = 0;
                    while (n < n2) {
                        listener = modelListenerArray[n];
                        listener.onAfterRemoveAssociation((Object)scFrameworkVersion.getPrimaryKey(), SCProductVersion.class.getName(), (Object)productVersionId);
                        ++n;
                    }
                }
            }
        }
    }

    protected class ContainsSCFrameworkVersion {
        private MappingSqlQuery<Integer> _mappingSqlQuery;

        protected ContainsSCFrameworkVersion() {
            this._mappingSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery((DataSource)SCProductVersionPersistenceImpl.this.getDataSource(), (String)SCProductVersionPersistenceImpl._SQL_CONTAINSSCFRAMEWORKVERSION, (int[])new int[]{-5, -5}, (RowMapper)RowMapper.COUNT);
        }

        protected boolean contains(long productVersionId, long frameworkVersionId) {
            Integer count;
            List results = this._mappingSqlQuery.execute(new Object[]{new Long(productVersionId), new Long(frameworkVersionId)});
            return results.size() > 0 && (count = (Integer)results.get(0)) > 0;
        }
    }

    protected class RemoveSCFrameworkVersion {
        private SqlUpdate _sqlUpdate;

        protected RemoveSCFrameworkVersion() {
            this._sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)SCProductVersionPersistenceImpl.this.getDataSource(), (String)"DELETE FROM SCFrameworkVersi_SCProductVers WHERE productVersionId = ? AND frameworkVersionId = ?", (int[])new int[]{-5, -5});
        }

        protected void remove(long productVersionId, long frameworkVersionId) throws SystemException {
            if (SCProductVersionPersistenceImpl.this.containsSCFrameworkVersion.contains(productVersionId, frameworkVersionId)) {
                ModelListener listener;
                ModelListener[] scFrameworkVersionListeners = SCProductVersionPersistenceImpl.this.scFrameworkVersionPersistence.getListeners();
                ModelListener[] modelListenerArray = SCProductVersionPersistenceImpl.this.listeners;
                int n = modelListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onBeforeRemoveAssociation((Object)productVersionId, SCFrameworkVersion.class.getName(), (Object)frameworkVersionId);
                    ++n2;
                }
                modelListenerArray = scFrameworkVersionListeners;
                n = scFrameworkVersionListeners.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onBeforeRemoveAssociation((Object)frameworkVersionId, SCProductVersion.class.getName(), (Object)productVersionId);
                    ++n2;
                }
                this._sqlUpdate.update(new Object[]{new Long(productVersionId), new Long(frameworkVersionId)});
                modelListenerArray = SCProductVersionPersistenceImpl.this.listeners;
                n = modelListenerArray.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onAfterRemoveAssociation((Object)productVersionId, SCFrameworkVersion.class.getName(), (Object)frameworkVersionId);
                    ++n2;
                }
                modelListenerArray = scFrameworkVersionListeners;
                n = scFrameworkVersionListeners.length;
                n2 = 0;
                while (n2 < n) {
                    listener = modelListenerArray[n2];
                    listener.onAfterRemoveAssociation((Object)frameworkVersionId, SCProductVersion.class.getName(), (Object)productVersionId);
                    ++n2;
                }
            }
        }
    }
}

