/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.HttpImpl;
import com.liferay.portlet.softwarecatalog.DuplicateProductVersionDirectDownloadURLException;
import com.liferay.portlet.softwarecatalog.ProductVersionChangeLogException;
import com.liferay.portlet.softwarecatalog.ProductVersionDownloadURLException;
import com.liferay.portlet.softwarecatalog.ProductVersionFrameworkVersionException;
import com.liferay.portlet.softwarecatalog.ProductVersionNameException;
import com.liferay.portlet.softwarecatalog.UnavailableProductVersionDirectDownloadURLException;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.service.base.SCProductVersionLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCProductVersionLocalServiceImpl
extends SCProductVersionLocalServiceBaseImpl {
    public SCProductVersion addProductVersion(long userId, long productEntryId, String version, String changeLog, String downloadPageURL, String directDownloadURL, boolean testDirectDownloadURL, boolean repoStoreArtifact, long[] frameworkVersionIds, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        SCProductEntry productEntry = this.scProductEntryPersistence.findByPrimaryKey(productEntryId);
        directDownloadURL = directDownloadURL.trim().toLowerCase();
        Date now = new Date();
        this.validate(0L, version, changeLog, downloadPageURL, directDownloadURL, testDirectDownloadURL, frameworkVersionIds);
        long productVersionId = this.counterLocalService.increment();
        SCProductVersion productVersion = this.scProductVersionPersistence.create(productVersionId);
        productVersion.setCompanyId(user.getCompanyId());
        productVersion.setUserId(user.getUserId());
        productVersion.setUserName(user.getFullName());
        productVersion.setCreateDate(now);
        productVersion.setModifiedDate(now);
        productVersion.setProductEntryId(productEntryId);
        productVersion.setVersion(version);
        productVersion.setChangeLog(changeLog);
        productVersion.setDownloadPageURL(downloadPageURL);
        productVersion.setDirectDownloadURL(directDownloadURL);
        productVersion.setRepoStoreArtifact(repoStoreArtifact);
        this.scProductVersionPersistence.update((BaseModel)productVersion, false);
        this.scProductVersionPersistence.setSCFrameworkVersions(productVersionId, frameworkVersionIds);
        productEntry.setModifiedDate(now);
        this.scProductEntryPersistence.update((BaseModel)productEntry, false);
        Indexer indexer = IndexerRegistryUtil.getIndexer(SCProductEntry.class);
        indexer.reindex((Object)productEntry);
        return productVersion;
    }

    public void deleteProductVersion(long productVersionId) throws PortalException, SystemException {
        SCProductVersion productVersion = this.scProductVersionPersistence.findByPrimaryKey(productVersionId);
        this.deleteProductVersion(productVersion);
    }

    public void deleteProductVersion(SCProductVersion productVersion) throws SystemException {
        this.scProductVersionPersistence.remove((BaseModel)productVersion);
    }

    public void deleteProductVersions(long productEntryId) throws SystemException {
        List productVersions = this.scProductVersionPersistence.findByProductEntryId(productEntryId);
        for (SCProductVersion productVersion : productVersions) {
            this.deleteProductVersion(productVersion);
        }
    }

    public SCProductVersion getProductVersion(long productVersionId) throws PortalException, SystemException {
        return this.scProductVersionPersistence.findByPrimaryKey(productVersionId);
    }

    public SCProductVersion getProductVersionByDirectDownloadURL(String directDownloadURL) throws PortalException, SystemException {
        return this.scProductVersionPersistence.findByDirectDownloadURL(directDownloadURL);
    }

    public List<SCProductVersion> getProductVersions(long productEntryId, int start, int end) throws SystemException {
        return this.scProductVersionPersistence.findByProductEntryId(productEntryId, start, end);
    }

    public int getProductVersionsCount(long productEntryId) throws SystemException {
        return this.scProductVersionPersistence.countByProductEntryId(productEntryId);
    }

    public SCProductVersion updateProductVersion(long productVersionId, String version, String changeLog, String downloadPageURL, String directDownloadURL, boolean testDirectDownloadURL, boolean repoStoreArtifact, long[] frameworkVersionIds) throws PortalException, SystemException {
        directDownloadURL = directDownloadURL.trim().toLowerCase();
        Date now = new Date();
        this.validate(productVersionId, version, changeLog, downloadPageURL, directDownloadURL, testDirectDownloadURL, frameworkVersionIds);
        SCProductVersion productVersion = this.scProductVersionPersistence.findByPrimaryKey(productVersionId);
        productVersion.setModifiedDate(now);
        productVersion.setVersion(version);
        productVersion.setChangeLog(changeLog);
        productVersion.setDownloadPageURL(downloadPageURL);
        productVersion.setDirectDownloadURL(directDownloadURL);
        productVersion.setRepoStoreArtifact(repoStoreArtifact);
        this.scProductVersionPersistence.update((BaseModel)productVersion, false);
        this.scProductVersionPersistence.setSCFrameworkVersions(productVersionId, frameworkVersionIds);
        SCProductEntry productEntry = this.scProductEntryPersistence.findByPrimaryKey(productVersion.getProductEntryId());
        productEntry.setModifiedDate(now);
        this.scProductEntryPersistence.update((BaseModel)productEntry, false);
        Indexer indexer = IndexerRegistryUtil.getIndexer(SCProductEntry.class);
        indexer.reindex((Object)productEntry);
        return productVersion;
    }

    protected void testDirectDownloadURL(String directDownloadURL) throws PortalException {
        try {
            HttpImpl httpImpl = (HttpImpl)HttpUtil.getHttp();
            HostConfiguration hostConfiguration = httpImpl.getHostConfiguration(directDownloadURL);
            HttpClient httpClient = httpImpl.getClient(hostConfiguration);
            GetMethod getFileMethod = new GetMethod(directDownloadURL);
            int responseCode = httpClient.executeMethod(hostConfiguration, (HttpMethod)getFileMethod);
            if (responseCode != 200) {
                throw new UnavailableProductVersionDirectDownloadURLException();
            }
        }
        catch (Exception exception) {
            throw new UnavailableProductVersionDirectDownloadURLException();
        }
    }

    protected void validate(long productVersionId, String version, String changeLog, String downloadPageURL, String directDownloadURL, boolean testDirectDownloadURL, long[] frameworkVersionIds) throws PortalException, SystemException {
        if (Validator.isNull((String)version)) {
            throw new ProductVersionNameException();
        }
        if (Validator.isNull((String)changeLog)) {
            throw new ProductVersionChangeLogException();
        }
        if (Validator.isNull((String)downloadPageURL) && Validator.isNull((String)directDownloadURL)) {
            throw new ProductVersionDownloadURLException();
        }
        if (Validator.isNotNull((String)directDownloadURL)) {
            SCProductVersion productVersion = this.scProductVersionPersistence.fetchByDirectDownloadURL(directDownloadURL);
            if (productVersion != null && productVersion.getProductVersionId() != productVersionId) {
                throw new DuplicateProductVersionDirectDownloadURLException();
            }
            if (testDirectDownloadURL) {
                this.testDirectDownloadURL(directDownloadURL);
            }
        } else if (frameworkVersionIds.length == 0) {
            throw new ProductVersionFrameworkVersionException();
        }
    }
}

