/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.JavaFieldsParser;
import com.liferay.portlet.social.model.SocialAchievement;
import com.liferay.portlet.social.model.SocialActivityCounterDefinition;
import com.liferay.portlet.social.model.SocialActivityDefinition;
import com.liferay.portlet.social.model.SocialActivityProcessor;
import com.liferay.util.UniqueList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialConfigurationUtil {
    private static Log _log = LogFactoryUtil.getLog(SocialConfigurationUtil.class);
    private static Map<String, Map<Integer, SocialActivityDefinition>> _activityDefinitions = new HashMap<String, Map<Integer, SocialActivityDefinition>>();

    public static List<String> getActivityCounterNames() {
        return SocialConfigurationUtil.getActivityCounterNames(0, false);
    }

    public static List<String> getActivityCounterNames(boolean transientCounter) {
        return SocialConfigurationUtil.getActivityCounterNames(0, transientCounter);
    }

    public static List<String> getActivityCounterNames(int ownerType) {
        return SocialConfigurationUtil.getActivityCounterNames(ownerType, false);
    }

    public static List<String> getActivityCounterNames(int ownerType, boolean transientCounter) {
        UniqueList activityCounterNames = new UniqueList();
        for (Map<Integer, SocialActivityDefinition> activityDefinitions : _activityDefinitions.values()) {
            for (SocialActivityDefinition activityDefinition : activityDefinitions.values()) {
                for (SocialActivityCounterDefinition activityCounterDefinition : activityDefinition.getActivityCounterDefinitions()) {
                    if (activityCounterDefinition.isTransient() != transientCounter || ownerType != 0 && ownerType != activityCounterDefinition.getOwnerType()) continue;
                    activityCounterNames.add(activityCounterDefinition.getName());
                }
            }
        }
        return activityCounterNames;
    }

    public static SocialActivityDefinition getActivityDefinition(String modelName, int activityType) {
        Map<Integer, SocialActivityDefinition> activityDefinitions = _activityDefinitions.get(modelName);
        if (activityDefinitions == null) {
            return null;
        }
        return activityDefinitions.get(activityType);
    }

    public static List<SocialActivityDefinition> getActivityDefinitions(String modelName) {
        Map<Integer, SocialActivityDefinition> activityDefinitions = _activityDefinitions.get(modelName);
        if (activityDefinitions == null) {
            return Collections.emptyList();
        }
        return ListUtil.fromCollection(activityDefinitions.values());
    }

    public static String[] getActivityModelNames() {
        Set<String> activityModelNames = _activityDefinitions.keySet();
        return activityModelNames.toArray(new String[activityModelNames.size()]);
    }

    public static List<Object> read(ClassLoader classLoader, String[] xmls) throws Exception {
        ArrayList<Object> objects = new ArrayList<Object>();
        String[] stringArray = xmls;
        int n = xmls.length;
        int n2 = 0;
        while (n2 < n) {
            String xml = stringArray[n2];
            SocialConfigurationUtil._read(classLoader, xml, objects);
            ++n2;
        }
        return objects;
    }

    public static void removeActivityDefinition(SocialActivityDefinition activityDefinition) {
        Map<Integer, SocialActivityDefinition> activityDefinitions = _activityDefinitions.get(activityDefinition.getModelName());
        if (activityDefinitions != null) {
            activityDefinitions.remove(activityDefinition.getActivityType());
        }
    }

    private static void _read(ClassLoader classLoader, String xml, List<Object> objects) throws Exception {
        if (xml == null) {
            return;
        }
        xml = JavaFieldsParser.parse(classLoader, xml);
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List activityElements = rootElement.elements("activity");
        for (Element activityElement : activityElements) {
            SocialConfigurationUtil._readActivity(classLoader, objects, activityElement);
        }
    }

    private static void _readAchievement(ClassLoader classLoader, List<Object> objects, SocialActivityDefinition activityDefinition, Element achievementElement) throws Exception {
        String achievementClassName = GetterUtil.getString((String)achievementElement.elementText("achievement-class"));
        SocialAchievement achievement = (SocialAchievement)ProxyFactory.newInstance((ClassLoader)classLoader, SocialAchievement.class, (String)achievementClassName);
        String name = GetterUtil.getString((String)achievementElement.elementText("name"));
        achievement.setName(name);
        String icon = GetterUtil.getString((String)achievementElement.elementText("icon"));
        achievement.setIcon(icon);
        List propertyElements = achievementElement.elements("property");
        for (Element propertyElement : propertyElements) {
            SocialConfigurationUtil._readAchievementProperty(achievement, propertyElement);
        }
        achievement.initialize(activityDefinition);
        List achievements = activityDefinition.getAchievements();
        achievements.add(achievement);
        Tuple tuple = new Tuple(new Object[]{activityDefinition, achievement});
        objects.add(tuple);
    }

    private static void _readAchievementProperty(SocialAchievement achievement, Element propertyElement) {
        String name = GetterUtil.getString((String)propertyElement.elementText("name"));
        String value = GetterUtil.getString((String)propertyElement.elementText("value"));
        achievement.setProperty(name, value);
    }

    private static void _readActivity(ClassLoader classLoader, Element activityElement, SocialActivityDefinition activityDefinition) throws Exception {
        String languageKey = GetterUtil.getString((String)activityElement.elementText("language-key"));
        activityDefinition.setLanguageKey(languageKey);
        boolean logActivity = GetterUtil.getBoolean((String)activityElement.elementText("log-activity"));
        activityDefinition.setLogActivity(logActivity);
        String processorClassName = GetterUtil.getString((String)activityElement.elementText("processor-class"));
        if (Validator.isNotNull((String)processorClassName)) {
            SocialActivityProcessor activityProcessor = (SocialActivityProcessor)ProxyFactory.newInstance((ClassLoader)classLoader, SocialActivityProcessor.class, (String)processorClassName);
            activityDefinition.setActivityProcessor(activityProcessor);
        }
        SocialConfigurationUtil._readActivityContribution(activityElement, activityDefinition);
        SocialConfigurationUtil._readActivityParticipation(activityElement, activityDefinition);
    }

    private static void _readActivity(ClassLoader classLoader, List<Object> objects, Element activityElement) throws Exception {
        int activityType;
        SocialActivityDefinition activityDefinition;
        String modelName = GetterUtil.getString((String)activityElement.elementText("model-name"));
        Map<Integer, SocialActivityDefinition> activityDefinitions = _activityDefinitions.get(modelName);
        if (activityDefinitions == null) {
            activityDefinitions = new HashMap<Integer, SocialActivityDefinition>();
            _activityDefinitions.put(modelName, activityDefinitions);
        }
        if ((activityDefinition = activityDefinitions.get(activityType = GetterUtil.getInteger((String)activityElement.elementText("activity-type")))) == null) {
            activityDefinition = new SocialActivityDefinition();
            activityDefinition.setModelName(modelName);
            activityDefinition.setActivityType(activityType);
            SocialConfigurationUtil._readActivity(classLoader, activityElement, activityDefinition);
            activityDefinitions.put(activityType, activityDefinition);
            objects.add(activityDefinition);
        }
        List counterElements = activityElement.elements("counter");
        for (Element counterElement : counterElements) {
            SocialConfigurationUtil._readCounter(objects, activityDefinition, counterElement);
        }
        List achievementElements = activityElement.elements("achievement");
        for (Element achievementElement : achievementElements) {
            SocialConfigurationUtil._readAchievement(classLoader, objects, activityDefinition, achievementElement);
        }
    }

    private static void _readActivityContribution(Element activityElement, SocialActivityDefinition activityDefinition) {
        Element contributionValueElement = activityElement.element("contribution-value");
        Element contributionLimitElement = activityElement.element("contribution-limit");
        if (contributionValueElement == null && contributionLimitElement == null) {
            return;
        }
        SocialActivityCounterDefinition activityCounterDefinition = new SocialActivityCounterDefinition();
        activityCounterDefinition.setName("contribution");
        activityCounterDefinition.setOwnerType(3);
        int increment = 0;
        if (contributionValueElement != null) {
            increment = GetterUtil.getInteger((String)contributionValueElement.getText());
        }
        activityCounterDefinition.setIncrement(increment);
        if (contributionLimitElement != null) {
            String limitPeriod;
            String limitEnabled = contributionLimitElement.attributeValue("enabled");
            if (Validator.isNotNull((String)limitEnabled)) {
                activityCounterDefinition.setLimitEnabled(GetterUtil.getBoolean((String)limitEnabled));
            }
            if (Validator.isNotNull((String)(limitPeriod = contributionLimitElement.attributeValue("period")))) {
                activityCounterDefinition.setLimitPeriod(limitPeriod);
            }
            int limitValue = GetterUtil.getInteger((String)contributionLimitElement.getText());
            activityCounterDefinition.setLimitValue(limitValue);
        }
        activityDefinition.addCounter(activityCounterDefinition);
        SocialActivityCounterDefinition popularityActivityCounterDefinition = new SocialActivityCounterDefinition();
        popularityActivityCounterDefinition.setName("popularity");
        popularityActivityCounterDefinition.setOwnerType(2);
        popularityActivityCounterDefinition.setIncrement(activityCounterDefinition.getIncrement());
        popularityActivityCounterDefinition.setLimitEnabled(activityCounterDefinition.isLimitEnabled());
        popularityActivityCounterDefinition.setLimitPeriod(activityCounterDefinition.getLimitPeriod());
        popularityActivityCounterDefinition.setLimitValue(activityCounterDefinition.getLimitValue());
        activityDefinition.addCounter(popularityActivityCounterDefinition);
    }

    private static void _readActivityParticipation(Element activityElement, SocialActivityDefinition activityDefinition) {
        Element participationValueElement = activityElement.element("participation-value");
        Element participationLimitElement = activityElement.element("participation-limit");
        if (participationValueElement == null && participationLimitElement == null) {
            return;
        }
        SocialActivityCounterDefinition activityCounterDefinition = new SocialActivityCounterDefinition();
        activityCounterDefinition.setName("participation");
        activityCounterDefinition.setOwnerType(1);
        int increment = 0;
        if (participationValueElement != null) {
            increment = GetterUtil.getInteger((String)participationValueElement.getText());
        }
        activityCounterDefinition.setIncrement(increment);
        if (participationLimitElement != null) {
            String limitPeriod;
            String limitEnabled = participationLimitElement.attributeValue("enabled");
            if (Validator.isNotNull((String)limitEnabled)) {
                activityCounterDefinition.setLimitEnabled(GetterUtil.getBoolean((String)limitEnabled));
            }
            if (Validator.isNotNull((String)(limitPeriod = participationLimitElement.attributeValue("period")))) {
                activityCounterDefinition.setLimitPeriod(limitPeriod);
            }
            int limitValue = GetterUtil.getInteger((String)participationLimitElement.getText());
            activityCounterDefinition.setLimitValue(limitValue);
        }
        activityDefinition.addCounter(activityCounterDefinition);
    }

    private static void _readCounter(List<Object> objects, SocialActivityDefinition activityDefinition, Element counterElement) {
        SocialActivityCounterDefinition activityCounterDefinition = new SocialActivityCounterDefinition();
        int increment = GetterUtil.getInteger((String)counterElement.elementText("increment"), (int)1);
        activityCounterDefinition.setIncrement(increment);
        boolean enabled = GetterUtil.getBoolean((String)counterElement.elementText("enabled"), (boolean)true);
        activityCounterDefinition.setEnabled(enabled);
        String name = GetterUtil.getString((String)counterElement.elementText("name"));
        activityCounterDefinition.setName(name);
        String ownerType = GetterUtil.getString((String)counterElement.elementText("owner-type"));
        activityCounterDefinition.setOwnerType(ownerType);
        if (activityCounterDefinition.getOwnerType() == 0) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid owner type " + ownerType + " for model " + activityDefinition.getModelName()));
            }
            return;
        }
        activityDefinition.addCounter(activityCounterDefinition);
        Tuple tuple = new Tuple(new Object[]{activityDefinition, activityCounterDefinition});
        objects.add(tuple);
    }
}

