/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.util;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.LayoutTypePortletImpl;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.LayoutSettings;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitesUtil {
    private static Log _log = LogFactoryUtil.getLog(SitesUtil.class);

    public static void addPortletBreadcrumbEntries(Group group, String pagesName, PortletURL redirectURL, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String portletName = portletDisplay.getPortletName();
        if (renderResponse == null || portletName.equals("156") || portletName.equals("140")) {
            return;
        }
        Locale locale = themeDisplay.getLocale();
        if (group.isLayoutPrototype()) {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)LanguageUtil.get((Locale)locale, (String)"page-template"), null);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)group.getDescriptiveName(), (String)redirectURL.toString());
        } else {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)group.getDescriptiveName(), null);
        }
        if (!group.isLayoutPrototype()) {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)LanguageUtil.get((Locale)locale, (String)pagesName), (String)redirectURL.toString());
        }
    }

    public static void applyLayoutPrototype(LayoutPrototype layoutPrototype, Layout targetLayout, boolean linkEnabled) throws Exception {
        Layout layoutPrototypeLayout = layoutPrototype.getLayout();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        serviceContext.setAttribute("layoutPrototypeLinkEnabled", (Serializable)Boolean.valueOf(linkEnabled));
        serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
        targetLayout = LayoutLocalServiceUtil.updateLayout((long)targetLayout.getGroupId(), (boolean)targetLayout.isPrivateLayout(), (long)targetLayout.getLayoutId(), (long)targetLayout.getParentLayoutId(), (Map)targetLayout.getNameMap(), (Map)targetLayout.getTitleMap(), (Map)targetLayout.getDescriptionMap(), (Map)targetLayout.getKeywordsMap(), (Map)targetLayout.getRobotsMap(), (String)layoutPrototypeLayout.getType(), (boolean)targetLayout.getHidden(), (String)targetLayout.getFriendlyURL(), (Boolean)targetLayout.getIconImage(), null, (ServiceContext)serviceContext);
        targetLayout = LayoutLocalServiceUtil.updateLayout((long)targetLayout.getGroupId(), (boolean)targetLayout.isPrivateLayout(), (long)targetLayout.getLayoutId(), (String)layoutPrototypeLayout.getTypeSettings());
        SitesUtil.copyLayoutPrototypePermissions(targetLayout, layoutPrototype);
        SitesUtil.copyPortletPermissions(targetLayout, layoutPrototypeLayout);
        SitesUtil.copyPortletSetups(layoutPrototypeLayout, targetLayout);
        SitesUtil.copyLookAndFeel(targetLayout, layoutPrototypeLayout);
        targetLayout = LayoutLocalServiceUtil.getLayout((long)targetLayout.getPlid());
        UnicodeProperties typeSettingsProperties = targetLayout.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("last-merge-time", String.valueOf(targetLayout.getModifiedDate().getTime()));
        LayoutLocalServiceUtil.updateLayout((Layout)targetLayout, (boolean)false);
        UnicodeProperties prototypeTypeSettingsProperties = layoutPrototypeLayout.getTypeSettingsProperties();
        prototypeTypeSettingsProperties.setProperty("merge-fail-count", "0");
        LayoutLocalServiceUtil.updateLayout((Layout)layoutPrototypeLayout, (boolean)false);
    }

    public static void applyLayoutSetPrototypes(Group group, long publicLayoutSetPrototypeId, long privateLayoutSetPrototypeId, ServiceContext serviceContext) throws Exception {
        LayoutSetPrototype layoutSetPrototype;
        Group sourceGroup = null;
        if (publicLayoutSetPrototypeId > 0L) {
            layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)publicLayoutSetPrototypeId);
            LayoutSet publicLayoutSet = group.getPublicLayoutSet();
            SitesUtil.copyLayoutSet(layoutSetPrototype.getLayoutSet(), publicLayoutSet, serviceContext);
            sourceGroup = layoutSetPrototype.getGroup();
        }
        if (privateLayoutSetPrototypeId > 0L) {
            layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)privateLayoutSetPrototypeId);
            LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
            SitesUtil.copyLayoutSet(layoutSetPrototype.getLayoutSet(), privateLayoutSet, serviceContext);
            if (sourceGroup == null) {
                sourceGroup = layoutSetPrototype.getGroup();
            }
        }
        if (sourceGroup != null) {
            SitesUtil.copyTypeSettings(sourceGroup, group);
        }
    }

    public static void copyLayout(long userId, Layout sourceLayout, Layout targetLayout, ServiceContext serviceContext) throws Exception {
        Map<String, String[]> parameterMap = SitesUtil.getLayoutSetPrototypeParameters(serviceContext);
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        File file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceLayout.getGroupId(), (boolean)sourceLayout.isPrivateLayout(), (long[])new long[]{sourceLayout.getLayoutId()}, parameterMap, null, null);
        try {
            LayoutLocalServiceUtil.importLayouts((long)userId, (long)targetLayout.getGroupId(), (boolean)targetLayout.isPrivateLayout(), parameterMap, (File)file);
        }
        finally {
            file.delete();
        }
    }

    public static void copyLayoutSet(LayoutSet sourceLayoutSet, LayoutSet targetLayoutSet, ServiceContext serviceContext) throws Exception {
        Map<String, String[]> parameterMap = SitesUtil.getLayoutSetPrototypeParameters(serviceContext);
        SitesUtil.setLayoutSetPrototypeLinkEnabledParameter(parameterMap, targetLayoutSet, serviceContext);
        File file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceLayoutSet.getGroupId(), (boolean)sourceLayoutSet.isPrivateLayout(), null, parameterMap, null, null);
        try {
            LayoutServiceUtil.importLayouts((long)targetLayoutSet.getGroupId(), (boolean)targetLayoutSet.isPrivateLayout(), parameterMap, (File)file);
        }
        finally {
            file.delete();
        }
    }

    public static void copyLookAndFeel(Layout targetLayout, Layout sourceLayout) throws Exception {
        LayoutLocalServiceUtil.updateLookAndFeel((long)targetLayout.getGroupId(), (boolean)targetLayout.isPrivateLayout(), (long)targetLayout.getLayoutId(), (String)sourceLayout.getThemeId(), (String)sourceLayout.getColorSchemeId(), (String)sourceLayout.getCss(), (boolean)false);
        LayoutLocalServiceUtil.updateLookAndFeel((long)targetLayout.getGroupId(), (boolean)targetLayout.isPrivateLayout(), (long)targetLayout.getLayoutId(), (String)sourceLayout.getWapThemeId(), (String)sourceLayout.getWapColorSchemeId(), (String)sourceLayout.getCss(), (boolean)true);
    }

    public static void copyPortletPermissions(Layout targetLayout, Layout sourceLayout) throws Exception {
        long companyId = targetLayout.getCompanyId();
        List roles = RoleLocalServiceUtil.getRoles((long)companyId);
        LayoutTypePortlet sourceLayoutTypePortlet = (LayoutTypePortlet)sourceLayout.getLayoutType();
        List sourcePortletIds = sourceLayoutTypePortlet.getPortletIds();
        for (String sourcePortletId : sourcePortletIds) {
            String resourceName = PortletConstants.getRootPortletId((String)sourcePortletId);
            String sourceResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)sourceLayout.getPlid(), (String)sourcePortletId);
            String targetResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)targetLayout.getPlid(), (String)sourcePortletId);
            List actionIds = ResourceActionsUtil.getPortletResourceActions((String)resourceName);
            for (Role role : roles) {
                String roleName = role.getName();
                if (roleName.equals("Administrator")) continue;
                List actions = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)resourceName, (int)4, (String)sourceResourcePrimKey, (long)role.getRoleId(), (Collection)actionIds);
                ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)resourceName, (int)4, (String)targetResourcePrimKey, (long)role.getRoleId(), (String[])actions.toArray(new String[actions.size()]));
            }
        }
    }

    public static void copyPortletSetups(Layout sourceLayout, Layout targetLayout) throws Exception {
        LayoutTypePortlet sourceLayoutTypePortlet = (LayoutTypePortlet)sourceLayout.getLayoutType();
        List sourcePortletIds = sourceLayoutTypePortlet.getPortletIds();
        for (String sourcePortletId : sourcePortletIds) {
            PortletPreferences sourcePreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)sourceLayout, (String)sourcePortletId, null);
            PortletPreferencesImpl sourcePreferencesImpl = (PortletPreferencesImpl)sourcePreferences;
            PortletPreferences targetPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)targetLayout, (String)sourcePortletId, null);
            PortletPreferencesImpl targetPreferencesImpl = (PortletPreferencesImpl)targetPreferences;
            PortletPreferencesLocalServiceUtil.updatePreferences((long)targetPreferencesImpl.getOwnerId(), (int)targetPreferencesImpl.getOwnerType(), (long)targetPreferencesImpl.getPlid(), (String)sourcePortletId, (PortletPreferences)sourcePreferences);
            if (sourcePreferencesImpl.getOwnerId() == 0L || sourcePreferencesImpl.getOwnerType() == 3) continue;
            sourcePreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)sourceLayout, (String)sourcePortletId);
            sourcePreferencesImpl = (PortletPreferencesImpl)sourcePreferences;
            targetPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)targetLayout, (String)sourcePortletId);
            targetPreferencesImpl = (PortletPreferencesImpl)targetPreferences;
            PortletPreferencesLocalServiceUtil.updatePreferences((long)targetPreferencesImpl.getOwnerId(), (int)targetPreferencesImpl.getOwnerType(), (long)targetPreferencesImpl.getPlid(), (String)sourcePortletId, (PortletPreferences)sourcePreferences);
        }
    }

    public static void copyTypeSettings(Group sourceGroup, Group targetGroup) throws Exception {
        GroupServiceUtil.updateGroup((long)targetGroup.getGroupId(), (String)sourceGroup.getTypeSettings());
    }

    public static Object[] deleteLayout(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        return SitesUtil.deleteLayout(request, response);
    }

    public static Object[] deleteLayout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Layout firstLayout;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"plid");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
        Layout layout = null;
        if (plid <= 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        } else {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
            groupId = layout.getGroupId();
            privateLayout = layout.isPrivateLayout();
            layoutId = layout.getLayoutId();
        }
        Group group = layout.getGroup();
        String oldFriendlyURL = layout.getFriendlyURL();
        if (group.isStagingGroup() && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_STAGING") && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"PUBLISH_STAGING")) {
            throw new PrincipalException();
        }
        if (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"DELETE")) {
            LayoutSettings layoutSettings = LayoutSettings.getInstance(layout);
            EventsProcessorUtil.process("layout.configuration.action.delete", layoutSettings.getConfigurationActionDelete(), request, response);
        }
        LayoutSet layoutSet = layout.getLayoutSet();
        Group layoutSetGroup = layoutSet.getGroup();
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
        if (layoutSetGroup.isLayoutSetPrototype()) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)layoutSetGroup.getClassPK());
            List linkedLayoutSets = LayoutSetLocalServiceUtil.getLayoutSetsByLayoutSetPrototypeUuid((String)layoutSetPrototype.getUuid());
            for (LayoutSet linkedLayoutSet : linkedLayoutSets) {
                Layout linkedLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layout.getUuid(), (long)linkedLayoutSet.getGroupId());
                if (linkedLayout == null || SitesUtil.isLayoutUpdateable(linkedLayout) && !SitesUtil.isLayoutToBeUpdatedFromSourcePrototype(linkedLayout)) continue;
                LayoutServiceUtil.deleteLayout((long)linkedLayout.getPlid(), (ServiceContext)serviceContext);
            }
        }
        LayoutServiceUtil.deleteLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (ServiceContext)serviceContext);
        long newPlid = layout.getParentPlid();
        if (newPlid <= 0L && (firstLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)layoutSet.getGroupId(), (boolean)layoutSet.getPrivateLayout(), (long)0L)) != null) {
            newPlid = firstLayout.getPlid();
        }
        return new Object[]{group, oldFriendlyURL, newPlid};
    }

    public static void deleteLayout(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)renderResponse);
        SitesUtil.deleteLayout(request, response);
    }

    public static File exportLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
        Map<String, String[]> parameterMap = SitesUtil.getLayoutSetPrototypeParameters(serviceContext);
        return LayoutLocalServiceUtil.exportLayoutsAsFile((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), null, parameterMap, null, null);
    }

    public static Map<String, String[]> getLayoutSetPrototypeParameters(ServiceContext serviceContext) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUTS_IMPORT_MODE", new String[]{"CREATED_FROM_PROTOTYPE"});
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        parameterMap.put("USER_PERMISSIONS", new String[]{Boolean.FALSE.toString()});
        return parameterMap;
    }

    public static void importLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype, InputStream inputStream, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
        Map<String, String[]> parameterMap = SitesUtil.getLayoutSetPrototypeParameters(serviceContext);
        SitesUtil.setLayoutSetPrototypeLinkEnabledParameter(parameterMap, layoutSet, serviceContext);
        LayoutServiceUtil.importLayouts((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), parameterMap, (InputStream)inputStream);
    }

    public static boolean isLayoutModifiedSinceLastMerge(Layout layout) throws PortalException, SystemException {
        if (layout == null || Validator.isNull((String)layout.getSourcePrototypeLayoutUuid()) || layout.isLayoutPrototypeLinkActive()) {
            return false;
        }
        LayoutSet existingLayoutSet = layout.getLayoutSet();
        long lastMergeTime = GetterUtil.getLong((String)existingLayoutSet.getSettingsProperty("last-merge-time"));
        Date existingLayoutModifiedDate = layout.getModifiedDate();
        return existingLayoutModifiedDate != null && existingLayoutModifiedDate.getTime() > lastMergeTime && SitesUtil.isLayoutUpdateable(layout);
    }

    public static boolean isLayoutSetPrototypeUpdateable(LayoutSet layoutSet) {
        block4: {
            if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
                return true;
            }
            try {
                LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuid((String)layoutSet.getLayoutSetPrototypeUuid());
                String layoutsUpdateable = layoutSetPrototype.getSettingsProperty("layoutsUpdateable");
                if (Validator.isNotNull((String)layoutsUpdateable)) {
                    return GetterUtil.getBoolean((String)layoutsUpdateable, (boolean)true);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return true;
    }

    public static boolean isLayoutToBeUpdatedFromSourcePrototype(Layout layout) throws Exception {
        if (layout == null) {
            return false;
        }
        LayoutSet layoutSet = layout.getLayoutSet();
        if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
            return false;
        }
        Layout sourcePrototypeLayout = LayoutTypePortletImpl.getSourcePrototypeLayout(layout);
        if (sourcePrototypeLayout == null) {
            return false;
        }
        Date layoutModifiedDate = layout.getModifiedDate();
        Date lastCopyDate = null;
        String lastCopyDateString = layout.getTypeSettingsProperty("layoutSetPrototypeLastCopyDate");
        if (Validator.isNotNull((String)lastCopyDateString)) {
            lastCopyDate = new Date(GetterUtil.getLong((String)lastCopyDateString));
        }
        if (lastCopyDate != null && lastCopyDate.after(sourcePrototypeLayout.getModifiedDate())) {
            return false;
        }
        if (!SitesUtil.isLayoutUpdateable(layout)) {
            return true;
        }
        return layoutModifiedDate == null || lastCopyDate != null && layoutModifiedDate.before(lastCopyDate);
    }

    public static boolean isLayoutUpdateable(Layout layout) {
        block8: {
            String layoutUpdateable;
            block10: {
                block9: {
                    block7: {
                        block6: {
                            if (!(layout instanceof VirtualLayout)) break block6;
                            return false;
                        }
                        if (!Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) break block7;
                        return true;
                    }
                    LayoutSet layoutSet = layout.getLayoutSet();
                    if (!layoutSet.isLayoutSetPrototypeLinkActive()) break block8;
                    boolean layoutSetPrototypeUpdateable = SitesUtil.isLayoutSetPrototypeUpdateable(layoutSet);
                    if (layoutSetPrototypeUpdateable) break block9;
                    return false;
                }
                LayoutTypePortletImpl layoutTypePortlet = new LayoutTypePortletImpl(layout);
                layoutUpdateable = layoutTypePortlet.getSourcePrototypeLayoutProperty("layoutUpdateable");
                if (!Validator.isNull((String)layoutUpdateable)) break block10;
                return true;
            }
            try {
                return GetterUtil.getBoolean((String)layoutUpdateable);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return true;
    }

    public static boolean isUserGroupLayoutSetViewable(PermissionChecker permissionChecker, Group userGroupGroup) throws PortalException, SystemException {
        if (!userGroupGroup.isUserGroup()) {
            return false;
        }
        if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)userGroupGroup.getGroupId(), (String)"VIEW")) {
            return true;
        }
        UserGroup userGroup = UserGroupLocalServiceUtil.getUserGroup((long)userGroupGroup.getClassPK());
        return UserLocalServiceUtil.hasUserGroupUser((long)userGroup.getUserGroupId(), (long)permissionChecker.getUserId());
    }

    protected static void copyLayoutPrototypePermissions(Layout targetLayout, LayoutPrototype sourceLayoutPrototype) throws Exception {
        List roles = RoleLocalServiceUtil.getRoles((long)targetLayout.getCompanyId());
        for (Role role : roles) {
            String roleName = role.getName();
            if (roleName.equals("Administrator")) continue;
            List actionIds = ResourceActionsUtil.getResourceActions((String)LayoutPrototype.class.getName());
            List actions = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)targetLayout.getCompanyId(), (String)LayoutPrototype.class.getName(), (int)4, (String)String.valueOf(sourceLayoutPrototype.getLayoutPrototypeId()), (long)role.getRoleId(), (Collection)actionIds);
            ResourcePermissionLocalServiceUtil.setResourcePermissions((long)targetLayout.getCompanyId(), (String)Layout.class.getName(), (int)4, (String)String.valueOf(targetLayout.getPlid()), (long)role.getRoleId(), (String[])actions.toArray(new String[actions.size()]));
        }
    }

    protected static void setLayoutSetPrototypeLinkEnabledParameter(Map<String, String[]> parameterMap, LayoutSet targetLayoutSet, ServiceContext serviceContext) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null || !PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"UNLINK_LAYOUT_SET_PROTOTYPE")) {
            return;
        }
        if (targetLayoutSet.isPrivateLayout()) {
            boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"privateLayoutSetPrototypeLinkEnabled", (boolean)true);
            if (!privateLayoutSetPrototypeLinkEnabled) {
                privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutSetPrototypeLinkEnabled");
            }
            parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{String.valueOf(privateLayoutSetPrototypeLinkEnabled)});
        } else {
            boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"publicLayoutSetPrototypeLinkEnabled");
            if (!publicLayoutSetPrototypeLinkEnabled) {
                publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutSetPrototypeLinkEnabled", (boolean)true);
            }
            parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{String.valueOf(publicLayoutSetPrototypeLinkEnabled)});
        }
    }
}

