/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.action;

import com.liferay.portal.DuplicateGroupException;
import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.GroupNameException;
import com.liferay.portal.LayoutSetVirtualHostException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.RemoteOptionsException;
import com.liferay.portal.RequiredGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.MembershipRequest;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetServiceUtil;
import com.liferay.portal.service.MembershipRequestLocalServiceUtil;
import com.liferay.portal.service.MembershipRequestServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.sites.action.ActionUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditGroupAction
extends PortletAction {
    private static final int _LAYOUT_SET_VISIBILITY_PRIVATE = 1;

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        try {
            String closeRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"closeRedirect");
            if (cmd.equals("add") || cmd.equals("update")) {
                Object[] returnValue = this.updateGroup(actionRequest);
                Group group = (Group)returnValue[0];
                String oldFriendlyURL = (String)returnValue[1];
                String oldStagingFriendlyURL = (String)returnValue[2];
                long newRefererPlid = (Long)returnValue[3];
                redirect = HttpUtil.setParameter((String)redirect, (String)"doAsGroupId", (long)group.getGroupId());
                redirect = HttpUtil.setParameter((String)redirect, (String)"refererPlid", (long)newRefererPlid);
                closeRedirect = this.updateCloseRedirect(closeRedirect, group, themeDisplay, oldFriendlyURL, oldStagingFriendlyURL);
            } else if (cmd.equals("deactivate") || cmd.equals("restore")) {
                this.updateActive(actionRequest, cmd);
            } else if (cmd.equals("delete")) {
                this.deleteGroup(actionRequest);
            }
            if (Validator.isNotNull((String)closeRedirect)) {
                SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".closeRedirect"), (Object)closeRedirect);
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.sites_admin.error");
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException || e instanceof DuplicateGroupException || e instanceof GroupFriendlyURLException || e instanceof GroupNameException || e instanceof LayoutSetVirtualHostException || e instanceof RemoteExportException || e instanceof RemoteOptionsException || e instanceof RequiredGroupException || e instanceof SystemException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
                if ((cmd.equals("deactivate") || cmd.equals("delete") || cmd.equals("restore")) && Validator.isNotNull((String)redirect)) {
                    actionResponse.sendRedirect(redirect);
                }
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.sites_admin.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.sites_admin.edit_site"));
    }

    protected void deleteGroup(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        GroupServiceUtil.deleteGroup((long)groupId);
        LiveUsers.deleteGroup(themeDisplay.getCompanyId(), groupId);
    }

    protected long getRefererGroupId(ThemeDisplay themeDisplay) throws Exception {
        long refererGroupId = 0L;
        try {
            Layout refererLayout = LayoutLocalServiceUtil.getLayout((long)themeDisplay.getRefererPlid());
            refererGroupId = refererLayout.getGroupId();
        }
        catch (NoSuchLayoutException noSuchLayoutException) {}
        return refererGroupId;
    }

    protected void updateActive(ActionRequest actionRequest, String cmd) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        if (groupId == themeDisplay.getDoAsGroupId() || groupId == themeDisplay.getScopeGroupId() || groupId == this.getRefererGroupId(themeDisplay)) {
            throw new RequiredGroupException(String.valueOf(groupId));
        }
        Group group = GroupServiceUtil.getGroup((long)groupId);
        boolean active = false;
        if (cmd.equals("restore")) {
            active = true;
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Group.class.getName(), (PortletRequest)actionRequest);
        GroupServiceUtil.updateGroup((long)groupId, (String)group.getName(), (String)group.getDescription(), (int)group.getType(), (String)group.getFriendlyURL(), (boolean)active, (ServiceContext)serviceContext);
    }

    protected String updateCloseRedirect(String closeRedirect, Group group, ThemeDisplay themeDisplay, String oldFriendlyURL, String oldStagingFriendlyURL) throws SystemException, PortalException {
        if (Validator.isNull((String)closeRedirect) || group == null) {
            return closeRedirect;
        }
        String oldPath = null;
        String newPath = null;
        if (Validator.isNotNull((String)oldFriendlyURL)) {
            oldPath = oldFriendlyURL;
            newPath = group.getFriendlyURL();
            closeRedirect = closeRedirect.indexOf(oldPath) != -1 ? PortalUtil.updateRedirect((String)closeRedirect, (String)oldPath, (String)newPath) : PortalUtil.getGroupFriendlyURL((Group)group, (boolean)false, (ThemeDisplay)themeDisplay);
        }
        if (Validator.isNotNull((String)oldStagingFriendlyURL)) {
            Group stagingGroup = group.getStagingGroup();
            if (GroupLocalServiceUtil.fetchGroup((long)stagingGroup.getGroupId()) == null) {
                oldPath = oldStagingFriendlyURL;
                newPath = group.getFriendlyURL();
            } else {
                oldPath = oldStagingFriendlyURL;
                newPath = stagingGroup.getFriendlyURL();
            }
            closeRedirect = closeRedirect.contains(oldPath) ? PortalUtil.updateRedirect((String)closeRedirect, (String)oldPath, (String)newPath) : PortalUtil.getGroupFriendlyURL((Group)group, (boolean)false, (ThemeDisplay)themeDisplay);
        }
        return closeRedirect;
    }

    protected Object[] updateGroup(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long userId = PortalUtil.getUserId((PortletRequest)actionRequest);
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
        String friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"friendlyURL");
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Group.class.getName(), (PortletRequest)actionRequest);
        Group liveGroup = null;
        String oldFriendlyURL = null;
        String oldStagingFriendlyURL = null;
        if (liveGroupId <= 0L) {
            liveGroup = GroupServiceUtil.addGroup((String)name, (String)description, (int)type, (String)friendlyURL, (boolean)true, (boolean)active, (ServiceContext)serviceContext);
            LiveUsers.joinGroup(themeDisplay.getCompanyId(), liveGroup.getGroupId(), userId);
        } else {
            liveGroup = GroupLocalServiceUtil.getGroup((long)liveGroupId);
            oldFriendlyURL = liveGroup.getFriendlyURL();
            liveGroup = GroupServiceUtil.updateGroup((long)liveGroupId, (String)name, (String)description, (int)type, (String)friendlyURL, (boolean)active, (ServiceContext)serviceContext);
            if (type == 1) {
                List membershipRequests = MembershipRequestLocalServiceUtil.search((long)liveGroupId, (int)0, (int)-1, (int)-1);
                for (MembershipRequest membershipRequest : membershipRequests) {
                    MembershipRequestServiceUtil.updateStatus((long)membershipRequest.getMembershipRequestId(), (String)themeDisplay.translate("your-membership-has-been-approved"), (int)1, (ServiceContext)serviceContext);
                    LiveUsers.joinGroup(themeDisplay.getCompanyId(), membershipRequest.getGroupId(), new long[]{membershipRequest.getUserId()});
                }
            }
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        String customJspServletContextName = ParamUtil.getString((PortletRequest)actionRequest, (String)"customJspServletContextName");
        typeSettingsProperties.setProperty("customJspServletContextName", customJspServletContextName);
        String googleAnalyticsId = ParamUtil.getString((PortletRequest)actionRequest, (String)"googleAnalyticsId");
        typeSettingsProperties.setProperty("googleAnalyticsId", googleAnalyticsId);
        String publicRobots = ParamUtil.getString((PortletRequest)actionRequest, (String)"publicRobots");
        String privateRobots = ParamUtil.getString((PortletRequest)actionRequest, (String)"privateRobots");
        typeSettingsProperties.setProperty("false-robots.txt", publicRobots);
        typeSettingsProperties.setProperty("true-robots.txt", privateRobots);
        String publicVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"publicVirtualHost");
        String privateVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"privateVirtualHost");
        LayoutSetServiceUtil.updateVirtualHost((long)liveGroup.getGroupId(), (boolean)false, (String)publicVirtualHost);
        LayoutSetServiceUtil.updateVirtualHost((long)liveGroup.getGroupId(), (boolean)true, (String)privateVirtualHost);
        if (liveGroup.hasStagingGroup()) {
            Group stagingGroup = liveGroup.getStagingGroup();
            oldStagingFriendlyURL = stagingGroup.getFriendlyURL();
            publicVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingPublicVirtualHost");
            privateVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingPrivateVirtualHost");
            friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingFriendlyURL");
            LayoutSetServiceUtil.updateVirtualHost((long)stagingGroup.getGroupId(), (boolean)false, (String)publicVirtualHost);
            LayoutSetServiceUtil.updateVirtualHost((long)stagingGroup.getGroupId(), (boolean)true, (String)privateVirtualHost);
            GroupServiceUtil.updateFriendlyURL((long)stagingGroup.getGroupId(), (String)friendlyURL);
        }
        liveGroup = GroupServiceUtil.updateGroup((long)liveGroup.getGroupId(), (String)typeSettingsProperties.toString());
        LayoutSet privateLayoutSet = liveGroup.getPrivateLayoutSet();
        LayoutSet publicLayoutSet = liveGroup.getPublicLayoutSet();
        if (!liveGroup.isStaged()) {
            long privateLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeId");
            long publicLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeId");
            if (privateLayoutSetPrototypeId == 0L && publicLayoutSetPrototypeId == 0L) {
                long layoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetPrototypeId");
                int layoutSetVisibility = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"layoutSetVisibility");
                if (layoutSetVisibility == 1) {
                    privateLayoutSetPrototypeId = layoutSetPrototypeId;
                } else {
                    publicLayoutSetPrototypeId = layoutSetPrototypeId;
                }
            }
            if (publicLayoutSetPrototypeId > 0L || privateLayoutSetPrototypeId > 0L) {
                SitesUtil.applyLayoutSetPrototypes(liveGroup, publicLayoutSetPrototypeId, privateLayoutSetPrototypeId, serviceContext);
            } else {
                boolean publicLayoutSetPrototypeLinkEnabled;
                boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"privateLayoutSetPrototypeLinkEnabled");
                if (privateLayoutSetPrototypeLinkEnabled != privateLayoutSet.isLayoutSetPrototypeLinkEnabled()) {
                    LayoutSetServiceUtil.updateLayoutSetPrototypeLinkEnabled((long)liveGroupId, (boolean)true, (boolean)privateLayoutSetPrototypeLinkEnabled);
                }
                if ((publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"publicLayoutSetPrototypeLinkEnabled")) != publicLayoutSet.isLayoutSetPrototypeLinkEnabled()) {
                    LayoutSetServiceUtil.updateLayoutSetPrototypeLinkEnabled((long)liveGroupId, (boolean)false, (boolean)publicLayoutSetPrototypeLinkEnabled);
                }
            }
        }
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        long refererPlid = GetterUtil.getLong((String)HttpUtil.getParameter((String)redirect, (String)"refererPlid", (boolean)false));
        if (!privateLayoutSet.isLayoutSetPrototypeLinkActive() && !publicLayoutSet.isLayoutSetPrototypeLinkActive()) {
            if (refererPlid > 0L && liveGroup.hasStagingGroup() && themeDisplay.getScopeGroupId() != liveGroup.getGroupId()) {
                Layout firstLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)liveGroup.getGroupId(), (boolean)false, (long)0L);
                if (firstLayout == null) {
                    firstLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)liveGroup.getGroupId(), (boolean)true, (long)0L);
                }
                refererPlid = firstLayout != null ? firstLayout.getPlid() : 0L;
            }
            StagingUtil.updateStaging((PortletRequest)actionRequest, (Group)liveGroup);
        }
        return new Object[]{liveGroup, oldFriendlyURL, oldStagingFriendlyURL, refererPlid};
    }
}

