/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.service.ShoppingCategoryServiceUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingCategoryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ShoppingCategoryServiceHttp.class);
    private static final Class<?>[] _addCategoryParameterTypes0 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteCategoryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getCategoriesParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getCategoriesParameterTypes3 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getCategoriesCountParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getCategoryParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getSubcategoryIdsParameterTypes6 = new Class[]{List.class, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _updateCategoryParameterTypes7 = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Boolean.TYPE, ServiceContext.class};

    public static ShoppingCategory addCategory(HttpPrincipal httpPrincipal, long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "addCategory", (Class[])_addCategoryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{parentCategoryId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (ShoppingCategory)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteCategory(HttpPrincipal httpPrincipal, long categoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "deleteCategory", (Class[])_deleteCategoryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<ShoppingCategory> getCategories(HttpPrincipal httpPrincipal, long groupId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "getCategories", (Class[])_getCategoriesParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<ShoppingCategory> getCategories(HttpPrincipal httpPrincipal, long groupId, long parentCategoryId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "getCategories", (Class[])_getCategoriesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentCategoryId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getCategoriesCount(HttpPrincipal httpPrincipal, long groupId, long parentCategoryId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "getCategoriesCount", (Class[])_getCategoriesCountParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, parentCategoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static ShoppingCategory getCategory(HttpPrincipal httpPrincipal, long categoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "getCategory", (Class[])_getCategoryParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (ShoppingCategory)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void getSubcategoryIds(HttpPrincipal httpPrincipal, List<Long> categoryIds, long groupId, long categoryId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "getSubcategoryIds", (Class[])_getSubcategoryIdsParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryIds, groupId, categoryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static ShoppingCategory updateCategory(HttpPrincipal httpPrincipal, long categoryId, long parentCategoryId, String name, String description, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingCategoryServiceUtil.class.getName(), "updateCategory", (Class[])_updateCategoryParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{categoryId, parentCategoryId, name, description, mergeWithParentCategory, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (ShoppingCategory)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

