/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rss.lar;

import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.lar.JournalPortletDataHandlerImpl;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class RSSPortletDataHandlerImpl
extends JournalPortletDataHandlerImpl {
    private static final boolean _ALWAYS_EXPORTABLE = false;
    private static final String _NAMESPACE = "rss";
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = true;
    private static Log _log = LogFactoryUtil.getLog(RSSPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("rss", "comments");
    private static PortletDataHandlerBoolean _embeddedAssets = new PortletDataHandlerBoolean("rss", "embedded-assets");
    private static PortletDataHandlerBoolean _images = new PortletDataHandlerBoolean("rss", "images");
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("rss", "ratings");
    private static PortletDataHandlerBoolean _selectedArticles = new PortletDataHandlerBoolean("rss", "selected-web-content", true, true);
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("rss", "tags");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_selectedArticles, _embeddedAssets, _images, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_selectedArticles, _images, _comments, _ratings, _tags};
    }

    public boolean isAlwaysExportable() {
        return false;
    }

    public boolean isPublishToLiveByDefault() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletPreferences.setValue("footerArticleValues", "");
        portletPreferences.setValue("headerArticleValues", "");
        portletPreferences.setValue("urls", "");
        portletPreferences.setValue("titles", "");
        portletPreferences.setValue("itemsPerChannel", "");
        portletPreferences.setValue("expandedItemsPerChannel", "");
        portletPreferences.setValue("showFeedTitle", "");
        portletPreferences.setValue("showFeedPublishedDate", "");
        portletPreferences.setValue("showFeedDescription", "");
        portletPreferences.setValue("showFeedImage", "");
        portletPreferences.setValue("feedImageAlignment", "");
        portletPreferences.setValue("showFeedItemAuthor", "");
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        JournalArticle headerArticle;
        JournalArticle footerArticle;
        ArrayList<JournalArticle> articles;
        block11: {
            long headerArticleGroupId;
            String headerArticleId;
            block10: {
                String[] footerArticleValues = portletPreferences.getValues("footerArticleValues", new String[]{"0", ""});
                String[] headerArticleValues = portletPreferences.getValues("headerArticleValues", new String[]{"0", ""});
                String footerArticleId = footerArticleValues[1];
                headerArticleId = headerArticleValues[1];
                if (Validator.isNull((String)footerArticleId) && Validator.isNull((String)headerArticleId)) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No article ids found in preferences of portlet " + portletId));
                    }
                    return "";
                }
                long footerArticleGroupId = GetterUtil.getLong((String)footerArticleValues[0]);
                headerArticleGroupId = GetterUtil.getLong((String)headerArticleValues[0]);
                if (footerArticleGroupId <= 0L && headerArticleGroupId <= 0L) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No group ids found in preferences of portlet " + portletId));
                    }
                    return "";
                }
                articles = new ArrayList<JournalArticle>(2);
                footerArticle = null;
                try {
                    footerArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)footerArticleGroupId, (String)footerArticleId, (int)0);
                    articles.add(footerArticle);
                }
                catch (NoSuchArticleException noSuchArticleException) {
                    if (!_log.isWarnEnabled()) break block10;
                    _log.warn((Object)("No approved article found with group id " + footerArticleGroupId + " and article id " + footerArticleId));
                }
            }
            headerArticle = null;
            try {
                headerArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)headerArticleGroupId, (String)headerArticleId, (int)0);
                articles.add(headerArticle);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                if (!_log.isWarnEnabled()) break block11;
                _log.warn((Object)("No approved article found with group id " + headerArticleGroupId + " and article id " + headerArticleId));
            }
        }
        if (footerArticle == null && headerArticle == null) {
            return "";
        }
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("journal-content-data");
        Element dlFileEntryTypesElement = rootElement.addElement("dl-file-entry-types");
        Element dlFoldersElement = rootElement.addElement("dl-folders");
        Element dlFilesElement = rootElement.addElement("dl-file-entries");
        Element dlFileRanksElement = rootElement.addElement("dl-file-ranks");
        for (JournalArticle article : articles) {
            String path = JournalPortletDataHandlerImpl.getArticlePath(portletDataContext, article);
            Element articleElement = null;
            articleElement = article == footerArticle ? rootElement.addElement("footer-article") : rootElement.addElement("header-article");
            articleElement.addAttribute("path", path);
            JournalPortletDataHandlerImpl.exportArticle(portletDataContext, rootElement, rootElement, rootElement, dlFileEntryTypesElement, dlFoldersElement, dlFilesElement, dlFileRanksElement, article, false);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        String[] headerArticleValues;
        String headerArticleId;
        Element headerArticleElement;
        String[] footerArticleValues;
        String footerArticleId;
        if (Validator.isNull((String)data)) {
            return null;
        }
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        JournalPortletDataHandlerImpl.importReferencedData(portletDataContext, rootElement);
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            JournalPortletDataHandlerImpl.importStructure(portletDataContext, structureElement);
        }
        List templateElements = rootElement.elements("template");
        for (Element templateElement : templateElements) {
            JournalPortletDataHandlerImpl.importTemplate(portletDataContext, templateElement);
        }
        Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getPlid());
        Element footerArticleElement = rootElement.element("footer-article");
        if (footerArticleElement != null) {
            JournalPortletDataHandlerImpl.importArticle(portletDataContext, footerArticleElement);
        }
        if (Validator.isNotNull((String)(footerArticleId = (footerArticleValues = portletPreferences.getValues("footerArticleValues", new String[]{"0", ""}))[1]))) {
            footerArticleId = MapUtil.getString((Map)articleIds, (String)footerArticleId, (String)footerArticleId);
            portletPreferences.setValues("footerArticleValues", new String[]{String.valueOf(portletDataContext.getScopeGroupId()), footerArticleId});
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)footerArticleId, (boolean)true);
        }
        if ((headerArticleElement = rootElement.element("header-article")) != null) {
            JournalPortletDataHandlerImpl.importArticle(portletDataContext, headerArticleElement);
        }
        if (Validator.isNotNull((String)(headerArticleId = (headerArticleValues = portletPreferences.getValues("headerArticleValues", new String[]{"0", ""}))[1]))) {
            headerArticleId = MapUtil.getString((Map)articleIds, (String)headerArticleId, (String)headerArticleId);
            portletPreferences.setValues("headerArticleValues", new String[]{String.valueOf(portletDataContext.getScopeGroupId()), headerArticleId});
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)headerArticleId, (boolean)true);
        }
        return portletPreferences;
    }
}

