/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rss.action;

import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ValidatorException;

public class ConfigurationActionImpl
extends DefaultConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("update")) {
            this.updateSubscriptions(actionRequest);
            super.processAction(portletConfig, actionRequest, actionResponse);
            return;
        }
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
        if (cmd.equals("remove-footer-article")) {
            this.removeFooterArticle(actionRequest, preferences);
        } else if (cmd.equals("remove-header-article")) {
            this.removeHeaderArticle(actionRequest, preferences);
        } else if (cmd.equals("set-footer-article")) {
            this.setFooterArticle(actionRequest, preferences);
        } else if (cmd.equals("set-header-article")) {
            this.setHeaderArticle(actionRequest, preferences);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            try {
                preferences.store();
            }
            catch (ValidatorException ve) {
                SessionErrors.add((PortletRequest)actionRequest, (String)ValidatorException.class.getName(), (Object)((Object)ve));
                return;
            }
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".refreshPortlet"), (Object)portletResource);
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".updatedConfiguration"));
        }
    }

    protected void removeFooterArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        preferences.setValues("footerArticleValues", new String[]{"0", ""});
    }

    protected void removeHeaderArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        preferences.setValues("headerArticleValues", new String[]{"0", ""});
    }

    protected void setFooterArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        long articleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"articleGroupId");
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        preferences.setValues("footerArticleValues", new String[]{String.valueOf(articleGroupId), articleId});
    }

    protected void setHeaderArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        long articleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"articleGroupId");
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        preferences.setValues("headerArticleValues", new String[]{String.valueOf(articleGroupId), articleId});
    }

    protected void updateSubscriptions(ActionRequest actionRequest) throws Exception {
        int[] subscriptionIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"subscriptionIndexes"), (int)0);
        HashMap<String, String> subscriptions = new HashMap<String, String>();
        int[] nArray = subscriptionIndexes;
        int n = subscriptionIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int subscriptionIndex = nArray[n2];
            String url = ParamUtil.getString((PortletRequest)actionRequest, (String)("url" + subscriptionIndex));
            String title = ParamUtil.getString((PortletRequest)actionRequest, (String)("title" + subscriptionIndex));
            if (!Validator.isNull((String)url)) {
                subscriptions.put(url, title);
            }
            ++n2;
        }
        String[] urls = new String[subscriptions.size()];
        String[] titles = new String[subscriptions.size()];
        int i = 0;
        for (Map.Entry entry : subscriptions.entrySet()) {
            urls[i] = (String)entry.getKey();
            titles[i] = (String)entry.getValue();
            ++i;
        }
        this.setPreference((PortletRequest)actionRequest, "urls", urls);
        this.setPreference((PortletRequest)actionRequest, "titles", titles);
    }
}

