/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rolesadmin.action;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.RoleAssignmentException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.rolesadmin.action.ActionUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditRoleAssignmentsAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("role_groups")) {
                this.updateRoleGroups(actionRequest);
            } else if (cmd.equals("role_users")) {
                this.updateRoleUsers(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"assignmentsRedirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchRoleException || e instanceof PrincipalException || e instanceof RoleAssignmentException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.roles_admin.error");
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getRole((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchRoleException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.roles_admin.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.roles_admin.edit_role_assignments"));
    }

    protected void updateRoleGroups(ActionRequest actionRequest) throws Exception {
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        long[] addGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addGroupIds"), (long)0L);
        long[] removeGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeGroupIds"), (long)0L);
        Role role = RoleLocalServiceUtil.getRole((long)roleId);
        if (role.getName().equals("Owner")) {
            throw new RoleAssignmentException(role.getName());
        }
        GroupServiceUtil.addRoleGroups((long)roleId, (long[])addGroupIds);
        GroupServiceUtil.unsetRoleGroups((long)roleId, (long[])removeGroupIds);
    }

    protected void updateRoleUsers(ActionRequest actionRequest) throws Exception {
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        long[] addUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserIds"), (long)0L);
        long[] removeUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserIds"), (long)0L);
        Role role = RoleLocalServiceUtil.getRole((long)roleId);
        if (role.getName().equals("Owner")) {
            throw new RoleAssignmentException(role.getName());
        }
        UserServiceUtil.addRoleUsers((long)roleId, (long[])addUserIds);
        UserServiceUtil.unsetRoleUsers((long)roleId, (long[])removeUserIds);
    }
}

