/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.PortletIdException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExportImportAction
extends EditConfigurationAction {
    private static Log _log = LogFactoryUtil.getLog(ExportImportAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("copy_from_live")) {
                StagingUtil.copyFromLive((PortletRequest)actionRequest, (Portlet)portlet);
                this.sendRedirect(actionRequest, actionResponse);
            } else if (cmd.equals("export")) {
                this.exportData(actionRequest, actionResponse, portlet);
                this.sendRedirect(actionRequest, actionResponse);
            } else if (cmd.equals("import")) {
                this.importData(actionRequest, actionResponse, portlet);
                this.sendRedirect(actionRequest, actionResponse);
            } else if (cmd.equals("publish_to_live")) {
                StagingUtil.publishToLive((PortletRequest)actionRequest, (Portlet)portlet);
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchLayoutException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.export_import"));
    }

    protected void exportData(ActionRequest actionRequest, ActionResponse actionResponse, Portlet portlet) throws Exception {
        try {
            Layout layout;
            PortletPreferences preferences;
            long lastPublishDate;
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
            long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"exportFileName");
            String range = ParamUtil.getString((PortletRequest)actionRequest, (String)"range");
            Date startDate = null;
            Date endDate = null;
            if (range.equals("dateRange")) {
                int startDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateMonth");
                int startDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateDay");
                int startDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateYear");
                int startDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateHour");
                int startDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateMinute");
                int startDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateAmPm");
                if (startDateAmPm == 1) {
                    startDateHour += 12;
                }
                startDate = PortalUtil.getDate((int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (TimeZone)themeDisplay.getTimeZone(), (PortalException)new PortalException());
                int endDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateMonth");
                int endDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateDay");
                int endDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateYear");
                int endDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateHour");
                int endDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateMinute");
                int endDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateAmPm");
                if (endDateAmPm == 1) {
                    endDateHour += 12;
                }
                endDate = PortalUtil.getDate((int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)endDateHour, (int)endDateMinute, (TimeZone)themeDisplay.getTimeZone(), (PortalException)new PortalException());
            } else if (range.equals("fromLastPublishDate") && (lastPublishDate = GetterUtil.getLong((String)(preferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)(layout = LayoutLocalServiceUtil.getLayout((long)plid)), (String)portlet.getPortletId(), (String)"")).getValue("last-publish-date", ""))) > 0L) {
                Calendar cal = Calendar.getInstance(themeDisplay.getTimeZone(), themeDisplay.getLocale());
                endDate = cal.getTime();
                cal.setTimeInMillis(lastPublishDate);
                startDate = cal.getTime();
            }
            File file = LayoutServiceUtil.exportPortletInfoAsFile((long)plid, (long)groupId, (String)portlet.getPortletId(), (Map)actionRequest.getParameterMap(), startDate, endDate);
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)new FileInputStream(file), (String)"application/zip");
            FileUtil.delete((File)file);
            this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
        }
    }

    protected void importData(ActionRequest actionRequest, ActionResponse actionResponse, Portlet portlet) throws Exception {
        try {
            UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
            long plid = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"plid");
            long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
            File file = uploadPortletRequest.getFile("importFileName");
            if (!file.exists()) {
                throw new LARFileException("Import file does not exist");
            }
            LayoutServiceUtil.importPortletInfo((long)plid, (long)groupId, (String)portlet.getPortletId(), (Map)actionRequest.getParameterMap(), (File)file);
            this.addSuccessMessage(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof LARFileException || e instanceof LARTypeException || e instanceof PortletIdException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, (String)LayoutImportException.class.getName());
        }
    }
}

