/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import com.liferay.portlet.portletconfiguration.util.PortletConfigurationUtil;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditScopeAction
extends EditConfigurationAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("save")) {
            this.updateScope(actionRequest, portlet);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".refreshPortlet"), (Object)portletResource);
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".updatedConfiguration"));
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_scope"));
    }

    protected Tuple getNewScope(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        String scopeType = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeType");
        long scopeGroupId = 0L;
        String scopeName = null;
        if (Validator.isNull((String)scopeType)) {
            scopeGroupId = layout.getGroupId();
        } else if (scopeType.equals("company")) {
            scopeGroupId = themeDisplay.getCompanyGroupId();
            scopeName = themeDisplay.translate("global");
        } else if (scopeType.equals("layout")) {
            String scopeLayoutUuid = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeLayoutUuid");
            Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)layout.getGroupId());
            if (!scopeLayout.hasScopeGroup()) {
                String name = String.valueOf(scopeLayout.getPlid());
                GroupLocalServiceUtil.addGroup((long)themeDisplay.getUserId(), (String)Layout.class.getName(), (long)scopeLayout.getPlid(), (String)name, null, (int)0, null, (boolean)false, (boolean)true, null);
            }
            scopeGroupId = scopeLayout.getGroupId();
            scopeName = scopeLayout.getName(themeDisplay.getLocale());
        } else {
            throw new IllegalArgumentException("Scope type " + scopeType + " is invalid");
        }
        return new Tuple(new Object[]{scopeGroupId, scopeName});
    }

    protected String getOldScopeName(ActionRequest actionRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portlet.getPortletId());
        String scopeType = GetterUtil.getString((String)preferences.getValue("lfrScopeType", null));
        if (Validator.isNull((String)scopeType)) {
            return null;
        }
        String scopeName = null;
        if (scopeType.equals("company")) {
            scopeName = themeDisplay.translate("global");
        } else if (scopeType.equals("layout")) {
            String scopeLayoutUuid = GetterUtil.getString((String)preferences.getValue("lfrScopeLayoutUuid", null));
            try {
                Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)layout.getGroupId());
                scopeName = scopeLayout.getName(themeDisplay.getLocale());
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        } else {
            throw new IllegalArgumentException("Scope type " + scopeType + " is invalid");
        }
        return scopeName;
    }

    protected String getPortletTitle(PortletRequest portletRequest, Portlet portlet, PortletPreferences preferences) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        String portletTitle = PortletConfigurationUtil.getPortletTitle((PortletPreferences)preferences, (String)themeDisplay.getLanguageId());
        if (Validator.isNull((String)portletTitle)) {
            ServletContext servletContext = (ServletContext)portletRequest.getAttribute("CTX");
            PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
            ResourceBundle resourceBundle = portletConfig.getResourceBundle(themeDisplay.getLocale());
            portletTitle = resourceBundle.getString("javax.portlet.title");
        }
        return portletTitle;
    }

    protected void updateScope(ActionRequest actionRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portlet.getPortletId());
        String scopeType = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeType");
        preferences.setValue("lfrScopeType", scopeType);
        String scopeLayoutUuid = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeLayoutUuid");
        if (!scopeType.equals("layout")) {
            scopeLayoutUuid = "";
        }
        preferences.setValue("lfrScopeLayoutUuid", scopeLayoutUuid);
        String portletTitle = this.getPortletTitle((PortletRequest)actionRequest, portlet, preferences);
        Tuple newScopeTuple = this.getNewScope(actionRequest);
        long newScopeGroupId = (Long)newScopeTuple.getObject(0);
        preferences.setValue("groupId", String.valueOf(newScopeGroupId));
        String oldScopeName = this.getOldScopeName(actionRequest, portlet);
        String newScopeName = (String)newScopeTuple.getObject(1);
        String newPortletTitle = PortalUtil.getNewPortletTitle((String)portletTitle, (String)oldScopeName, (String)newScopeName);
        if (!newPortletTitle.equals(portletTitle)) {
            preferences.setValue("portletSetupTitle_" + themeDisplay.getLanguageId(), newPortletTitle);
            preferences.setValue("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        }
        preferences.store();
    }
}

