/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.action.ActionUtil;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import com.liferay.portlet.portletconfiguration.util.PublicRenderParameterConfiguration;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditPublicRenderParametersAction
extends EditConfigurationAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        this.updatePreferences(actionRequest, portlet);
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".refreshPortlet"), (Object)portletResource);
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".updatedConfiguration"));
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        ActionUtil.getLayoutPublicRenderParameters((PortletRequest)renderRequest);
        ActionUtil.getPublicRenderParameterConfigurationList((PortletRequest)renderRequest, portlet);
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_public_render_parameters"));
    }

    protected void updatePreferences(ActionRequest actionRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portlet.getPortletId());
        Enumeration enu = preferences.getNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith("lfr-prp-ignore-") && !name.startsWith("lfr-prp-mapping-")) continue;
            preferences.reset(name);
        }
        for (PublicRenderParameter publicRenderParameter : portlet.getPublicRenderParameters()) {
            String ignoreKey = PublicRenderParameterConfiguration.getIgnoreKey(publicRenderParameter);
            boolean ignoreValue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)ignoreKey);
            if (ignoreValue) {
                preferences.setValue(ignoreKey, String.valueOf(Boolean.TRUE));
                continue;
            }
            String mappingKey = PublicRenderParameterConfiguration.getMappingKey(publicRenderParameter);
            String mappingValue = ParamUtil.getString((PortletRequest)actionRequest, (String)mappingKey);
            if (!Validator.isNotNull((String)mappingValue)) continue;
            preferences.setValue(mappingKey, mappingValue);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.store();
        }
    }
}

