/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.polls.DuplicateVoteException;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.model.PollsVote;
import com.liferay.portlet.polls.service.PollsChoiceLocalServiceUtil;
import com.liferay.portlet.polls.service.PollsQuestionLocalServiceUtil;
import com.liferay.portlet.polls.service.PollsVoteLocalServiceUtil;
import com.liferay.portlet.polls.service.persistence.PollsChoiceFinderUtil;
import com.liferay.portlet.polls.service.persistence.PollsChoiceUtil;
import com.liferay.portlet.polls.service.persistence.PollsQuestionUtil;
import com.liferay.portlet.polls.service.persistence.PollsVoteUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class PollsPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "polls";
    private static PortletDataHandlerBoolean _questions = new PortletDataHandlerBoolean("polls", "questions", true, true);
    private static PortletDataHandlerBoolean _votes = new PortletDataHandlerBoolean("polls", "votes");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_questions, _votes};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_questions, _votes};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    protected static void exportChoice(PortletDataContext portletDataContext, Element questionsElement, PollsChoice choice) throws Exception {
        String path = PollsPortletDataHandlerImpl.getChoicePath(portletDataContext, choice);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element choiceElement = questionsElement.addElement("choice");
        portletDataContext.addClassedModel(choiceElement, path, (ClassedModel)choice, _NAMESPACE);
    }

    protected static void exportQuestion(PortletDataContext portletDataContext, Element questionsElement, Element choicesElement, Element votesElement, PollsQuestion question) throws Exception {
        if (!portletDataContext.isWithinDateRange(question.getModifiedDate())) {
            return;
        }
        String path = PollsPortletDataHandlerImpl.getQuestionPath(portletDataContext, question);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element questionElement = questionsElement.addElement("question");
        List choices = PollsChoiceUtil.findByQuestionId((long)question.getQuestionId());
        for (PollsChoice choice : choices) {
            PollsPortletDataHandlerImpl.exportChoice(portletDataContext, choicesElement, choice);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "votes")) {
            List votes = PollsVoteUtil.findByQuestionId((long)question.getQuestionId());
            for (PollsVote vote : votes) {
                PollsPortletDataHandlerImpl.exportVote(portletDataContext, votesElement, vote);
            }
        }
        portletDataContext.addClassedModel(questionElement, path, (ClassedModel)question, _NAMESPACE);
    }

    protected static void exportVote(PortletDataContext portletDataContext, Element questionsElement, PollsVote vote) throws Exception {
        String path = PollsPortletDataHandlerImpl.getVotePath(portletDataContext, vote);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element voteElement = questionsElement.addElement("vote");
        portletDataContext.addClassedModel(voteElement, path, (ClassedModel)vote, _NAMESPACE);
    }

    protected static String getChoicePath(PortletDataContext portletDataContext, PollsChoice choice) {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getPortletPath("25"));
        sb.append("/questions/");
        sb.append(choice.getQuestionId());
        sb.append("/choices/");
        sb.append(choice.getChoiceId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getQuestionPath(PortletDataContext portletDataContext, PollsQuestion question) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("25"));
        sb.append("/questions/");
        sb.append(question.getQuestionId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getVotePath(PortletDataContext portletDataContext, PollsVote vote) {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getPortletPath("25"));
        sb.append("/questions/");
        sb.append(vote.getQuestionId());
        sb.append("/votes/");
        sb.append(vote.getVoteId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static void importChoice(PortletDataContext portletDataContext, PollsChoice choice) throws Exception {
        Map questionPKs = portletDataContext.getNewPrimaryKeysMap(PollsQuestion.class);
        long questionId = MapUtil.getLong((Map)questionPKs, (long)choice.getQuestionId(), (long)choice.getQuestionId());
        PollsChoice importedChoice = null;
        if (portletDataContext.isDataStrategyMirror()) {
            PollsChoice existingChoice = PollsChoiceFinderUtil.fetchByUUID_G((String)choice.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingChoice == null) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setUuid(choice.getUuid());
                importedChoice = PollsChoiceLocalServiceUtil.addChoice((long)questionId, (String)choice.getName(), (String)choice.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedChoice = PollsChoiceLocalServiceUtil.updateChoice((long)existingChoice.getChoiceId(), (long)questionId, (String)choice.getName(), (String)choice.getDescription());
            }
        } else {
            importedChoice = PollsChoiceLocalServiceUtil.addChoice((long)questionId, (String)choice.getName(), (String)choice.getDescription(), (ServiceContext)new ServiceContext());
        }
        portletDataContext.importClassedModel((ClassedModel)choice, (ClassedModel)importedChoice, _NAMESPACE);
    }

    protected static void importQuestion(PortletDataContext portletDataContext, Element questionElement, PollsQuestion question) throws Exception {
        long userId = portletDataContext.getUserId(question.getUserUuid());
        Date expirationDate = question.getExpirationDate();
        int expirationMonth = 0;
        int expirationDay = 0;
        int expirationYear = 0;
        int expirationHour = 0;
        int expirationMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar();
            expirationCal.setTime(expirationDate);
            expirationMonth = expirationCal.get(2);
            expirationDay = expirationCal.get(5);
            expirationYear = expirationCal.get(1);
            expirationHour = expirationCal.get(10);
            expirationMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationHour += 12;
            }
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext(questionElement, (ClassedModel)question, _NAMESPACE);
        PollsQuestion importedQuestion = null;
        if (portletDataContext.isDataStrategyMirror()) {
            PollsQuestion existingQuestion = PollsQuestionUtil.fetchByUUID_G((String)question.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingQuestion == null) {
                serviceContext.setUuid(question.getUuid());
                importedQuestion = PollsQuestionLocalServiceUtil.addQuestion((long)userId, (Map)question.getTitleMap(), (Map)question.getDescriptionMap(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext);
            } else {
                importedQuestion = PollsQuestionLocalServiceUtil.updateQuestion((long)userId, (long)existingQuestion.getQuestionId(), (Map)question.getTitleMap(), (Map)question.getDescriptionMap(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext);
            }
        } else {
            importedQuestion = PollsQuestionLocalServiceUtil.addQuestion((long)userId, (Map)question.getTitleMap(), (Map)question.getDescriptionMap(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)question, (ClassedModel)importedQuestion, _NAMESPACE);
    }

    protected static void importVote(PortletDataContext portletDataContext, PollsVote vote) throws Exception {
        long userId = portletDataContext.getUserId(vote.getUserUuid());
        Map questionPKs = portletDataContext.getNewPrimaryKeysMap(PollsQuestion.class);
        long questionId = MapUtil.getLong((Map)questionPKs, (long)vote.getQuestionId(), (long)vote.getQuestionId());
        Map choicePKs = portletDataContext.getNewPrimaryKeysMap(PollsChoice.class);
        long choiceId = MapUtil.getLong((Map)choicePKs, (long)vote.getChoiceId(), (long)vote.getChoiceId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCreateDate(vote.getVoteDate());
        try {
            PollsVoteLocalServiceUtil.addVote((long)userId, (long)questionId, (long)choiceId, (ServiceContext)serviceContext);
        }
        catch (DuplicateVoteException duplicateVoteException) {}
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(PollsPortletDataHandlerImpl.class, "deleteData")) {
            PollsQuestionLocalServiceUtil.deleteQuestions((long)portletDataContext.getScopeGroupId());
        }
        return null;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.polls", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("polls-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        Element questionsElement = rootElement.addElement("questions");
        Element choicesElement = rootElement.addElement("choices");
        Element votesElement = rootElement.addElement("votes");
        List questions = PollsQuestionUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (PollsQuestion question : questions) {
            PollsPortletDataHandlerImpl.exportQuestion(portletDataContext, questionsElement, choicesElement, votesElement, question);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.polls", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element questionsElement = rootElement.element("questions");
        for (Element questionElement : questionsElement.elements("question")) {
            String path = questionElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            PollsQuestion question = (PollsQuestion)portletDataContext.getZipEntryAsObject(path);
            PollsPortletDataHandlerImpl.importQuestion(portletDataContext, questionElement, question);
        }
        Element choicesElement = rootElement.element("choices");
        for (Element choiceElement : choicesElement.elements("choice")) {
            String path = choiceElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            PollsChoice choice = (PollsChoice)portletDataContext.getZipEntryAsObject(path);
            PollsPortletDataHandlerImpl.importChoice(portletDataContext, choice);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "votes")) {
            Element votesElement = rootElement.element("votes");
            for (Element voteElement : votesElement.elements("vote")) {
                String path = voteElement.attributeValue("path");
                if (!portletDataContext.isPathNotProcessed(path)) continue;
                PollsVote vote = (PollsVote)portletDataContext.getZipEntryAsObject(path);
                PollsPortletDataHandlerImpl.importVote(portletDataContext, vote);
            }
        }
        return null;
    }
}

