/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.service.base.MDRRuleGroupServiceBaseImpl;
import com.liferay.portlet.mobiledevicerules.service.permission.MDRPermissionUtil;
import com.liferay.portlet.mobiledevicerules.service.permission.MDRRuleGroupPermissionUtil;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDRRuleGroupServiceImpl
extends MDRRuleGroupServiceBaseImpl {
    public MDRRuleGroup addRuleGroup(long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ADD_RULE_GROUP");
        return this.mdrRuleGroupLocalService.addRuleGroup(groupId, nameMap, descriptionMap, serviceContext);
    }

    public MDRRuleGroup copyRuleGroup(long ruleGroupId, long groupId, ServiceContext serviceContext) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        MDRRuleGroup ruleGroup = this.getRuleGroup(ruleGroupId);
        MDRRuleGroupPermissionUtil.check((PermissionChecker)permissionChecker, (MDRRuleGroup)ruleGroup, (String)"VIEW");
        MDRPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_RULE_GROUP");
        return this.mdrRuleGroupLocalService.copyRuleGroup(ruleGroup, groupId, serviceContext);
    }

    public void deleteRuleGroup(long ruleGroupId) throws PortalException, SystemException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (MDRRuleGroup)ruleGroup, (String)"DELETE");
        this.mdrRuleGroupLocalService.deleteRuleGroup(ruleGroup);
    }

    public MDRRuleGroup fetchRuleGroup(long ruleGroupId) throws PortalException, SystemException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.fetchByPrimaryKey(ruleGroupId);
        if (ruleGroup != null) {
            MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (MDRRuleGroup)ruleGroup, (String)"VIEW");
        }
        return ruleGroup;
    }

    public MDRRuleGroup getRuleGroup(long ruleGroupId) throws PortalException, SystemException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (MDRRuleGroup)ruleGroup, (String)"VIEW");
        return ruleGroup;
    }

    public MDRRuleGroup updateRuleGroup(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (MDRRuleGroup)ruleGroup, (String)"UPDATE");
        return this.mdrRuleGroupLocalService.updateRuleGroup(ruleGroupId, nameMap, descriptionMap, serviceContext);
    }
}

