/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.mobiledevicerules.model.MDRRule;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.service.base.MDRRuleGroupLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDRRuleGroupLocalServiceImpl
extends MDRRuleGroupLocalServiceBaseImpl {
    public MDRRuleGroup addRuleGroup(long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(serviceContext.getUserId());
        Date now = new Date();
        long ruleGroupId = this.counterLocalService.increment();
        MDRRuleGroup ruleGroup = this.createMDRRuleGroup(ruleGroupId);
        ruleGroup.setUuid(serviceContext.getUuid());
        ruleGroup.setGroupId(groupId);
        ruleGroup.setCompanyId(serviceContext.getCompanyId());
        ruleGroup.setCreateDate(serviceContext.getCreateDate(now));
        ruleGroup.setModifiedDate(serviceContext.getModifiedDate(now));
        ruleGroup.setUserId(user.getUserId());
        ruleGroup.setUserName(user.getFullName());
        ruleGroup.setNameMap(nameMap);
        ruleGroup.setDescriptionMap(descriptionMap);
        return this.updateMDRRuleGroup(ruleGroup, false);
    }

    public MDRRuleGroup copyRuleGroup(long ruleGroupId, long groupId, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        return this.copyRuleGroup(ruleGroup, groupId, serviceContext);
    }

    public MDRRuleGroup copyRuleGroup(MDRRuleGroup ruleGroup, long groupId, ServiceContext serviceContext) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Map nameMap = ruleGroup.getNameMap();
        for (Map.Entry entry : nameMap.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            String name = (String)entry.getValue();
            if (Validator.isNull((String)name)) continue;
            String postfix = LanguageUtil.get((Locale)locale, (String)PropsValues.MOBILE_DEVICE_RULES_RULE_GROUP_COPY_POSTFIX);
            nameMap.put(locale, name.concat(" ").concat(postfix));
        }
        MDRRuleGroup newRuleGroup = this.addRuleGroup(group.getGroupId(), nameMap, ruleGroup.getDescriptionMap(), serviceContext);
        List rules = this.mdrRulePersistence.findByRuleGroupId(ruleGroup.getRuleGroupId());
        for (MDRRule rule : rules) {
            serviceContext.setUuid(PortalUUIDUtil.generate());
            this.mdrRuleLocalService.copyRule(rule, newRuleGroup.getRuleGroupId(), serviceContext);
        }
        return newRuleGroup;
    }

    public void deleteRuleGroup(long ruleGroupId) throws SystemException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.fetchByPrimaryKey(ruleGroupId);
        if (ruleGroup != null) {
            this.deleteRuleGroup(ruleGroup);
        }
    }

    public void deleteRuleGroup(MDRRuleGroup ruleGroup) throws SystemException {
        this.mdrRuleGroupPersistence.remove((BaseModel)ruleGroup);
        this.mdrRuleLocalService.deleteRules(ruleGroup.getRuleGroupId());
        this.mdrRuleGroupInstanceLocalService.deleteRuleGroupInstances(ruleGroup.getRuleGroupId());
    }

    public void deleteRuleGroups(long groupId) throws SystemException {
        List ruleGroups = this.mdrRuleGroupPersistence.findByGroupId(groupId);
        for (MDRRuleGroup ruleGroup : ruleGroups) {
            this.deleteRuleGroup(ruleGroup);
        }
    }

    public MDRRuleGroup fetchRuleGroup(long ruleGroupId) throws SystemException {
        return this.mdrRuleGroupPersistence.fetchByPrimaryKey(ruleGroupId);
    }

    public MDRRuleGroup getRuleGroup(long ruleGroupId) throws PortalException, SystemException {
        return this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
    }

    public List<MDRRuleGroup> getRuleGroups(long groupId) throws SystemException {
        return this.mdrRuleGroupPersistence.findByGroupId(groupId);
    }

    public List<MDRRuleGroup> getRuleGroups(long groupId, int start, int end) throws SystemException {
        return this.mdrRuleGroupPersistence.findByGroupId(groupId, start, end);
    }

    public int getRuleGroupsCount(long groupId) throws SystemException {
        return this.mdrRuleGroupPersistence.countByGroupId(groupId);
    }

    public List<MDRRuleGroup> search(long groupId, String name, boolean andOperator, int start, int end) throws SystemException {
        return this.mdrRuleGroupFinder.findByG_N(groupId, name, andOperator, start, end);
    }

    public List<MDRRuleGroup> searchByKeywords(long groupId, String keywords, boolean andOperator, int start, int end) throws SystemException {
        return this.mdrRuleGroupFinder.findByKeywords(groupId, keywords, start, end);
    }

    public int searchByKeywordsCount(long groupId, String keywords, boolean andOperator) throws SystemException {
        return this.mdrRuleGroupFinder.countByKeywords(groupId, keywords);
    }

    public int searchCount(long groupId, String name, boolean andOperator) throws SystemException {
        return this.mdrRuleGroupFinder.countByG_N(groupId, name, andOperator);
    }

    public MDRRuleGroup updateRuleGroup(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        ruleGroup.setModifiedDate(serviceContext.getModifiedDate(null));
        ruleGroup.setNameMap(nameMap);
        ruleGroup.setDescriptionMap(descriptionMap);
        this.mdrRuleGroupPersistence.update((BaseModel)ruleGroup, false);
        return ruleGroup;
    }
}

