/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.persistence;

import com.liferay.portal.NoSuchSubscriptionException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.persistence.MBCategoryFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBCategoryFinderImpl
extends BasePersistenceImpl<MBCategory>
implements MBCategoryFinder {
    public static String COUNT_BY_S_G_U_P = String.valueOf(MBCategoryFinder.class.getName()) + ".countByS_G_U_P";
    public static String FIND_BY_S_G_U_P = String.valueOf(MBCategoryFinder.class.getName()) + ".findByS_G_U_P";

    public int countByS_G_U_P(long groupId, long userId, long[] parentCategoryIds) throws SystemException {
        return this.doCountByS_G_U_P(groupId, userId, parentCategoryIds, false);
    }

    public int filterCountByS_G_U_P(long groupId, long userId, long[] parentCategoryIds) throws SystemException {
        return this.doCountByS_G_U_P(groupId, userId, parentCategoryIds, true);
    }

    public List<MBCategory> filterFindByS_G_U_P(long groupId, long userId, long[] parentCategoryIds, int start, int end) throws SystemException {
        return this.doFindByS_G_U_P(groupId, userId, parentCategoryIds, start, end, true);
    }

    public List<MBCategory> findByS_G_U_P(long groupId, long userId, long[] parentCategoryIds, int start, int end) throws SystemException {
        return this.doFindByS_G_U_P(groupId, userId, parentCategoryIds, start, end, false);
    }

    protected int doCountByS_G_U_P(long groupId, long userId, long[] parentCategoryIds, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long l;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_S_G_U_P);
            sql = parentCategoryIds == null || parentCategoryIds.length == 0 ? StringUtil.replace((String)sql, (String)"(MBCategory.parentCategoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"MBCategory.parentCategoryId = ?", (String)("MBCategory.parentCategoryId = " + StringUtil.merge((long[])parentCategoryIds, (String)" OR MBCategory.parentCategoryId = ")));
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBCategory.class.getName(), (String)"MBCategory.categoryId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(PortalUtil.getClassNameId((String)MBCategory.class.getName()));
            qPos.add(groupId);
            qPos.add(userId);
            int count = 0;
            Iterator itr = q.iterate();
            if (itr.hasNext() && (l = (Long)itr.next()) != null) {
                count = l.intValue();
            }
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                SubscriptionLocalServiceUtil.getSubscription((long)group.getCompanyId(), (long)userId, (String)MBCategory.class.getName(), (long)groupId);
                ++count;
            }
            catch (NoSuchSubscriptionException noSuchSubscriptionException) {}
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<MBCategory> doFindByS_G_U_P(long groupId, long userId, long[] parentCategoryIds, int start, int end, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_S_G_U_P);
            sql = parentCategoryIds == null || parentCategoryIds.length == 0 ? StringUtil.replace((String)sql, (String)"(MBCategory.parentCategoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"MBCategory.parentCategoryId = ?", (String)("MBCategory.parentCategoryId = " + StringUtil.merge((long[])parentCategoryIds, (String)" OR MBCategory.parentCategoryId = ")));
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBCategory.class.getName(), (String)"MBCategory.categoryId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("MBCategory", MBCategoryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(PortalUtil.getClassNameId((String)MBCategory.class.getName()));
            qPos.add(groupId);
            qPos.add(userId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)-1, (int)-1, (boolean)false);
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                SubscriptionLocalServiceUtil.getSubscription((long)group.getCompanyId(), (long)userId, (String)MBCategory.class.getName(), (long)groupId);
                int threadCount = MBThreadLocalServiceUtil.getCategoryThreadsCount((long)groupId, (long)MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID, (int)0);
                int messageCount = MBMessageLocalServiceUtil.getCategoryMessagesCount((long)groupId, (long)MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID, (int)0);
                MBCategoryImpl category = new MBCategoryImpl();
                category.setCompanyId(group.getCompanyId());
                category.setName(group.getName());
                category.setDescription(group.getDescription());
                category.setThreadCount(threadCount);
                category.setMessageCount(messageCount);
                list.add(category);
            }
            catch (NoSuchSubscriptionException noSuchSubscriptionException) {}
            UnmodifiableList unmodifiableList = new UnmodifiableList(ListUtil.subList((List)list, (int)start, (int)end));
            return unmodifiableList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

