/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.pop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.pop.MessageListenerException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionCheckerUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.NoSuchCategoryException;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.portlet.messageboards.util.MBUtil;
import java.io.InputStream;
import javax.mail.Message;
import javax.mail.Part;
import org.apache.commons.lang.time.StopWatch;

public class MessageListenerImpl
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(MessageListenerImpl.class);

    public boolean accept(String from, String recipient, Message message) {
        Company company;
        block7: {
            String messageId;
            block6: {
                try {
                    messageId = this.getMessageId(recipient, message);
                    if (messageId != null && messageId.startsWith("mb_message.", this.getOffset())) break block6;
                    return false;
                }
                catch (Exception e) {
                    if (_log.isErrorEnabled()) {
                        _log.error((Object)("Unable to process message: " + message), (Throwable)e);
                    }
                    return false;
                }
            }
            company = this.getCompany(messageId);
            long categoryId = this.getCategoryId(messageId);
            MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
            if (category.getCompanyId() == company.getCompanyId()) break block7;
            return false;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Check to see if user " + from + " exists"));
        }
        UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)from);
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deliver(String from, String recipient, Message message) throws MessageListenerException {
        block21: {
            inputStreamOVPs = null;
            try {
                try {
                    stopWatch = null;
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        stopWatch = new StopWatch();
                        stopWatch.start();
                        MessageListenerImpl._log.debug((Object)("Deliver message from " + from + " to " + recipient));
                    }
                    messageId = this.getMessageId(recipient, message);
                    company = this.getCompany(messageId);
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Message id " + messageId));
                    }
                    groupId = 0L;
                    categoryId = this.getCategoryId(messageId);
                    try {
                        category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
                        groupId = category.getGroupId();
                    }
                    catch (NoSuchCategoryException v0) {
                        groupId = categoryId;
                        categoryId = MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID;
                    }
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Group id " + groupId));
                        MessageListenerImpl._log.debug((Object)("Category id " + categoryId));
                    }
                    user = UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)from);
                    parentMessageId = this.getParentMessageId(recipient, message);
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Parent message id " + parentMessageId));
                    }
                    parentMessage = null;
                    try {
                        if (parentMessageId > 0L) {
                            parentMessage = MBMessageLocalServiceUtil.getMessage((long)parentMessageId);
                        }
                    }
                    catch (NoSuchMessageException v1) {}
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Parent message " + parentMessage));
                    }
                    subject = MBUtil.getSubjectWithoutMessageId(message);
                    mbMailMessage = new MBMailMessage();
                    MBUtil.collectPartContent((Part)message, mbMailMessage);
                    inputStreamOVPs = mbMailMessage.getInputStreamOVPs();
                    PermissionCheckerUtil.setThreadValues(user);
                    serviceContext = new ServiceContext();
                    serviceContext.setAddGroupPermissions(true);
                    serviceContext.setAddGuestPermissions(true);
                    serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL((long)groupId, (String)"19"));
                    serviceContext.setScopeGroupId(groupId);
                    if (parentMessage == null) {
                        MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (String)subject, (String)mbMailMessage.getBody(), (String)MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, (boolean)false, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
                    } else {
                        MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (long)parentMessage.getThreadId(), (long)parentMessage.getMessageId(), (String)subject, (String)mbMailMessage.getBody(), (String)MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, (boolean)false, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
                    }
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Delivering message takes " + stopWatch.getTime() + " ms"));
                    }
                }
                catch (PrincipalException pe) {
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Prevented unauthorized post from " + from));
                    }
                    throw new MessageListenerException((Throwable)pe);
                }
                catch (Exception e) {
                    MessageListenerImpl._log.error((Object)e, (Throwable)e);
                    throw new MessageListenerException((Throwable)e);
                }
            }
            finally {
                if (inputStreamOVPs == null) break block21;
                ** for (inputStreamOVP : inputStreamOVPs)
            }
lbl-1000:
            // 1 sources

            {
                inputStream = (InputStream)inputStreamOVP.getValue();
                StreamUtil.cleanUp((InputStream)inputStream);
                continue;
            }
        }
        PermissionCheckerUtil.setThreadValues(null);
    }

    public String getId() {
        return MessageListenerImpl.class.getName();
    }

    protected long getCategoryId(String recipient) {
        int pos = recipient.indexOf(64);
        String target = recipient.substring("mb_message.".length() + this.getOffset(), pos);
        String[] parts = StringUtil.split((String)target, (char)'.');
        return GetterUtil.getLong((String)parts[0]);
    }

    protected Company getCompany(String messageId) throws Exception {
        int pos = messageId.indexOf(64) + PropsValues.POP_SERVER_SUBDOMAIN.length() + 1;
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() > 0) {
            ++pos;
        }
        String mx = messageId.substring(pos, messageId.length() - 1);
        return CompanyLocalServiceUtil.getCompanyByMx((String)mx);
    }

    protected String getMessageId(String recipient, Message message) throws Exception {
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() > 0) {
            return recipient;
        }
        return MBUtil.getParentMessageIdString(message);
    }

    protected int getOffset() {
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() == 0) {
            return 1;
        }
        return 0;
    }

    protected long getParentMessageId(String recipient, Message message) throws Exception {
        if (!StringUtil.startsWith((String)recipient, (String)"mb_message.")) {
            return MBUtil.getParentMessageId(message);
        }
        int pos = recipient.indexOf(64);
        if (pos < 0) {
            return MBUtil.getParentMessageId(message);
        }
        String target = recipient.substring("mb_message.".length(), pos);
        String[] parts = StringUtil.split((String)target, (char)'.');
        long parentMessageId = 0L;
        if (parts.length == 2) {
            parentMessageId = GetterUtil.getLong((String)parts[1]);
        }
        if (parentMessageId > 0L) {
            return parentMessageId;
        }
        return MBUtil.getParentMessageId(message);
    }
}

