/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchDirectoryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageBaseImpl;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;

public class MBMessageImpl
extends MBMessageBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(MBMessageImpl.class);
    private String _attachmentDirs;

    public String[] getAssetTagNames() throws SystemException {
        return AssetTagLocalServiceUtil.getTagNames((String)MBMessage.class.getName(), (long)this.getMessageId());
    }

    public String getAttachmentsDir() {
        if (this._attachmentDirs == null) {
            this._attachmentDirs = String.valueOf(this.getThreadAttachmentsDir()) + "/" + this.getMessageId();
        }
        return this._attachmentDirs;
    }

    public String[] getAttachmentsFiles() throws PortalException, SystemException {
        String[] fileNames = new String[]{};
        try {
            fileNames = DLStoreUtil.getFileNames((long)this.getCompanyId(), (long)0L, (String)this.getAttachmentsDir());
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {}
        return fileNames;
    }

    public String getBody(boolean translate) {
        String body = null;
        body = translate ? BBCodeTranslatorUtil.getHTML((String)this.getBody()) : this.getBody();
        return body;
    }

    public MBCategory getCategory() {
        MBCategory category = null;
        long categoryId = this.getCategoryId();
        try {
            category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        }
        catch (Exception e) {
            category = new MBCategoryImpl();
            category.setCategoryId(this.getCategoryId());
            _log.error((Throwable)e);
        }
        return category;
    }

    public MBThread getThread() throws PortalException, SystemException {
        return MBThreadLocalServiceUtil.getThread((long)this.getThreadId());
    }

    public String getThreadAttachmentsDir() {
        return "messageboards/" + this.getThreadId();
    }

    public String getWorkflowClassName() {
        if (this.isDiscussion()) {
            return MBDiscussion.class.getName();
        }
        return MBMessage.class.getName();
    }

    public boolean isDiscussion() {
        return this.getCategoryId() == MBCategoryConstants.DISCUSSION_CATEGORY_ID;
    }

    public boolean isFormatBBCode() {
        String format = this.getFormat();
        return format.equals("bbcode");
    }

    public boolean isReply() {
        return !this.isRoot();
    }

    public boolean isRoot() {
        return this.getParentMessageId() == MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID;
    }

    public void setAttachmentsDir(String attachmentsDir) {
        this._attachmentDirs = attachmentsDir;
    }
}

