/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.messageboards.model.MBBan;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.MBThreadFlag;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadFlagLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.persistence.MBBanUtil;
import com.liferay.portlet.messageboards.service.persistence.MBCategoryUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessageUtil;
import com.liferay.portlet.messageboards.service.persistence.MBThreadFlagUtil;
import com.liferay.portlet.messageboards.service.persistence.MBThreadUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "message_board";
    private static Log _log = LogFactoryUtil.getLog(MBPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _attachments = new PortletDataHandlerBoolean("message_board", "attachments");
    private static PortletDataHandlerBoolean _categoriesAndMessages = new PortletDataHandlerBoolean("message_board", "categories-and-messages", true, true);
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("message_board", "ratings");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("message_board", "tags");
    private static PortletDataHandlerBoolean _threadFlags = new PortletDataHandlerBoolean("message_board", "thread-flags");
    private static PortletDataHandlerBoolean _userBans = new PortletDataHandlerBoolean("message_board", "user-bans");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_categoriesAndMessages, _attachments, _threadFlags, _userBans, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_categoriesAndMessages, _attachments, _threadFlags, _userBans, _ratings, _tags};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return PropsValues.MESSAGE_BOARDS_PUBLISH_TO_LIVE_BY_DEFAULT;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(MBPortletDataHandlerImpl.class, "deleteData")) {
            MBCategoryLocalServiceUtil.deleteCategories((long)portletDataContext.getScopeGroupId());
            MBThreadLocalServiceUtil.deleteThreads((long)portletDataContext.getScopeGroupId(), (long)MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID);
        }
        return null;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.messageboards", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("message-boards-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        Element categoriesElement = rootElement.addElement("categories");
        Element messagesElement = rootElement.addElement("messages");
        Element threadFlagsElement = rootElement.addElement("thread-flags");
        Element userBansElement = rootElement.addElement("user-bans");
        List categories = MBCategoryUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (MBCategory category : categories) {
            this.exportCategory(portletDataContext, categoriesElement, messagesElement, threadFlagsElement, category);
        }
        List messages = MBMessageUtil.findByG_C((long)portletDataContext.getScopeGroupId(), (long)MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID);
        for (MBMessage message : messages) {
            this.exportMessage(portletDataContext, categoriesElement, messagesElement, threadFlagsElement, message);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "user-bans")) {
            List bans = MBBanUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
            for (MBBan ban : bans) {
                this.exportBan(portletDataContext, userBansElement, ban);
            }
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        String path;
        portletDataContext.importPermissions("com.liferay.portlet.messageboards", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element categoriesElement = rootElement.element("categories");
        for (Element categoryElement : categoriesElement.elements("category")) {
            String path2 = categoryElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path2)) continue;
            MBCategory category = (MBCategory)portletDataContext.getZipEntryAsObject(path2);
            this.importCategory(portletDataContext, path2, category);
        }
        Element messagesElement = rootElement.element("messages");
        for (Element messageElement : messagesElement.elements("message")) {
            String path3 = messageElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path3)) continue;
            MBMessage message = (MBMessage)portletDataContext.getZipEntryAsObject(path3);
            this.importMessage(portletDataContext, messageElement, message);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "thread-flags")) {
            Element threadFlagsElement = rootElement.element("thread-flags");
            for (Element threadFlagElement : threadFlagsElement.elements("thread-flag")) {
                path = threadFlagElement.attributeValue("path");
                if (!portletDataContext.isPathNotProcessed(path)) continue;
                MBThreadFlag threadFlag = (MBThreadFlag)portletDataContext.getZipEntryAsObject(path);
                this.importThreadFlag(portletDataContext, threadFlagElement, threadFlag);
            }
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "user-bans")) {
            Element userBansElement = rootElement.element("user-bans");
            for (Element userBanElement : userBansElement.elements("user-ban")) {
                path = userBanElement.attributeValue("path");
                if (!portletDataContext.isPathNotProcessed(path)) continue;
                MBBan ban = (MBBan)portletDataContext.getZipEntryAsObject(path);
                this.importBan(portletDataContext, userBanElement, ban);
            }
        }
        return null;
    }

    protected void exportBan(PortletDataContext portletDataContext, Element userBansElement, MBBan ban) throws Exception {
        if (!portletDataContext.isWithinDateRange(ban.getModifiedDate())) {
            return;
        }
        String path = this.getUserBanPath(portletDataContext, ban);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element userBanElement = userBansElement.addElement("user-ban");
        ban.setBanUserUuid(ban.getBanUserUuid());
        portletDataContext.addClassedModel(userBanElement, path, (ClassedModel)ban, _NAMESPACE);
    }

    protected void exportCategory(PortletDataContext portletDataContext, Element categoriesElement, Element messagesElement, Element threadFlagsElement, MBCategory category) throws Exception {
        if (portletDataContext.isWithinDateRange(category.getModifiedDate())) {
            this.exportParentCategory(portletDataContext, categoriesElement, category.getParentCategoryId());
            String path = this.getCategoryPath(portletDataContext, category);
            if (portletDataContext.isPathNotProcessed(path)) {
                Element categoryElement = categoriesElement.addElement("category");
                portletDataContext.addClassedModel(categoryElement, path, (ClassedModel)category, _NAMESPACE);
            }
        }
        List messages = MBMessageUtil.findByG_C((long)category.getGroupId(), (long)category.getCategoryId());
        for (MBMessage message : messages) {
            this.exportMessage(portletDataContext, categoriesElement, messagesElement, threadFlagsElement, message);
        }
    }

    protected void exportMessage(PortletDataContext portletDataContext, Element categoriesElement, Element messagesElement, Element threadFlagsElement, MBMessage message) throws Exception {
        if (!portletDataContext.isWithinDateRange(message.getModifiedDate())) {
            return;
        }
        if (message.getStatus() != 0) {
            return;
        }
        this.exportParentCategory(portletDataContext, categoriesElement, message.getCategoryId());
        String path = this.getMessagePath(portletDataContext, message);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element messageElement = messagesElement.addElement("message");
        message.setPriority(message.getPriority());
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "attachments") && message.isAttachments()) {
            String[] stringArray = message.getAttachmentsFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attachment = stringArray[n2];
                int pos = attachment.lastIndexOf(47);
                String name = attachment.substring(pos + 1);
                String binPath = this.getMessageAttachementBinPath(portletDataContext, message, name);
                Element attachmentElement = messageElement.addElement("attachment");
                attachmentElement.addAttribute("name", name);
                attachmentElement.addAttribute("bin-path", binPath);
                byte[] bytes = DLStoreUtil.getFileAsBytes((long)portletDataContext.getCompanyId(), (long)0L, (String)attachment);
                portletDataContext.addZipEntry(binPath, bytes);
                ++n2;
            }
            message.setAttachmentsDir(message.getAttachmentsDir());
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "thread-flags")) {
            List threadFlags = MBThreadFlagUtil.findByThreadId((long)message.getThreadId());
            for (MBThreadFlag threadFlag : threadFlags) {
                this.exportThreadFlag(portletDataContext, threadFlagsElement, threadFlag);
            }
        }
        portletDataContext.addClassedModel(messageElement, path, (ClassedModel)message, _NAMESPACE);
    }

    protected void exportParentCategory(PortletDataContext portletDataContext, Element categoriesElement, long categoryId) throws Exception {
        if (!portletDataContext.hasDateRange() || categoryId == MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID || categoryId == MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
            return;
        }
        MBCategory category = MBCategoryUtil.findByPrimaryKey((long)categoryId);
        this.exportParentCategory(portletDataContext, categoriesElement, category.getParentCategoryId());
        String path = this.getCategoryPath(portletDataContext, category);
        if (portletDataContext.isPathNotProcessed(path)) {
            Element categoryElement = categoriesElement.addElement("category");
            portletDataContext.addClassedModel(categoryElement, path, (ClassedModel)category, _NAMESPACE);
        }
    }

    protected void exportThreadFlag(PortletDataContext portletDataContext, Element threadFlagsElement, MBThreadFlag threadFlag) throws Exception {
        String path = this.getThreadFlagPath(portletDataContext, threadFlag);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element threadFlagElement = threadFlagsElement.addElement("thread-flag");
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)threadFlag.getThreadId());
        MBMessage rootMessage = MBMessageLocalServiceUtil.getMessage((long)thread.getRootMessageId());
        threadFlagElement.addAttribute("root-message-uuid", rootMessage.getUuid());
        portletDataContext.addClassedModel(threadFlagElement, path, (ClassedModel)threadFlag, _NAMESPACE);
    }

    protected List<ObjectValuePair<String, InputStream>> getAttachments(PortletDataContext portletDataContext, Element messageElement, MBMessage message) {
        if (!message.isAttachments() && portletDataContext.getBooleanParameter(_NAMESPACE, "attachments")) {
            return Collections.emptyList();
        }
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>();
        List attachmentElements = messageElement.elements("attachment");
        for (Element attachmentElement : attachmentElements) {
            String name = attachmentElement.attributeValue("name");
            String binPath = attachmentElement.attributeValue("bin-path");
            InputStream inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
            ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)name, (Object)inputStream);
            inputStreamOVPs.add((ObjectValuePair<String, InputStream>)inputStreamOVP);
        }
        if (inputStreamOVPs.isEmpty()) {
            _log.error((Object)("Could not find attachments for message " + message.getMessageId()));
        }
        return inputStreamOVPs;
    }

    protected long getCategoryId(PortletDataContext portletDataContext, MBMessage message, Map<Long, Long> categoryPKs, long categoryId) throws Exception {
        if (categoryId != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && categoryId != MBCategoryConstants.DISCUSSION_CATEGORY_ID && categoryId == message.getCategoryId()) {
            String path = this.getImportCategoryPath(portletDataContext, categoryId);
            MBCategory category = (MBCategory)portletDataContext.getZipEntryAsObject(path);
            this.importCategory(portletDataContext, path, category);
            categoryId = MapUtil.getLong(categoryPKs, (long)message.getCategoryId(), (long)message.getCategoryId());
        }
        return categoryId;
    }

    protected String getCategoryPath(PortletDataContext portletDataContext, MBCategory category) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("19"));
        sb.append("/categories/");
        sb.append(category.getCategoryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getImportCategoryPath(PortletDataContext portletDataContext, long categoryId) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getSourcePortletPath("19"));
        sb.append("/categories/");
        sb.append(categoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getMessageAttachementBinPath(PortletDataContext portletDataContext, MBMessage message, String attachment) {
        StringBundler sb = new StringBundler(5);
        sb.append(portletDataContext.getPortletPath("19"));
        sb.append("/bin/");
        sb.append(message.getMessageId());
        sb.append("/");
        sb.append(PortalUUIDUtil.generate());
        return sb.toString();
    }

    protected String getMessagePath(PortletDataContext portletDataContext, MBMessage message) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("19"));
        sb.append("/messages/");
        sb.append(message.getMessageId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getThreadFlagPath(PortletDataContext portletDataContext, MBThreadFlag threadFlag) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("19"));
        sb.append("/thread-flags/");
        sb.append(threadFlag.getThreadFlagId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getUserBanPath(PortletDataContext portletDataContext, MBBan ban) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("19"));
        sb.append("/user-bans/");
        sb.append(ban.getBanId());
        sb.append(".xml");
        return sb.toString();
    }

    protected void importBan(PortletDataContext portletDataContext, Element userBanElement, MBBan ban) throws Exception {
        long userId = portletDataContext.getUserId(ban.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext(userBanElement, (ClassedModel)ban, _NAMESPACE);
        List users = UserUtil.findByUuid((String)ban.getBanUserUuid());
        Iterator itr = users.iterator();
        if (itr.hasNext()) {
            User user = (User)itr.next();
            MBBanLocalServiceUtil.addBan((long)userId, (long)user.getUserId(), (ServiceContext)serviceContext);
        } else {
            _log.error((Object)("Could not find banned user with uuid " + ban.getBanUserUuid()));
        }
    }

    protected void importCategory(PortletDataContext portletDataContext, String categoryPath, MBCategory category) throws Exception {
        long userId = portletDataContext.getUserId(category.getUserUuid());
        Map categoryPKs = portletDataContext.getNewPrimaryKeysMap(MBCategory.class);
        long parentCategoryId = MapUtil.getLong((Map)categoryPKs, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        String emailAddress = null;
        String inProtocol = null;
        String inServerName = null;
        int inServerPort = 0;
        boolean inUseSSL = false;
        String inUserName = null;
        String inPassword = null;
        int inReadInterval = 0;
        String outEmailAddress = null;
        boolean outCustom = false;
        String outServerName = null;
        int outServerPort = 0;
        boolean outUseSSL = false;
        String outUserName = null;
        String outPassword = null;
        boolean allowAnonymous = false;
        boolean mailingListActive = false;
        ServiceContext serviceContext = portletDataContext.createServiceContext(categoryPath, (ClassedModel)category, _NAMESPACE);
        if (parentCategoryId != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && parentCategoryId != MBCategoryConstants.DISCUSSION_CATEGORY_ID && parentCategoryId == category.getParentCategoryId()) {
            String path = this.getImportCategoryPath(portletDataContext, parentCategoryId);
            MBCategory parentCategory = (MBCategory)portletDataContext.getZipEntryAsObject(path);
            this.importCategory(portletDataContext, path, parentCategory);
            parentCategoryId = MapUtil.getLong((Map)categoryPKs, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        }
        MBCategory importedCategory = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MBCategory existingCategory = MBCategoryUtil.fetchByUUID_G((String)category.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingCategory == null) {
                serviceContext.setUuid(category.getUuid());
                importedCategory = MBCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), (String)category.getDisplayStyle(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (ServiceContext)serviceContext);
            } else {
                importedCategory = MBCategoryLocalServiceUtil.updateCategory((long)existingCategory.getCategoryId(), (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), (String)category.getDisplayStyle(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            importedCategory = MBCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), (String)category.getDisplayStyle(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)category, (ClassedModel)importedCategory, _NAMESPACE);
    }

    /*
     * Unable to fully structure code
     */
    protected void importMessage(PortletDataContext portletDataContext, Element messageElement, MBMessage message) throws Exception {
        userId = portletDataContext.getUserId(message.getUserUuid());
        userName = message.getUserName();
        categoryPKs = portletDataContext.getNewPrimaryKeysMap(MBCategory.class);
        categoryId = MapUtil.getLong((Map)categoryPKs, (long)message.getCategoryId(), (long)message.getCategoryId());
        threadPKs = portletDataContext.getNewPrimaryKeysMap(MBThread.class);
        threadId = MapUtil.getLong((Map)threadPKs, (long)message.getThreadId(), (long)0L);
        messagePKs = portletDataContext.getNewPrimaryKeysMap(MBMessage.class);
        parentMessageId = MapUtil.getLong((Map)messagePKs, (long)message.getParentMessageId(), (long)message.getParentMessageId());
        existingFiles = new ArrayList<E>();
        inputStreamOVPs = this.getAttachments(portletDataContext, messageElement, message);
        try {
            serviceContext = portletDataContext.createServiceContext(messageElement, (ClassedModel)message, "message_board");
            if (message.getStatus() != 0) {
                serviceContext.setWorkflowAction(2);
            }
            categoryId = this.getCategoryId(portletDataContext, message, categoryPKs, categoryId);
            importedMessage = null;
            if (portletDataContext.isDataStrategyMirror()) {
                existingMessage = MBMessageUtil.fetchByUUID_G((String)message.getUuid(), (long)portletDataContext.getScopeGroupId());
                if (existingMessage == null) {
                    serviceContext.setUuid(message.getUuid());
                    importedMessage = MBMessageLocalServiceUtil.addMessage((long)userId, (String)userName, (long)portletDataContext.getScopeGroupId(), (long)categoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (String)message.getFormat(), inputStreamOVPs, (boolean)message.getAnonymous(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
                } else {
                    importedMessage = MBMessageLocalServiceUtil.updateMessage((long)userId, (long)existingMessage.getMessageId(), (String)message.getSubject(), (String)message.getBody(), inputStreamOVPs, existingFiles, (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
                }
            } else {
                importedMessage = MBMessageLocalServiceUtil.addMessage((long)userId, (String)userName, (long)portletDataContext.getScopeGroupId(), (long)categoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (String)message.getFormat(), inputStreamOVPs, (boolean)message.getAnonymous(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
            }
            threadPKs.put(message.getThreadId(), importedMessage.getThreadId());
            portletDataContext.importClassedModel((ClassedModel)message, (ClassedModel)importedMessage, "message_board");
        }
        finally {
            ** for (inputStreamOVP : inputStreamOVPs)
        }
lbl-1000:
        // 1 sources

        {
            inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((InputStream)inputStream);
            continue;
        }
lbl35:
        // 1 sources

    }

    protected void importThreadFlag(PortletDataContext portletDataContext, Element threadFlagElement, MBThreadFlag threadFlag) throws Exception {
        String rootMessageUuid;
        MBMessage rootMessage;
        long userId = portletDataContext.getUserId(threadFlag.getUserUuid());
        Map messagePKs = portletDataContext.getNewPrimaryKeysMap(MBMessage.class);
        long threadId = MapUtil.getLong((Map)messagePKs, (long)threadFlag.getThreadId(), (long)threadFlag.getThreadId());
        MBThread thread = MBThreadUtil.fetchByPrimaryKey((long)threadId);
        if (thread == null && (rootMessage = MBMessageUtil.fetchByUUID_G((String)(rootMessageUuid = threadFlagElement.attributeValue("root-message-uuid")), (long)portletDataContext.getScopeGroupId())) != null) {
            thread = rootMessage.getThread();
        }
        if (thread == null) {
            return;
        }
        MBThreadFlagLocalServiceUtil.addThreadFlag((long)userId, (MBThread)thread);
    }
}

