/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.captcha.CaptchaMaxChallengesException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.CategoryNameException;
import com.liferay.portlet.messageboards.MailingListEmailAddressException;
import com.liferay.portlet.messageboards.MailingListInServerNameException;
import com.liferay.portlet.messageboards.MailingListInUserNameException;
import com.liferay.portlet.messageboards.MailingListOutEmailAddressException;
import com.liferay.portlet.messageboards.MailingListOutServerNameException;
import com.liferay.portlet.messageboards.MailingListOutUserNameException;
import com.liferay.portlet.messageboards.NoSuchCategoryException;
import com.liferay.portlet.messageboards.action.ActionUtil;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.service.MBCategoryServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditCategoryAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateCategory(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteCategories(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeCategory(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeCategory(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchCategoryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.message_boards.error");
            }
            if (e instanceof CaptchaMaxChallengesException || e instanceof CaptchaTextException || e instanceof CategoryNameException || e instanceof MailingListEmailAddressException || e instanceof MailingListInServerNameException || e instanceof MailingListInUserNameException || e instanceof MailingListOutEmailAddressException || e instanceof MailingListOutServerNameException || e instanceof MailingListOutUserNameException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getCategory((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchCategoryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.message_boards.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.message_boards.edit_category"));
    }

    protected void deleteCategories(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        if (categoryId > 0L) {
            MBCategoryServiceUtil.deleteCategory((long)themeDisplay.getScopeGroupId(), (long)categoryId);
        } else {
            long[] deleteCategoryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteCategoryIds"), (long)0L);
            int i = 0;
            while (i < deleteCategoryIds.length) {
                MBCategoryServiceUtil.deleteCategory((long)themeDisplay.getScopeGroupId(), (long)deleteCategoryIds[i]);
                ++i;
            }
        }
    }

    protected void subscribeCategory(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        MBCategoryServiceUtil.subscribeCategory((long)themeDisplay.getScopeGroupId(), (long)categoryId);
    }

    protected void unsubscribeCategory(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        MBCategoryServiceUtil.unsubscribeCategory((long)themeDisplay.getScopeGroupId(), (long)categoryId);
    }

    protected void updateCategory(ActionRequest actionRequest) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        long parentCategoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentCategoryId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String displayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"displayStyle");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        String inProtocol = ParamUtil.getString((PortletRequest)actionRequest, (String)"inProtocol");
        String inServerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"inServerName");
        int inServerPort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"inServerPort");
        boolean inUseSSL = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"inUseSSL");
        String inUserName = ParamUtil.getString((PortletRequest)actionRequest, (String)"inUserName");
        String inPassword = ParamUtil.getString((PortletRequest)actionRequest, (String)"inPassword");
        int inReadInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"inReadInterval");
        String outEmailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"outEmailAddress");
        boolean outCustom = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"outCustom");
        String outServerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"outServerName");
        int outServerPort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"outServerPort");
        boolean outUseSSL = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"outUseSSL");
        String outUserName = ParamUtil.getString((PortletRequest)actionRequest, (String)"outUserName");
        String outPassword = ParamUtil.getString((PortletRequest)actionRequest, (String)"outPassword");
        boolean allowAnonymous = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowAnonymous");
        boolean mailingListActive = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mailingListActive");
        boolean mergeWithParentCategory = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeWithParentCategory");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBCategory.class.getName(), (PortletRequest)actionRequest);
        if (categoryId <= 0L) {
            if (PropsValues.CAPTCHA_CHECK_PORTLET_MESSAGE_BOARDS_EDIT_CATEGORY) {
                CaptchaUtil.check((PortletRequest)actionRequest);
            }
            MBCategoryServiceUtil.addCategory((long)parentCategoryId, (String)name, (String)description, (String)displayStyle, (String)emailAddress, (String)inProtocol, (String)inServerName, (int)inServerPort, (boolean)inUseSSL, (String)inUserName, (String)inPassword, (int)inReadInterval, (String)outEmailAddress, (boolean)outCustom, (String)outServerName, (int)outServerPort, (boolean)outUseSSL, (String)outUserName, (String)outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (ServiceContext)serviceContext);
        } else {
            MBCategoryServiceUtil.updateCategory((long)categoryId, (long)parentCategoryId, (String)name, (String)description, (String)displayStyle, (String)emailAddress, (String)inProtocol, (String)inServerName, (int)inServerPort, (boolean)inUseSSL, (String)inUserName, (String)inPassword, (int)inReadInterval, (String)outEmailAddress, (boolean)outCustom, (String)outServerName, (int)outServerPort, (boolean)outUseSSL, (String)outUserName, (String)outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (boolean)mergeWithParentCategory, (ServiceContext)serviceContext);
        }
    }
}

