/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;

public class ConfigurationActionImpl
extends DefaultConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
        if (tabs2.equals("email-from")) {
            this.validateEmailFrom(actionRequest);
        } else if (tabs2.equals("message-added-email")) {
            this.validateEmailMessageAdded(actionRequest);
        } else if (tabs2.equals("message-updated-email")) {
            this.validateEmailMessageUpdated(actionRequest);
        } else if (tabs2.equals("thread-priorities")) {
            this.updateThreadPriorities(actionRequest);
        } else if (tabs2.equals("user-ranks")) {
            this.updateUserRanks(actionRequest);
        }
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    protected void validateEmailFrom(ActionRequest actionRequest) throws Exception {
        String emailFromName = this.getParameter((PortletRequest)actionRequest, "emailFromName");
        String emailFromAddress = this.getParameter((PortletRequest)actionRequest, "emailFromAddress");
        if (Validator.isNull((String)emailFromName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromName");
        } else if (!Validator.isEmailAddress((String)emailFromAddress) && !Validator.isVariableTerm((String)emailFromAddress)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromAddress");
        }
    }

    protected void validateEmailMessageAdded(ActionRequest actionRequest) throws Exception {
        String emailMessageAddedSubjectPrefix = this.getParameter((PortletRequest)actionRequest, "emailMessageAddedSubjectPrefix");
        String emailMessageAddedBody = this.getParameter((PortletRequest)actionRequest, "emailMessageAddedBody");
        if (Validator.isNull((String)emailMessageAddedSubjectPrefix)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailMessageAddedSubjectPrefix");
        } else if (Validator.isNull((String)emailMessageAddedBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailMessageAddedBody");
        }
    }

    protected void validateEmailMessageUpdated(ActionRequest actionRequest) throws Exception {
        String emailMessageUpdatedSubjectPrefix = this.getParameter((PortletRequest)actionRequest, "emailMessageUpdatedSubjectPrefix");
        String emailMessageUpdatedBody = this.getParameter((PortletRequest)actionRequest, "emailMessageUpdatedBody");
        if (Validator.isNull((String)emailMessageUpdatedSubjectPrefix)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailMessageUpdatedSubjectPrefix");
        } else if (Validator.isNull((String)emailMessageUpdatedBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailMessageUpdatedBody");
        }
    }

    protected void updateThreadPriorities(ActionRequest actionRequest) throws Exception {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            String languageId = LocaleUtil.toLanguageId((Locale)locales[i]);
            ArrayList<String> priorities = new ArrayList<String>();
            int j = 0;
            while (j < 10) {
                String name = ParamUtil.getString((PortletRequest)actionRequest, (String)("priorityName" + j + "_" + languageId));
                String image = ParamUtil.getString((PortletRequest)actionRequest, (String)("priorityImage" + j + "_" + languageId));
                double value = ParamUtil.getDouble((PortletRequest)actionRequest, (String)("priorityValue" + j + "_" + languageId));
                if (Validator.isNotNull((String)name) || Validator.isNotNull((String)image) || value != 0.0) {
                    priorities.add(String.valueOf(name) + "," + image + "," + value);
                }
                ++j;
            }
            String preferenceName = LocalizationUtil.getPreferencesKey((String)"priorities", (String)languageId);
            this.setPreference((PortletRequest)actionRequest, preferenceName, priorities.toArray(new String[priorities.size()]));
            ++i;
        }
    }

    protected void updateUserRanks(ActionRequest actionRequest) throws Exception {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            String kvpValue;
            String languageId = LocaleUtil.toLanguageId((Locale)locales[i]);
            String[] ranks = StringUtil.splitLines((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("ranks_" + languageId)));
            TreeMap<String, String> map = new TreeMap<String, String>();
            int j = 0;
            while (j < ranks.length) {
                String[] kvp = StringUtil.split((String)ranks[j], (char)'=');
                String kvpName = kvp[0];
                kvpValue = kvp[1];
                map.put(kvpValue, kvpName);
                ++j;
            }
            ranks = new String[map.size()];
            int count = 0;
            for (Map.Entry entry : map.entrySet()) {
                kvpValue = (String)entry.getKey();
                String kvpName = (String)entry.getValue();
                ranks[count++] = String.valueOf(kvpName) + "=" + kvpValue;
            }
            String preferenceName = LocalizationUtil.getPreferencesKey((String)"ranks", (String)languageId);
            this.setPreference((PortletRequest)actionRequest, preferenceName, ranks);
            ++i;
        }
    }
}

