/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBCategoryServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBPermission;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static void getCategory(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        String topLink = ParamUtil.getString((HttpServletRequest)request, (String)"topLink");
        if (topLink.equals("banned-users") && !MBPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "BAN_USER")) {
            throw new PrincipalException();
        }
        MBBanLocalServiceUtil.checkBan((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId());
        long categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId");
        MBCategory category = null;
        if (categoryId > 0L && categoryId != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID) {
            category = MBCategoryServiceUtil.getCategory((long)categoryId);
        } else {
            MBPermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW");
        }
        request.setAttribute("MESSAGE_BOARDS_CATEGORY", (Object)category);
    }

    public static void getCategory(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getCategory(request);
    }

    public static void getMessage(HttpServletRequest request) throws Exception {
        long messageId = ParamUtil.getLong((HttpServletRequest)request, (String)"messageId");
        MBMessage message = null;
        if (messageId > 0L) {
            message = MBMessageServiceUtil.getMessage((long)messageId);
        }
        request.setAttribute("MESSAGE_BOARDS_MESSAGE", (Object)message);
    }

    public static void getMessage(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getMessage(request);
    }

    public static void getThreadMessage(HttpServletRequest request) throws Exception {
        long threadId = ParamUtil.getLong((HttpServletRequest)request, (String)"threadId");
        MBMessage message = null;
        if (threadId > 0L) {
            MBThread thread = MBThreadLocalServiceUtil.getThread((long)threadId);
            message = MBMessageServiceUtil.getMessage((long)thread.getRootMessageId());
        }
        request.setAttribute("MESSAGE_BOARDS_MESSAGE", message);
    }

    public static void getThreadMessage(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ActionUtil.getThreadMessage(request);
    }
}

