/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.CompanyMaxUsersException;
import com.liferay.portal.CookieNotSupportedException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.PasswordExpiredException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserIdException;
import com.liferay.portal.UserLockoutException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.login.util.LoginUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LoginAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static Log _log = LogFactoryUtil.getLog(LoginAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            actionResponse.sendRedirect(String.valueOf(themeDisplay.getPathMain()) + PropsValues.AUTH_LOGIN_DISABLED_PATH);
            return;
        }
        try {
            PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest);
            this.login(themeDisplay, actionRequest, actionResponse, preferences);
            boolean doActionAfterLogin = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"doActionAfterLogin");
            if (doActionAfterLogin) {
                this.setForward((PortletRequest)actionRequest, "portlet.login.login_redirect");
            }
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                Throwable cause = e.getCause();
                if (cause instanceof PasswordExpiredException || cause instanceof UserLockoutException) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)cause.getClass().getName());
                } else {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Authentication failed");
                    }
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                }
            }
            if (e instanceof CompanyMaxUsersException || e instanceof CookieNotSupportedException || e instanceof NoSuchUserException || e instanceof PasswordExpiredException || e instanceof UserEmailAddressException || e instanceof UserIdException || e instanceof UserLockoutException || e instanceof UserPasswordException || e instanceof UserScreenNameException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            _log.error((Object)e, (Throwable)e);
            PortalUtil.sendError((Exception)e, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.login.login"));
    }

    protected String getCompleteRedirectURL(HttpServletRequest request, String redirect) {
        HttpSession session = request.getSession();
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        String portalURL = null;
        portalURL = PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !PropsValues.SESSION_ENABLE_PHISHING_PROTECTION && httpsInitial != null && httpsInitial == false ? PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)false) : PortalUtil.getPortalURL((HttpServletRequest)request);
        return portalURL.concat(redirect);
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void login(ThemeDisplay themeDisplay, ActionRequest actionRequest, ActionResponse actionResponse, PortletPreferences preferences) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        String login = ParamUtil.getString((PortletRequest)actionRequest, (String)"login");
        String password = actionRequest.getParameter("password");
        boolean rememberMe = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"rememberMe");
        String authType = preferences.getValue("authType", null);
        LoginUtil.login(request, response, login, password, rememberMe, authType);
        if (PropsValues.PORTAL_JAAS_ENABLE) {
            actionResponse.sendRedirect(String.valueOf(themeDisplay.getPathMain()) + "/portal/protected");
        } else {
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (Validator.isNotNull((String)redirect)) {
                if (!(redirect = PortalUtil.escapeRedirect((String)redirect)).startsWith("http")) {
                    redirect = this.getCompleteRedirectURL(request, redirect);
                }
                actionResponse.sendRedirect(redirect);
            } else {
                boolean doActionAfterLogin = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"doActionAfterLogin");
                if (doActionAfterLogin) {
                    return;
                }
                actionResponse.sendRedirect(themeDisplay.getPathMain());
            }
        }
    }
}

