/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.facebook.FacebookConnectUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletConfig;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FacebookConnectAction
extends PortletAction {
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        if (!FacebookConnectUtil.isEnabled((long)themeDisplay.getCompanyId())) {
            return null;
        }
        return mapping.findForward("portlet.login.facebook_login");
    }

    public ActionForward strutsExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (!FacebookConnectUtil.isEnabled((long)themeDisplay.getCompanyId())) {
            return null;
        }
        HttpSession session = request.getSession();
        String redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
        String code = ParamUtil.getString((HttpServletRequest)request, (String)"code");
        String token = FacebookConnectUtil.getAccessToken((long)themeDisplay.getCompanyId(), (String)redirect, (String)code);
        if (!Validator.isNotNull((String)token)) {
            return mapping.findForward("/common/referer_js.jsp");
        }
        session.setAttribute("FACEBOOK_ACCESS_TOKEN", (Object)token);
        this.setFacebookCredentials(session, themeDisplay.getCompanyId(), token);
        response.sendRedirect(redirect);
        return null;
    }

    protected void addUser(HttpSession session, long companyId, JSONObject jsonObject) throws Exception {
        long creatorUserId = 0L;
        boolean autoPassword = true;
        String password1 = "";
        String password2 = "";
        boolean autoScreenName = true;
        String screenName = "";
        String emailAddress = jsonObject.getString("email");
        long facebookId = jsonObject.getLong("id");
        String openId = "";
        Locale locale = LocaleUtil.getDefault();
        String firstName = jsonObject.getString("first_name");
        String middleName = "";
        String lastName = jsonObject.getString("last_name");
        int prefixId = 0;
        int suffixId = 0;
        boolean male = Validator.equals((Object)jsonObject.getString("gender"), (Object)"male");
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = true;
        ServiceContext serviceContext = new ServiceContext();
        User user = UserLocalServiceUtil.addUser((long)creatorUserId, (long)companyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (long)facebookId, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, (long[])groupIds, (long[])organizationIds, (long[])roleIds, (long[])userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
        UserLocalServiceUtil.updateLastLogin((long)user.getUserId(), (String)user.getLoginIP());
        UserLocalServiceUtil.updatePasswordReset((long)user.getUserId(), (boolean)false);
        UserLocalServiceUtil.updateEmailAddressVerified((long)user.getUserId(), (boolean)true);
        session.setAttribute("FACEBOOK_USER_EMAIL_ADDRESS", (Object)emailAddress);
    }

    protected void setFacebookCredentials(HttpSession session, long companyId, String token) throws Exception {
        JSONObject jsonObject = FacebookConnectUtil.getGraphResources((long)companyId, (String)"/me", (String)token, (String)"id,email,first_name,last_name,gender");
        if (jsonObject == null || jsonObject.getJSONObject("error") != null) {
            return;
        }
        if (FacebookConnectUtil.isVerifiedAccountRequired((long)companyId) && !jsonObject.getBoolean("verified")) {
            return;
        }
        User user = null;
        long facebookId = jsonObject.getLong("id");
        if (facebookId > 0L) {
            session.setAttribute("FACEBOOK_USER_ID", (Object)String.valueOf(facebookId));
            try {
                user = UserLocalServiceUtil.getUserByFacebookId((long)companyId, (long)facebookId);
            }
            catch (NoSuchUserException noSuchUserException) {}
        }
        String emailAddress = jsonObject.getString("email");
        if (user == null && Validator.isNotNull((String)emailAddress)) {
            session.setAttribute("FACEBOOK_USER_EMAIL_ADDRESS", (Object)emailAddress);
            try {
                user = UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)emailAddress);
            }
            catch (NoSuchUserException noSuchUserException) {}
        }
        if (user != null) {
            this.updateUser(user, jsonObject);
        } else {
            this.addUser(session, companyId, jsonObject);
        }
    }

    protected void updateUser(User user, JSONObject jsonObject) throws Exception {
        long facebookId = jsonObject.getLong("id");
        String emailAddress = jsonObject.getString("email");
        String firstName = jsonObject.getString("first_name");
        String lastName = jsonObject.getString("last_name");
        boolean male = Validator.equals((Object)jsonObject.getString("gender"), (Object)"male");
        if (facebookId == user.getFacebookId() && emailAddress.equals(user.getEmailAddress()) && firstName.equals(user.getFirstName()) && lastName.equals(user.getLastName()) && male == user.isMale()) {
            return;
        }
        Contact contact = user.getContact();
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(contact.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        List userGroupRoles = null;
        long[] userGroupIds = null;
        ServiceContext serviceContext = new ServiceContext();
        if (!emailAddress.equalsIgnoreCase(user.getEmailAddress())) {
            UserLocalServiceUtil.updateEmailAddress((long)user.getUserId(), (String)"", (String)emailAddress, (String)emailAddress);
        }
        UserLocalServiceUtil.updateEmailAddressVerified((long)user.getUserId(), (boolean)true);
        UserLocalServiceUtil.updateUser((long)user.getUserId(), (String)"", (String)"", (String)"", (boolean)false, (String)user.getReminderQueryQuestion(), (String)user.getReminderQueryAnswer(), (String)user.getScreenName(), (String)emailAddress, (long)facebookId, (String)user.getOpenId(), (String)user.getLanguageId(), (String)user.getTimeZoneId(), (String)user.getGreeting(), (String)user.getComments(), (String)firstName, (String)user.getMiddleName(), (String)lastName, (int)contact.getPrefixId(), (int)contact.getSuffixId(), (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)contact.getSmsSn(), (String)contact.getAimSn(), (String)contact.getFacebookSn(), (String)contact.getIcqSn(), (String)contact.getJabberSn(), (String)contact.getMsnSn(), (String)contact.getMySpaceSn(), (String)contact.getSkypeSn(), (String)contact.getTwitterSn(), (String)contact.getYmSn(), (String)contact.getJobTitle(), (long[])groupIds, (long[])organizationIds, (long[])roleIds, userGroupRoles, (long[])userGroupIds, (ServiceContext)serviceContext);
    }
}

