/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.LayoutTypePortletImpl;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.sites.util.SitesUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetLayoutsAction
extends JSONAction {
    @Override
    public String getJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List layoutAncestors = null;
        long selPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"selPlid");
        if (selPlid != 0L) {
            Layout selLayout = LayoutLocalServiceUtil.getLayout((long)selPlid);
            layoutAncestors = selLayout.getAncestors();
        }
        List<Layout> layouts = this.getLayouts(request);
        for (Layout layout : layouts) {
            Layout sourcePrototypeLayout;
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("contentDisplayPage", layout.isContentDisplayPage());
            jsonObject.put("hasChildren", layout.hasChildren());
            jsonObject.put("layoutId", layout.getLayoutId());
            String name = layout.getName(themeDisplay.getLocale());
            if (SitesUtil.isLayoutToBeUpdatedFromSourcePrototype(layout) && (sourcePrototypeLayout = LayoutTypePortletImpl.getSourcePrototypeLayout(layout)) != null) {
                name = sourcePrototypeLayout.getName(themeDisplay.getLocale());
            }
            jsonObject.put("name", name);
            jsonObject.put("parentLayoutId", layout.getParentLayoutId());
            jsonObject.put("plid", layout.getPlid());
            jsonObject.put("priority", layout.getPriority());
            jsonObject.put("privateLayout", layout.isPrivateLayout());
            if (layoutAncestors != null && layoutAncestors.contains(layout)) {
                jsonObject.put("selLayoutAncestor", true);
            }
            jsonObject.put("type", layout.getType());
            jsonObject.put("updateable", SitesUtil.isLayoutUpdateable(layout));
            jsonObject.put("uuid", layout.getUuid());
            LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
            if (layoutRevision != null) {
                User user = themeDisplay.getUser();
                long recentLayoutSetBranchId = StagingUtil.getRecentLayoutSetBranchId((User)user, (long)layout.getLayoutSet().getLayoutSetId());
                if (StagingUtil.isIncomplete((Layout)layout, (long)recentLayoutSetBranchId)) {
                    jsonObject.put("incomplete", true);
                }
                long layoutSetBranchId = layoutRevision.getLayoutSetBranchId();
                LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)layoutSetBranchId);
                LayoutBranch layoutBranch = layoutRevision.getLayoutBranch();
                if (!layoutBranch.isMaster()) {
                    jsonObject.put("layoutBranchId", layoutBranch.getLayoutBranchId());
                    jsonObject.put("layoutBranchName", layoutBranch.getName());
                }
                jsonObject.put("layoutRevisionId", layoutRevision.getLayoutRevisionId());
                jsonObject.put("layoutSetBranchId", layoutSetBranchId);
                jsonObject.put("layoutSetBranchName", layoutSetBranch.getName());
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray.toString();
    }

    protected List<Layout> getLayouts(HttpServletRequest request) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"parentLayoutId");
        boolean incomplete = ParamUtil.getBoolean((HttpServletRequest)request, (String)"incomplete", (boolean)true);
        int start = ParamUtil.getInteger((HttpServletRequest)request, (String)"start");
        int end = start + PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN;
        return LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (boolean)incomplete, (int)start, (int)end);
    }
}

