/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutconfiguration.util.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.PortletRenderWeightComparator;
import com.liferay.portlet.layoutconfiguration.util.RuntimePortletUtil;
import com.liferay.portlet.layoutconfiguration.util.velocity.RuntimeLogic;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletColumnLogic
extends RuntimeLogic {
    private static Log _log = LogFactoryUtil.getLog(PortletColumnLogic.class);
    private ServletContext _servletContext;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private ThemeDisplay _themeDisplay;
    private Map<Portlet, Object[]> _portletsMap;
    private boolean _parallelRenderEnable;

    public PortletColumnLogic(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this._servletContext = servletContext;
        this._request = request;
        this._response = response;
        this._themeDisplay = (ThemeDisplay)this._request.getAttribute("THEME_DISPLAY");
        this._portletsMap = new TreeMap<Portlet, Object[]>((Comparator<Portlet>)new PortletRenderWeightComparator());
        this._parallelRenderEnable = PropsValues.LAYOUT_PARALLEL_RENDER_ENABLE;
        if (this._parallelRenderEnable && PropsValues.SESSION_DISABLED && _log.isWarnEnabled()) {
            _log.warn((Object)"Parallel rendering should be disabled if sessions are disabled");
        }
        if (this._parallelRenderEnable) {
            Boolean portletParallelRender = (Boolean)request.getAttribute("PORTLET_PARALLEL_RENDER");
            if (portletParallelRender != null && !portletParallelRender.booleanValue()) {
                this._parallelRenderEnable = false;
            }
        } else {
            request.removeAttribute("PORTLET_PARALLEL_RENDER");
        }
    }

    @Override
    public String processContent(Map<String, String> attributes) throws Exception {
        String additionalClassNames;
        LayoutTypePortlet layoutTypePortlet = this._themeDisplay.getLayoutTypePortlet();
        String columnId = attributes.get("id");
        List portlets = layoutTypePortlet.getAllPortlets(columnId);
        String columnCssClass = "portlet-dropzone";
        if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isColumnDisabled(columnId)) {
            columnCssClass = String.valueOf(columnCssClass) + " portlet-dropzone-disabled";
        }
        if (layoutTypePortlet.isTemplateCustomizable(columnId) && layoutTypePortlet.isColumnCustomizable(columnId)) {
            columnCssClass = String.valueOf(columnCssClass) + " customizable";
        }
        if (portlets.size() == 0) {
            columnCssClass = String.valueOf(columnCssClass) + " empty";
        }
        if (Validator.isNotNull((String)(additionalClassNames = attributes.get("classNames")))) {
            columnCssClass = String.valueOf(columnCssClass) + " " + additionalClassNames;
        }
        StringBundler sb = new StringBundler();
        sb.append("<div class=\"");
        sb.append(columnCssClass);
        sb.append("\" id=\"layout-column_");
        sb.append(columnId);
        sb.append("\">");
        int i = 0;
        while (i < portlets.size()) {
            Portlet portlet = (Portlet)portlets.get(i);
            String queryString = null;
            Integer columnPos = new Integer(i);
            Integer columnCount = new Integer(portlets.size());
            String path = null;
            if (this._parallelRenderEnable) {
                path = "/html/portal/load_render_portlet.jsp";
                if (portlet.getRenderWeight() >= 1) {
                    this._portletsMap.put(portlet, new Object[]{queryString, columnId, columnPos, columnCount});
                }
            }
            String content = RuntimePortletUtil.processPortlet((ServletContext)this._servletContext, (HttpServletRequest)this._request, (HttpServletResponse)this._response, (Portlet)portlet, queryString, (String)columnId, (Integer)columnPos, (Integer)columnCount, (String)path, (boolean)false);
            sb.append(content);
            ++i;
        }
        sb.append("</div>");
        return sb.toString();
    }

    public Map<Portlet, Object[]> getPortletsMap() {
        return this._portletsMap;
    }
}

