/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutconfiguration.util.velocity;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.CustomizedPages;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.impl.LayoutTypePortletImpl;
import com.liferay.portlet.layoutconfiguration.util.velocity.ColumnProcessor;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class CustomizationSettingsProcessor
implements ColumnProcessor {
    private static MethodKey _doEndTagMethodKey = new MethodKey("com.liferay.taglib.aui.InputTag", "doEndTag", new Class[0]);
    private static MethodKey _doStartTagMethodKey = new MethodKey("com.liferay.taglib.aui.InputTag", "doStartTag", new Class[0]);
    private static Class<?> _inputTagClass;
    private UnicodeProperties _layoutTypeSettings;
    private PageContext _pageContext;
    private HttpServletRequest _request;
    private Layout _templateLayout;
    private Writer _writer;

    static {
        try {
            _inputTagClass = Class.forName("com.liferay.taglib.aui.InputTag");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public CustomizationSettingsProcessor(HttpServletRequest request, PageContext pageContext, Writer writer) {
        this._pageContext = pageContext;
        this._request = request;
        this._writer = writer;
        Layout selLayout = (Layout)this._request.getAttribute("edit_pages.jsp-selLayout");
        this._layoutTypeSettings = selLayout.getTypeSettingsProperties();
        this._templateLayout = LayoutTypePortletImpl.getSourcePrototypeLayout(selLayout);
    }

    public String processColumn(String columnId) throws Exception {
        return this.processColumn(columnId, "");
    }

    public String processColumn(String columnId, String classNames) throws Exception {
        String customizableKey = CustomizedPages.namespaceColumnId((String)columnId);
        boolean templateCustomizable = true;
        if (this._templateLayout != null) {
            templateCustomizable = GetterUtil.getBoolean((String)this._templateLayout.getTypeSettingsProperty(customizableKey));
        }
        boolean customizable = false;
        if (templateCustomizable) {
            customizable = GetterUtil.getBoolean((String)this._layoutTypeSettings.getProperty(customizableKey, String.valueOf(false)));
        }
        this._writer.append("<div class=\"");
        this._writer.append(classNames);
        this._writer.append("\">");
        this._writer.append("<h1>");
        this._writer.append(columnId);
        this._writer.append("</h1>");
        Object inputTag = _inputTagClass.newInstance();
        BeanPropertiesUtil.setProperty(inputTag, (String)"disabled", (Object)(!templateCustomizable ? 1 : 0));
        BeanPropertiesUtil.setProperty(inputTag, (String)"label", (Object)"customizable");
        BeanPropertiesUtil.setProperty(inputTag, (String)"name", (Object)"TypeSettingsProperties--".concat(customizableKey).concat("--"));
        BeanPropertiesUtil.setProperty(inputTag, (String)"pageContext", (Object)this._pageContext);
        BeanPropertiesUtil.setProperty(inputTag, (String)"type", (Object)"checkbox");
        BeanPropertiesUtil.setProperty(inputTag, (String)"value", (Object)customizable);
        MethodHandler doEndMethodHandler = new MethodHandler(_doEndTagMethodKey, new Object[0]);
        MethodHandler doStartMethodHandler = new MethodHandler(_doStartTagMethodKey, new Object[0]);
        int result = (Integer)doStartMethodHandler.invoke(inputTag);
        if (result == 1) {
            doEndMethodHandler.invoke(inputTag);
        }
        this._writer.append("</div>");
        return "";
    }

    public String processMax() throws Exception {
        return this.processMax("");
    }

    public String processMax(String classNames) throws Exception {
        return "";
    }

    public String processPortlet(String portletId) throws Exception {
        this._writer.append("<div class=\"portlet\">");
        this._writer.append(portletId);
        this._writer.append("</div>");
        return "";
    }
}

