/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutconfiguration.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PipingPageContext;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.kernel.velocity.VelocityVariablesUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.PortletDisplayFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.layoutconfiguration.util.RuntimePortlet;
import com.liferay.portlet.layoutconfiguration.util.RuntimePortletUtil;
import com.liferay.portlet.layoutconfiguration.util.velocity.CustomizationSettingsProcessor;
import com.liferay.portlet.layoutconfiguration.util.velocity.TemplateProcessor;
import com.liferay.portlet.layoutconfiguration.util.xml.RuntimeLogic;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class RuntimePortletImpl
implements RuntimePortlet {
    private static Log _log = LogFactoryUtil.getLog(RuntimePortletUtil.class);
    private static MethodKey _initMethodKey = new MethodKey("com.liferay.taglib.util.VelocityTaglib", "init", new Class[]{ServletContext.class, HttpServletRequest.class, HttpServletResponse.class, PageContext.class});

    public String processCustomizationSettings(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, String velocityTemplateId, String velocityTemplateContent) throws Exception {
        if (Validator.isNull((String)velocityTemplateContent)) {
            return "";
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        CustomizationSettingsProcessor processor = new CustomizationSettingsProcessor(request, (PageContext)new PipingPageContext(pageContext, (Writer)unsyncStringWriter), (Writer)unsyncStringWriter);
        VelocityContext velocityContext = VelocityEngineUtil.getWrappedStandardToolsContext();
        velocityContext.put("processor", (Object)processor);
        VelocityVariablesUtil.insertVariables((VelocityContext)velocityContext, (HttpServletRequest)request);
        MethodHandler methodHandler = new MethodHandler(_initMethodKey, new Object[]{servletContext, request, new PipingServletResponse(response, (Writer)unsyncStringWriter), pageContext});
        Object velocityTaglib = methodHandler.invoke(true);
        velocityContext.put("taglibLiferay", velocityTaglib);
        velocityContext.put("theme", velocityTaglib);
        try {
            VelocityEngineUtil.mergeTemplate((String)velocityTemplateId, (String)velocityTemplateContent, (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw e;
        }
        return unsyncStringWriter.toString();
    }

    public String processPortlet(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, RenderRequest renderRequest, RenderResponse renderResponse, String portletId, String queryString, boolean writeOutput) throws Exception {
        return this.processPortlet(servletContext, request, response, renderRequest, renderResponse, portletId, queryString, null, null, null, writeOutput);
    }

    public String processPortlet(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, RenderRequest renderRequest, RenderResponse renderResponse, String portletId, String queryString, String columnId, Integer columnPos, Integer columnCount, boolean writeOutput) throws Exception {
        return this.processPortlet(servletContext, request, response, renderRequest, renderResponse, null, portletId, queryString, columnId, columnPos, columnCount, null, writeOutput);
    }

    public String processPortlet(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Portlet portlet, String queryString, String columnId, Integer columnPos, Integer columnCount, String path, boolean writeOutput) throws Exception {
        return this.processPortlet(servletContext, request, response, null, null, portlet, portlet.getPortletId(), queryString, columnId, columnPos, columnCount, path, writeOutput);
    }

    public String processPortlet(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, RenderRequest renderRequest, RenderResponse renderResponse, Portlet portlet, String portletId, String queryString, String columnId, Integer columnPos, Integer columnCount, String path, boolean writeOutput) throws Exception {
        String instanceId;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (portlet == null) {
            portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        }
        if (!(portlet == null || !portlet.isInstanceable() || portlet.isAddDefaultResource() || Validator.isNotNull((String)(instanceId = portlet.getInstanceId())) && Validator.isPassword((String)instanceId) && instanceId.length() >= 4)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Portlet " + portlet.getPortletId() + " is instanceable but does not have a " + "valid instance id"));
            }
            portlet = null;
        }
        if (portlet == null) {
            return "";
        }
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        PortletDisplay portletDisplayClone = PortletDisplayFactory.create();
        portletDisplay.copyTo(portletDisplayClone);
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        try {
            String string = PortalUtil.renderPortlet((ServletContext)servletContext, (HttpServletRequest)request, (HttpServletResponse)response, (Portlet)portlet, (String)queryString, (String)columnId, (Integer)columnPos, (Integer)columnCount, (String)path, (boolean)writeOutput);
            return string;
        }
        finally {
            portletDisplay.copyFrom(portletDisplayClone);
            portletDisplayClone.recycle();
            RuntimePortletImpl._defineObjects(request, portletConfig, renderRequest, renderResponse);
        }
    }

    public void processTemplate(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, JspWriter jspWriter, String velocityTemplateId, String velocityTemplateContent) throws Exception {
        this.processTemplate(servletContext, request, response, pageContext, jspWriter, null, velocityTemplateId, velocityTemplateContent);
    }

    public void processTemplate(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, JspWriter jspWriter, String portletId, String velocityTemplateId, String velocityTemplateContent) throws Exception {
        if (Validator.isNull((String)velocityTemplateContent)) {
            return;
        }
        TemplateProcessor processor = new TemplateProcessor(servletContext, request, response, portletId);
        VelocityContext velocityContext = VelocityEngineUtil.getWrappedStandardToolsContext();
        velocityContext.put("processor", (Object)processor);
        VelocityVariablesUtil.insertVariables((VelocityContext)velocityContext, (HttpServletRequest)request);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        MethodHandler methodHandler = new MethodHandler(_initMethodKey, new Object[]{servletContext, request, new PipingServletResponse(response, (Writer)unsyncStringWriter), pageContext});
        Object velocityTaglib = methodHandler.invoke(true);
        velocityContext.put("taglibLiferay", velocityTaglib);
        velocityContext.put("theme", velocityTaglib);
        try {
            VelocityEngineUtil.mergeTemplate((String)velocityTemplateId, (String)velocityTemplateContent, (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw e;
        }
        String output = unsyncStringWriter.toString();
        Map<Portlet, Object[]> portletsMap = processor.getPortletsMap();
        HashMap<String, StringBundler> contentsMap = new HashMap<String, StringBundler>(portletsMap.size());
        for (Map.Entry<Portlet, Object[]> entry : portletsMap.entrySet()) {
            Portlet portlet = entry.getKey();
            Object[] value = entry.getValue();
            String queryString = (String)value[0];
            String columnId = (String)value[1];
            Integer columnPos = (Integer)value[2];
            Integer columnCount = (Integer)value[3];
            UnsyncStringWriter portletUnsyncStringWriter = new UnsyncStringWriter();
            PipingServletResponse pipingServletResponse = new PipingServletResponse(response, (Writer)portletUnsyncStringWriter);
            this.processPortlet(servletContext, request, (HttpServletResponse)pipingServletResponse, portlet, queryString, columnId, columnPos, columnCount, null, true);
            contentsMap.put(portlet.getPortletId(), portletUnsyncStringWriter.getStringBundler());
        }
        StringBundler sb = StringUtil.replaceWithStringBundler((String)output, (String)"[$TEMPLATE_PORTLET_", (String)"$]", contentsMap);
        sb.writeTo((Writer)jspWriter);
    }

    public String processXML(HttpServletRequest request, String content, RuntimeLogic runtimeLogic) throws Exception {
        if (Validator.isNull((String)content)) {
            return "";
        }
        Portlet renderPortlet = (Portlet)request.getAttribute("RENDER_PORTLET");
        Boolean renderPortletResource = (Boolean)request.getAttribute("RENDER_PORTLET_RESOURCE");
        String outerPortletId = (String)request.getAttribute("OUTER_PORTLET_ID");
        if (outerPortletId == null) {
            request.setAttribute("OUTER_PORTLET_ID", (Object)renderPortlet.getPortletId());
        }
        try {
            request.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
            StringBuilder sb = new StringBuilder();
            int x = 0;
            int y = content.indexOf(runtimeLogic.getOpenTag());
            while (y != -1) {
                sb.append(content.substring(x, y));
                int close1 = content.indexOf(runtimeLogic.getClose1Tag(), y);
                int close2 = content.indexOf(runtimeLogic.getClose2Tag(), y);
                x = close2 == -1 || close1 != -1 && close1 < close2 ? close1 + runtimeLogic.getClose1Tag().length() : close2 + runtimeLogic.getClose2Tag().length();
                sb.append(runtimeLogic.processXML(content.substring(y, x)));
                y = content.indexOf(runtimeLogic.getOpenTag(), x);
            }
            if (y == -1) {
                sb.append(content.substring(x, content.length()));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (outerPortletId == null) {
                request.removeAttribute("OUTER_PORTLET_ID");
            }
            request.setAttribute("RENDER_PORTLET", (Object)renderPortlet);
            if (renderPortletResource == null) {
                request.removeAttribute("RENDER_PORTLET_RESOURCE");
            } else {
                request.setAttribute("RENDER_PORTLET_RESOURCE", (Object)renderPortletResource);
            }
        }
    }

    private static void _defineObjects(HttpServletRequest request, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) {
        if (portletConfig != null) {
            request.setAttribute("javax.portlet.config", (Object)portletConfig);
        }
        if (renderRequest != null) {
            request.setAttribute("javax.portlet.request", (Object)renderRequest);
        }
        if (renderResponse != null) {
            request.setAttribute("javax.portlet.response", (Object)renderResponse);
        }
    }
}

