/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class JournalIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{JournalArticle.class.getName()};
    public static final String PORTLET_ID = "15";
    private static final String _FIELD_NAMESPACE = "web_content";
    private static final boolean _PERMISSION_AWARE = true;
    private static Log _log = LogFactoryUtil.getLog(JournalIndexer.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        String templateId;
        String structureId;
        String articleType;
        int status;
        Long classNameId = (Long)searchContext.getAttribute("classNameId");
        if (classNameId != null) {
            contextQuery.addRequiredTerm("classNameId", classNameId.toString());
        }
        if ((status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0)) != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
        if (Validator.isNotNull((String)(articleType = (String)((Object)searchContext.getAttribute("articleType"))))) {
            contextQuery.addRequiredTerm("type", articleType);
        }
        if (Validator.isNotNull((String)(structureId = (String)((Object)searchContext.getAttribute("structureId"))))) {
            contextQuery.addRequiredTerm("structureId", structureId);
        }
        if (Validator.isNotNull((String)(templateId = (String)((Object)searchContext.getAttribute("templateId"))))) {
            contextQuery.addRequiredTerm("templateId", templateId);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "classPK", false);
        this.addLocalizedSearchTerm(searchQuery, searchContext, "content", false);
        this.addLocalizedSearchTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addLocalizedSearchTerm(searchQuery, searchContext, "title", false);
        this.addSearchTerm(searchQuery, searchContext, "type", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        this.deleteDocument(article.getCompanyId(), article.getGroupId(), article.getArticleId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        String[] languageIds;
        JournalArticle article = (JournalArticle)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)article);
        document.addUID(PORTLET_ID, article.getGroupId(), article.getArticleId());
        Locale defaultLocale = LocaleUtil.getDefault();
        String defaultLangaugeId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        String[] stringArray = languageIds = this.getLanguageIds(defaultLangaugeId, article.getContent());
        int n = languageIds.length;
        int n2 = 0;
        while (n2 < n) {
            String languageId = stringArray[n2];
            String content = this.extractContent(article.getContentByLocale(languageId));
            if (languageId.equals(defaultLangaugeId)) {
                document.addText("content", content);
            }
            document.addText("content".concat("_").concat(languageId), content);
            ++n2;
        }
        document.addLocalizedText("description", article.getDescriptionMap());
        document.addLocalizedText("title", article.getTitleMap());
        document.addKeyword("type", article.getType());
        document.addKeyword("version", article.getVersion());
        document.addKeyword("articleId", article.getArticleId());
        document.addDate("displayDate", article.getDisplayDate());
        document.addKeyword("layoutUuid", article.getLayoutUuid());
        document.addKeyword("structureId", article.getStructureId());
        document.addKeyword("templateId", article.getTemplateId());
        JournalStructure structure = null;
        if (Validator.isNotNull((String)article.getStructureId())) {
            try {
                structure = JournalStructureLocalServiceUtil.getStructure((long)article.getGroupId(), (String)article.getStructureId());
            }
            catch (NoSuchStructureException noSuchStructureException) {
                Group group = GroupLocalServiceUtil.getCompanyGroup((long)article.getCompanyId());
                try {
                    structure = JournalStructureLocalServiceUtil.getStructure((long)group.getGroupId(), (String)article.getStructureId());
                }
                catch (NoSuchStructureException noSuchStructureException2) {}
            }
        }
        this.processStructure(structure, document, article.getContent());
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("display-date")) {
            return "displayDate";
        }
        if (orderByCol.equals("id")) {
            return "entryClassPK";
        }
        if (orderByCol.equals("modified-date")) {
            return "modified";
        }
        if (orderByCol.equals("title")) {
            return "title";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get(locale, "title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get(locale, "content"), (int)200);
        }
        String groupId = document.get("groupId");
        String articleId = document.get("articleId");
        String version = document.get("version");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("groupId", groupId);
        portletURL.setParameter("articleId", articleId);
        portletURL.setParameter("version", version);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        Document document = this.getDocument(article);
        if (!article.isIndexable() || !article.isApproved() && article.getVersion() != 1.0) {
            SearchEngineUtil.deleteDocument((long)article.getCompanyId(), (String)document.get("uid"));
            return;
        }
        SearchEngineUtil.updateDocument((long)article.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK, (int)0);
        this.doReindex(article);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexArticles(companyId);
    }

    protected String encodeFieldName(String name) {
        return _FIELD_NAMESPACE.concat("/").concat(name);
    }

    protected String extractContent(String content) {
        content = StringUtil.replace((String)content, (String)"<![CDATA[", (String)"");
        content = StringUtil.replace((String)content, (String)"]]>", (String)"");
        content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
        content = StringUtil.replace((String)content, (String)"&lt;", (String)"<");
        content = StringUtil.replace((String)content, (String)"&gt;", (String)">");
        content = HtmlUtil.extractText((String)content);
        return content;
    }

    protected String[] getLanguageIds(String defaultLangaugeId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLocales((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLangaugeId};
        }
        return languageIds;
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void indexField(Document document, Element element, String elType, String elIndexType) {
        if (Validator.isNull((String)elIndexType)) {
            return;
        }
        com.liferay.portal.kernel.xml.Document structureDocument = element.getDocument();
        Element rootElement = structureDocument.getRootElement();
        String defaultLocale = GetterUtil.getString((String)rootElement.attributeValue("default-locale"));
        String name = this.encodeFieldName(element.attributeValue("name"));
        List dynamicContentElements = element.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            String contentLocale = GetterUtil.getString((String)dynamicContentElement.attributeValue("language-id"));
            Object[] value = new String[]{dynamicContentElement.getText()};
            if (elType.equals("multi-list")) {
                List optionElements = dynamicContentElement.elements("option");
                value = new String[optionElements.size()];
                int i = 0;
                while (i < optionElements.size()) {
                    value[i] = ((Element)optionElements.get(i)).getText();
                    ++i;
                }
            }
            if (elIndexType.equals("keyword")) {
                if (Validator.isNull((String)contentLocale)) {
                    document.addKeyword(name, (String[])value);
                    continue;
                }
                if (defaultLocale.equals(contentLocale)) {
                    document.addKeyword(name, (String[])value);
                }
                document.addKeyword(name.concat("_").concat(contentLocale), (String[])value);
                continue;
            }
            if (!elIndexType.equals("text")) continue;
            if (Validator.isNull((String)contentLocale)) {
                document.addText(name, StringUtil.merge((Object[])value, (String)" "));
                continue;
            }
            if (defaultLocale.equals(contentLocale)) {
                document.addText(name, StringUtil.merge((Object[])value, (String)" "));
            }
            document.addText(name.concat("_").concat(contentLocale), StringUtil.merge((Object[])value, (String)" "));
        }
    }

    protected void processStructure(com.liferay.portal.kernel.xml.Document structureDocument, Document document, Element rootElement) throws Exception {
        LinkedList queue = new LinkedList(rootElement.elements());
        Element element = null;
        while ((element = (Element)queue.poll()) != null) {
            String path;
            Node structureNode;
            String elName = element.attributeValue("name", "");
            String elType = element.attributeValue("type", "");
            String elIndexType = element.attributeValue("index-type", "");
            if (structureDocument != null && (structureNode = structureDocument.selectSingleNode(path = element.getPath().concat("[@name='").concat(elName).concat("']"))) != null) {
                Element structureElement = (Element)structureNode;
                elType = structureElement.attributeValue("type", "");
                elIndexType = structureElement.attributeValue("index-type", "");
            }
            if (Validator.isNotNull((String)elType)) {
                this.indexField(document, element, elType, elIndexType);
            }
            queue.addAll(element.elements());
        }
    }

    protected void processStructure(JournalStructure structure, Document document, String content) {
        try {
            com.liferay.portal.kernel.xml.Document structureDocument = null;
            if (structure != null) {
                structureDocument = SAXReaderUtil.read((String)structure.getXsd());
            }
            com.liferay.portal.kernel.xml.Document contentDocument = SAXReaderUtil.read((String)content);
            Element rootElement = contentDocument.getRootElement();
            this.processStructure(structureDocument, document, rootElement);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void reindexArticles(long companyId) throws Exception {
        int count = JournalArticleLocalServiceUtil.getCompanyArticlesCount((long)companyId, (int)0);
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexArticles(companyId, start, end);
            ++i;
        }
    }

    protected void reindexArticles(long companyId, int start, int end) throws Exception {
        ArrayList articles = new ArrayList();
        List approvedArticles = JournalArticleLocalServiceUtil.getCompanyArticles((long)companyId, (int)0, (int)start, (int)end);
        articles.addAll(approvedArticles);
        List draftArticles = JournalArticleLocalServiceUtil.getCompanyArticles((long)companyId, (double)1.0, (int)2, (int)start, (int)end);
        articles.addAll(draftArticles);
        if (articles.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (JournalArticle article : articles) {
            JournalArticle latestArticle;
            if (!article.isIndexable() || article.isApproved() && !(latestArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)article.getResourcePrimKey(), (int)0)).isIndexable()) continue;
            Document document = this.getDocument(article);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

