/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.freemarker.FreeMarkerContext;
import com.liferay.portal.kernel.freemarker.FreeMarkerEngineUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.templateparser.TemplateContext;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.util.VelocityTemplateParser;
import com.liferay.util.ContentUtil;
import freemarker.core.ParseException;
import freemarker.template.TemplateException;
import java.io.Writer;

public class FreeMarkerTemplateParser
extends VelocityTemplateParser {
    protected String getErrorTemplateContent() {
        return ContentUtil.get((String)PropsValues.JOURNAL_ERROR_TEMPLATE_FREEMARKER);
    }

    protected String getErrorTemplateId() {
        return PropsValues.JOURNAL_ERROR_TEMPLATE_FREEMARKER;
    }

    protected String getJournalTemplatesPath() {
        StringBundler sb = new StringBundler(5);
        sb.append("_JOURNAL_CONTEXT_");
        sb.append("/");
        sb.append(this.getCompanyId());
        sb.append("/");
        sb.append(this.getGroupId());
        return sb.toString();
    }

    protected TemplateContext getTemplateContext() {
        return FreeMarkerEngineUtil.getWrappedRestrictedToolsContext();
    }

    protected boolean mergeTemplate(TemplateContext templateContext, UnsyncStringWriter unsyncStringWriter) throws Exception {
        FreeMarkerContext freeMarkerContext = (FreeMarkerContext)templateContext;
        try {
            return FreeMarkerEngineUtil.mergeTemplate((String)this.getTemplateId(), (String)this.getScript(), (FreeMarkerContext)freeMarkerContext, (Writer)unsyncStringWriter);
        }
        catch (Exception e) {
            if (e instanceof ParseException || e instanceof TemplateException) {
                String errorTemplateId = this.getErrorTemplateId();
                String errorTemplateContent = this.getErrorTemplateContent();
                freeMarkerContext.put("exception", (Object)e.getMessage());
                freeMarkerContext.put("script", (Object)this.getScript());
                if (e instanceof ParseException) {
                    ParseException pe = (ParseException)e;
                    freeMarkerContext.put("column", (Object)pe.getColumnNumber());
                    freeMarkerContext.put("line", (Object)pe.getLineNumber());
                }
                unsyncStringWriter.reset();
                return FreeMarkerEngineUtil.mergeTemplate((String)errorTemplateId, (String)errorTemplateContent, (FreeMarkerContext)freeMarkerContext, (Writer)unsyncStringWriter);
            }
            throw e;
        }
    }
}

