/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;

public class JournalTemplatePermission {
    public static void check(PermissionChecker permissionChecker, JournalTemplate template, String actionId) throws PortalException {
        if (!JournalTemplatePermission.contains(permissionChecker, template, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long id, String actionId) throws PortalException, SystemException {
        if (!JournalTemplatePermission.contains(permissionChecker, id, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String templateId, String actionId) throws PortalException, SystemException {
        if (!JournalTemplatePermission.contains(permissionChecker, groupId, templateId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, JournalTemplate template, String actionId) {
        if (permissionChecker.hasOwnerPermission(template.getCompanyId(), JournalTemplate.class.getName(), template.getId(), template.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(template.getGroupId(), JournalTemplate.class.getName(), template.getId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long id, String actionId) throws PortalException, SystemException {
        JournalTemplate template = JournalTemplateLocalServiceUtil.getTemplate((long)id);
        return JournalTemplatePermission.contains(permissionChecker, template, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String templateId, String actionId) throws PortalException, SystemException {
        JournalTemplate template = JournalTemplateLocalServiceUtil.getTemplate((long)groupId, (String)templateId);
        return JournalTemplatePermission.contains(permissionChecker, template, actionId);
    }
}

