/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.journal.DuplicateTemplateIdException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.RequiredTemplateException;
import com.liferay.portlet.journal.TemplateIdException;
import com.liferay.portlet.journal.TemplateNameException;
import com.liferay.portlet.journal.TemplateSmallImageNameException;
import com.liferay.portlet.journal.TemplateSmallImageSizeException;
import com.liferay.portlet.journal.TemplateXslException;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.base.JournalTemplateLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.JournalUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalTemplateLocalServiceImpl
extends JournalTemplateLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(JournalTemplateLocalServiceImpl.class);

    public JournalTemplate addTemplate(long userId, long groupId, String templateId, boolean autoTemplateId, String structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsl, boolean formatXsl, String langType, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        templateId = templateId.trim().toUpperCase();
        Date now = new Date();
        try {
            if (formatXsl) {
                xsl = langType.equals("vm") ? JournalUtil.formatVM(xsl) : DDMXMLUtil.formatXML((String)xsl);
            }
        }
        catch (Exception exception) {
            throw new TemplateXslException();
        }
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {}
        this.validate(groupId, templateId, autoTemplateId, nameMap, xsl, smallImage, smallImageURL, smallImageFile, smallImageBytes);
        if (autoTemplateId) {
            templateId = String.valueOf(this.counterLocalService.increment());
        }
        long id = this.counterLocalService.increment();
        JournalTemplate template = this.journalTemplatePersistence.create(id);
        template.setUuid(serviceContext.getUuid());
        template.setGroupId(groupId);
        template.setCompanyId(user.getCompanyId());
        template.setUserId(user.getUserId());
        template.setUserName(user.getFullName());
        template.setCreateDate(serviceContext.getCreateDate(now));
        template.setModifiedDate(serviceContext.getModifiedDate(now));
        template.setTemplateId(templateId);
        template.setStructureId(structureId);
        template.setNameMap(nameMap);
        template.setDescriptionMap(descriptionMap);
        template.setXsl(xsl);
        template.setLangType(langType);
        template.setCacheable(cacheable);
        template.setSmallImage(smallImage);
        template.setSmallImageId(this.counterLocalService.increment());
        template.setSmallImageURL(smallImageURL);
        this.journalTemplatePersistence.update((BaseModel)template, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addTemplateResources(template, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addTemplateResources(template, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        ExpandoBridge expandoBridge = template.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        this.saveImages(smallImage, template.getSmallImageId(), smallImageFile, smallImageBytes);
        return template;
    }

    public void addTemplateResources(long groupId, String templateId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        JournalTemplate template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
        this.addTemplateResources(template, addGroupPermissions, addGuestPermissions);
    }

    public void addTemplateResources(JournalTemplate template, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(template.getCompanyId(), template.getGroupId(), template.getUserId(), JournalTemplate.class.getName(), template.getId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addTemplateResources(long groupId, String templateId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        JournalTemplate template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
        this.addTemplateResources(template, groupPermissions, guestPermissions);
    }

    public void addTemplateResources(JournalTemplate template, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(template.getCompanyId(), template.getGroupId(), template.getUserId(), JournalTemplate.class.getName(), template.getId(), groupPermissions, guestPermissions);
    }

    public void checkNewLine(long groupId, String templateId) throws PortalException, SystemException {
        JournalTemplate template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
        String xsl = template.getXsl();
        if (xsl != null && xsl.indexOf("\\n") != -1) {
            xsl = StringUtil.replace((String)xsl, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            template.setXsl(xsl);
            this.journalTemplatePersistence.update((BaseModel)template, false);
        }
    }

    public JournalTemplate copyTemplate(long userId, long groupId, String oldTemplateId, String newTemplateId, boolean autoTemplateId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        oldTemplateId = oldTemplateId.trim().toUpperCase();
        newTemplateId = newTemplateId.trim().toUpperCase();
        Date now = new Date();
        JournalTemplate oldTemplate = this.journalTemplatePersistence.findByG_T(groupId, oldTemplateId);
        if (autoTemplateId) {
            newTemplateId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validate(newTemplateId);
            JournalTemplate newTemplate = this.journalTemplatePersistence.fetchByG_T(groupId, newTemplateId);
            if (newTemplate != null) {
                throw new DuplicateTemplateIdException();
            }
        }
        long id = this.counterLocalService.increment();
        JournalTemplate newTemplate = this.journalTemplatePersistence.create(id);
        newTemplate.setGroupId(groupId);
        newTemplate.setCompanyId(user.getCompanyId());
        newTemplate.setUserId(user.getUserId());
        newTemplate.setUserName(user.getFullName());
        newTemplate.setCreateDate(now);
        newTemplate.setModifiedDate(now);
        newTemplate.setTemplateId(newTemplateId);
        newTemplate.setStructureId(oldTemplate.getStructureId());
        newTemplate.setNameMap(oldTemplate.getNameMap());
        newTemplate.setDescriptionMap(oldTemplate.getDescriptionMap());
        newTemplate.setXsl(oldTemplate.getXsl());
        newTemplate.setLangType(oldTemplate.getLangType());
        newTemplate.setCacheable(oldTemplate.isCacheable());
        newTemplate.setSmallImage(oldTemplate.isSmallImage());
        newTemplate.setSmallImageId(this.counterLocalService.increment());
        newTemplate.setSmallImageURL(oldTemplate.getSmallImageURL());
        this.journalTemplatePersistence.update((BaseModel)newTemplate, false);
        if (oldTemplate.getSmallImage()) {
            Image image = this.imageLocalService.getImage(oldTemplate.getSmallImageId());
            byte[] smallImageBytes = image.getTextObj();
            this.imageLocalService.updateImage(newTemplate.getSmallImageId(), smallImageBytes);
        }
        this.addTemplateResources(newTemplate, true, true);
        return newTemplate;
    }

    public void deleteTemplate(long groupId, String templateId) throws PortalException, SystemException {
        templateId = templateId.trim().toUpperCase();
        JournalTemplate template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
        this.deleteTemplate(template);
    }

    public void deleteTemplate(JournalTemplate template) throws PortalException, SystemException {
        if (this.journalArticlePersistence.countByG_C_T(template.getGroupId(), 0L, template.getTemplateId()) > 0) {
            throw new RequiredTemplateException();
        }
        this.webDAVPropsLocalService.deleteWebDAVProps(JournalTemplate.class.getName(), template.getId());
        this.imageLocalService.deleteImage(template.getSmallImageId());
        this.expandoValueLocalService.deleteValues(JournalTemplate.class.getName(), template.getId());
        this.resourceLocalService.deleteResource(template.getCompanyId(), JournalTemplate.class.getName(), 4, template.getId());
        this.journalArticleLocalService.updateTemplateId(template.getGroupId(), PortalUtil.getClassNameId((String)JournalStructure.class.getName()), template.getTemplateId(), "");
        this.journalTemplatePersistence.remove((BaseModel)template);
    }

    public void deleteTemplates(long groupId) throws PortalException, SystemException {
        for (JournalTemplate template : this.journalTemplatePersistence.findByGroupId(groupId)) {
            this.deleteTemplate(template);
        }
    }

    public List<JournalTemplate> getStructureTemplates(long groupId, String structureId) throws SystemException {
        return this.journalTemplatePersistence.findByG_S(groupId, structureId);
    }

    public List<JournalTemplate> getStructureTemplates(long groupId, String structureId, int start, int end) throws SystemException {
        return this.journalTemplatePersistence.findByG_S(groupId, structureId, start, end);
    }

    public int getStructureTemplatesCount(long groupId, String structureId) throws SystemException {
        return this.journalTemplatePersistence.countByG_S(groupId, structureId);
    }

    public JournalTemplate getTemplate(long id) throws PortalException, SystemException {
        return this.journalTemplatePersistence.findByPrimaryKey(id);
    }

    public JournalTemplate getTemplate(long groupId, String templateId) throws PortalException, SystemException {
        templateId = GetterUtil.getString((String)templateId).toUpperCase();
        if (groupId == 0L) {
            _log.error((Object)("No group id was passed for " + templateId + ". Group id is " + "required since 4.2.0. Please update all custom code and " + "data that references templates without a group id."));
            List templates = this.journalTemplatePersistence.findByTemplateId(templateId);
            if (templates.size() == 0) {
                throw new NoSuchTemplateException("No JournalTemplate exists with the template id " + templateId);
            }
            return (JournalTemplate)templates.get(0);
        }
        return this.journalTemplatePersistence.findByG_T(groupId, templateId);
    }

    public JournalTemplate getTemplateBySmallImageId(long smallImageId) throws PortalException, SystemException {
        return this.journalTemplatePersistence.findBySmallImageId(smallImageId);
    }

    public List<JournalTemplate> getTemplates() throws SystemException {
        return this.journalTemplatePersistence.findAll();
    }

    public List<JournalTemplate> getTemplates(long groupId) throws SystemException {
        return this.journalTemplatePersistence.findByGroupId(groupId);
    }

    public List<JournalTemplate> getTemplates(long groupId, int start, int end) throws SystemException {
        return this.journalTemplatePersistence.findByGroupId(groupId, start, end);
    }

    public int getTemplatesCount(long groupId) throws SystemException {
        return this.journalTemplatePersistence.countByGroupId(groupId);
    }

    public boolean hasTemplate(long groupId, String templateId) throws SystemException {
        try {
            this.getTemplate(groupId, templateId);
            return true;
        }
        catch (PortalException portalException) {
            return false;
        }
    }

    public List<JournalTemplate> search(long companyId, long[] groupIds, String keywords, String structureId, String structureIdComparator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalTemplateFinder.findByKeywords(companyId, groupIds, keywords, structureId, structureIdComparator, start, end, obc);
    }

    public List<JournalTemplate> search(long companyId, long[] groupIds, String templateId, String structureId, String structureIdComparator, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalTemplateFinder.findByC_G_T_S_N_D(companyId, groupIds, templateId, structureId, structureIdComparator, name, description, andOperator, start, end, obc);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords, String structureId, String structureIdComparator) throws SystemException {
        return this.journalTemplateFinder.countByKeywords(companyId, groupIds, keywords, structureId, structureIdComparator);
    }

    public int searchCount(long companyId, long[] groupIds, String templateId, String structureId, String structureIdComparator, String name, String description, boolean andOperator) throws SystemException {
        return this.journalTemplateFinder.countByC_G_T_S_N_D(companyId, groupIds, templateId, structureId, structureIdComparator, name, description, andOperator);
    }

    public JournalTemplate updateTemplate(long groupId, String templateId, String structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsl, boolean formatXsl, String langType, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException, SystemException {
        templateId = templateId.trim().toUpperCase();
        try {
            if (formatXsl) {
                xsl = langType.equals("vm") ? JournalUtil.formatVM(xsl) : DDMXMLUtil.formatXML((String)xsl);
            }
        }
        catch (Exception exception) {
            throw new TemplateXslException();
        }
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {}
        this.validate(nameMap, xsl, smallImage, smallImageURL, smallImageFile, smallImageBytes);
        JournalTemplate template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
        template.setModifiedDate(new Date());
        if (Validator.isNull((String)template.getStructureId()) && Validator.isNotNull((String)structureId)) {
            template.setStructureId(structureId);
        }
        template.setNameMap(nameMap);
        template.setDescriptionMap(descriptionMap);
        template.setXsl(xsl);
        template.setLangType(langType);
        template.setCacheable(cacheable);
        template.setSmallImage(smallImage);
        template.setSmallImageURL(smallImageURL);
        template.setModifiedDate(serviceContext.getModifiedDate(null));
        this.journalTemplatePersistence.update((BaseModel)template, false);
        ExpandoBridge expandoBridge = template.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        this.saveImages(smallImage, template.getSmallImageId(), smallImageFile, smallImageBytes);
        return template;
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
    }

    protected void validate(String templateId) throws PortalException {
        if (Validator.isNull((String)templateId) || Validator.isNumber((String)templateId) || templateId.indexOf(32) != -1) {
            throw new TemplateIdException();
        }
    }

    protected void validate(long groupId, String templateId, boolean autoTemplateId, Map<Locale, String> nameMap, String xsl, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        if (!autoTemplateId) {
            this.validate(templateId);
            JournalTemplate template = this.journalTemplatePersistence.fetchByG_T(groupId, templateId);
            if (template != null) {
                throw new DuplicateTemplateIdException();
            }
        }
        this.validate(nameMap, xsl, smallImage, smallImageURL, smallImageFile, smallImageBytes);
    }

    protected void validate(Map<Locale, String> nameMap, String xsl, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        Locale locale = LocaleUtil.getDefault();
        if (nameMap.isEmpty() || Validator.isNull((String)nameMap.get(locale))) {
            throw new TemplateNameException();
        }
        if (Validator.isNull((String)xsl)) {
            throw new TemplateXslException();
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray("journal.image.extensions", ",");
        if (smallImage && Validator.isNull((String)smallImageURL) && smallImageFile != null && smallImageBytes != null) {
            long smallImageMaxSize;
            String smallImageName = smallImageFile.getName();
            if (smallImageName != null) {
                boolean validSmallImageExtension = false;
                int i = 0;
                while (i < imageExtensions.length) {
                    if ("*".equals(imageExtensions[i]) || StringUtil.endsWith((String)smallImageName, (String)imageExtensions[i])) {
                        validSmallImageExtension = true;
                        break;
                    }
                    ++i;
                }
                if (!validSmallImageExtension) {
                    throw new TemplateSmallImageNameException(smallImageName);
                }
            }
            if ((smallImageMaxSize = PrefsPropsUtil.getLong("journal.image.small.max.size")) > 0L && (smallImageBytes == null || (long)smallImageBytes.length > smallImageMaxSize)) {
                throw new TemplateSmallImageSizeException();
            }
        }
    }
}

