/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.journal.DuplicateFeedIdException;
import com.liferay.portlet.journal.FeedContentFieldException;
import com.liferay.portlet.journal.FeedIdException;
import com.liferay.portlet.journal.FeedNameException;
import com.liferay.portlet.journal.FeedTargetLayoutFriendlyUrlException;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.base.JournalFeedLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalFeedLocalServiceImpl
extends JournalFeedLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(JournalFeedLocalServiceImpl.class);

    public JournalFeed addFeed(long userId, long groupId, String feedId, boolean autoFeedId, String name, String description, String type, String structureId, String templateId, String rendererTemplateId, int delta, String orderByCol, String orderByType, String targetLayoutFriendlyUrl, String targetPortletId, String contentField, String feedType, double feedVersion, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        feedId = feedId.trim().toUpperCase();
        Date now = new Date();
        this.validate(user.getCompanyId(), groupId, feedId, autoFeedId, name, structureId, targetLayoutFriendlyUrl, contentField);
        if (autoFeedId) {
            feedId = String.valueOf(this.counterLocalService.increment());
        }
        long id = this.counterLocalService.increment();
        JournalFeed feed = this.journalFeedPersistence.create(id);
        feed.setUuid(serviceContext.getUuid());
        feed.setGroupId(groupId);
        feed.setCompanyId(user.getCompanyId());
        feed.setUserId(user.getUserId());
        feed.setUserName(user.getFullName());
        feed.setCreateDate(serviceContext.getCreateDate(now));
        feed.setModifiedDate(serviceContext.getModifiedDate(now));
        feed.setFeedId(feedId);
        feed.setName(name);
        feed.setDescription(description);
        feed.setType(type);
        feed.setStructureId(structureId);
        feed.setTemplateId(templateId);
        feed.setRendererTemplateId(rendererTemplateId);
        feed.setDelta(delta);
        feed.setOrderByCol(orderByCol);
        feed.setOrderByType(orderByType);
        feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        feed.setTargetPortletId(targetPortletId);
        feed.setContentField(contentField);
        if (Validator.isNull((String)feedType)) {
            feed.setFeedType("atom");
            feed.setFeedVersion(1.0);
        } else {
            feed.setFeedType(feedType);
            feed.setFeedVersion(feedVersion);
        }
        this.journalFeedPersistence.update((BaseModel)feed, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFeedResources(feed, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFeedResources(feed, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        ExpandoBridge expandoBridge = feed.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        return feed;
    }

    public void addFeedResources(long feedId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        JournalFeed feed = this.journalFeedPersistence.findByPrimaryKey(feedId);
        this.addFeedResources(feed, addGroupPermissions, addGuestPermissions);
    }

    public void addFeedResources(JournalFeed feed, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(feed.getCompanyId(), feed.getGroupId(), feed.getUserId(), JournalFeed.class.getName(), feed.getId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addFeedResources(long feedId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        JournalFeed feed = this.journalFeedPersistence.findByPrimaryKey(feedId);
        this.addFeedResources(feed, groupPermissions, guestPermissions);
    }

    public void addFeedResources(JournalFeed feed, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(feed.getCompanyId(), feed.getGroupId(), feed.getUserId(), JournalFeed.class.getName(), feed.getId(), groupPermissions, guestPermissions);
    }

    public void deleteFeed(long feedId) throws PortalException, SystemException {
        JournalFeed feed = this.journalFeedPersistence.findByPrimaryKey(feedId);
        this.deleteFeed(feed);
    }

    public void deleteFeed(long groupId, String feedId) throws PortalException, SystemException {
        JournalFeed feed = this.journalFeedPersistence.findByG_F(groupId, feedId);
        this.deleteFeed(feed);
    }

    public void deleteFeed(JournalFeed feed) throws PortalException, SystemException {
        this.expandoValueLocalService.deleteValues(JournalFeed.class.getName(), feed.getId());
        this.resourceLocalService.deleteResource(feed.getCompanyId(), JournalFeed.class.getName(), 4, feed.getId());
        this.journalFeedPersistence.remove((BaseModel)feed);
    }

    public JournalFeed getFeed(long feedId) throws PortalException, SystemException {
        return this.journalFeedPersistence.findByPrimaryKey(feedId);
    }

    public JournalFeed getFeed(long groupId, String feedId) throws PortalException, SystemException {
        return this.journalFeedPersistence.findByG_F(groupId, feedId);
    }

    public List<JournalFeed> getFeeds() throws SystemException {
        return this.journalFeedPersistence.findAll();
    }

    public List<JournalFeed> getFeeds(long groupId) throws SystemException {
        return this.journalFeedPersistence.findByGroupId(groupId);
    }

    public List<JournalFeed> getFeeds(long groupId, int start, int end) throws SystemException {
        return this.journalFeedPersistence.findByGroupId(groupId, start, end);
    }

    public int getFeedsCount(long groupId) throws SystemException {
        return this.journalFeedPersistence.countByGroupId(groupId);
    }

    public List<JournalFeed> search(long companyId, long groupId, String keywords, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalFeedFinder.findByKeywords(companyId, groupId, keywords, start, end, obc);
    }

    public List<JournalFeed> search(long companyId, long groupId, String feedId, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalFeedFinder.findByC_G_F_N_D(companyId, groupId, feedId, name, description, andOperator, start, end, obc);
    }

    public int searchCount(long companyId, long groupId, String keywords) throws SystemException {
        return this.journalFeedFinder.countByKeywords(companyId, groupId, keywords);
    }

    public int searchCount(long companyId, long groupId, String feedId, String name, String description, boolean andOperator) throws SystemException {
        return this.journalFeedFinder.countByC_G_F_N_D(companyId, groupId, feedId, name, description, andOperator);
    }

    public JournalFeed updateFeed(long groupId, String feedId, String name, String description, String type, String structureId, String templateId, String rendererTemplateId, int delta, String orderByCol, String orderByType, String targetLayoutFriendlyUrl, String targetPortletId, String contentField, String feedType, double feedVersion, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalFeed feed = this.journalFeedPersistence.findByG_F(groupId, feedId);
        this.validate(feed.getCompanyId(), groupId, name, structureId, targetLayoutFriendlyUrl, contentField);
        feed.setModifiedDate(serviceContext.getModifiedDate(null));
        feed.setName(name);
        feed.setDescription(description);
        feed.setType(type);
        feed.setStructureId(structureId);
        feed.setTemplateId(templateId);
        feed.setRendererTemplateId(rendererTemplateId);
        feed.setDelta(delta);
        feed.setOrderByCol(orderByCol);
        feed.setOrderByType(orderByType);
        feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        feed.setTargetPortletId(targetPortletId);
        feed.setContentField(contentField);
        if (Validator.isNull((String)feedType)) {
            feed.setFeedType("atom");
            feed.setFeedVersion(1.0);
        } else {
            feed.setFeedType(feedType);
            feed.setFeedVersion(feedVersion);
        }
        this.journalFeedPersistence.update((BaseModel)feed, false);
        ExpandoBridge expandoBridge = feed.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        return feed;
    }

    protected boolean isValidStructureField(long groupId, String structureId, String contentField) {
        if (contentField.equals("web-content-description") || contentField.equals("rendered-web-content")) {
            return true;
        }
        try {
            JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
            Document document = SAXReaderUtil.read((String)structure.getXsd());
            XPath xPathSelector = SAXReaderUtil.createXPath((String)("//dynamic-element[@name='" + contentField + "']"));
            Node node = xPathSelector.selectSingleNode((Object)document);
            if (node != null) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    protected void validate(long companyId, long groupId, String feedId, boolean autoFeedId, String name, String structureId, String targetLayoutFriendlyUrl, String contentField) throws PortalException, SystemException {
        if (!autoFeedId) {
            if (Validator.isNull((String)feedId) || Validator.isNumber((String)feedId) || feedId.indexOf(32) != -1) {
                throw new FeedIdException();
            }
            JournalFeed feed = this.journalFeedPersistence.fetchByG_F(groupId, feedId);
            if (feed != null) {
                throw new DuplicateFeedIdException();
            }
        }
        this.validate(companyId, groupId, name, structureId, targetLayoutFriendlyUrl, contentField);
    }

    protected void validate(long companyId, long groupId, String name, String structureId, String targetLayoutFriendlyUrl, String contentField) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new FeedNameException();
        }
        long plid = PortalUtil.getPlidFromFriendlyURL((long)companyId, (String)targetLayoutFriendlyUrl);
        if (plid <= 0L) {
            throw new FeedTargetLayoutFriendlyUrlException();
        }
        if (!this.isValidStructureField(groupId, structureId, contentField)) {
            throw new FeedContentFieldException();
        }
    }
}

