/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.journal.ArticleContentException;
import com.liferay.portlet.journal.ArticleDisplayDateException;
import com.liferay.portlet.journal.ArticleExpirationDateException;
import com.liferay.portlet.journal.ArticleIdException;
import com.liferay.portlet.journal.ArticleReviewDateException;
import com.liferay.portlet.journal.ArticleSmallImageNameException;
import com.liferay.portlet.journal.ArticleSmallImageSizeException;
import com.liferay.portlet.journal.ArticleTitleException;
import com.liferay.portlet.journal.ArticleTypeException;
import com.liferay.portlet.journal.ArticleVersionException;
import com.liferay.portlet.journal.DuplicateArticleIdException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.NoSuchArticleResourceException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.StructureXsdException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleConstants;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.model.impl.JournalArticleDisplayImpl;
import com.liferay.portlet.journal.service.base.JournalArticleLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.journal.util.comparator.ArticleIDComparator;
import com.liferay.portlet.journal.util.comparator.ArticleVersionComparator;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalArticleLocalServiceImpl
extends JournalArticleLocalServiceBaseImpl {
    private static long _JOURNAL_ARTICLE_CHECK_INTERVAL = (long)PropsValues.JOURNAL_ARTICLE_CHECK_INTERVAL * 60000L;
    private static Log _log = LogFactoryUtil.getLog(JournalArticleLocalServiceImpl.class);

    public JournalArticle addArticle(long userId, long groupId, long classNameId, long classPK, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String type, String structureId, String templateId, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        articleId = articleId.trim().toUpperCase();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new ArticleDisplayDateException());
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new ArticleExpirationDateException());
        }
        Date reviewDate = null;
        if (!neverReview) {
            reviewDate = PortalUtil.getDate((int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new ArticleReviewDateException());
        }
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {}
        Date now = new Date();
        this.validate(user.getCompanyId(), groupId, classNameId, articleId, autoArticleId, version, titleMap, content, type, structureId, templateId, smallImage, smallImageURL, smallImageFile, smallImageBytes);
        if (autoArticleId) {
            articleId = String.valueOf(this.counterLocalService.increment());
        }
        long id = this.counterLocalService.increment();
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(serviceContext.getUuid(), groupId, articleId);
        JournalArticle article = this.journalArticlePersistence.create(id);
        Locale locale = LocaleUtil.getDefault();
        String defaultLanguageId = GetterUtil.getString((Object)serviceContext.getAttribute("defaultLanguageId"));
        if (Validator.isNotNull((String)defaultLanguageId)) {
            locale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }
        String title = titleMap.get(locale);
        content = this.format(user, groupId, articleId, version, false, content, structureId, images);
        article.setResourcePrimKey(resourcePrimKey);
        article.setGroupId(groupId);
        article.setCompanyId(user.getCompanyId());
        article.setUserId(user.getUserId());
        article.setUserName(user.getFullName());
        article.setCreateDate(serviceContext.getCreateDate(now));
        article.setModifiedDate(serviceContext.getModifiedDate(now));
        article.setClassNameId(classNameId);
        article.setClassPK(classPK);
        article.setArticleId(articleId);
        article.setVersion(version);
        article.setTitleMap(titleMap, locale);
        article.setUrlTitle(this.getUniqueUrlTitle(id, groupId, articleId, title));
        article.setDescriptionMap(descriptionMap, locale);
        article.setContent(content);
        article.setType(type);
        article.setStructureId(structureId);
        article.setTemplateId(templateId);
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        article.setSmallImageId(this.counterLocalService.increment());
        article.setSmallImageURL(smallImageURL);
        if (expirationDate == null || expirationDate.after(now)) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        this.journalArticlePersistence.update((BaseModel)article, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addArticleResources(article, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addArticleResources(article, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        ExpandoBridge expandoBridge = article.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (PropsValues.JOURNAL_ARTICLE_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, article.getUserName(), groupId, JournalArticle.class.getName(), resourcePrimKey, 1);
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        this.sendEmail(article, articleURL, preferences, "requested", serviceContext);
        if (classNameId == 0L) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)JournalArticle.class.getName(), (long)article.getId(), (Object)article, (ServiceContext)serviceContext);
            if (serviceContext.getWorkflowAction() != 1) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
                indexer.reindex((Object)article);
            }
        } else {
            this.updateStatus(userId, article, 0, null, serviceContext);
        }
        return article;
    }

    public void addArticleResources(JournalArticle article, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addArticleResources(JournalArticle article, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public void addArticleResources(long groupId, String articleId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, addGroupPermissions, addGuestPermissions);
    }

    public void addArticleResources(long groupId, String articleId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, groupPermissions, guestPermissions);
    }

    public JournalArticle checkArticleResourcePrimKey(long groupId, String articleId, double version) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.getResourcePrimKey() > 0L) {
            return article;
        }
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, articleId);
        article.setResourcePrimKey(resourcePrimKey);
        this.journalArticlePersistence.update((BaseModel)article, false);
        return article;
    }

    public void checkArticles() throws PortalException, SystemException {
        Indexer indexer;
        Date now = new Date();
        List articles = this.journalArticleFinder.findByExpirationDate(0L, 0, now);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + articles.size() + " articles"));
        }
        HashSet<Long> companyIds = new HashSet<Long>();
        for (JournalArticle article : articles) {
            article.setStatus(3);
            this.journalArticlePersistence.update((BaseModel)article, false);
            if (article.isIndexable()) {
                indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
                indexer.delete((Object)article);
            }
            this.updatePreviousApprovedArticle(article);
            JournalContentUtil.clearCache((long)article.getGroupId(), (String)article.getArticleId(), (String)article.getTemplateId());
            companyIds.add(article.getCompanyId());
        }
        indexer = companyIds.iterator();
        while (indexer.hasNext()) {
            long companyId = (Long)indexer.next();
            CacheUtil.clearCache(companyId);
        }
        articles = this.journalArticleFinder.findByReviewDate(0L, now, new Date(now.getTime() - _JOURNAL_ARTICLE_CHECK_INTERVAL));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending review notifications for " + articles.size() + " articles"));
        }
        for (JournalArticle article : articles) {
            String articleURL = "";
            long ownerId = article.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "15";
            PortletPreferences preferences = this.portletPreferencesLocalService.getPreferences(article.getCompanyId(), ownerId, ownerType, plid, portletId);
            this.sendEmail(article, articleURL, preferences, "review", new ServiceContext());
        }
    }

    public void checkNewLine(long groupId, String articleId, double version) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        String content = GetterUtil.getString((String)article.getContent());
        if (content.indexOf("\\n") != -1) {
            content = StringUtil.replace((String)content, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            article.setContent(content);
            this.journalArticlePersistence.update((BaseModel)article, false);
        }
    }

    public void checkStructure(long groupId, String articleId, double version) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (Validator.isNull((String)article.getStructureId())) {
            return;
        }
        try {
            this.checkStructure(article);
        }
        catch (DocumentException de) {
            _log.error((Object)de, (Throwable)de);
        }
    }

    public JournalArticle copyArticle(long userId, long groupId, String oldArticleId, String newArticleId, boolean autoArticleId, double version) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        oldArticleId = oldArticleId.trim().toUpperCase();
        newArticleId = newArticleId.trim().toUpperCase();
        Date now = new Date();
        JournalArticle oldArticle = this.journalArticlePersistence.findByG_A_V(groupId, oldArticleId, version);
        if (autoArticleId) {
            newArticleId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validate(groupId, newArticleId);
        }
        long id = this.counterLocalService.increment();
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, newArticleId);
        JournalArticle newArticle = this.journalArticlePersistence.create(id);
        newArticle.setResourcePrimKey(resourcePrimKey);
        newArticle.setGroupId(groupId);
        newArticle.setCompanyId(user.getCompanyId());
        newArticle.setUserId(user.getUserId());
        newArticle.setUserName(user.getFullName());
        newArticle.setCreateDate(now);
        newArticle.setModifiedDate(now);
        newArticle.setArticleId(newArticleId);
        newArticle.setVersion(1.0);
        newArticle.setTitle(oldArticle.getTitle());
        newArticle.setDescription(oldArticle.getDescription());
        try {
            this.copyArticleImages(oldArticle, newArticle);
        }
        catch (Exception exception) {
            newArticle.setContent(oldArticle.getContent());
        }
        newArticle.setType(oldArticle.getType());
        newArticle.setStructureId(oldArticle.getStructureId());
        newArticle.setTemplateId(oldArticle.getTemplateId());
        newArticle.setLayoutUuid(oldArticle.getLayoutUuid());
        newArticle.setDisplayDate(oldArticle.getDisplayDate());
        newArticle.setExpirationDate(oldArticle.getExpirationDate());
        newArticle.setReviewDate(oldArticle.getReviewDate());
        newArticle.setIndexable(oldArticle.isIndexable());
        newArticle.setSmallImage(oldArticle.isSmallImage());
        newArticle.setSmallImageId(this.counterLocalService.increment());
        newArticle.setSmallImageURL(oldArticle.getSmallImageURL());
        newArticle.setStatus(oldArticle.getStatus());
        this.journalArticlePersistence.update((BaseModel)newArticle, false);
        this.addArticleResources(newArticle, true, true);
        if (oldArticle.getSmallImage()) {
            Image image = this.imageLocalService.getImage(oldArticle.getSmallImageId());
            byte[] smallImageBytes = image.getTextObj();
            this.imageLocalService.updateImage(newArticle.getSmallImageId(), smallImageBytes);
        }
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        String[] assetTagNames = this.assetTagLocalService.getTagNames(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        this.updateAsset(userId, newArticle, assetCategoryIds, assetTagNames, null);
        return newArticle;
    }

    public void deleteArticle(JournalArticle article, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        int articlesCount;
        PortletPreferences preferences;
        if (article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion(), 0)) {
            this.updatePreviousApprovedArticle(article);
        }
        if ((preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext)) != null && !article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            this.sendEmail(article, articleURL, preferences, "denied", serviceContext);
        }
        this.journalArticleImageLocalService.deleteImages(article.getGroupId(), article.getArticleId(), article.getVersion());
        if (!article.isDraft()) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        if ((articlesCount = this.journalArticlePersistence.countByG_A(article.getGroupId(), article.getArticleId())) == 1) {
            this.ratingsStatsLocalService.deleteStats(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.mbMessageLocalService.deleteDiscussionMessages(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.journalContentSearchLocalService.deleteArticleContentSearches(article.getGroupId(), article.getArticleId());
            this.imageLocalService.deleteImage(article.getSmallImageId());
            this.expandoValueLocalService.deleteValues(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.resourceLocalService.deleteResource(article.getCompanyId(), JournalArticle.class.getName(), 4, article.getResourcePrimKey());
            try {
                this.journalArticleResourceLocalService.deleteArticleResource(article.getGroupId(), article.getArticleId());
            }
            catch (NoSuchArticleResourceException noSuchArticleResourceException) {}
        }
        this.journalArticlePersistence.remove((BaseModel)article);
    }

    public void deleteArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        this.deleteArticle(article, articleURL, serviceContext);
    }

    public void deleteArticle(long groupId, String articleId, ServiceContext serviceContext) throws PortalException, SystemException {
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
        for (JournalArticle article : articles) {
            this.deleteArticle(article, null, serviceContext);
        }
    }

    public void deleteArticles(long groupId) throws PortalException, SystemException {
        for (JournalArticle article : this.journalArticlePersistence.findByGroupId(groupId)) {
            this.deleteArticle(article, null, null);
        }
    }

    public void deleteLayoutArticleReferences(long groupId, String layoutUuid) throws SystemException {
        List articles = this.journalArticlePersistence.findByG_L(groupId, layoutUuid);
        for (JournalArticle article : articles) {
            article.setLayoutUuid("");
            this.journalArticlePersistence.update((BaseModel)article, false);
        }
    }

    public JournalArticle expireArticle(long userId, long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateStatus(userId, groupId, articleId, version, 3, articleURL, serviceContext);
    }

    public void expireArticle(long userId, long groupId, String articleId, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
        for (JournalArticle article : articles) {
            this.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
        }
    }

    public JournalArticle getArticle(long id) throws PortalException, SystemException {
        return this.journalArticlePersistence.findByPrimaryKey(id);
    }

    public JournalArticle getArticle(long groupId, String articleId) throws PortalException, SystemException {
        try {
            return this.getLatestArticle(groupId, articleId, 0);
        }
        catch (NoSuchArticleException noSuchArticleException) {
            return this.getLatestArticle(groupId, articleId, -1);
        }
    }

    public JournalArticle getArticle(long groupId, String articleId, double version) throws PortalException, SystemException {
        return this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
    }

    public JournalArticle getArticle(long groupId, String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, classNameId, classPK);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No approved JournalArticle exists with the key {groupId=" + groupId + ", className=" + className + ", classPK=" + classPK + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticleByUrlTitle(long groupId, String urlTitle) throws PortalException, SystemException {
        try {
            return this.getLatestArticleByUrlTitle(groupId, urlTitle, 0);
        }
        catch (NoSuchArticleException noSuchArticleException) {
            return this.getLatestArticleByUrlTitle(groupId, urlTitle, 1);
        }
    }

    public String getArticleContent(JournalArticle article, String templateId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(article, templateId, viewMode, languageId, 1, null, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String templateId, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, version, templateId, viewMode, languageId, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getArticleContent(groupId, articleId, version, viewMode, null, languageId, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, String viewMode, String templateId, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, templateId, viewMode, languageId, themeDisplay);
        return articleDisplay.getContent();
    }

    public String getArticleContent(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getArticleContent(groupId, articleId, viewMode, null, languageId, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(JournalArticle article, String templateId, String viewMode, String languageId, int page, String xmlRequest, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String content = null;
        if (page < 1) {
            page = 1;
        }
        int numberOfPages = 1;
        boolean paginate = false;
        boolean pageFlow = false;
        boolean cacheable = true;
        if (Validator.isNull((String)xmlRequest)) {
            xmlRequest = "<request />";
        }
        Map<String, String> tokens = JournalUtil.getTokens(article.getGroupId(), themeDisplay, xmlRequest);
        tokens.put("article_resource_pk", String.valueOf(article.getResourcePrimKey()));
        String defaultTemplateId = article.getTemplateId();
        if (article.isTemplateDriven()) {
            if (Validator.isNull((String)templateId)) {
                templateId = defaultTemplateId;
            }
            tokens.put("structure_id", article.getStructureId());
            tokens.put("template_id", templateId);
        }
        String xml = article.getContent();
        try {
            Document document = null;
            Element rootElement = null;
            if (article.isTemplateDriven()) {
                document = SAXReaderUtil.read((String)xml);
                rootElement = document.getRootElement();
                Document requestDocument = SAXReaderUtil.read((String)xmlRequest);
                List pages = rootElement.elements("page");
                if (!pages.isEmpty()) {
                    pageFlow = true;
                    String targetPage = requestDocument.valueOf("/request/parameters/parameter[name='targetPage']/value");
                    Element pageElement = null;
                    if (Validator.isNotNull((String)targetPage)) {
                        XPath xPathSelector = SAXReaderUtil.createXPath((String)("/root/page[@id = '" + targetPage + "']"));
                        pageElement = (Element)xPathSelector.selectSingleNode((Object)document);
                    }
                    if (pageElement != null) {
                        document = SAXReaderUtil.createDocument(pageElement);
                        rootElement = document.getRootElement();
                        numberOfPages = pages.size();
                    } else {
                        if (page > pages.size()) {
                            page = 1;
                        }
                        pageElement = (Element)pages.get(page - 1);
                        document = SAXReaderUtil.createDocument((Element)pageElement);
                        rootElement = document.getRootElement();
                        numberOfPages = pages.size();
                        paginate = true;
                    }
                }
                rootElement.add(requestDocument.getRootElement().createCopy());
                JournalUtil.addAllReservedEls(rootElement, tokens, article, languageId);
                xml = DDMXMLUtil.formatXML((Document)document);
            }
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        try {
            String[] pieces;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Transforming " + article.getArticleId() + " " + article.getVersion() + " " + languageId));
            }
            String script = null;
            String langType = null;
            if (article.isTemplateDriven()) {
                JournalTemplate template;
                block24: {
                    template = null;
                    try {
                        template = this.journalTemplatePersistence.findByG_T(article.getGroupId(), templateId);
                    }
                    catch (NoSuchTemplateException nste1) {
                        try {
                            Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
                            template = this.journalTemplatePersistence.findByG_T(companyGroup.getGroupId(), templateId);
                            tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
                        }
                        catch (NoSuchTemplateException noSuchTemplateException) {
                            if (!defaultTemplateId.equals(templateId)) {
                                template = this.journalTemplatePersistence.findByG_T(article.getGroupId(), defaultTemplateId);
                                break block24;
                            }
                            throw nste1;
                        }
                    }
                }
                script = template.getXsl();
                langType = template.getLangType();
                cacheable = template.isCacheable();
            }
            content = JournalUtil.transform(themeDisplay, tokens, viewMode, languageId, xml, script, langType);
            if (!pageFlow && (pieces = StringUtil.split((String)content, (String)PropsValues.JOURNAL_ARTICLE_TOKEN_PAGE_BREAK)).length > 1) {
                if (page > pieces.length) {
                    page = 1;
                }
                content = pieces[page - 1];
                numberOfPages = pieces.length;
                paginate = true;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        return new JournalArticleDisplayImpl(article.getCompanyId(), article.getId(), article.getResourcePrimKey(), article.getGroupId(), article.getUserId(), article.getArticleId(), article.getVersion(), article.getTitle(languageId), article.getUrlTitle(), article.getDescription(languageId), article.getAvailableLocales(), content, article.getType(), article.getStructureId(), templateId, article.isSmallImage(), article.getSmallImageId(), article.getSmallImageURL(), numberOfPages, page, paginate, cacheable);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String templateId, String viewMode, String languageId, int page, String xmlRequest, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Date expirationDate;
        Date now = new Date();
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.isExpired() && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(now)) {
            return null;
        }
        if (article.getDisplayDate().after(now)) {
            return null;
        }
        return this.getArticleDisplay(article, templateId, viewMode, languageId, page, xmlRequest, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String templateId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getArticleDisplay(groupId, articleId, version, templateId, viewMode, languageId, 1, null, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, int page, String xmlRequest, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getArticleDisplay(groupId, articleId, null, viewMode, languageId, page, xmlRequest, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String templateId, String viewMode, String languageId, int page, String xmlRequest, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), templateId, viewMode, languageId, page, xmlRequest, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String templateId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), templateId, viewMode, languageId, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getArticleDisplay(groupId, articleId, null, viewMode, languageId, themeDisplay);
    }

    public List<JournalArticle> getArticles() throws SystemException {
        return this.journalArticlePersistence.findAll();
    }

    public List<JournalArticle> getArticles(long groupId) throws SystemException {
        return this.journalArticlePersistence.findByGroupId(groupId);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end) throws SystemException {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<JournalArticle> getArticles(long groupId, String articleId) throws SystemException {
        return this.journalArticlePersistence.findByG_A(groupId, articleId);
    }

    public List<JournalArticle> getArticlesBySmallImageId(long smallImageId) throws SystemException {
        return this.journalArticlePersistence.findBySmallImageId(smallImageId);
    }

    public int getArticlesCount(long groupId) throws SystemException {
        return this.journalArticlePersistence.countByGroupId(groupId);
    }

    public List<JournalArticle> getCompanyArticles(long companyId, double version, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.journalArticlePersistence.findByC_V(companyId, version, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_V_ST(companyId, version, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public List<JournalArticle> getCompanyArticles(long companyId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.journalArticlePersistence.findByCompanyId(companyId, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_ST(companyId, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public int getCompanyArticlesCount(long companyId, double version, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.journalArticlePersistence.countByC_V(companyId, version);
        }
        return this.journalArticlePersistence.countByC_V_ST(companyId, version, status);
    }

    public int getCompanyArticlesCount(long companyId, int status) throws SystemException {
        if (status == -1) {
            return this.journalArticlePersistence.countByCompanyId(companyId);
        }
        return this.journalArticlePersistence.countByC_ST(companyId, status);
    }

    public JournalArticle getDisplayArticle(long groupId, String articleId) throws PortalException, SystemException {
        List articles = this.journalArticlePersistence.findByG_A_ST(groupId, articleId, 0);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No approved JournalArticle exists with the key {groupId=" + groupId + ", " + "articleId=" + articleId + "}");
        }
        Date now = new Date();
        int i = 0;
        while (i < articles.size()) {
            JournalArticle article = (JournalArticle)articles.get(i);
            Date expirationDate = article.getExpirationDate();
            if (article.getDisplayDate().before(now) && (expirationDate == null || expirationDate.after(now))) {
                return article;
            }
            ++i;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getDisplayArticleByUrlTitle(long groupId, String urlTitle) throws PortalException, SystemException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        articles = this.journalArticlePersistence.findByG_UT_ST(groupId, urlTitle, 0, -1, -1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", urlTitle=" + urlTitle + "}");
        }
        Date now = new Date();
        for (JournalArticle article : articles) {
            Date expirationDate = article.getExpirationDate();
            if (!article.getDisplayDate().before(now) || expirationDate != null && !expirationDate.after(now)) continue;
            return article;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey) throws PortalException, SystemException {
        return this.getLatestArticle(resourcePrimKey, -1);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status) throws PortalException, SystemException {
        return this.getLatestArticle(resourcePrimKey, status, true);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status, boolean preferApproved) throws PortalException, SystemException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, 0, 0, 1, (OrderByComparator)orderByComparator);
            }
            if (articles == null || articles.size() == 0) {
                articles = this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey, 0, 1, (OrderByComparator)orderByComparator);
            }
        } else {
            articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, status, 0, 1, (OrderByComparator)orderByComparator);
        }
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {resourcePrimKey=" + resourcePrimKey + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId) throws PortalException, SystemException {
        return this.getLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId, int status) throws PortalException, SystemException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        articles = status == -1 ? this.journalArticlePersistence.findByG_A(groupId, articleId, 0, 1, (OrderByComparator)orderByComparator) : this.journalArticlePersistence.findByG_A_ST(groupId, articleId, status, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", articleId=" + articleId + ", status=" + status + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticle(long groupId, String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, classNameId, classPK, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", className=" + className + ", classPK =" + classPK + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticleByUrlTitle(long groupId, String urlTitle, int status) throws PortalException, SystemException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        articles = status == -1 ? this.journalArticlePersistence.findByG_UT(groupId, urlTitle, 0, 1, (OrderByComparator)orderByComparator) : this.journalArticlePersistence.findByG_UT_ST(groupId, urlTitle, status, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", urlTitle=" + urlTitle + ", status=" + status + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public double getLatestVersion(long groupId, String articleId) throws PortalException, SystemException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        return article.getVersion();
    }

    public double getLatestVersion(long groupId, String articleId, int status) throws PortalException, SystemException {
        JournalArticle article = this.getLatestArticle(groupId, articleId, status);
        return article.getVersion();
    }

    public List<JournalArticle> getStructureArticles(long groupId, String structureId) throws SystemException {
        return this.journalArticlePersistence.findByG_S(groupId, structureId);
    }

    public List<JournalArticle> getStructureArticles(long groupId, String structureId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticlePersistence.findByG_S(groupId, structureId, start, end, obc);
    }

    public int getStructureArticlesCount(long groupId, String structureId) throws SystemException {
        return this.journalArticlePersistence.countByG_S(groupId, structureId);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String templateId) throws SystemException {
        return this.journalArticlePersistence.findByG_T(groupId, templateId);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String templateId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticlePersistence.findByG_T(groupId, templateId, start, end, obc);
    }

    public int getTemplateArticlesCount(long groupId, String templateId) throws SystemException {
        return this.journalArticlePersistence.countByG_T(groupId, templateId);
    }

    public boolean hasArticle(long groupId, String articleId) throws SystemException {
        try {
            this.getArticle(groupId, articleId);
            return true;
        }
        catch (PortalException portalException) {
            return false;
        }
    }

    public boolean isLatestVersion(long groupId, String articleId, double version) throws PortalException, SystemException {
        return this.getLatestVersion(groupId, articleId) == version;
    }

    public boolean isLatestVersion(long groupId, String articleId, double version, int status) throws PortalException, SystemException {
        return this.getLatestVersion(groupId, articleId, status) == version;
    }

    public JournalArticle removeArticleLocale(long groupId, String articleId, double version, String languageId) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        String title = article.getTitle();
        title = LocalizationUtil.removeLocalization((String)title, (String)"static-content", (String)languageId, (boolean)true);
        article.setTitle(title);
        String description = article.getDescription();
        description = LocalizationUtil.removeLocalization((String)description, (String)"static-content", (String)languageId, (boolean)true);
        article.setDescription(description);
        String content = article.getContent();
        content = article.isTemplateDriven() ? JournalUtil.removeArticleLocale(content, languageId) : LocalizationUtil.removeLocalization((String)content, (String)"static-content", (String)languageId, (boolean)true);
        article.setContent(content);
        this.journalArticlePersistence.update((BaseModel)article, false);
        return article;
    }

    public List<JournalArticle> search(long companyId, long groupId, long classNameId, String keywords, Double version, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticleFinder.findByKeywords(companyId, groupId, classNameId, keywords, version, type, structureId, templateId, displayDateGT, displayDateLT, status, reviewDate, start, end, obc);
    }

    public List<JournalArticle> search(long companyId, long groupId, long classNameId, String articleId, Double version, String title, String description, String content, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticleFinder.findByC_G_C_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, classNameId, articleId, version, title, description, content, type, structureId, templateId, displayDateGT, displayDateLT, status, reviewDate, andOperator, start, end, obc);
    }

    public List<JournalArticle> search(long companyId, long groupId, long classNameId, String articleId, Double version, String title, String description, String content, String type, String[] structureIds, String[] templateIds, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticleFinder.findByC_G_C_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, classNameId, articleId, version, title, description, content, type, structureIds, templateIds, displayDateGT, displayDateLT, status, reviewDate, andOperator, start, end, obc);
    }

    public Hits search(long companyId, long groupId, long classNameId, String structureId, String templateId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws SystemException {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        String status = String.valueOf(-1);
        params.put("keywords", keywords);
        return this.search(companyId, groupId, classNameId, articleId, title, description, content, null, status, structureId, templateId, params, andOperator, start, end, sort);
    }

    public Hits search(long companyId, long groupId, long classNameId, String articleId, String title, String description, String content, String type, String status, String structureId, String templateId, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws SystemException {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("classNameId", classNameId);
            attributes.put("content", content);
            attributes.put("description", description);
            attributes.put("status", status);
            attributes.put("title", title);
            attributes.put("type", type);
            attributes.put("articleId", articleId);
            attributes.put("params", params);
            attributes.put("structureId", structureId);
            attributes.put("templateId", templateId);
            SearchContext searchContext = new SearchContext();
            searchContext.setAndSearch(andSearch);
            searchContext.setAttributes(attributes);
            searchContext.setCompanyId(companyId);
            searchContext.setGroupIds(new long[]{groupId});
            searchContext.setEnd(end);
            String keywords = (String)params.remove("keywords");
            if (Validator.isNotNull((String)keywords)) {
                searchContext.setKeywords(keywords);
            }
            searchContext.setSorts(new Sort[]{sort});
            QueryConfig queryConfig = new QueryConfig();
            queryConfig.setHighlightEnabled(false);
            queryConfig.setScoreEnabled(false);
            searchContext.setQueryConfig(queryConfig);
            searchContext.setStart(start);
            Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public int searchCount(long companyId, long groupId, long classNameId, String keywords, Double version, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate) throws SystemException {
        return this.journalArticleFinder.countByKeywords(companyId, groupId, classNameId, keywords, version, type, structureId, templateId, displayDateGT, displayDateLT, status, reviewDate);
    }

    public int searchCount(long companyId, long groupId, long classNameId, String articleId, Double version, String title, String description, String content, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) throws SystemException {
        return this.journalArticleFinder.countByC_G_C_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, classNameId, articleId, version, title, description, content, type, structureId, templateId, displayDateGT, displayDateLT, status, reviewDate, andOperator);
    }

    public int searchCount(long companyId, long groupId, long classNameId, String articleId, Double version, String title, String description, String content, String type, String[] structureIds, String[] templateIds, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) throws SystemException {
        return this.journalArticleFinder.countByC_G_C_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, classNameId, articleId, version, title, description, content, type, structureIds, templateIds, displayDateGT, displayDateLT, status, reviewDate, andOperator);
    }

    public void subscribe(long userId, long groupId) throws PortalException, SystemException {
        this.subscriptionLocalService.addSubscription(userId, groupId, JournalArticle.class.getName(), groupId);
    }

    public void unsubscribe(long userId, long groupId) throws PortalException, SystemException {
        this.subscriptionLocalService.deleteSubscription(userId, JournalArticle.class.getName(), groupId);
    }

    public JournalArticle updateArticle(long userId, long groupId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String layoutUuid, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        return this.updateArticle(userId, groupId, articleId, version, titleMap, descriptionMap, content, article.getType(), article.getStructureId(), article.getTemplateId(), layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.getIndexable(), article.isSmallImage(), article.getSmallImageURL(), null, null, null, serviceContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JournalArticle updateArticle(long userId, long groupId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String type, String structureId, String templateId, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        articleId = articleId.trim().toUpperCase();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new ArticleDisplayDateException());
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new ArticleExpirationDateException());
        }
        Date now = new Date();
        boolean expired = false;
        if (expirationDate != null && expirationDate.before(now)) {
            expired = true;
        }
        Date reviewDate = null;
        if (!neverReview) {
            reviewDate = PortalUtil.getDate((int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new ArticleReviewDateException());
        }
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException iOException) {}
        JournalArticle oldArticle = null;
        double oldVersion = 0.0;
        boolean incrementVersion = false;
        boolean imported = GetterUtil.getBoolean((Object)serviceContext.getAttribute("imported"));
        if (imported) {
            oldArticle = this.getArticle(groupId, articleId, version);
            oldVersion = version;
            if (expired) return this.expireArticle(userId, groupId, articleId, version, articleURL, serviceContext);
            incrementVersion = true;
        } else {
            oldArticle = this.getLatestArticle(groupId, articleId, -1);
            oldVersion = oldArticle.getVersion();
            if (version > 0.0 && version != oldVersion) {
                throw new ArticleVersionException();
            }
            if (oldArticle.isApproved() || oldArticle.isExpired()) {
                incrementVersion = true;
            }
        }
        this.validate(user.getCompanyId(), groupId, oldArticle.getClassNameId(), titleMap, content, type, structureId, templateId, smallImage, smallImageURL, smallImageFile, smallImageBytes);
        JournalArticle article = null;
        if (incrementVersion) {
            double newVersion = MathUtil.format((double)(oldVersion + 0.1), (int)1, (int)1);
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(oldArticle.getResourcePrimKey());
            article.setGroupId(oldArticle.getGroupId());
            article.setCompanyId(oldArticle.getCompanyId());
            article.setUserId(user.getUserId());
            article.setUserName(user.getFullName());
            article.setCreateDate(serviceContext.getModifiedDate(now));
            article.setClassNameId(oldArticle.getClassNameId());
            article.setClassPK(oldArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(newVersion);
            article.setSmallImageId(oldArticle.getSmallImageId());
        } else {
            article = oldArticle;
        }
        Locale locale = LocaleUtil.getDefault();
        String defaultLanguageId = GetterUtil.getString((Object)serviceContext.getAttribute("defaultLanguageId"));
        if (Validator.isNotNull((String)defaultLanguageId)) {
            locale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }
        String title = titleMap.get(locale);
        content = this.format(user, groupId, articleId, article.getVersion(), incrementVersion, content, structureId, images);
        article.setModifiedDate(serviceContext.getModifiedDate(now));
        article.setTitleMap(titleMap, locale);
        article.setUrlTitle(this.getUniqueUrlTitle(article.getId(), groupId, articleId, title));
        article.setDescriptionMap(descriptionMap, locale);
        article.setContent(content);
        article.setType(type);
        article.setStructureId(structureId);
        article.setTemplateId(templateId);
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        if (article.getSmallImageId() == 0L) {
            article.setSmallImageId(this.counterLocalService.increment());
        }
        article.setSmallImageURL(smallImageURL);
        if (oldArticle.isPending()) {
            article.setStatus(oldArticle.getStatus());
        } else if (!expired) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        this.journalArticlePersistence.update((BaseModel)article, false);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        ExpandoBridge expandoBridge = article.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (serviceContext.getWorkflowAction() == 1) {
            this.sendEmail(article, articleURL, preferences, "requested", serviceContext);
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)JournalArticle.class.getName(), (long)article.getId(), (Object)article, (ServiceContext)serviceContext);
            return article;
        } else {
            if (article.getVersion() != 1.0) return article;
            Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
            indexer.reindex((Object)article);
        }
        return article;
    }

    public JournalArticle updateArticle(long userId, long groupId, String articleId, double version, String content, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.updateArticle(userId, groupId, articleId, version, article.getTitleMap(), article.getDescriptionMap(), content, article.getLayoutUuid(), serviceContext);
    }

    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images) throws PortalException, SystemException {
        this.validateContent(content);
        JournalArticle oldArticle = this.getLatestArticle(groupId, articleId, -1);
        double oldVersion = oldArticle.getVersion();
        if (version > 0.0 && version != oldVersion) {
            throw new ArticleVersionException();
        }
        JournalArticle article = null;
        User user = this.userService.getUserById(oldArticle.getUserId());
        if (!oldArticle.isDraft()) {
            double newVersion = MathUtil.format((double)(oldVersion + 0.1), (int)1, (int)1);
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(oldArticle.getResourcePrimKey());
            article.setGroupId(oldArticle.getGroupId());
            article.setCompanyId(oldArticle.getCompanyId());
            article.setUserId(oldArticle.getUserId());
            article.setUserName(user.getFullName());
            article.setCreateDate(new Date());
            article.setModifiedDate(new Date());
            article.setClassNameId(oldArticle.getClassNameId());
            article.setClassPK(oldArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(newVersion);
            article.setTitleMap(oldArticle.getTitleMap());
            article.setUrlTitle(this.getUniqueUrlTitle(article.getId(), groupId, articleId, title));
            article.setDescriptionMap(oldArticle.getDescriptionMap());
            article.setType(oldArticle.getType());
            article.setStructureId(oldArticle.getStructureId());
            article.setTemplateId(oldArticle.getTemplateId());
            article.setLayoutUuid(oldArticle.getLayoutUuid());
            article.setDisplayDate(oldArticle.getDisplayDate());
            article.setExpirationDate(oldArticle.getExpirationDate());
            article.setReviewDate(oldArticle.getReviewDate());
            article.setIndexable(oldArticle.getIndexable());
            article.setSmallImage(oldArticle.getSmallImage());
            article.setSmallImageId(oldArticle.getSmallImageId());
            if (article.getSmallImageId() == 0L) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
            article.setSmallImageURL(oldArticle.getSmallImageURL());
            article.setStatus(2);
            article.setStatusDate(new Date());
        } else {
            article = oldArticle;
        }
        Map titleMap = article.getTitleMap();
        titleMap.put(locale, title);
        article.setTitleMap(titleMap);
        Map descriptionMap = article.getDescriptionMap();
        descriptionMap.put(locale, description);
        article.setDescriptionMap(descriptionMap);
        content = this.format(user, groupId, articleId, version, !oldArticle.isDraft(), content, oldArticle.getStructureId(), images);
        article.setContent(content);
        this.journalArticlePersistence.update((BaseModel)article, false);
        return article;
    }

    public void updateAsset(long userId, JournalArticle article, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        int approvedArticlesCount;
        Date[] dateInterval = this.getDateInterval(article.getGroupId(), article.getArticleId(), article.getDisplayDate(), article.getExpirationDate());
        Date displayDate = dateInterval[0];
        Date expirationDate = dateInterval[1];
        boolean visible = article.isApproved();
        if (article.getClassNameId() > 0L) {
            visible = false;
        }
        boolean addDraftAssetEntry = false;
        if (!article.isApproved() && article.getVersion() != 1.0 && (approvedArticlesCount = this.journalArticlePersistence.countByG_A_ST(article.getGroupId(), article.getArticleId(), JournalArticleConstants.ASSET_ENTRY_CREATION_STATUSES)) > 0) {
            addDraftAssetEntry = true;
        }
        AssetEntry assetEntry = null;
        if (addDraftAssetEntry) {
            assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), JournalArticle.class.getName(), article.getPrimaryKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, false, null, null, displayDate, expirationDate, "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, null, false);
        } else {
            JournalArticleResource journalArticleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
            assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), JournalArticle.class.getName(), journalArticleResource.getResourcePrimKey(), journalArticleResource.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, visible, null, null, displayDate, expirationDate, "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, null, false);
        }
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public JournalArticle updateContent(long groupId, String articleId, double version, String content) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        article.setContent(content);
        this.journalArticlePersistence.update((BaseModel)article, false);
        return article;
    }

    public JournalArticle updateStatus(long userId, JournalArticle article, int status, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        Date expirationDate;
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        int oldStatus = article.getStatus();
        article.setModifiedDate(serviceContext.getModifiedDate(now));
        boolean neverExpire = false;
        if (status == 0 && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(now)) {
            neverExpire = true;
            article.setExpirationDate(null);
        }
        if (status == 3) {
            article.setExpirationDate(now);
        }
        article.setStatus(status);
        article.setStatusByUserId(user.getUserId());
        article.setStatusByUserName(user.getFullName());
        article.setStatusDate(serviceContext.getModifiedDate(now));
        this.journalArticlePersistence.update((BaseModel)article, false);
        if (this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            if (status == 0) {
                this.updateUrlTitles(article.getGroupId(), article.getArticleId(), article.getUrlTitle());
                if (oldStatus != 0 && article.getVersion() != 1.0) {
                    AssetEntry draftAssetEntry = null;
                    try {
                        draftAssetEntry = this.assetEntryLocalService.getEntry(JournalArticle.class.getName(), article.getPrimaryKey());
                        Date[] dateInterval = this.getDateInterval(article.getGroupId(), article.getArticleId(), article.getDisplayDate(), article.getExpirationDate());
                        Date displayDate = dateInterval[0];
                        Date expirationDate2 = dateInterval[1];
                        long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                        String[] assetTagNames = draftAssetEntry.getTagNames();
                        List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0);
                        long[] assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
                        boolean visible = true;
                        if (article.getClassNameId() > 0L) {
                            visible = false;
                        }
                        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, visible, null, null, displayDate, expirationDate2, "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, null, false);
                        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                        this.assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getPrimaryKey());
                    }
                    catch (NoSuchEntryException noSuchEntryException) {}
                }
                if (article.getClassNameId() == 0L) {
                    AssetEntry assetEntry = this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), true);
                    if (neverExpire) {
                        assetEntry.setExpirationDate(null);
                        this.assetEntryLocalService.updateAssetEntry(assetEntry, false);
                    }
                }
                ExpandoBridge expandoBridge = article.getExpandoBridge();
                expandoBridge.setAttributes(serviceContext);
                Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
                indexer.reindex((Object)article);
            } else if (oldStatus == 0) {
                this.updatePreviousApprovedArticle(article);
            }
        }
        if (article.getClassNameId() == 0L) {
            if (oldStatus == 1 && (status == 0 || status == 4)) {
                String msg = "granted";
                if (status == 4) {
                    msg = "denied";
                }
                try {
                    PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
                    this.sendEmail(article, articleURL, preferences, msg, serviceContext);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to send email to notify the change of status  to " + msg + " for article " + article.getId() + ": " + e.getMessage()));
                }
            }
            this.notifySubscribers(article, serviceContext);
        }
        return article;
    }

    public JournalArticle updateStatus(long userId, long classPK, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle article = this.getArticle(classPK);
        return this.updateStatus(userId, article, status, null, serviceContext);
    }

    public JournalArticle updateStatus(long userId, long groupId, String articleId, double version, int status, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.updateStatus(userId, article, status, articleURL, serviceContext);
    }

    public void updateTemplateId(long groupId, long classNameId, String oldTemplateId, String newTemplateId) throws SystemException {
        List articles = this.journalArticlePersistence.findByG_C_T(groupId, classNameId, oldTemplateId);
        for (JournalArticle article : articles) {
            article.setTemplateId(newTemplateId);
            this.journalArticlePersistence.update((BaseModel)article, false);
        }
    }

    protected void checkStructure(Document contentDoc, Element root) throws PortalException {
        for (Element el : root.elements()) {
            this.checkStructureField(el, contentDoc);
            this.checkStructure(contentDoc, el);
        }
    }

    protected void checkStructure(JournalArticle article) throws DocumentException, PortalException, SystemException {
        block4: {
            Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
            JournalStructure structure = null;
            try {
                structure = this.journalStructurePersistence.findByG_S(article.getGroupId(), article.getStructureId());
            }
            catch (NoSuchStructureException noSuchStructureException) {
                structure = this.journalStructurePersistence.findByG_S(companyGroup.getGroupId(), article.getStructureId());
            }
            String content = GetterUtil.getString((String)article.getContent());
            Document contentDoc = SAXReaderUtil.read((String)content);
            Document xsdDoc = SAXReaderUtil.read((String)structure.getXsd());
            try {
                this.checkStructure(contentDoc, xsdDoc.getRootElement());
            }
            catch (StructureXsdException sxsde) {
                long groupId = article.getGroupId();
                String articleId = article.getArticleId();
                double version = article.getVersion();
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Article {groupId=" + groupId + ", articleId=" + articleId + ", version=" + version + "} has content that does not match its " + "structure: " + sxsde.getMessage()));
            }
        }
    }

    protected void checkStructureField(Element el, Document contentDoc) throws PortalException {
        StringBuilder elPath = new StringBuilder();
        elPath.append(el.attributeValue("name"));
        for (Element elParent = el.getParent(); elParent != null && !elParent.getName().equals("root"); elParent = elParent.getParent()) {
            elPath.insert(0, String.valueOf(elParent.attributeValue("name")) + ",");
        }
        String[] elPathNames = StringUtil.split((String)elPath.toString());
        Element contentEl = contentDoc.getRootElement();
        String[] stringArray = elPathNames;
        int n = elPathNames.length;
        int n2 = 0;
        while (n2 < n) {
            String _elPathName = stringArray[n2];
            boolean foundEl = false;
            for (Element tempEl : contentEl.elements()) {
                if (!_elPathName.equals(tempEl.attributeValue("name", ""))) continue;
                contentEl = tempEl;
                foundEl = true;
                break;
            }
            if (!foundEl) {
                String elType = contentEl.attributeValue("type", "");
                if (elType.equals("list") || elType.equals("multi-list")) break;
                throw new StructureXsdException(elPath.toString());
            }
            ++n2;
        }
    }

    protected void copyArticleImages(JournalArticle oldArticle, JournalArticle newArticle) throws Exception {
        Document contentDoc = SAXReaderUtil.read((String)oldArticle.getContent());
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='image']");
        List imageNodes = xPathSelector.selectNodes((Object)contentDoc);
        for (Node imageNode : imageNodes) {
            Element imageEl = (Element)imageNode;
            String instanceId = imageEl.attributeValue("instance-id");
            String name = imageEl.attributeValue("name");
            List dynamicContentEls = imageEl.elements("dynamic-content");
            for (Element dynamicContentEl : dynamicContentEls) {
                long imageId = GetterUtil.getLong((String)dynamicContentEl.attributeValue("id"));
                String languageId = dynamicContentEl.attributeValue("language-id");
                Image oldImage = null;
                try {
                    oldImage = this.imageLocalService.getImage(imageId);
                }
                catch (NoSuchImageException noSuchImageException) {
                    continue;
                }
                imageId = this.journalArticleImageLocalService.getArticleImageId(newArticle.getGroupId(), newArticle.getArticleId(), newArticle.getVersion(), instanceId, name, languageId);
                this.imageLocalService.updateImage(imageId, oldImage.getTextObj());
                String elContent = "/image/journal/article?img_id=" + imageId + "&t=" + WebServerServletTokenUtil.getToken((long)imageId);
                dynamicContentEl.setText(elContent);
                dynamicContentEl.addAttribute("id", String.valueOf(imageId));
            }
        }
        newArticle.setContent(contentDoc.formattedString());
    }

    protected void format(User user, long groupId, String articleId, double version, boolean incrementVersion, Element root, Map<String, byte[]> images) throws PortalException, SystemException {
        for (Element element : root.elements()) {
            String elInstanceId = element.attributeValue("instance-id", "");
            String elName = element.attributeValue("name", "");
            String elType = element.attributeValue("type", "");
            if (elType.equals("image")) {
                this.formatImage(groupId, articleId, version, incrementVersion, element, elInstanceId, elName, images);
            } else if (elType.equals("text_area") || elType.equals("text") || elType.equals("text_box")) {
                List dynamicContentElements = element.elements("dynamic-content");
                for (Element dynamicContentElement : dynamicContentElements) {
                    String dynamicContent = dynamicContentElement.getText();
                    if (!Validator.isNotNull((String)dynamicContent)) continue;
                    dynamicContent = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)user.getUserId(), (String)JournalArticle.class.getName(), (long)0L, (String)"text/html", (String)dynamicContent);
                    dynamicContentElement.setText(dynamicContent);
                }
            }
            this.format(user, groupId, articleId, version, incrementVersion, element, images);
        }
    }

    protected String format(User user, long groupId, String articleId, double version, boolean incrementVersion, String content, String structureId, Map<String, byte[]> images) throws PortalException, SystemException {
        Document document = null;
        try {
            document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            if (Validator.isNotNull((String)structureId)) {
                this.format(user, groupId, articleId, version, incrementVersion, rootElement, images);
            } else {
                List staticContentElements = rootElement.elements("static-content");
                for (Element staticContentElement : staticContentElements) {
                    String staticContent = staticContentElement.getText();
                    staticContent = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)user.getUserId(), (String)JournalArticle.class.getName(), (long)0L, (String)"text/html", (String)staticContent);
                    staticContentElement.setText(staticContent);
                }
            }
            content = DDMXMLUtil.formatXML((Document)document);
        }
        catch (DocumentException de) {
            _log.error((Throwable)de);
        }
        catch (IOException ioe) {
            _log.error((Throwable)ioe);
        }
        content = HtmlUtil.replaceMsWordCharacters((String)content);
        return content;
    }

    protected void formatImage(long groupId, String articleId, double version, boolean incrementVersion, Element el, String elInstanceId, String elName, Map<String, byte[]> images) throws PortalException, SystemException {
        List imageContents = el.elements("dynamic-content");
        for (Element dynamicContent : imageContents) {
            long defaultImageId;
            Image defaultImage;
            String elLanguage = dynamicContent.attributeValue("language-id", "");
            if (!elLanguage.equals("")) {
                elLanguage = "_" + elLanguage;
            }
            long imageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, elLanguage);
            double oldVersion = MathUtil.format((double)(version - 0.1), (int)1, (int)1);
            long oldImageId = 0L;
            if (oldVersion >= 1.0 && incrementVersion) {
                oldImageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, oldVersion, elInstanceId, elName, elLanguage);
            }
            String elContent = "/image/journal/article?img_id=" + imageId + "&t=" + WebServerServletTokenUtil.getToken((long)imageId);
            if (dynamicContent.getText().equals("delete")) {
                dynamicContent.setText("");
                this.imageLocalService.deleteImage(imageId);
                String defaultElLanguage = "";
                if (!Validator.isNotNull((String)elLanguage)) {
                    defaultElLanguage = "_" + LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
                }
                long defaultImageId2 = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, defaultElLanguage);
                this.imageLocalService.deleteImage(defaultImageId2);
                continue;
            }
            byte[] bytes = images.get(String.valueOf(elInstanceId) + "_" + elName + elLanguage);
            if (bytes != null && bytes.length > 0) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(imageId));
                this.imageLocalService.updateImage(imageId, bytes);
                continue;
            }
            if (version > 1.0 && incrementVersion) {
                Image oldImage = null;
                if (oldImageId > 0L) {
                    oldImage = this.imageLocalService.getImage(oldImageId);
                }
                if (oldImage == null) continue;
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(imageId));
                bytes = oldImage.getTextObj();
                this.imageLocalService.updateImage(imageId, bytes);
                continue;
            }
            Image image = this.imageLocalService.getImage(imageId);
            if (image != null) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(imageId));
                continue;
            }
            long contentImageId = GetterUtil.getLong((String)HttpUtil.getParameter((String)dynamicContent.getText(), (String)"img_id"));
            if (contentImageId <= 0L) {
                contentImageId = GetterUtil.getLong((String)HttpUtil.getParameter((String)dynamicContent.getText(), (String)"img_id", (boolean)false));
            }
            if (contentImageId > 0L && (image = this.imageLocalService.getImage(contentImageId)) != null) {
                dynamicContent.addAttribute("id", String.valueOf(contentImageId));
                continue;
            }
            String defaultElLanguage = "";
            if (!Validator.isNotNull((String)elLanguage)) {
                defaultElLanguage = "_" + LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
            }
            if ((defaultImage = this.imageLocalService.getImage(defaultImageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, defaultElLanguage))) != null) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(defaultImageId));
                bytes = defaultImage.getTextObj();
                this.imageLocalService.updateImage(defaultImageId, bytes);
                continue;
            }
            if (!Validator.isNotNull((String)elLanguage)) continue;
            dynamicContent.setText("");
        }
    }

    protected long getClassTypeId(JournalArticle article) {
        long classTypeId = 0L;
        try {
            JournalStructure structure = this.journalStructurePersistence.fetchByG_S(article.getGroupId(), article.getStructureId());
            if (structure == null) {
                Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
                structure = this.journalStructurePersistence.fetchByG_S(companyGroup.getGroupId(), article.getStructureId());
            }
            if (structure != null) {
                classTypeId = structure.getId();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return classTypeId;
    }

    protected Date[] getDateInterval(long groupId, String articleId, Date earliestDisplayDate, Date latestExpirationDate) throws SystemException {
        Date[] dateInterval = new Date[2];
        List articles = this.journalArticlePersistence.findByG_A_ST(groupId, articleId, 0);
        boolean expiringArticle = true;
        if (latestExpirationDate == null) {
            expiringArticle = false;
        }
        for (JournalArticle article : articles) {
            if (earliestDisplayDate == null || article.getDisplayDate() != null && earliestDisplayDate.after(article.getDisplayDate())) {
                earliestDisplayDate = article.getDisplayDate();
            }
            if (expiringArticle && (latestExpirationDate == null || article.getExpirationDate() != null && latestExpirationDate.before(article.getExpirationDate()))) {
                latestExpirationDate = article.getExpirationDate();
            }
            if (!expiringArticle || article.getExpirationDate() != null || latestExpirationDate == null) continue;
            expiringArticle = false;
        }
        dateInterval[0] = earliestDisplayDate;
        dateInterval[1] = latestExpirationDate;
        return dateInterval;
    }

    protected String getUniqueUrlTitle(long id, long groupId, String articleId, String title) throws PortalException, SystemException {
        String urlTitle = JournalUtil.getUrlTitle(id, title);
        String newUrlTitle = ModelHintsUtil.trimString((String)JournalArticle.class.getName(), (String)"urlTitle", (String)urlTitle);
        int i = 1;
        while (true) {
            JournalArticle article = null;
            try {
                article = this.getArticleByUrlTitle(groupId, newUrlTitle);
            }
            catch (NoSuchArticleException noSuchArticleException) {}
            if (article == null || article.getArticleId().equals(articleId)) break;
            String suffix = "-" + i;
            String prefix = newUrlTitle;
            if (newUrlTitle.length() > suffix.length()) {
                prefix = newUrlTitle.substring(0, newUrlTitle.length() - suffix.length());
            }
            newUrlTitle = String.valueOf(prefix) + suffix;
            ++i;
        }
        return newUrlTitle;
    }

    protected void notifySubscribers(JournalArticle article, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!article.isApproved()) {
            return;
        }
        String articleURL = PortalUtil.getControlPanelFullURL((long)serviceContext.getScopeGroupId(), (String)"15", null);
        if (Validator.isNull((String)articleURL)) {
            return;
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = article.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "15";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(article.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(article.getVersion() == 1.0 && JournalUtil.getEmailArticleAddedEnabled(preferences) || article.getVersion() != 1.0 && JournalUtil.getEmailArticleUpdatedEnabled(preferences))) {
            return;
        }
        String fromName = JournalUtil.getEmailFromName(preferences, article.getCompanyId());
        String fromAddress = JournalUtil.getEmailFromAddress(preferences, article.getCompanyId());
        String subject = null;
        String body = null;
        if (article.getVersion() == 1.0) {
            subject = JournalUtil.getEmailArticleAddedSubject(preferences);
            body = JournalUtil.getEmailArticleAddedBody(preferences);
        } else {
            subject = JournalUtil.getEmailArticleUpdatedSubject(preferences);
            body = JournalUtil.getEmailArticleUpdatedBody(preferences);
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(article.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", article.getTitle(serviceContext.getLanguageId()), "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_VERSION$]", article.getVersion()});
        subscriptionSender.setContextUserPrefix("ARTICLE");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        subscriptionSender.setPortletId("15");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(article.getUserId());
        subscriptionSender.addPersistedSubscribers(JournalArticle.class.getName(), article.getGroupId());
        subscriptionSender.flushNotificationsAsync();
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
    }

    protected void sendEmail(JournalArticle article, String articleURL, PortletPreferences preferences, String emailType, ServiceContext serviceContext) throws PortalException, SystemException {
        if (preferences == null) {
            return;
        }
        if (!(emailType.equals("denied") && JournalUtil.getEmailArticleApprovalDeniedEnabled(preferences) || emailType.equals("granted") && JournalUtil.getEmailArticleApprovalGrantedEnabled(preferences) || emailType.equals("requested") && JournalUtil.getEmailArticleApprovalRequestedEnabled(preferences) || emailType.equals("review") && JournalUtil.getEmailArticleReviewEnabled(preferences))) {
            return;
        }
        Company company = this.companyPersistence.findByPrimaryKey(article.getCompanyId());
        User user = this.userPersistence.findByPrimaryKey(article.getUserId());
        articleURL = String.valueOf(articleURL) + "&groupId=" + article.getGroupId() + "&articleId=" + article.getArticleId() + "&version=" + article.getVersion();
        String fromName = JournalUtil.getEmailFromName(preferences, article.getCompanyId());
        String fromAddress = JournalUtil.getEmailFromAddress(preferences, article.getCompanyId());
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        if (emailType.equals("requested") || emailType.equals("review")) {
            String tempToName = fromName;
            String tempToAddress = fromAddress;
            fromName = toName;
            fromAddress = toAddress;
            toName = tempToName;
            toAddress = tempToAddress;
        }
        String subject = null;
        String body = null;
        if (emailType.equals("denied")) {
            subject = JournalUtil.getEmailArticleApprovalDeniedSubject(preferences);
            body = JournalUtil.getEmailArticleApprovalDeniedBody(preferences);
        } else if (emailType.equals("granted")) {
            subject = JournalUtil.getEmailArticleApprovalGrantedSubject(preferences);
            body = JournalUtil.getEmailArticleApprovalGrantedBody(preferences);
        } else if (emailType.equals("requested")) {
            subject = JournalUtil.getEmailArticleApprovalRequestedSubject(preferences);
            body = JournalUtil.getEmailArticleApprovalRequestedBody(preferences);
        } else if (emailType.equals("review")) {
            subject = JournalUtil.getEmailArticleReviewSubject(preferences);
            body = JournalUtil.getEmailArticleReviewBody(preferences);
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(company.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", article.getTitle(), "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_USER_NAME$]", article.getUserName(), "[$ARTICLE_VERSION$]", article.getVersion()});
        subscriptionSender.setContextUserPrefix("ARTICLE");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        subscriptionSender.setPortletId("15");
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(article.getUserId());
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void updatePreviousApprovedArticle(JournalArticle article) throws PortalException, SystemException {
        List approvedArticles = this.journalArticlePersistence.findByG_A_ST(article.getGroupId(), article.getArticleId(), 0, 0, 2);
        if (approvedArticles.isEmpty() || approvedArticles.size() == 1 && article.getStatus() == 0) {
            if (article.isIndexable()) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
                indexer.delete((Object)article);
            }
            this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
        } else {
            JournalArticle previousApprovedArticle = (JournalArticle)approvedArticles.get(0);
            if (article.getStatus() == 0) {
                previousApprovedArticle = (JournalArticle)approvedArticles.get(1);
            }
            if (article.isIndexable()) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
                indexer.reindex((Object)previousApprovedArticle);
            }
        }
    }

    protected void updateUrlTitles(long groupId, String articleId, String urlTitle) throws SystemException {
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        for (JournalArticle article : articles) {
            if (article.getUrlTitle().equals(urlTitle)) continue;
            article.setUrlTitle(urlTitle);
            this.journalArticlePersistence.update((BaseModel)article, false);
        }
    }

    protected void validate(long companyId, long groupId, long classNameId, Map<Locale, String> titleMap, String content, String type, String structureId, String templateId, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLocale((String)content));
        if (classNameId == 0L && (titleMap.isEmpty() || Validator.isNull((String)titleMap.get(defaultLocale)))) {
            throw new ArticleTitleException();
        }
        if (Validator.isNull((String)type)) {
            throw new ArticleTypeException();
        }
        this.validateContent(content);
        if (Validator.isNotNull((String)structureId)) {
            Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
            try {
                this.journalStructurePersistence.findByG_S(groupId, structureId);
            }
            catch (NoSuchStructureException noSuchStructureException) {
                this.journalStructurePersistence.findByG_S(companyGroup.getGroupId(), structureId);
            }
            JournalTemplate template = null;
            if (Validator.isNotNull((String)templateId)) {
                try {
                    template = this.journalTemplatePersistence.findByG_T(groupId, templateId);
                }
                catch (NoSuchTemplateException noSuchTemplateException) {
                    template = this.journalTemplatePersistence.findByG_T(companyGroup.getGroupId(), templateId);
                }
                if (!template.getStructureId().equals(structureId)) {
                    throw new NoSuchTemplateException();
                }
            } else if (classNameId == 0L) {
                throw new NoSuchTemplateException();
            }
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray("journal.image.extensions", ",");
        if (smallImage && Validator.isNull((String)smallImageURL) && smallImageFile != null && smallImageBytes != null) {
            long smallImageMaxSize;
            String smallImageName = smallImageFile.getName();
            if (smallImageName != null) {
                boolean validSmallImageExtension = false;
                String[] stringArray = imageExtensions;
                int n = imageExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String _imageExtension = stringArray[n2];
                    if ("*".equals(_imageExtension) || StringUtil.endsWith((String)smallImageName, (String)_imageExtension)) {
                        validSmallImageExtension = true;
                        break;
                    }
                    ++n2;
                }
                if (!validSmallImageExtension) {
                    throw new ArticleSmallImageNameException(smallImageName);
                }
            }
            if ((smallImageMaxSize = PrefsPropsUtil.getLong("journal.image.small.max.size")) > 0L && (smallImageBytes == null || (long)smallImageBytes.length > smallImageMaxSize)) {
                throw new ArticleSmallImageSizeException();
            }
        }
    }

    protected void validate(long companyId, long groupId, long classNameId, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, String content, String type, String structureId, String templateId, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes) throws PortalException, SystemException {
        if (!autoArticleId) {
            this.validate(groupId, articleId);
        }
        this.validate(companyId, groupId, classNameId, titleMap, content, type, structureId, templateId, smallImage, smallImageURL, smallImageFile, smallImageBytes);
    }

    protected void validate(long groupId, String articleId) throws PortalException, SystemException {
        if (Validator.isNull((String)articleId) || articleId.indexOf(32) != -1) {
            throw new ArticleIdException();
        }
        if (this.journalArticlePersistence.countByG_A(groupId, articleId) > 0) {
            throw new DuplicateArticleIdException();
        }
    }

    protected void validateContent(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            throw new ArticleContentException();
        }
        try {
            SAXReaderUtil.read((String)content);
        }
        catch (DocumentException documentException) {
            throw new ArticleContentException();
        }
    }
}

