/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.model.impl;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.impl.JournalStructureBaseImpl;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;

public class JournalStructureImpl
extends JournalStructureBaseImpl {
    private static final String _DYNAMIC_ELEMENT = "dynamic-element";
    private static final String _PARENT_STRUCTURE_ID = "parent-structure-id";

    public String getMergedXsd() {
        String parentStructureId = this.getParentStructureId();
        String xsd = this.getXsd();
        if (Validator.isNull((String)parentStructureId)) {
            return xsd;
        }
        try {
            JournalStructure parentStructure = null;
            try {
                parentStructure = JournalStructureLocalServiceUtil.getStructure((long)this.getGroupId(), (String)parentStructureId);
            }
            catch (NoSuchStructureException noSuchStructureException) {
                Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)group.getCompanyId());
                if (this.getGroupId() == companyGroup.getGroupId()) {
                    throw new NoSuchStructureException();
                }
                parentStructure = JournalStructureLocalServiceUtil.getStructure((long)companyGroup.getGroupId(), (String)parentStructureId);
            }
            Document doc = SAXReaderUtil.read((String)this.getXsd());
            Element root = doc.getRootElement();
            Document parentDoc = SAXReaderUtil.read((String)parentStructure.getMergedXsd());
            Element parentRoot = parentDoc.getRootElement();
            this.addParentStructureId(parentRoot, parentStructureId);
            root.content().addAll(0, parentRoot.content());
            xsd = root.asXML();
        }
        catch (Exception exception) {}
        return xsd;
    }

    protected void addParentStructureId(Element parentEl, String parentStructureId) {
        for (Element dynamicEl : parentEl.elements(_DYNAMIC_ELEMENT)) {
            dynamicEl.addAttribute(_PARENT_STRUCTURE_ID, parentStructureId);
            this.addParentStructureId(dynamicEl, parentStructureId);
        }
    }
}

