/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.ImageUtil;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandlerImpl;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.journal.FeedTargetLayoutFriendlyUrlException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.lar.JournalCreationStrategy;
import com.liferay.portlet.journal.lar.JournalCreationStrategyFactory;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleImage;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFeedLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleImageUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleResourceUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleUtil;
import com.liferay.portlet.journal.service.persistence.JournalFeedUtil;
import com.liferay.portlet.journal.service.persistence.JournalStructureUtil;
import com.liferay.portlet.journal.service.persistence.JournalTemplateUtil;
import com.liferay.portlet.journal.util.comparator.ArticleIDComparator;
import com.liferay.portlet.journal.util.comparator.StructurePKComparator;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;

public class JournalPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "journal";
    private static Log _log = LogFactoryUtil.getLog(JournalPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("journal", "categories");
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("journal", "comments");
    private static PortletDataHandlerBoolean _embeddedAssets = new PortletDataHandlerBoolean("journal", "embedded-assets");
    private static PortletDataHandlerBoolean _images = new PortletDataHandlerBoolean("journal", "images");
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("journal", "ratings");
    private static PortletDataHandlerBoolean _structuresTemplatesAndFeeds = new PortletDataHandlerBoolean("journal", "structures-templates-and-feeds", true, true);
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("journal", "tags");
    private static PortletDataHandlerBoolean _articles = new PortletDataHandlerBoolean("journal", "articles", true, false, new PortletDataHandlerControl[]{_images, _comments, _ratings, _tags});
    private static Pattern _exportLinksToLayoutPattern = Pattern.compile("\\[([0-9]+)@(public|private\\-[a-z]*)\\]");
    private static Pattern _importLinksToLayoutPattern = Pattern.compile("\\[([0-9]+)@(public|private\\-[a-z]*)@(\\p{XDigit}{8}\\-(?:\\p{XDigit}{4}\\-){3}\\p{XDigit}{12})@([^\\]]*)\\]");

    public static void exportArticle(PortletDataContext portletDataContext, Element articlesElement, Element structuresElement, Element templatesElement, Element dlFileEntryTypesElement, Element dlFoldersElement, Element dlFileEntriesElement, Element dlFileRanksElement, JournalArticle article, boolean checkDateRange) throws Exception {
        if (checkDateRange && !portletDataContext.isWithinDateRange(article.getModifiedDate())) {
            return;
        }
        if (article.getStatus() != 0 && article.getStatus() != 3) {
            return;
        }
        String path = JournalPortletDataHandlerImpl.getArticlePath(portletDataContext, article);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        article = (JournalArticle)article.clone();
        Element articleElement = (Element)articlesElement.selectSingleNode("//article[@path='".concat(path).concat("']"));
        if (articleElement == null) {
            articleElement = articlesElement.addElement("article");
        }
        articleElement.addAttribute("article-resource-uuid", article.getArticleResourceUuid());
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)article.getCompanyId());
        if (Validator.isNotNull((String)article.getStructureId())) {
            JournalStructure structure = null;
            try {
                structure = JournalStructureLocalServiceUtil.getStructure((long)article.getGroupId(), (String)article.getStructureId());
            }
            catch (NoSuchStructureException noSuchStructureException) {
                structure = JournalStructureLocalServiceUtil.getStructure((long)companyGroup.getGroupId(), (String)article.getStructureId());
            }
            articleElement.addAttribute("structure-uuid", structure.getUuid());
            JournalPortletDataHandlerImpl.exportStructure(portletDataContext, structuresElement, structure);
        }
        if (Validator.isNotNull((String)article.getTemplateId())) {
            JournalTemplate template = null;
            try {
                template = JournalTemplateLocalServiceUtil.getTemplate((long)article.getGroupId(), (String)article.getTemplateId());
            }
            catch (NoSuchTemplateException noSuchTemplateException) {
                template = JournalTemplateLocalServiceUtil.getTemplate((long)companyGroup.getGroupId(), (String)article.getTemplateId());
            }
            articleElement.addAttribute("template-uuid", template.getUuid());
            JournalPortletDataHandlerImpl.exportTemplate(portletDataContext, templatesElement, dlFileEntryTypesElement, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, template);
        }
        Image smallImage = ImageUtil.fetchByPrimaryKey((long)article.getSmallImageId());
        if (article.isSmallImage() && smallImage != null) {
            String smallImagePath = JournalPortletDataHandlerImpl.getArticleSmallImagePath(portletDataContext, article);
            articleElement.addAttribute("small-image-path", smallImagePath);
            article.setSmallImageType(smallImage.getType());
            portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "images")) {
            String imagePath = JournalPortletDataHandlerImpl.getArticleImagePath(portletDataContext, article);
            articleElement.addAttribute("image-path", imagePath);
            List articleImages = JournalArticleImageUtil.findByG_A_V((long)article.getGroupId(), (String)article.getArticleId(), (double)article.getVersion());
            for (JournalArticleImage articleImage : articleImages) {
                Image image = null;
                try {
                    image = ImageUtil.findByPrimaryKey((long)articleImage.getArticleImageId());
                }
                catch (NoSuchImageException noSuchImageException) {
                    continue;
                }
                String articleImagePath = JournalPortletDataHandlerImpl.getArticleImagePath(portletDataContext, article, articleImage, image);
                if (!portletDataContext.isPathNotProcessed(articleImagePath)) continue;
                portletDataContext.addZipEntry(articleImagePath, image.getTextObj());
            }
        }
        article.setStatusByUserUuid(article.getStatusByUserUuid());
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "embedded-assets")) {
            String content = JournalPortletDataHandlerImpl.exportReferencedContent(portletDataContext, dlFileEntryTypesElement, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, articleElement, article.getContent());
            article.setContent(content);
        }
        portletDataContext.addClassedModel(articleElement, path, (ClassedModel)article, _NAMESPACE);
    }

    public static String exportReferencedContent(PortletDataContext portletDataContext, Element dlFileEntryTypesElement, Element dlFoldersElement, Element dlFileEntriesElement, Element dlFileRanksElement, Element entityElement, String content) throws Exception {
        content = JournalPortletDataHandlerImpl.exportDLFileEntries(portletDataContext, dlFileEntryTypesElement, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, entityElement, content, false);
        content = JournalPortletDataHandlerImpl.exportLayoutFriendlyURLs(portletDataContext, content);
        content = JournalPortletDataHandlerImpl.exportLinksToLayout(portletDataContext, content);
        String entityElementName = entityElement.getName();
        if (!entityElementName.equals("article")) {
            content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
        }
        return content;
    }

    public static String getArticlePath(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        StringBundler sb = new StringBundler(8);
        sb.append(portletDataContext.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleResourceUuid());
        sb.append("/");
        sb.append(article.getVersion());
        sb.append("/");
        sb.append("article.xml");
        return sb.toString();
    }

    public static void importArticle(PortletDataContext portletDataContext, Element articleElement) throws Exception {
        long companyGroupId;
        Group companyGroup;
        Map articleIds;
        String newArticleId;
        String path = articleElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        JournalArticle article = (JournalArticle)portletDataContext.getZipEntryAsObject(path);
        long userId = portletDataContext.getUserId(article.getUserUuid());
        JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
        long authorId = creationStrategy.getAuthorUserId(portletDataContext, article);
        if (authorId != 0L) {
            userId = authorId;
        }
        User user = UserLocalServiceUtil.getUser((long)userId);
        String articleId = article.getArticleId();
        boolean autoArticleId = false;
        if (Validator.isNumber((String)articleId) || JournalArticleUtil.fetchByG_A_V((long)portletDataContext.getScopeGroupId(), (String)articleId, (double)1.0) != null) {
            autoArticleId = true;
        }
        if (Validator.isNotNull((String)(newArticleId = (String)(articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId")).get(articleId)))) {
            articleId = newArticleId;
            autoArticleId = false;
        }
        String content = article.getContent();
        content = JournalPortletDataHandlerImpl.importDLFileEntries(portletDataContext, articleElement, content);
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        content = StringUtil.replace((String)content, (String)"@data_handler_group_friendly_url@", (String)group.getFriendlyURL());
        content = JournalPortletDataHandlerImpl.importLinksToLayout(portletDataContext, content);
        article.setContent(content);
        String newContent = creationStrategy.getTransformedContent(portletDataContext, article);
        if (newContent != JournalCreationStrategy.ARTICLE_CONTENT_UNCHANGED) {
            article.setContent(newContent);
        }
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(JournalStructure.class);
        String parentStructureId = MapUtil.getString((Map)structureIds, (String)article.getStructureId(), (String)article.getStructureId());
        Map templateIds = portletDataContext.getNewPrimaryKeysMap(JournalTemplate.class);
        String parentTemplateId = MapUtil.getString((Map)templateIds, (String)article.getTemplateId(), (String)article.getTemplateId());
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        long structurePrimaryKey = 0L;
        if (Validator.isNotNull((String)article.getStructureId())) {
            String structureUuid = articleElement.attributeValue("structure-uuid");
            JournalStructure existingStructure = JournalStructureUtil.fetchByUUID_G((String)structureUuid, (long)portletDataContext.getScopeGroupId());
            if (existingStructure == null) {
                companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                companyGroupId = companyGroup.getGroupId();
                existingStructure = JournalStructureUtil.fetchByUUID_G((String)structureUuid, (long)companyGroupId);
            }
            if (existingStructure == null) {
                String newStructureId = (String)structureIds.get(article.getStructureId());
                if (Validator.isNotNull((String)newStructureId)) {
                    existingStructure = JournalStructureUtil.fetchByG_S((long)portletDataContext.getScopeGroupId(), (String)String.valueOf(newStructureId));
                }
                if (existingStructure == null) {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler();
                        sb.append("Structure ");
                        sb.append(article.getStructureId());
                        sb.append(" is missing for article ");
                        sb.append(article.getArticleId());
                        sb.append(", skipping this article.");
                        _log.warn((Object)sb.toString());
                    }
                    return;
                }
            }
            structurePrimaryKey = existingStructure.getPrimaryKey();
            parentStructureId = existingStructure.getStructureId();
        }
        if (Validator.isNotNull((String)article.getTemplateId())) {
            String templateUuid = articleElement.attributeValue("template-uuid");
            JournalTemplate existingTemplate = JournalTemplateUtil.fetchByUUID_G((String)templateUuid, (long)portletDataContext.getScopeGroupId());
            if (existingTemplate == null) {
                companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                companyGroupId = companyGroup.getGroupId();
                existingTemplate = JournalTemplateUtil.fetchByUUID_G((String)templateUuid, (long)companyGroupId);
            }
            if (existingTemplate == null) {
                String newTemplateId = (String)templateIds.get(article.getTemplateId());
                if (Validator.isNotNull((String)newTemplateId)) {
                    existingTemplate = JournalTemplateUtil.fetchByG_T((long)portletDataContext.getScopeGroupId(), (String)newTemplateId);
                }
                if (existingTemplate == null) {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler();
                        sb.append("Template ");
                        sb.append(article.getTemplateId());
                        sb.append(" is missing for article ");
                        sb.append(article.getArticleId());
                        sb.append(", skipping this article.");
                        _log.warn((Object)sb.toString());
                    }
                    return;
                }
            }
            parentTemplateId = existingTemplate.getTemplateId();
        }
        File smallFile = null;
        String smallImagePath = articleElement.attributeValue("small-image-path");
        if (article.isSmallImage() && Validator.isNotNull((String)smallImagePath)) {
            byte[] bytes = portletDataContext.getZipEntryAsByteArray(smallImagePath);
            smallFile = File.createTempFile(String.valueOf(article.getSmallImageId()), "." + article.getSmallImageType());
            FileUtil.write((File)smallFile, (byte[])bytes);
        }
        HashMap<String, byte[]> images = new HashMap<String, byte[]>();
        String imagePath = articleElement.attributeValue("image-path");
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "images") && Validator.isNotNull((String)imagePath)) {
            List imageFiles = portletDataContext.getZipFolderEntries(imagePath);
            for (String imageFile : imageFiles) {
                String fileName = imageFile;
                if (fileName.contains("/")) {
                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                }
                if (fileName.endsWith(".xml")) continue;
                int pos = fileName.lastIndexOf(46);
                if (pos != -1) {
                    fileName = fileName.substring(0, pos);
                }
                images.put(fileName, portletDataContext.getZipEntryAsByteArray(imageFile));
            }
        }
        String articleURL = null;
        boolean addGroupPermissions = creationStrategy.addGroupPermissions(portletDataContext, article);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(portletDataContext, article);
        ServiceContext serviceContext = portletDataContext.createServiceContext(articleElement, (ClassedModel)article, _NAMESPACE);
        serviceContext.setAddGroupPermissions(addGroupPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        serviceContext.setAttribute("imported", (Serializable)((Object)Boolean.TRUE.toString()));
        if (article.getStatus() != 0) {
            serviceContext.setWorkflowAction(2);
        }
        JournalArticle importedArticle = null;
        String articleResourceUuid = articleElement.attributeValue("article-resource-uuid");
        if (portletDataContext.isDataStrategyMirror()) {
            JournalArticleResource articleResource = JournalArticleResourceUtil.fetchByUUID_G((String)articleResourceUuid, (long)portletDataContext.getScopeGroupId());
            if (articleResource == null) {
                Group companyGroup2 = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                long companyGroupId2 = companyGroup2.getGroupId();
                articleResource = JournalArticleResourceUtil.fetchByUUID_G((String)articleResourceUuid, (long)companyGroupId2);
            }
            serviceContext.setUuid(articleResourceUuid);
            JournalArticle existingArticle = null;
            if (articleResource != null) {
                try {
                    existingArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)articleResource.getResourcePrimKey(), (int)-1, (boolean)false);
                }
                catch (NoSuchArticleException noSuchArticleException) {}
            }
            if (existingArticle == null) {
                existingArticle = JournalArticleUtil.fetchByG_A_V((long)portletDataContext.getScopeGroupId(), (String)newArticleId, (double)article.getVersion());
            }
            importedArticle = existingArticle == null ? JournalArticleLocalServiceUtil.addArticle((long)userId, (long)portletDataContext.getScopeGroupId(), (long)article.getClassNameId(), (long)structurePrimaryKey, (String)articleId, (boolean)autoArticleId, (double)article.getVersion(), (Map)article.getTitleMap(), (Map)article.getDescriptionMap(), (String)article.getContent(), (String)article.getType(), (String)parentStructureId, (String)parentTemplateId, (String)article.getLayoutUuid(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext) : JournalArticleLocalServiceUtil.updateArticle((long)userId, (long)existingArticle.getGroupId(), (String)existingArticle.getArticleId(), (double)existingArticle.getVersion(), (Map)article.getTitleMap(), (Map)article.getDescriptionMap(), (String)article.getContent(), (String)article.getType(), (String)parentStructureId, (String)parentTemplateId, (String)existingArticle.getLayoutUuid(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext);
        } else {
            importedArticle = JournalArticleLocalServiceUtil.addArticle((long)userId, (long)portletDataContext.getScopeGroupId(), (long)article.getClassNameId(), (long)structurePrimaryKey, (String)articleId, (boolean)autoArticleId, (double)article.getVersion(), (Map)article.getTitleMap(), (Map)article.getDescriptionMap(), (String)article.getContent(), (String)article.getType(), (String)parentStructureId, (String)parentTemplateId, (String)article.getLayoutUuid(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext);
        }
        if (smallFile != null) {
            smallFile.delete();
        }
        portletDataContext.importClassedModel((ClassedModel)article, (ClassedModel)importedArticle, _NAMESPACE);
        if (Validator.isNull((String)newArticleId)) {
            articleIds.put(article.getArticleId(), importedArticle.getArticleId());
        }
        articleElement.addAttribute("imported-article-group-id", String.valueOf(importedArticle.getGroupId()));
        if (!articleId.equals(importedArticle.getArticleId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("An article with the ID " + articleId + " already " + "exists. The new generated ID is " + importedArticle.getArticleId()));
        }
    }

    public static void importFeed(PortletDataContext portletDataContext, Element feedElement) throws Exception {
        block11: {
            String path = feedElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) {
                return;
            }
            JournalFeed feed = (JournalFeed)portletDataContext.getZipEntryAsObject(path);
            long userId = portletDataContext.getUserId(feed.getUserUuid());
            JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
            long authorId = creationStrategy.getAuthorUserId(portletDataContext, feed);
            if (authorId != 0L) {
                userId = authorId;
            }
            Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
            String newGroupFriendlyURL = group.getFriendlyURL().substring(1);
            String[] friendlyUrlParts = StringUtil.split((String)feed.getTargetLayoutFriendlyUrl(), (char)'/');
            String oldGroupFriendlyURL = friendlyUrlParts[2];
            if (oldGroupFriendlyURL.equals("@data_handler_group_friendly_url@")) {
                feed.setTargetLayoutFriendlyUrl(StringUtil.replace((String)feed.getTargetLayoutFriendlyUrl(), (String)"@data_handler_group_friendly_url@", (String)newGroupFriendlyURL));
            }
            String feedId = feed.getFeedId();
            boolean autoFeedId = false;
            if (Validator.isNumber((String)feedId) || JournalFeedUtil.fetchByG_F((long)portletDataContext.getScopeGroupId(), (String)feedId) != null) {
                autoFeedId = true;
            }
            Map structureIds = portletDataContext.getNewPrimaryKeysMap(JournalStructure.class + ".structureId");
            String parentStructureId = MapUtil.getString((Map)structureIds, (String)feed.getStructureId(), (String)feed.getStructureId());
            Map templateIds = portletDataContext.getNewPrimaryKeysMap(JournalTemplate.class + ".templateId");
            String parentTemplateId = MapUtil.getString((Map)templateIds, (String)feed.getTemplateId(), (String)feed.getTemplateId());
            String parentRenderTemplateId = MapUtil.getString((Map)templateIds, (String)feed.getRendererTemplateId(), (String)feed.getRendererTemplateId());
            boolean addGroupPermissions = creationStrategy.addGroupPermissions(portletDataContext, feed);
            boolean addGuestPermissions = creationStrategy.addGuestPermissions(portletDataContext, feed);
            ServiceContext serviceContext = portletDataContext.createServiceContext(feedElement, (ClassedModel)feed, _NAMESPACE);
            serviceContext.setAddGroupPermissions(addGroupPermissions);
            serviceContext.setAddGuestPermissions(addGuestPermissions);
            JournalFeed importedFeed = null;
            try {
                if (portletDataContext.isDataStrategyMirror()) {
                    JournalFeed existingFeed = JournalFeedUtil.fetchByUUID_G((String)feed.getUuid(), (long)portletDataContext.getScopeGroupId());
                    if (existingFeed == null) {
                        serviceContext.setUuid(feed.getUuid());
                        importedFeed = JournalFeedLocalServiceUtil.addFeed((long)userId, (long)portletDataContext.getScopeGroupId(), (String)feedId, (boolean)autoFeedId, (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentStructureId, (String)parentTemplateId, (String)parentRenderTemplateId, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedType(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
                    } else {
                        importedFeed = JournalFeedLocalServiceUtil.updateFeed((long)existingFeed.getGroupId(), (String)existingFeed.getFeedId(), (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentStructureId, (String)parentTemplateId, (String)parentRenderTemplateId, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedType(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
                    }
                } else {
                    importedFeed = JournalFeedLocalServiceUtil.addFeed((long)userId, (long)portletDataContext.getScopeGroupId(), (String)feedId, (boolean)autoFeedId, (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentStructureId, (String)parentTemplateId, (String)parentRenderTemplateId, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedType(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
                }
                portletDataContext.importClassedModel((ClassedModel)feed, (ClassedModel)importedFeed, _NAMESPACE);
                if (!feedId.equals(importedFeed.getFeedId()) && _log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(5);
                    sb.append("A feed with the ID ");
                    sb.append(feedId);
                    sb.append(" already exists. The new generated ID is ");
                    sb.append(importedFeed.getFeedId());
                    sb.append(".");
                    _log.warn((Object)sb.toString());
                }
            }
            catch (FeedTargetLayoutFriendlyUrlException feedTargetLayoutFriendlyUrlException) {
                if (!_log.isWarnEnabled()) break block11;
                StringBundler sb = new StringBundler(6);
                sb.append("A feed with the ID ");
                sb.append(feedId);
                sb.append(" cannot be imported because layout with friendly ");
                sb.append("URL ");
                sb.append(feed.getTargetLayoutFriendlyUrl());
                sb.append(" does not exist");
                _log.warn((Object)sb.toString());
            }
        }
    }

    public static String importReferencedContent(PortletDataContext portletDataContext, Element parentElement, String content) throws Exception {
        content = JournalPortletDataHandlerImpl.importDLFileEntries(portletDataContext, parentElement, content);
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        content = StringUtil.replace((String)content, (String)"@data_handler_group_friendly_url@", (String)group.getFriendlyURL());
        content = JournalPortletDataHandlerImpl.importLinksToLayout(portletDataContext, content);
        return content;
    }

    public static void importReferencedData(PortletDataContext portletDataContext, Element entityElement) throws Exception {
        Element dlFoldersElement = entityElement.element("dl-folders");
        List dlFolderElements = Collections.emptyList();
        if (dlFoldersElement != null) {
            dlFolderElements = dlFoldersElement.elements("folder");
        }
        for (Element folderElement : dlFolderElements) {
            DLPortletDataHandlerImpl.importFolder(portletDataContext, folderElement);
        }
        Element dlFileEntriesElement = entityElement.element("dl-file-entries");
        List dlFileEntryElements = Collections.emptyList();
        if (dlFileEntriesElement != null) {
            dlFileEntryElements = dlFileEntriesElement.elements("file-entry");
        }
        for (Element fileEntryElement : dlFileEntryElements) {
            DLPortletDataHandlerImpl.importFileEntry(portletDataContext, fileEntryElement);
        }
        Element dlFileRanksElement = entityElement.element("dl-file-ranks");
        List dlFileRankElements = Collections.emptyList();
        if (dlFileRanksElement != null) {
            dlFileRankElements = dlFileRanksElement.elements("file-rank");
        }
        for (Element fileRankElement : dlFileRankElements) {
            DLPortletDataHandlerImpl.importFileRank(portletDataContext, fileRankElement);
        }
    }

    public static void importStructure(PortletDataContext portletDataContext, Element structureElement) throws Exception {
        String path = structureElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        JournalStructure structure = (JournalStructure)portletDataContext.getZipEntryAsObject(path);
        long userId = portletDataContext.getUserId(structure.getUserUuid());
        JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
        long authorId = creationStrategy.getAuthorUserId(portletDataContext, structure);
        if (authorId != 0L) {
            userId = authorId;
        }
        String structureId = structure.getStructureId();
        boolean autoStructureId = false;
        if (Validator.isNumber((String)structureId) || JournalStructureUtil.fetchByG_S((long)portletDataContext.getScopeGroupId(), (String)structureId) != null) {
            autoStructureId = true;
        }
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(JournalStructure.class + ".structureId");
        String parentStructureId = MapUtil.getString((Map)structureIds, (String)structure.getParentStructureId(), (String)structure.getParentStructureId());
        Document document = structureElement.getDocument();
        Element rootElement = document.getRootElement();
        Element parentStructureElement = (Element)rootElement.selectSingleNode("./structures/structure[@structure-id='" + parentStructureId + "']");
        String parentStructureUuid = GetterUtil.getString((String)structureElement.attributeValue("parent-structure-uuid"));
        if (parentStructureElement != null && Validator.isNotNull((String)parentStructureId)) {
            JournalPortletDataHandlerImpl.importStructure(portletDataContext, parentStructureElement);
            parentStructureId = (String)structureIds.get(parentStructureId);
        } else if (Validator.isNotNull((String)parentStructureUuid)) {
            JournalStructure parentStructure = JournalStructureLocalServiceUtil.getJournalStructureByUuidAndGroupId((String)parentStructureUuid, (long)portletDataContext.getGroupId());
            parentStructureId = parentStructure.getStructureId();
        }
        boolean addGroupPermissions = creationStrategy.addGroupPermissions(portletDataContext, structure);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(portletDataContext, structure);
        ServiceContext serviceContext = portletDataContext.createServiceContext(structureElement, (ClassedModel)structure, _NAMESPACE);
        serviceContext.setAddGroupPermissions(addGroupPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        JournalStructure importedStructure = null;
        if (portletDataContext.isDataStrategyMirror()) {
            JournalStructure existingStructure = JournalStructureUtil.fetchByUUID_G((String)structure.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingStructure == null) {
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                long companyGroupId = companyGroup.getGroupId();
                existingStructure = JournalStructureUtil.fetchByUUID_G((String)structure.getUuid(), (long)companyGroupId);
            }
            if (existingStructure == null) {
                serviceContext.setUuid(structure.getUuid());
                importedStructure = JournalStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (String)structureId, (boolean)autoStructureId, (String)parentStructureId, (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (ServiceContext)serviceContext);
            } else {
                importedStructure = JournalStructureLocalServiceUtil.updateStructure((long)existingStructure.getGroupId(), (String)existingStructure.getStructureId(), (String)parentStructureId, (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (ServiceContext)serviceContext);
            }
        } else {
            importedStructure = JournalStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (String)structureId, (boolean)autoStructureId, (String)parentStructureId, (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)structure, (ClassedModel)importedStructure, _NAMESPACE);
        structureIds.put(structureId, importedStructure.getStructureId());
        if (!structureId.equals(importedStructure.getStructureId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("A structure with the ID " + structureId + " already " + "exists. The new generated ID is " + importedStructure.getStructureId()));
        }
    }

    public static void importTemplate(PortletDataContext portletDataContext, Element templateElement) throws Exception {
        String path = templateElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        JournalTemplate template = (JournalTemplate)portletDataContext.getZipEntryAsObject(path);
        long userId = portletDataContext.getUserId(template.getUserUuid());
        JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
        long authorId = creationStrategy.getAuthorUserId(portletDataContext, template);
        if (authorId != 0L) {
            userId = authorId;
        }
        String templateId = template.getTemplateId();
        boolean autoTemplateId = false;
        if (Validator.isNumber((String)templateId) || JournalTemplateUtil.fetchByG_T((long)portletDataContext.getScopeGroupId(), (String)templateId) != null) {
            autoTemplateId = true;
        }
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(JournalStructure.class + ".structureId");
        String parentStructureId = MapUtil.getString((Map)structureIds, (String)template.getStructureId(), (String)template.getStructureId());
        String xsl = template.getXsl();
        xsl = JournalPortletDataHandlerImpl.importDLFileEntries(portletDataContext, templateElement, xsl);
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        xsl = StringUtil.replace((String)xsl, (String)"@data_handler_group_friendly_url@", (String)group.getFriendlyURL());
        template.setXsl(xsl);
        boolean formatXsl = false;
        boolean addGroupPermissions = creationStrategy.addGroupPermissions(portletDataContext, template);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(portletDataContext, template);
        ServiceContext serviceContext = portletDataContext.createServiceContext(templateElement, (ClassedModel)template, _NAMESPACE);
        serviceContext.setAddGroupPermissions(addGroupPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        File smallFile = null;
        String smallImagePath = templateElement.attributeValue("small-image-path");
        if (template.isSmallImage() && Validator.isNotNull((String)smallImagePath)) {
            byte[] bytes;
            if (smallImagePath.endsWith(".")) {
                smallImagePath = String.valueOf(smallImagePath) + template.getSmallImageType();
            }
            if ((bytes = portletDataContext.getZipEntryAsByteArray(smallImagePath)) != null) {
                smallFile = File.createTempFile(String.valueOf(template.getSmallImageId()), "." + template.getSmallImageType());
                FileUtil.write((File)smallFile, (byte[])bytes);
            }
        }
        JournalTemplate importedTemplate = null;
        if (portletDataContext.isDataStrategyMirror()) {
            JournalTemplate existingTemplate = JournalTemplateUtil.fetchByUUID_G((String)template.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingTemplate == null) {
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                long companyGroupId = companyGroup.getGroupId();
                existingTemplate = JournalTemplateUtil.fetchByUUID_G((String)template.getUuid(), (long)companyGroupId);
            }
            if (existingTemplate == null) {
                serviceContext.setUuid(template.getUuid());
                importedTemplate = JournalTemplateLocalServiceUtil.addTemplate((long)userId, (long)portletDataContext.getScopeGroupId(), (String)templateId, (boolean)autoTemplateId, (String)parentStructureId, (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getXsl(), (boolean)formatXsl, (String)template.getLangType(), (boolean)template.getCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
            } else {
                importedTemplate = JournalTemplateLocalServiceUtil.updateTemplate((long)existingTemplate.getGroupId(), (String)existingTemplate.getTemplateId(), (String)existingTemplate.getStructureId(), (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getXsl(), (boolean)formatXsl, (String)template.getLangType(), (boolean)template.getCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
            }
        } else {
            importedTemplate = JournalTemplateLocalServiceUtil.addTemplate((long)userId, (long)portletDataContext.getScopeGroupId(), (String)templateId, (boolean)autoTemplateId, (String)parentStructureId, (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getXsl(), (boolean)formatXsl, (String)template.getLangType(), (boolean)template.getCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
        }
        if (smallFile != null) {
            smallFile.delete();
        }
        portletDataContext.importClassedModel((ClassedModel)template, (ClassedModel)importedTemplate, _NAMESPACE);
        Map templateIds = portletDataContext.getNewPrimaryKeysMap(JournalTemplate.class + ".templateId");
        templateIds.put(template.getTemplateId(), importedTemplate.getTemplateId());
        if (!templateId.equals(importedTemplate.getTemplateId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("A template with the ID " + templateId + " already " + "exists. The new generated ID is " + importedTemplate.getTemplateId()));
        }
    }

    protected static String exportDLFileEntries(PortletDataContext portletDataContext, Element dlFileEntryTypesElement, Element dlFoldersElement, Element dlFileEntriesElement, Element dlFileRanksElement, Element entityElement, String content, boolean checkDateRange) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("20")) {
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        int beginPos = content.length();
        int currentLocation = -1;
        while (true) {
            block26: {
                if ((currentLocation = content.lastIndexOf("/c/document_library/get_file?", beginPos)) == -1) {
                    currentLocation = content.lastIndexOf("/documents/", beginPos);
                }
                if (currentLocation == -1) {
                    return sb.toString();
                }
                beginPos = currentLocation;
                int endPos1 = content.indexOf(39, beginPos);
                int endPos2 = content.indexOf(93, beginPos);
                int endPos3 = content.indexOf(125, beginPos);
                int endPos4 = content.indexOf(41, beginPos);
                int endPos5 = content.indexOf(60, beginPos);
                int endPos6 = content.indexOf(34, beginPos);
                int endPos7 = content.indexOf(32, beginPos);
                int endPos = endPos1;
                if (endPos == -1 || endPos2 != -1 && endPos2 < endPos) {
                    endPos = endPos2;
                }
                if (endPos == -1 || endPos3 != -1 && endPos3 < endPos) {
                    endPos = endPos3;
                }
                if (endPos == -1 || endPos4 != -1 && endPos4 < endPos) {
                    endPos = endPos4;
                }
                if (endPos == -1 || endPos5 != -1 && endPos5 < endPos) {
                    endPos = endPos5;
                }
                if (endPos == -1 || endPos6 != -1 && endPos6 < endPos) {
                    endPos = endPos6;
                }
                if (endPos == -1 || endPos7 != -1 && endPos7 < endPos) {
                    endPos = endPos7;
                }
                if (beginPos == -1 || endPos == -1) break;
                try {
                    String oldParameters = content.substring(beginPos, endPos);
                    while (oldParameters.contains("&amp;")) {
                        oldParameters = oldParameters.replace("&amp;", "&");
                    }
                    Map<String, String[]> map = new HashMap<String, String[]>();
                    if (oldParameters.startsWith("/documents/")) {
                        String[] pathArray = oldParameters.split("/");
                        map.put("groupId", new String[]{pathArray[2]});
                        if (pathArray.length == 4) {
                            map.put("uuid", new String[]{pathArray[3]});
                        } else if (pathArray.length > 4) {
                            map.put("folderId", new String[]{pathArray[3]});
                            String name = HttpUtil.decodeURL((String)pathArray[4]);
                            int pos = name.indexOf("?");
                            if (pos != -1) {
                                name = name.substring(0, pos);
                            }
                            map.put("name", new String[]{name});
                        }
                    } else {
                        oldParameters = oldParameters.substring(oldParameters.indexOf(63) + 1);
                        map = HttpUtil.parameterMapFromString((String)oldParameters);
                    }
                    FileEntry fileEntry = null;
                    String uuid = MapUtil.getString(map, (String)"uuid");
                    if (Validator.isNotNull((String)uuid)) {
                        String groupIdString = MapUtil.getString(map, (String)"groupId");
                        long groupId = GetterUtil.getLong((String)groupIdString);
                        if (groupIdString.equals("@group_id@")) {
                            groupId = portletDataContext.getScopeGroupId();
                        }
                        fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                    } else {
                        String folderIdString = MapUtil.getString(map, (String)"folderId");
                        if (Validator.isNotNull((String)folderIdString)) {
                            long folderId = GetterUtil.getLong((String)folderIdString);
                            String name = MapUtil.getString(map, (String)"name");
                            String groupIdString = MapUtil.getString(map, (String)"groupId");
                            long groupId = GetterUtil.getLong((String)groupIdString);
                            if (groupIdString.equals("@group_id@")) {
                                groupId = portletDataContext.getScopeGroupId();
                            }
                            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)name);
                        }
                    }
                    if (fileEntry == null) {
                        --beginPos;
                        continue;
                    }
                    String path = DLPortletDataHandlerImpl.getFileEntryPath(portletDataContext, fileEntry);
                    Element dlReferenceElement = entityElement.addElement("dl-reference");
                    dlReferenceElement.addAttribute("path", path);
                    DLPortletDataHandlerImpl.exportFileEntry(portletDataContext, dlFileEntryTypesElement, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, fileEntry, checkDateRange);
                    String dlReference = "[$dl-reference=" + path + "$]";
                    sb.replace(beginPos, endPos, dlReference);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block26;
                    _log.warn((Throwable)e);
                }
            }
            --beginPos;
        }
        return sb.toString();
    }

    protected static void exportFeed(PortletDataContext portletDataContext, Element feedsElement, JournalFeed feed) throws Exception {
        String[] friendlyUrlParts;
        String oldGroupFriendlyURL;
        if (!portletDataContext.isWithinDateRange(feed.getModifiedDate())) {
            return;
        }
        String path = JournalPortletDataHandlerImpl.getFeedPath(portletDataContext, feed);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        feed = (JournalFeed)feed.clone();
        Element feedElement = feedsElement.addElement("feed");
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        String newGroupFriendlyURL = group.getFriendlyURL().substring(1);
        if (newGroupFriendlyURL.equals(oldGroupFriendlyURL = (friendlyUrlParts = StringUtil.split((String)feed.getTargetLayoutFriendlyUrl(), (char)'/'))[2])) {
            String targetLayoutFriendlyUrl = StringUtil.replaceFirst((String)feed.getTargetLayoutFriendlyUrl(), (String)("/" + newGroupFriendlyURL + "/"), (String)"/@data_handler_group_friendly_url@/");
            feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        }
        portletDataContext.addClassedModel(feedElement, path, (ClassedModel)feed, _NAMESPACE);
    }

    protected static String exportLayoutFriendlyURLs(PortletDataContext portletDataContext, String content) {
        Group group = null;
        try {
            group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)e);
            }
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        String friendlyURLPrivateGroupPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        String friendlyURLPrivateUserPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        String friendlyURLPublicPath = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        String href = "href=";
        int beginPos = content.length();
        while (true) {
            int hrefLength = href.length();
            if ((beginPos = content.lastIndexOf(href, beginPos)) == -1) break;
            char c = content.charAt(beginPos + hrefLength);
            if (c == '\'' || c == '\"') {
                ++hrefLength;
            }
            int endPos1 = content.indexOf(39, beginPos + hrefLength);
            int endPos2 = content.indexOf(93, beginPos + hrefLength);
            int endPos3 = content.indexOf(41, beginPos + hrefLength);
            int endPos4 = content.indexOf(60, beginPos + hrefLength);
            int endPos5 = content.indexOf(34, beginPos + hrefLength);
            int endPos6 = content.indexOf(32, beginPos + hrefLength);
            int endPos = endPos1;
            if (endPos == -1 || endPos2 != -1 && endPos2 < endPos) {
                endPos = endPos2;
            }
            if (endPos == -1 || endPos3 != -1 && endPos3 < endPos) {
                endPos = endPos3;
            }
            if (endPos == -1 || endPos4 != -1 && endPos4 < endPos) {
                endPos = endPos4;
            }
            if (endPos == -1 || endPos5 != -1 && endPos5 < endPos) {
                endPos = endPos5;
            }
            if (endPos == -1 || endPos6 != -1 && endPos6 < endPos) {
                endPos = endPos6;
            }
            if (endPos == -1) {
                --beginPos;
                continue;
            }
            String url = content.substring(beginPos + hrefLength, endPos);
            if (!(url.startsWith(friendlyURLPrivateGroupPath) || url.startsWith(friendlyURLPrivateUserPath) || url.startsWith(friendlyURLPublicPath))) {
                --beginPos;
                continue;
            }
            int beginGroupPos = content.indexOf(47, beginPos + hrefLength + 1);
            if (beginGroupPos == -1) {
                --beginPos;
                continue;
            }
            int endGroupPos = content.indexOf(47, beginGroupPos + 1);
            if (endGroupPos == -1) {
                --beginPos;
                continue;
            }
            String groupFriendlyURL = content.substring(beginGroupPos, endGroupPos);
            if (groupFriendlyURL.equals(group.getFriendlyURL())) {
                sb.replace(beginGroupPos, endGroupPos, "@data_handler_group_friendly_url@");
            }
            --beginPos;
        }
        return sb.toString();
    }

    protected static String exportLinksToLayout(PortletDataContext portletDataContext, String content) throws Exception {
        ArrayList<String> oldLinksToLayout = new ArrayList<String>();
        ArrayList<String> newLinksToLayout = new ArrayList<String>();
        Matcher matcher = _exportLinksToLayoutPattern.matcher(content);
        while (matcher.find()) {
            long layoutId = GetterUtil.getLong((String)matcher.group(1));
            String type = matcher.group(2);
            boolean privateLayout = type.startsWith("private");
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getScopeGroupId(), (boolean)privateLayout, (long)layoutId);
                String oldLinkToLayout = matcher.group(0);
                StringBundler sb = new StringBundler(5);
                sb.append(type);
                sb.append("@");
                sb.append(layout.getUuid());
                sb.append("@");
                sb.append(layout.getFriendlyURL());
                String newLinkToLayout = StringUtil.replace((String)oldLinkToLayout, (String)type, (String)sb.toString());
                oldLinksToLayout.add(oldLinkToLayout);
                newLinksToLayout.add(newLinkToLayout);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to get layout with id " + layoutId + " in group " + portletDataContext.getScopeGroupId()), (Throwable)e);
            }
        }
        content = StringUtil.replace((String)content, (String[])ArrayUtil.toStringArray((Object[])oldLinksToLayout.toArray()), (String[])ArrayUtil.toStringArray((Object[])newLinksToLayout.toArray()));
        return content;
    }

    protected static void exportStructure(PortletDataContext portletDataContext, Element structuresElement, JournalStructure structure) throws Exception {
        String path = JournalPortletDataHandlerImpl.getStructurePath(portletDataContext, structure);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element structureElement = structuresElement.addElement("structure");
        String parentStructureId = structure.getParentStructureId();
        if (Validator.isNotNull((String)parentStructureId)) {
            try {
                JournalStructure parentStructure = JournalStructureLocalServiceUtil.getStructure((long)structure.getGroupId(), (String)parentStructureId);
                structureElement.addAttribute("parent-structure-uuid", parentStructure.getUuid());
                JournalPortletDataHandlerImpl.exportStructure(portletDataContext, structuresElement, parentStructure);
            }
            catch (NoSuchStructureException noSuchStructureException) {}
        }
        portletDataContext.addClassedModel(structureElement, path, (ClassedModel)structure, _NAMESPACE);
    }

    protected static void exportTemplate(PortletDataContext portletDataContext, Element templatesElement, Element dlFileEntryTypesElement, Element dlFoldersElement, Element dlFileEntriesElement, Element dlFileRanksElement, JournalTemplate template) throws Exception {
        String path = JournalPortletDataHandlerImpl.getTemplatePath(portletDataContext, template);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        template = (JournalTemplate)template.clone();
        Element templateElement = templatesElement.addElement("template");
        if (template.isSmallImage()) {
            String smallImagePath = JournalPortletDataHandlerImpl.getTemplateSmallImagePath(portletDataContext, template);
            templateElement.addAttribute("small-image-path", smallImagePath);
            Image smallImage = ImageUtil.fetchByPrimaryKey((long)template.getSmallImageId());
            template.setSmallImageType(smallImage.getType());
            portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "embedded-assets")) {
            String content = JournalPortletDataHandlerImpl.exportReferencedContent(portletDataContext, dlFileEntryTypesElement, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, templateElement, template.getXsl());
            template.setXsl(content);
        }
        portletDataContext.addClassedModel(templateElement, path, (ClassedModel)template, _NAMESPACE);
    }

    protected static String getArticleImagePath(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleResourceUuid());
        sb.append("/");
        sb.append(article.getVersion());
        sb.append("/");
        return sb.toString();
    }

    protected static String getArticleImagePath(PortletDataContext portletDataContext, JournalArticle article, JournalArticleImage articleImage, Image image) throws Exception {
        StringBundler sb = new StringBundler(13);
        sb.append(portletDataContext.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleResourceUuid());
        sb.append("/");
        sb.append(article.getVersion());
        sb.append("/");
        sb.append(articleImage.getElInstanceId());
        sb.append("_");
        sb.append(articleImage.getElName());
        if (Validator.isNotNull((String)articleImage.getLanguageId())) {
            sb.append("_");
            sb.append(articleImage.getLanguageId());
        }
        sb.append(".");
        sb.append(image.getType());
        return sb.toString();
    }

    protected static String getArticleSmallImagePath(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleResourceUuid());
        sb.append("/thumbnail");
        sb.append(".");
        sb.append(article.getSmallImageType());
        return sb.toString();
    }

    protected static String getFeedPath(PortletDataContext portletDataContext, JournalFeed feed) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("15"));
        sb.append("/feeds/");
        sb.append(feed.getUuid());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getStructurePath(PortletDataContext portletDataContext, JournalStructure structure) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("15"));
        sb.append("/structures/");
        sb.append(structure.getUuid());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getTemplatePath(PortletDataContext portletDataContext, JournalTemplate template) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("15"));
        sb.append("/templates/");
        sb.append(template.getUuid());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getTemplateSmallImagePath(PortletDataContext portletDataContext, JournalTemplate template) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append(portletDataContext.getPortletPath("15"));
        sb.append("/templates/thumbnail-");
        sb.append(template.getUuid());
        sb.append(".");
        sb.append(template.getSmallImageType());
        return sb.toString();
    }

    protected static String importDLFileEntries(PortletDataContext portletDataContext, Element parentElement, String content) throws Exception {
        List dlReferenceElements = parentElement.elements("dl-reference");
        for (Element dlReferenceElement : dlReferenceElements) {
            FileEntry fileEntry;
            String dlReferencePath;
            block3: {
                dlReferencePath = dlReferenceElement.attributeValue("path");
                fileEntry = null;
                try {
                    fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(dlReferencePath);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)e);
                }
            }
            if (fileEntry == null || (fileEntry = FileEntryUtil.fetchByUUID_R(fileEntry.getUuid(), portletDataContext.getGroupId())) == null) continue;
            String dlReference = "[$dl-reference=" + dlReferencePath + "$]";
            StringBundler sb = new StringBundler(6);
            sb.append("/documents/");
            sb.append(portletDataContext.getScopeGroupId());
            sb.append("/");
            sb.append(fileEntry.getFolderId());
            sb.append("/");
            sb.append(HttpUtil.encodeURL((String)HtmlUtil.unescape((String)fileEntry.getTitle()), (boolean)true));
            content = StringUtil.replace((String)content, (String)dlReference, (String)sb.toString());
        }
        return content;
    }

    protected static String importLinksToLayout(PortletDataContext portletDataContext, String content) throws Exception {
        ArrayList<String> oldLinksToLayout = new ArrayList<String>();
        ArrayList<String> newLinksToLayout = new ArrayList<String>();
        Matcher matcher = _importLinksToLayoutPattern.matcher(content);
        while (matcher.find()) {
            StringBundler sb;
            String friendlyURL;
            String layoutUuid;
            long newLayoutId;
            long oldLayoutId;
            block8: {
                newLayoutId = oldLayoutId = GetterUtil.getLong((String)matcher.group(1));
                String type = matcher.group(2);
                boolean privateLayout = type.startsWith("private");
                layoutUuid = matcher.group(3);
                friendlyURL = matcher.group(4);
                try {
                    Layout layout = LayoutUtil.fetchByUUID_G((String)layoutUuid, (long)portletDataContext.getScopeGroupId());
                    if (layout == null) {
                        layout = LayoutUtil.fetchByG_P_F((long)portletDataContext.getScopeGroupId(), (boolean)privateLayout, (String)friendlyURL);
                    }
                    if (layout == null) {
                        layout = LayoutUtil.fetchByG_P_L((long)portletDataContext.getScopeGroupId(), (boolean)privateLayout, (long)oldLayoutId);
                    }
                    if (layout == null) {
                        if (_log.isWarnEnabled()) {
                            sb = new StringBundler(9);
                            sb.append("Unable to get layout with UUID ");
                            sb.append(layoutUuid);
                            sb.append(", friendly URL ");
                            sb.append(friendlyURL);
                            sb.append(", or ");
                            sb.append("layoutId ");
                            sb.append(oldLayoutId);
                            sb.append(" in group ");
                            sb.append(portletDataContext.getScopeGroupId());
                            _log.warn((Object)sb.toString());
                        }
                    } else {
                        newLayoutId = layout.getLayoutId();
                    }
                }
                catch (SystemException e) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)("Unable to get layout in group " + portletDataContext.getScopeGroupId()), (Throwable)e);
                }
            }
            String oldLinkToLayout = matcher.group(0);
            sb = new StringBundler(4);
            sb.append("@");
            sb.append(layoutUuid);
            sb.append("@");
            sb.append(friendlyURL);
            String newLinkToLayout = StringUtil.replace((String)oldLinkToLayout, (String[])new String[]{sb.toString(), String.valueOf(oldLayoutId)}, (String[])new String[]{"", String.valueOf(newLayoutId)});
            oldLinksToLayout.add(oldLinkToLayout);
            newLinksToLayout.add(newLinkToLayout);
        }
        content = StringUtil.replace((String)content, (String[])ArrayUtil.toStringArray((Object[])oldLinksToLayout.toArray()), (String[])ArrayUtil.toStringArray((Object[])newLinksToLayout.toArray()));
        return content;
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_articles, _structuresTemplatesAndFeeds, _embeddedAssets, _images, _categories, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_articles, _structuresTemplatesAndFeeds, _images, _categories, _comments, _ratings, _tags};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return PropsValues.JOURNAL_PUBLISH_TO_LIVE_BY_DEFAULT;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(JournalPortletDataHandlerImpl.class, "deleteData")) {
            JournalArticleLocalServiceUtil.deleteArticles((long)portletDataContext.getScopeGroupId());
            JournalTemplateLocalServiceUtil.deleteTemplates((long)portletDataContext.getScopeGroupId());
            JournalStructureLocalServiceUtil.deleteStructures((long)portletDataContext.getScopeGroupId());
        }
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.journal", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("journal-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        Element structuresElement = rootElement.addElement("structures");
        List structures = JournalStructureUtil.findByGroupId((long)portletDataContext.getScopeGroupId(), (int)-1, (int)-1, (OrderByComparator)new StructurePKComparator(true));
        for (JournalStructure structure : structures) {
            if (!portletDataContext.isWithinDateRange(structure.getModifiedDate())) continue;
            JournalPortletDataHandlerImpl.exportStructure(portletDataContext, structuresElement, structure);
        }
        Element templatesElement = rootElement.addElement("templates");
        Element dlFileEntryTypesElement = rootElement.addElement("dl-file-entry-types");
        Element dlFoldersElement = rootElement.addElement("dl-folders");
        Element dlFilesElement = rootElement.addElement("dl-file-entries");
        Element dlFileRanksElement = rootElement.addElement("dl-file-ranks");
        List templates = JournalTemplateUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (JournalTemplate template : templates) {
            if (!portletDataContext.isWithinDateRange(template.getModifiedDate())) continue;
            JournalPortletDataHandlerImpl.exportTemplate(portletDataContext, templatesElement, dlFileEntryTypesElement, dlFoldersElement, dlFilesElement, dlFileRanksElement, template);
        }
        Element feedsElement = rootElement.addElement("feeds");
        List feeds = JournalFeedUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (JournalFeed feed : feeds) {
            if (!portletDataContext.isWithinDateRange(feed.getModifiedDate())) continue;
            JournalPortletDataHandlerImpl.exportFeed(portletDataContext, feedsElement, feed);
        }
        Element articlesElement = rootElement.addElement("articles");
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "articles")) {
            List articles = JournalArticleUtil.findByGroupId((long)portletDataContext.getScopeGroupId(), (int)-1, (int)-1, (OrderByComparator)new ArticleIDComparator(true));
            for (JournalArticle article : articles) {
                JournalPortletDataHandlerImpl.exportArticle(portletDataContext, articlesElement, structuresElement, templatesElement, dlFileEntryTypesElement, dlFoldersElement, dlFilesElement, dlFileRanksElement, article, true);
            }
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.journal", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        JournalPortletDataHandlerImpl.importReferencedData(portletDataContext, rootElement);
        Element structuresElement = rootElement.element("structures");
        List structureElements = structuresElement.elements("structure");
        for (Element structureElement : structureElements) {
            JournalPortletDataHandlerImpl.importStructure(portletDataContext, structureElement);
        }
        Element templatesElement = rootElement.element("templates");
        List templateElements = templatesElement.elements("template");
        for (Element templateElement : templateElements) {
            JournalPortletDataHandlerImpl.importTemplate(portletDataContext, templateElement);
        }
        Element feedsElement = rootElement.element("feeds");
        List feedElements = feedsElement.elements("feed");
        for (Element feedElement : feedElements) {
            JournalPortletDataHandlerImpl.importFeed(portletDataContext, feedElement);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "articles")) {
            Element articlesElement = rootElement.element("articles");
            List articleElements = articlesElement.elements("article");
            for (Element articleElement : articleElements) {
                JournalPortletDataHandlerImpl.importArticle(portletDataContext, articleElement);
            }
        }
        return portletPreferences;
    }
}

