/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.asset;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class JournalArticleAssetRenderer
extends BaseAssetRenderer {
    private JournalArticle _article;

    public JournalArticleAssetRenderer(JournalArticle article) {
        this._article = article;
    }

    public JournalArticle getArticle() {
        return this._article;
    }

    public String[] getAvailableLocales() {
        return this._article.getAvailableLocales();
    }

    public long getClassPK() {
        if ((this._article.isDraft() || this._article.isPending()) && this._article.getVersion() != 1.0) {
            return this._article.getPrimaryKey();
        }
        return this._article.getResourcePrimKey();
    }

    public String getDiscussionPath() {
        if (PropsValues.JOURNAL_ARTICLE_COMMENTS_ENABLED) {
            return "edit_article_discussion";
        }
        return null;
    }

    public long getGroupId() {
        return this._article.getGroupId();
    }

    public String getSummary(Locale locale) {
        return this._article.getDescription(locale);
    }

    public String getTitle(Locale locale) {
        return this._article.getTitle(locale);
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "15", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        portletURL.setParameter("articleId", this._article.getArticleId());
        portletURL.setParameter("version", String.valueOf(this._article.getVersion()));
        return portletURL;
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        PortletURL portletURL = liferayPortletResponse.createActionURL();
        portletURL.setParameter("struts_action", "/asset_publisher/export_journal_article");
        portletURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        portletURL.setParameter("articleId", this._article.getArticleId());
        return portletURL;
    }

    public String getUrlTitle() {
        return this._article.getUrlTitle();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) throws Exception {
        if (Validator.isNull((String)this._article.getLayoutUuid())) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        Group group = themeDisplay.getScopeGroup();
        if (group.getGroupId() != this._article.getGroupId()) {
            group = GroupLocalServiceUtil.getGroup((long)this._article.getGroupId());
        }
        String groupFriendlyURL = PortalUtil.getGroupFriendlyURL((Group)group, (boolean)false, (ThemeDisplay)themeDisplay);
        return groupFriendlyURL.concat("/-/").concat(HtmlUtil.escape((String)this._article.getUrlTitle()));
    }

    public long getUserId() {
        return this._article.getUserId();
    }

    public String getUuid() {
        return this._article.getUuid();
    }

    public String getViewInContextMessage() {
        return "view";
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return JournalArticlePermission.contains(permissionChecker, this._article, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return JournalArticlePermission.contains(permissionChecker, this._article, "VIEW");
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isDisplayable() {
        Date now = new Date();
        Date displayDate = this._article.getDisplayDate();
        if (displayDate != null && displayDate.after(now)) {
            return false;
        }
        Date expirationDate = this._article.getExpirationDate();
        return expirationDate == null || !expirationDate.before(now);
    }

    public boolean isLocalizable() {
        return true;
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("JOURNAL_ARTICLE", (Object)this._article);
            return "/html/portlet/journal/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/history.png";
    }
}

