/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleImageLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ViewArticleContentAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            String articleId = ParamUtil.getString((HttpServletRequest)request, (String)"articleId");
            double version = ParamUtil.getDouble((HttpServletRequest)request, (String)"version", (double)1.0);
            String languageId = LanguageUtil.getLanguageId((HttpServletRequest)request);
            String output = null;
            if (cmd.equals("preview")) {
                JournalArticle article = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
                output = JournalArticleLocalServiceUtil.getArticleContent((JournalArticle)article, (String)article.getTemplateId(), null, (String)languageId, (ThemeDisplay)themeDisplay);
            } else {
                output = JournalArticleServiceUtil.getArticleContent((long)groupId, (String)articleId, (double)version, (String)languageId, (ThemeDisplay)themeDisplay);
            }
            request.setAttribute("JOURNAL_ARTICLE_CONTENT", (Object)output);
            if (output.startsWith("<?xml ")) {
                return mapping.findForward("portlet.journal.raw_article_content");
            }
            return mapping.findForward("portlet.journal.view_article_content");
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected void format(long groupId, String articleId, double version, String previewArticleId, Element root, UploadServletRequest uploadServletRequest) throws Exception {
        for (Element el : root.elements()) {
            Element dynamicContent = el.element("dynamic-content");
            String elInstanceId = el.attributeValue("instance-id", "");
            String elName = el.attributeValue("name", "");
            String elType = el.attributeValue("type", "");
            String elContent = "";
            String elLanguage = "";
            if (dynamicContent != null) {
                elContent = dynamicContent.getTextTrim();
                elLanguage = dynamicContent.attributeValue("language-id", "");
                if (!elLanguage.equals("")) {
                    elLanguage = "_" + elLanguage;
                }
            }
            if (elType.equals("image") && Validator.isNull((String)elContent)) {
                String token;
                long imageId;
                File file = uploadServletRequest.getFile("structure_image_" + elName + elLanguage);
                byte[] bytes = FileUtil.getBytes((File)file);
                if (bytes != null && bytes.length > 0) {
                    imageId = JournalArticleImageLocalServiceUtil.getArticleImageId((long)groupId, (String)previewArticleId, (double)version, (String)elInstanceId, (String)elName, (String)elLanguage, (boolean)true);
                    token = WebServerServletTokenUtil.getToken((long)imageId);
                    dynamicContent.setText("/image/journal/article?img_id=" + imageId + "&t=" + token);
                    ImageLocalServiceUtil.updateImage((long)imageId, (byte[])bytes);
                } else if (Validator.isNotNull((String)articleId)) {
                    imageId = JournalArticleImageLocalServiceUtil.getArticleImageId((long)groupId, (String)articleId, (double)version, (String)elInstanceId, (String)elName, (String)elLanguage);
                    token = WebServerServletTokenUtil.getToken((long)imageId);
                    dynamicContent.setText("/image/journal/article?img_id=" + imageId + "&t=" + token);
                }
            }
            this.format(groupId, articleId, version, previewArticleId, el, uploadServletRequest);
        }
    }
}

