/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.journal.DuplicateStructureElementException;
import com.liferay.portlet.journal.DuplicateStructureIdException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.RequiredStructureException;
import com.liferay.portlet.journal.StructureIdException;
import com.liferay.portlet.journal.StructureInheritanceException;
import com.liferay.portlet.journal.StructureNameException;
import com.liferay.portlet.journal.StructureXsdException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.JournalStructureServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditStructureAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        JournalStructure structure = null;
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                structure = this.updateStructure(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteStructures(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                boolean saveAndContinue;
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                if (structure != null && (saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue"))) {
                    redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, structure, redirect);
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchStructureException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e instanceof DuplicateStructureElementException || e instanceof DuplicateStructureIdException || e instanceof RequiredStructureException || e instanceof StructureIdException || e instanceof StructureInheritanceException || e instanceof StructureNameException || e instanceof StructureXsdException) {
                String redirect;
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
                if (e instanceof RequiredStructureException && Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                    actionResponse.sendRedirect(redirect);
                }
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)renderRequest, (String)"cmd");
            if (!cmd.equals("add")) {
                ActionUtil.getStructure((PortletRequest)renderRequest);
            }
        }
        catch (NoSuchStructureException noSuchStructureException) {
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.journal.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_structure"));
    }

    protected void deleteStructures(ActionRequest actionRequest) throws Exception {
        String[] deleteStructureIds;
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] stringArray = deleteStructureIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteStructureIds"));
        int n = deleteStructureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String deleteStructureId = stringArray[n2];
            JournalStructureServiceUtil.deleteStructure((long)groupId, (String)deleteStructureId);
            JournalUtil.removeRecentStructure((PortletRequest)actionRequest, deleteStructureId);
            ++n2;
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, JournalStructure structure, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String originalRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"originalRedirect");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setWindowState(actionRequest.getWindowState());
        portletURL.setParameter("struts_action", "/journal/edit_structure");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("originalRedirect", originalRedirect, false);
        portletURL.setParameter("groupId", String.valueOf(structure.getGroupId()), false);
        portletURL.setParameter("structureId", structure.getStructureId(), false);
        return portletURL.toString();
    }

    protected JournalStructure updateStructure(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String structureId = ParamUtil.getString((PortletRequest)actionRequest, (String)"structureId");
        boolean autoStructureId = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"autoStructureId");
        String parentStructureId = ParamUtil.getString((PortletRequest)actionRequest, (String)"parentStructureId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        String xsd = ParamUtil.getString((PortletRequest)actionRequest, (String)"xsd");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalStructure.class.getName(), (PortletRequest)actionRequest);
        JournalStructure structure = null;
        structure = cmd.equals("add") ? JournalStructureServiceUtil.addStructure((long)groupId, (String)structureId, (boolean)autoStructureId, (String)parentStructureId, (Map)nameMap, (Map)descriptionMap, (String)xsd, (ServiceContext)serviceContext) : JournalStructureServiceUtil.updateStructure((long)groupId, (String)structureId, (String)parentStructureId, (Map)nameMap, (Map)descriptionMap, (String)xsd, (ServiceContext)serviceContext);
        JournalUtil.addRecentStructure((PortletRequest)actionRequest, structure);
        return structure;
    }
}

