/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.journal.ArticleContentException;
import com.liferay.portlet.journal.ArticleContentSizeException;
import com.liferay.portlet.journal.ArticleDisplayDateException;
import com.liferay.portlet.journal.ArticleExpirationDateException;
import com.liferay.portlet.journal.ArticleIdException;
import com.liferay.portlet.journal.ArticleSmallImageNameException;
import com.liferay.portlet.journal.ArticleSmallImageSizeException;
import com.liferay.portlet.journal.ArticleTitleException;
import com.liferay.portlet.journal.ArticleTypeException;
import com.liferay.portlet.journal.ArticleVersionException;
import com.liferay.portlet.journal.DuplicateArticleIdException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditArticleAction
extends PortletAction {
    public static final String VERSION_SEPARATOR = "_version_";

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        JournalArticle article = null;
        String oldUrlTitle = "";
        try {
            if (Validator.isNull((String)cmd)) {
                UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                if (uploadException != null) {
                    if (uploadException.isExceededSizeLimit()) {
                        throw new ArticleContentSizeException();
                    }
                    throw new PortalException(uploadException.getCause());
                }
            } else if (cmd.equals("add") || cmd.equals("translate") || cmd.equals("update")) {
                Object[] returnValue = this.updateArticle(actionRequest);
                article = (JournalArticle)returnValue[0];
                oldUrlTitle = (String)returnValue[1];
            } else if (cmd.equals("delete") || cmd.equals("delete_versions")) {
                this.deleteArticles(actionRequest);
            } else if (cmd.equals("delete_translation")) {
                this.removeArticlesLocale(actionRequest);
            } else if (cmd.equals("expire")) {
                this.expireArticles(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeArticles(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeArticles(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
                if (article != null && workflowAction == 2) {
                    redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, article, redirect);
                }
                if (redirect.contains("/content/" + oldUrlTitle + "?")) {
                    int pos = redirect.indexOf("?");
                    if (pos == -1) {
                        pos = redirect.length();
                    }
                    String newRedirect = redirect.substring(0, pos - oldUrlTitle.length());
                    newRedirect = String.valueOf(newRedirect) + article.getUrlTitle();
                    if (oldUrlTitle.contains("/maximized")) {
                        newRedirect = String.valueOf(newRedirect) + "/maximized";
                    }
                    if (pos < redirect.length()) {
                        newRedirect = String.valueOf(newRedirect) + "?" + redirect.substring(pos + 1, redirect.length());
                    }
                    redirect = newRedirect;
                }
                WindowState windowState = actionRequest.getWindowState();
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
                Layout layout = themeDisplay.getLayout();
                if (cmd.equals("delete_versions") && this.hasArticle(actionRequest)) {
                    redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"originalRedirect");
                }
                if (cmd.equals("delete_translation") || cmd.equals("translate")) {
                    this.setForward((PortletRequest)actionRequest, "portlet.journal.update_translation_redirect");
                } else if (!windowState.equals((Object)LiferayWindowState.POP_UP) && layout.isTypeControlPanel()) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else if (Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)redirect)))) {
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException || e instanceof NoSuchStructureException || e instanceof NoSuchTemplateException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e instanceof ArticleContentException || e instanceof ArticleContentSizeException || e instanceof ArticleDisplayDateException || e instanceof ArticleExpirationDateException || e instanceof ArticleIdException || e instanceof ArticleSmallImageNameException || e instanceof ArticleSmallImageSizeException || e instanceof ArticleTitleException || e instanceof ArticleTypeException || e instanceof ArticleVersionException || e instanceof DuplicateArticleIdException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getArticle((PortletRequest)renderRequest);
        }
        catch (NoSuchArticleException noSuchArticleException) {
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.journal.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_article"));
    }

    @Override
    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/journal/editor.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void deleteArticles(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] deleteArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteArticleIds"));
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        String[] stringArray = deleteArticleIds;
        int n = deleteArticleIds.length;
        int n2 = 0;
        while (n2 < n) {
            String deleteArticleId = stringArray[n2];
            int pos = deleteArticleId.lastIndexOf(VERSION_SEPARATOR);
            String articleId = deleteArticleId;
            String articleURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleURL");
            double version = 0.0;
            if (pos == -1) {
                JournalArticleServiceUtil.deleteArticle((long)groupId, (String)articleId, (String)articleURL, (ServiceContext)serviceContext);
            } else {
                articleId = articleId.substring(0, pos);
                version = GetterUtil.getDouble((String)deleteArticleId.substring(pos + VERSION_SEPARATOR.length()));
                JournalArticleServiceUtil.deleteArticle((long)groupId, (String)articleId, (double)version, (String)articleURL, (ServiceContext)serviceContext);
            }
            JournalUtil.removeRecentArticle((PortletRequest)actionRequest, articleId, version);
            ++n2;
        }
    }

    protected void expireArticles(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] expireArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"expireArticleIds"));
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        String[] stringArray = expireArticleIds;
        int n = expireArticleIds.length;
        int n2 = 0;
        while (n2 < n) {
            String expireArticleId = stringArray[n2];
            int pos = expireArticleId.lastIndexOf(VERSION_SEPARATOR);
            String articleId = expireArticleId;
            String articleURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleURL");
            double version = 0.0;
            if (pos == -1) {
                JournalArticleServiceUtil.expireArticle((long)groupId, (String)articleId, (String)articleURL, (ServiceContext)serviceContext);
            } else {
                articleId = articleId.substring(0, pos);
                version = GetterUtil.getDouble((String)expireArticleId.substring(pos + VERSION_SEPARATOR.length()));
                JournalArticleServiceUtil.expireArticle((long)groupId, (String)articleId, (double)version, (String)articleURL, (ServiceContext)serviceContext);
            }
            ++n2;
        }
    }

    protected Map<String, byte[]> getImages(UploadPortletRequest uploadPortletRequest) throws Exception {
        HashMap<String, byte[]> images = new HashMap<String, byte[]>();
        String imagePrefix = "structure_image_";
        Enumeration enu = uploadPortletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            File file;
            byte[] bytes;
            String name = (String)enu.nextElement();
            if (!name.startsWith(imagePrefix) || (bytes = FileUtil.getBytes((File)(file = uploadPortletRequest.getFile(name)))) == null || bytes.length <= 0) continue;
            name = name.substring(imagePrefix.length(), name.length());
            images.put(name, bytes);
        }
        return images;
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, JournalArticle article, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String originalRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"originalRedirect");
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setWindowState(actionRequest.getWindowState());
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("originalRedirect", originalRedirect, false);
        portletURL.setParameter("groupId", String.valueOf(article.getGroupId()), false);
        portletURL.setParameter("articleId", article.getArticleId(), false);
        portletURL.setParameter("version", String.valueOf(article.getVersion()), false);
        portletURL.setParameter("languageId", languageId, false);
        return portletURL.toString();
    }

    protected boolean hasArticle(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        try {
            JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId);
        }
        catch (NoSuchArticleException noSuchArticleException) {
            return true;
        }
        return false;
    }

    protected void removeArticlesLocale(ActionRequest actionRequest) throws Exception {
        String[] removeArticleLocaleIds;
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] stringArray = removeArticleLocaleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteArticleIds"));
        int n = removeArticleLocaleIds.length;
        int n2 = 0;
        while (n2 < n) {
            String removeArticleLocaleId = stringArray[n2];
            int pos = removeArticleLocaleId.lastIndexOf(VERSION_SEPARATOR);
            String articleId = removeArticleLocaleId.substring(0, pos);
            double version = GetterUtil.getDouble((String)removeArticleLocaleId.substring(pos + VERSION_SEPARATOR.length()));
            String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
            JournalArticleServiceUtil.removeArticleLocale((long)groupId, (String)articleId, (double)version, (String)languageId);
            ++n2;
        }
    }

    protected void subscribeArticles(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        JournalArticleServiceUtil.subscribe((long)themeDisplay.getScopeGroupId());
    }

    protected void unsubscribeArticles(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        JournalArticleServiceUtil.unsubscribe((long)themeDisplay.getScopeGroupId());
    }

    protected Object[] updateArticle(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String cmd = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
        long classNameId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classPK");
        String articleId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"articleId");
        boolean autoArticleId = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"autoArticleId");
        double version = ParamUtil.getDouble((HttpServletRequest)uploadPortletRequest, (String)"version");
        boolean localized = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"localized");
        String defaultLanguageId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"defaultLanguageId");
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        String toLanguageId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"toLanguageId");
        Locale toLocale = null;
        String title = "";
        String description = "";
        if (Validator.isNull((String)toLanguageId)) {
            title = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("title_" + defaultLanguageId));
            description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("description_" + defaultLanguageId));
        } else {
            toLocale = LocaleUtil.fromLanguageId((String)toLanguageId);
            title = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("title_" + toLanguageId));
            description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("description_" + toLanguageId));
        }
        String content = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"content");
        Boolean fileItemThresholdSizeExceeded = (Boolean)uploadPortletRequest.getAttribute("FILE_ITEM_THRESHOLD_SIZE_EXCEEDED");
        if (fileItemThresholdSizeExceeded != null && fileItemThresholdSizeExceeded.booleanValue()) {
            throw new ArticleContentSizeException();
        }
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        String structureId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"structureId");
        String templateId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"templateId");
        String layoutUuid = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutUuid");
        Layout targetLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)groupId);
        if (targetLayout == null) {
            layoutUuid = null;
        }
        int displayDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateMonth");
        int displayDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateDay");
        int displayDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateYear");
        int displayDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateHour");
        int displayDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateMinute");
        int displayDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateAmPm");
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        int expirationDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateMonth");
        int expirationDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateDay");
        int expirationDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateYear");
        int expirationDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateHour");
        int expirationDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateMinute");
        int expirationDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateAmPm");
        boolean neverExpire = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"neverExpire");
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        int reviewDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateMonth");
        int reviewDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateDay");
        int reviewDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateYear");
        int reviewDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateHour");
        int reviewDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateMinute");
        int reviewDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateAmPm");
        boolean neverReview = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"neverReview");
        if (reviewDateAmPm == 1) {
            reviewDateHour += 12;
        }
        boolean indexable = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"indexable");
        boolean smallImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"smallImage");
        String smallImageURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"smallImageURL");
        File smallFile = uploadPortletRequest.getFile("smallFile");
        Map<String, byte[]> images = this.getImages(uploadPortletRequest);
        String articleURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"articleURL");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        serviceContext.setAttribute("defaultLanguageId", (Serializable)((Object)defaultLanguageId));
        JournalArticle article = null;
        String oldUrlTitle = "";
        if (cmd.equals("add")) {
            HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
            titleMap.put(defaultLocale, title);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(defaultLocale, description);
            if (Validator.isNull((String)structureId)) {
                content = LocalizationUtil.updateLocalization((String)"", (String)"static-content", (String)content, (String)defaultLanguageId, (String)defaultLanguageId, (boolean)true, (boolean)localized);
            }
            article = JournalArticleServiceUtil.addArticle((long)groupId, (long)classNameId, (long)classPK, (String)articleId, (boolean)autoArticleId, titleMap, descriptionMap, (String)content, (String)type, (String)structureId, (String)templateId, (String)layoutUuid, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)indexable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, images, (String)articleURL, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, JournalArticle.class.getName(), article.getResourcePrimKey(), -1);
        } else {
            JournalArticle curArticle = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
            if (Validator.isNull((String)structureId)) {
                if (!curArticle.isTemplateDriven()) {
                    String curContent = "";
                    curContent = curArticle.getContent();
                    content = cmd.equals("translate") ? LocalizationUtil.updateLocalization((String)curContent, (String)"static-content", (String)content, (String)toLanguageId, (String)defaultLanguageId, (boolean)true, (boolean)true) : LocalizationUtil.updateLocalization((String)curContent, (String)"static-content", (String)content, (String)defaultLanguageId, (String)defaultLanguageId, (boolean)true, (boolean)localized);
                }
            } else if (curArticle.isTemplateDriven()) {
                JournalStructure structure = null;
                try {
                    structure = JournalStructureLocalServiceUtil.getStructure((long)groupId, (String)structureId);
                }
                catch (NoSuchStructureException noSuchStructureException) {
                    structure = JournalStructureLocalServiceUtil.getStructure((long)themeDisplay.getCompanyGroupId(), (String)structureId);
                }
                content = JournalUtil.mergeArticleContent(curArticle.getContent(), content, true);
                content = JournalUtil.removeOldContent(content, structure.getMergedXsd());
            }
            article = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
            Map titleMap = article.getTitleMap();
            Map descriptionMap = article.getDescriptionMap();
            String tempOldUrlTitle = article.getUrlTitle();
            if (cmd.equals("update")) {
                titleMap.put(defaultLocale, title);
                descriptionMap.put(defaultLocale, description);
                article = JournalArticleServiceUtil.updateArticle((long)groupId, (String)articleId, (double)version, (Map)titleMap, (Map)descriptionMap, (String)content, (String)type, (String)structureId, (String)templateId, (String)layoutUuid, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)indexable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, images, (String)articleURL, (ServiceContext)serviceContext);
            } else if (cmd.equals("translate")) {
                article = JournalArticleServiceUtil.updateArticleTranslation((long)groupId, (String)articleId, (double)version, (Locale)toLocale, (String)title, (String)description, (String)content, images);
            }
            if (!tempOldUrlTitle.equals(article.getUrlTitle())) {
                oldUrlTitle = tempOldUrlTitle;
            }
        }
        JournalUtil.addRecentArticle((PortletRequest)actionRequest, article);
        String portletResource = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"portletResource");
        if (Validator.isNotNull((String)portletResource)) {
            PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((HttpServletRequest)uploadPortletRequest, (String)portletResource);
            preferences.setValue("groupId", String.valueOf(article.getGroupId()));
            preferences.setValue("articleId", article.getArticleId());
            preferences.store();
            this.updateContentSearch(actionRequest, portletResource, article.getArticleId());
        }
        return new Object[]{article, oldUrlTitle};
    }

    protected void updateContentSearch(ActionRequest actionRequest, String portletResource, String articleId) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        JournalContentSearchLocalServiceUtil.updateContentSearch((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletResource, (String)articleId);
    }
}

