/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.model.impl.ExpandoValueImpl;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandoBridgeIndexerImpl
implements ExpandoBridgeIndexer {
    protected static final String _FIELD_NAMESPACE = "expando";
    private static Log _log = LogFactoryUtil.getLog(ExpandoBridgeIndexerImpl.class);

    public void addAttributes(Document document, ExpandoBridge expandoBridge) {
        if (expandoBridge == null) {
            return;
        }
        try {
            this.doAddAttributes(document, expandoBridge);
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
        }
    }

    public String encodeFieldName(String columnName) {
        StringBundler sb = new StringBundler(3);
        sb.append(_FIELD_NAMESPACE);
        sb.append("/");
        sb.append("CUSTOM_FIELDS".toLowerCase());
        sb.append("/");
        sb.append(columnName);
        return sb.toString();
    }

    protected void doAddAttributes(Document document, ExpandoBridge expandoBridge) throws SystemException {
        List expandoColumns = ExpandoColumnLocalServiceUtil.getDefaultTableColumns((long)expandoBridge.getCompanyId(), (String)expandoBridge.getClassName());
        if (expandoColumns == null || expandoColumns.isEmpty()) {
            return;
        }
        ArrayList<ExpandoColumn> indexedColumns = new ArrayList<ExpandoColumn>();
        for (ExpandoColumn expandoColumn : expandoColumns) {
            UnicodeProperties properties = expandoColumn.getTypeSettingsProperties();
            int indexType = GetterUtil.getInteger((String)((String)properties.get((Object)"index-type")));
            if (indexType == 0) continue;
            indexedColumns.add(expandoColumn);
        }
        if (indexedColumns.isEmpty()) {
            return;
        }
        List expandoValues = ExpandoValueLocalServiceUtil.getRowValues((long)expandoBridge.getCompanyId(), (String)expandoBridge.getClassName(), (String)"CUSTOM_FIELDS", (long)expandoBridge.getClassPK(), (int)-1, (int)-1);
        for (ExpandoColumn expandoColumn : indexedColumns) {
            try {
                this.addAttribute(document, expandoColumn, expandoValues);
            }
            catch (Exception e) {
                _log.error((Object)("Indexing " + expandoColumn.getName()), (Throwable)e);
            }
        }
    }

    protected void addAttribute(Document document, ExpandoColumn expandoColumn, List<ExpandoValue> expandoValues) throws PortalException, SystemException {
        String fieldName = this.encodeFieldName(expandoColumn.getName());
        ExpandoValueImpl expandoValue = new ExpandoValueImpl();
        expandoValue.setColumnId(expandoColumn.getColumnId());
        expandoValue.setData(expandoColumn.getDefaultData());
        boolean defaultValue = true;
        for (ExpandoValue curExpandoValue : expandoValues) {
            if (curExpandoValue.getColumnId() != expandoColumn.getColumnId()) continue;
            expandoValue = curExpandoValue;
            defaultValue = false;
            break;
        }
        UnicodeProperties typeSettingsProperties = expandoColumn.getTypeSettingsProperties();
        int indexType = GetterUtil.getInteger((String)typeSettingsProperties.getProperty("index-type"));
        int type = expandoColumn.getType();
        if (type == 1) {
            document.addKeyword(fieldName, expandoValue.getBoolean());
        } else if (type == 2) {
            if (!defaultValue) {
                document.addKeyword(fieldName, expandoValue.getBooleanArray());
            } else {
                document.addKeyword(fieldName, new boolean[0]);
            }
        } else if (type == 3) {
            document.addDate(fieldName, expandoValue.getDate());
        } else if (type == 5) {
            document.addKeyword(fieldName, expandoValue.getDouble());
        } else if (type == 6) {
            if (!defaultValue) {
                document.addKeyword(fieldName, expandoValue.getDoubleArray());
            } else {
                document.addKeyword(fieldName, new double[0]);
            }
        } else if (type == 7) {
            document.addKeyword(fieldName, expandoValue.getFloat());
        } else if (type == 8) {
            if (!defaultValue) {
                document.addKeyword(fieldName, expandoValue.getFloatArray());
            } else {
                document.addKeyword(fieldName, new float[0]);
            }
        } else if (type == 9) {
            document.addKeyword(fieldName, expandoValue.getInteger());
        } else if (type == 10) {
            if (!defaultValue) {
                document.addKeyword(fieldName, expandoValue.getIntegerArray());
            } else {
                document.addKeyword(fieldName, new int[0]);
            }
        } else if (type == 11) {
            document.addKeyword(fieldName, expandoValue.getLong());
        } else if (type == 12) {
            if (!defaultValue) {
                document.addKeyword(fieldName, expandoValue.getLongArray());
            } else {
                document.addKeyword(fieldName, new long[0]);
            }
        } else if (type == 13) {
            document.addKeyword(fieldName, expandoValue.getShort());
        } else if (type == 14) {
            if (!defaultValue) {
                document.addKeyword(fieldName, expandoValue.getShortArray());
            } else {
                document.addKeyword(fieldName, new short[0]);
            }
        } else if (type == 15) {
            if (indexType == 2) {
                document.addKeyword(fieldName, expandoValue.getString());
            } else {
                document.addText(fieldName, expandoValue.getString());
            }
        } else if (type == 16) {
            if (!defaultValue) {
                if (indexType == 2) {
                    document.addKeyword(fieldName, expandoValue.getStringArray());
                } else {
                    document.addText(fieldName, StringUtil.merge((Object[])expandoValue.getStringArray(), (String)" "));
                }
            } else if (indexType == 2) {
                document.addKeyword(fieldName, "");
            } else {
                document.addText(fieldName, "");
            }
        }
    }
}

