/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoRow;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.model.impl.ExpandoValueImpl;
import com.liferay.portlet.expando.service.base.ExpandoValueLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandoValueLocalServiceImpl
extends ExpandoValueLocalServiceBaseImpl {
    public ExpandoValue addValue(long classNameId, long tableId, long columnId, long classPK, String data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        return this.doAddValue(table.getCompanyId(), classNameId, tableId, columnId, classPK, data);
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, boolean data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setBoolean(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, boolean[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setBooleanArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Date data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDate(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Date[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDateArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, double data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDouble(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, double[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDoubleArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, float data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setFloat(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, float[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setFloatArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, int data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setInteger(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, int[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setIntegerArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, long data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setLong(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, long[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setLongArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Number data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setNumber(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Number[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setNumberArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Object data) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        int type = column.getType();
        if (type == 1) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Boolean)data).booleanValue());
        }
        if (type == 2) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (boolean[])data);
        }
        if (type == 3) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (Date)data);
        }
        if (type == 4) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (Date[])data);
        }
        if (type == 5) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Double)data).doubleValue());
        }
        if (type == 6) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (double[])data);
        }
        if (type == 7) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Float)data).floatValue());
        }
        if (type == 8) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (float[])data);
        }
        if (type == 9) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Integer)data).intValue());
        }
        if (type == 10) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (int[])data);
        }
        if (type == 11) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Long)data).longValue());
        }
        if (type == 12) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (long[])data);
        }
        if (type == 17) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (Number)data);
        }
        if (type == 18) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (Number[])data);
        }
        if (type == 13) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Short)data).shortValue());
        }
        if (type == 14) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (short[])data);
        }
        if (type == 16) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (String[])data);
        }
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (String)data);
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, short data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setShort(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, short[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setShortArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, String data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setString(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, String[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setStringArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, boolean data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, boolean[] data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, Date data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, Date[] data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, double data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, double[] data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, float data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, float[] data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, int data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, int[] data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, long data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, long[] data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, Object data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, short data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, short[] data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, String data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, String[] data) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public void addValues(long classNameId, long tableId, List<ExpandoColumn> columns, long classPK, Map<String, String> data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        ExpandoRow row = this.expandoRowPersistence.fetchByT_C(tableId, classPK);
        if (row == null) {
            long rowId = this.counterLocalService.increment();
            row = this.expandoRowPersistence.create(rowId);
            row.setCompanyId(table.getCompanyId());
            row.setTableId(tableId);
            row.setClassPK(classPK);
            this.expandoRowPersistence.update((BaseModel)row, false);
        }
        for (ExpandoColumn column : columns) {
            String dataString = data.get(column.getName());
            if (dataString == null) continue;
            ExpandoValue value = this.expandoValuePersistence.fetchByC_R(column.getColumnId(), row.getRowId());
            if (value == null) {
                long valueId = this.counterLocalService.increment();
                value = this.expandoValuePersistence.create(valueId);
                value.setCompanyId(table.getCompanyId());
                value.setTableId(tableId);
                value.setColumnId(column.getColumnId());
                value.setRowId(row.getRowId());
                value.setClassNameId(classNameId);
                value.setClassPK(classPK);
            }
            value.setData(dataString);
            this.expandoValuePersistence.update((BaseModel)value, false);
        }
    }

    public void addValues(long companyId, long classNameId, String tableName, long classPK, Map<String, Serializable> attributes) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, classNameId, tableName);
        List columns = this.expandoColumnLocalService.getColumns(table.getTableId(), attributes.keySet());
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(companyId);
        for (ExpandoColumn column : columns) {
            Serializable attributeValue = attributes.get(column.getName());
            value.setColumn(column);
            int type = column.getType();
            if (type == 1) {
                value.setBoolean((Boolean)attributeValue);
            } else if (type == 2) {
                value.setBooleanArray((boolean[])attributeValue);
            } else if (type == 3) {
                value.setDate((Date)attributeValue);
            } else if (type == 4) {
                value.setDateArray((Date[])attributeValue);
            } else if (type == 5) {
                value.setDouble((Double)attributeValue);
            } else if (type == 6) {
                value.setDoubleArray((double[])attributeValue);
            } else if (type == 7) {
                value.setFloat(((Float)attributeValue).floatValue());
            } else if (type == 8) {
                value.setFloatArray((float[])attributeValue);
            } else if (type == 9) {
                value.setInteger((Integer)attributeValue);
            } else if (type == 10) {
                value.setIntegerArray((int[])attributeValue);
            } else if (type == 11) {
                value.setLong((Long)attributeValue);
            } else if (type == 12) {
                value.setLongArray((long[])attributeValue);
            } else if (type == 13) {
                value.setShort((Short)attributeValue);
            } else if (type == 14) {
                value.setShortArray((short[])attributeValue);
            } else if (type == 16) {
                value.setStringArray((String[])attributeValue);
            } else {
                value.setString((String)((Object)attributeValue));
            }
            this.doAddValue(companyId, classNameId, table.getTableId(), column.getColumnId(), classPK, value.getData());
        }
    }

    public void addValues(long companyId, String className, String tableName, long classPK, Map<String, Serializable> attributes) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.addValues(companyId, classNameId, tableName, classPK, attributes);
    }

    public void deleteColumnValues(long columnId) throws SystemException {
        List values = this.expandoValuePersistence.findByColumnId(columnId);
        for (ExpandoValue value : values) {
            this.deleteValue(value);
        }
    }

    public void deleteRowValues(long rowId) throws SystemException {
        List values = this.expandoValuePersistence.findByRowId(rowId);
        for (ExpandoValue value : values) {
            this.deleteValue(value);
        }
    }

    public void deleteTableValues(long tableId) throws SystemException {
        List values = this.expandoValuePersistence.findByTableId(tableId);
        for (ExpandoValue value : values) {
            this.deleteValue(value);
        }
    }

    public void deleteValue(ExpandoValue value) throws SystemException {
        this.expandoValuePersistence.remove((BaseModel)value);
    }

    public void deleteValue(long valueId) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValuePersistence.findByPrimaryKey(valueId);
        this.deleteValue(value);
    }

    public void deleteValue(long columnId, long rowId) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValuePersistence.findByC_R(columnId, rowId);
        this.deleteValue(value);
    }

    public void deleteValue(long companyId, long classNameId, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return;
        }
        List columns = this.expandoColumnPersistence.findByT_N(table.getTableId(), columnName);
        if (columns.isEmpty()) {
            return;
        }
        ExpandoColumn column = (ExpandoColumn)columns.get(0);
        ExpandoValue value = this.expandoValuePersistence.fetchByT_C_C(table.getTableId(), column.getColumnId(), classPK);
        if (value != null) {
            this.deleteValue(value.getValueId());
        }
    }

    public void deleteValue(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.expandoValueLocalService.deleteValue(companyId, classNameId, tableName, columnName, classPK);
    }

    public void deleteValues(long classNameId, long classPK) throws SystemException {
        List values = this.expandoValuePersistence.findByC_C(classNameId, classPK);
        for (ExpandoValue value : values) {
            this.deleteValue(value);
        }
    }

    public void deleteValues(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.expandoValueLocalService.deleteValues(classNameId, classPK);
    }

    public List<ExpandoValue> getColumnValues(long columnId, int start, int end) throws SystemException {
        return this.expandoValuePersistence.findByColumnId(columnId, start, end);
    }

    public List<ExpandoValue> getColumnValues(long companyId, long classNameId, String tableName, String columnName, int start, int end) throws SystemException {
        return this.expandoValueLocalService.getColumnValues(companyId, classNameId, tableName, columnName, null, start, end);
    }

    public List<ExpandoValue> getColumnValues(long companyId, long classNameId, String tableName, String columnName, String data, int start, int end) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        List columns = this.expandoColumnPersistence.findByT_N(table.getTableId(), columnName);
        if (columns.isEmpty()) {
            return Collections.emptyList();
        }
        ExpandoColumn column = (ExpandoColumn)columns.get(0);
        if (data == null) {
            return this.expandoValuePersistence.findByT_C(table.getTableId(), column.getColumnId(), start, end);
        }
        return this.expandoValuePersistence.findByT_C_D(table.getTableId(), column.getColumnId(), data, start, end);
    }

    public List<ExpandoValue> getColumnValues(long companyId, String className, String tableName, String columnName, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.expandoValueLocalService.getColumnValues(companyId, classNameId, tableName, columnName, start, end);
    }

    public List<ExpandoValue> getColumnValues(long companyId, String className, String tableName, String columnName, String data, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.expandoValueLocalService.getColumnValues(companyId, classNameId, tableName, columnName, data, start, end);
    }

    public List<ExpandoValue> getColumnValues(String className, String tableName, String columnName, String data, int start, int end) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getColumnValues(companyId, className, tableName, columnName, data, start, end);
    }

    public int getColumnValuesCount(long columnId) throws SystemException {
        return this.expandoValuePersistence.countByColumnId(columnId);
    }

    public int getColumnValuesCount(long companyId, long classNameId, String tableName, String columnName) throws SystemException {
        return this.expandoValueLocalService.getColumnValuesCount(companyId, classNameId, tableName, columnName, null);
    }

    public int getColumnValuesCount(long companyId, long classNameId, String tableName, String columnName, String data) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        List columns = this.expandoColumnPersistence.findByT_N(table.getTableId(), columnName);
        if (columns.isEmpty()) {
            return 0;
        }
        ExpandoColumn column = (ExpandoColumn)columns.get(0);
        if (data == null) {
            return this.expandoValuePersistence.countByT_C(table.getTableId(), column.getColumnId());
        }
        return this.expandoValuePersistence.countByT_C_D(table.getTableId(), column.getColumnId(), data);
    }

    public int getColumnValuesCount(long companyId, String className, String tableName, String columnName) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.expandoValueLocalService.getColumnValuesCount(companyId, classNameId, tableName, columnName);
    }

    public int getColumnValuesCount(long companyId, String className, String tableName, String columnName, String data) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.expandoValueLocalService.getColumnValuesCount(companyId, classNameId, tableName, columnName, data);
    }

    public int getColumnValuesCount(String className, String tableName, String columnName, String data) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getColumnValuesCount(companyId, className, tableName, columnName, data);
    }

    public Map<String, Serializable> getData(long companyId, String className, String tableName, Collection<String> columnNames, long classPK) throws PortalException, SystemException {
        List columns = this.expandoColumnLocalService.getColumns(companyId, className, tableName, columnNames);
        HashMap<String, Serializable> attributeValues = new HashMap<String, Serializable>((int)((double)columnNames.size() * 1.4));
        ExpandoValueImpl value = new ExpandoValueImpl();
        for (ExpandoColumn column : columns) {
            value.setColumn(column);
            value.setData(column.getDefaultData());
            Serializable attributeValue = this.doGetData(companyId, className, tableName, column.getName(), classPK, value, column.getType());
            attributeValues.put(column.getName(), attributeValue);
        }
        return attributeValues;
    }

    public Serializable getData(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setColumn(column);
        value.setData(column.getDefaultData());
        return this.doGetData(companyId, className, tableName, columnName, classPK, value, column.getType());
    }

    public boolean getData(long companyId, String className, String tableName, String columnName, long classPK, boolean defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getBoolean();
    }

    public boolean[] getData(long companyId, String className, String tableName, String columnName, long classPK, boolean[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getBooleanArray();
    }

    public Date getData(long companyId, String className, String tableName, String columnName, long classPK, Date defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDate();
    }

    public Date[] getData(long companyId, String className, String tableName, String columnName, long classPK, Date[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDateArray();
    }

    public double getData(long companyId, String className, String tableName, String columnName, long classPK, double defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDouble();
    }

    public double[] getData(long companyId, String className, String tableName, String columnName, long classPK, double[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDoubleArray();
    }

    public float getData(long companyId, String className, String tableName, String columnName, long classPK, float defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getFloat();
    }

    public float[] getData(long companyId, String className, String tableName, String columnName, long classPK, float[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getFloatArray();
    }

    public int getData(long companyId, String className, String tableName, String columnName, long classPK, int defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getInteger();
    }

    public int[] getData(long companyId, String className, String tableName, String columnName, long classPK, int[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getIntegerArray();
    }

    public long getData(long companyId, String className, String tableName, String columnName, long classPK, long defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getLong();
    }

    public long[] getData(long companyId, String className, String tableName, String columnName, long classPK, long[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getLongArray();
    }

    public short getData(long companyId, String className, String tableName, String columnName, long classPK, short defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getShort();
    }

    public short[] getData(long companyId, String className, String tableName, String columnName, long classPK, short[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getShortArray();
    }

    public String getData(long companyId, String className, String tableName, String columnName, long classPK, String defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getString();
    }

    public String[] getData(long companyId, String className, String tableName, String columnName, long classPK, String[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getStringArray();
    }

    public Serializable getData(String className, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK);
    }

    public boolean getData(String className, String tableName, String columnName, long classPK, boolean defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public boolean[] getData(String className, String tableName, String columnName, long classPK, boolean[] defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public Date getData(String className, String tableName, String columnName, long classPK, Date defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public Date[] getData(String className, String tableName, String columnName, long classPK, Date[] defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public double getData(String className, String tableName, String columnName, long classPK, double defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public double[] getData(String className, String tableName, String columnName, long classPK, double[] defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public float getData(String className, String tableName, String columnName, long classPK, float defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public float[] getData(String className, String tableName, String columnName, long classPK, float[] defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public int getData(String className, String tableName, String columnName, long classPK, int defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public int[] getData(String className, String tableName, String columnName, long classPK, int[] defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public long getData(String className, String tableName, String columnName, long classPK, long defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public long[] getData(String className, String tableName, String columnName, long classPK, long[] defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public short getData(String className, String tableName, String columnName, long classPK, short defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public short[] getData(String className, String tableName, String columnName, long classPK, short[] defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public String getData(String className, String tableName, String columnName, long classPK, String defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public String[] getData(String className, String tableName, String columnName, long classPK, String[] defaultData) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, defaultData);
    }

    public List<ExpandoValue> getDefaultTableColumnValues(long companyId, long classNameId, String columnName, int start, int end) throws SystemException {
        return this.expandoValueLocalService.getColumnValues(companyId, classNameId, "CUSTOM_FIELDS", columnName, start, end);
    }

    public List<ExpandoValue> getDefaultTableColumnValues(long companyId, String className, String columnName, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.expandoValueLocalService.getDefaultTableColumnValues(companyId, classNameId, columnName, start, end);
    }

    public int getDefaultTableColumnValuesCount(long companyId, long classNameId, String columnName) throws SystemException {
        return this.expandoValueLocalService.getColumnValuesCount(companyId, classNameId, "CUSTOM_FIELDS", columnName);
    }

    public int getDefaultTableColumnValuesCount(long companyId, String className, String columnName) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.expandoValueLocalService.getDefaultTableColumnValuesCount(companyId, classNameId, columnName);
    }

    public List<ExpandoValue> getRowValues(long rowId) throws SystemException {
        return this.expandoValuePersistence.findByRowId(rowId);
    }

    public List<ExpandoValue> getRowValues(long rowId, int start, int end) throws SystemException {
        return this.expandoValuePersistence.findByRowId(rowId, start, end);
    }

    public List<ExpandoValue> getRowValues(long companyId, long classNameId, String tableName, long classPK, int start, int end) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        return this.expandoValuePersistence.findByT_CPK(table.getTableId(), classPK, start, end);
    }

    public List<ExpandoValue> getRowValues(long companyId, String className, String tableName, long classPK, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.expandoValueLocalService.getRowValues(companyId, classNameId, tableName, classPK, start, end);
    }

    public int getRowValuesCount(long rowId) throws SystemException {
        return this.expandoValuePersistence.countByRowId(rowId);
    }

    public int getRowValuesCount(long companyId, long classNameId, String tableName, long classPK) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        return this.expandoValuePersistence.countByT_CPK(table.getTableId(), classPK);
    }

    public int getRowValuesCount(long companyId, String className, String tableName, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.expandoValueLocalService.getRowValuesCount(companyId, classNameId, tableName, classPK);
    }

    public ExpandoValue getValue(long valueId) throws PortalException, SystemException {
        return this.expandoValuePersistence.findByPrimaryKey(valueId);
    }

    public ExpandoValue getValue(long columnId, long rowId) throws PortalException, SystemException {
        return this.expandoValuePersistence.findByC_R(columnId, rowId);
    }

    public ExpandoValue getValue(long tableId, long columnId, long classPK) throws SystemException {
        return this.expandoValuePersistence.fetchByT_C_C(tableId, columnId, classPK);
    }

    public ExpandoValue getValue(long companyId, long classNameId, String tableName, String columnName, long classPK) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return null;
        }
        List columns = this.expandoColumnPersistence.findByT_N(table.getTableId(), columnName);
        if (columns.isEmpty()) {
            return null;
        }
        ExpandoColumn column = (ExpandoColumn)columns.get(0);
        return this.expandoValuePersistence.fetchByT_C_C(table.getTableId(), column.getColumnId(), classPK);
    }

    public ExpandoValue getValue(long classNameId, String tableName, String columnName, long classPK) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getValue(companyId, classNameId, tableName, columnName, classPK);
    }

    public ExpandoValue getValue(long companyId, String className, String tableName, String columnName, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.expandoValueLocalService.getValue(companyId, classNameId, tableName, columnName, classPK);
    }

    public ExpandoValue getValue(String className, String tableName, String columnName, long classPK) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
    }

    protected ExpandoValue doAddValue(long companyId, long classNameId, long tableId, long columnId, long classPK, String data) throws SystemException {
        ExpandoValue value;
        ExpandoRow row = this.expandoRowPersistence.fetchByT_C(tableId, classPK);
        if (row == null) {
            long rowId = this.counterLocalService.increment();
            row = this.expandoRowPersistence.create(rowId);
            row.setCompanyId(companyId);
            row.setTableId(tableId);
            row.setClassPK(classPK);
            this.expandoRowPersistence.update((BaseModel)row, false);
        }
        if ((value = this.expandoValuePersistence.fetchByC_R(columnId, row.getRowId())) == null) {
            long valueId = this.counterLocalService.increment();
            value = this.expandoValuePersistence.create(valueId);
            value.setCompanyId(companyId);
            value.setTableId(tableId);
            value.setColumnId(columnId);
            value.setRowId(row.getRowId());
            value.setClassNameId(classNameId);
            value.setClassPK(classPK);
        }
        value.setData(data);
        this.expandoValuePersistence.update((BaseModel)value, false);
        return value;
    }

    protected Serializable doGetData(long companyId, String className, String tableName, String columnName, long classPK, ExpandoValue value, int type) throws PortalException, SystemException {
        if (type == 1) {
            return Boolean.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getBoolean()));
        }
        if (type == 2) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new boolean[0]);
        }
        if (type == 3) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getDate());
        }
        if (type == 4) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new Date[0]);
        }
        if (type == 5) {
            return Double.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getDouble()));
        }
        if (type == 6) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new double[0]);
        }
        if (type == 7) {
            return Float.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getFloat()));
        }
        if (type == 8) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new float[0]);
        }
        if (type == 9) {
            return Integer.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getInteger()));
        }
        if (type == 10) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new int[0]);
        }
        if (type == 11) {
            return Long.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getLong()));
        }
        if (type == 12) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new long[0]);
        }
        if (type == 13) {
            return Short.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getShort()));
        }
        if (type == 14) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new short[0]);
        }
        if (type == 16) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new String[0]);
        }
        return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getString());
    }
}

