/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStorageLink;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStorageLinkLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.BaseStorageAdapter;
import com.liferay.portlet.dynamicdatamapping.storage.ExpandoValueBeanResolver;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.query.ComparisonOperator;
import com.liferay.portlet.dynamicdatamapping.storage.query.Condition;
import com.liferay.portlet.dynamicdatamapping.storage.query.FieldCondition;
import com.liferay.portlet.dynamicdatamapping.storage.query.Junction;
import com.liferay.portlet.dynamicdatamapping.storage.query.LogicalOperator;
import com.liferay.portlet.expando.NoSuchTableException;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoRow;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoRowLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoTableLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandoStorageAdapter
extends BaseStorageAdapter {
    private static Log _log = LogFactoryUtil.getLog(ExpandoStorageAdapter.class);

    protected long doCreate(long companyId, long ddmStructureId, Fields fields, ServiceContext serviceContext) throws Exception {
        ExpandoTable expandoTable = this._getExpandoTable(companyId, ddmStructureId, fields);
        ExpandoRow expandoRow = ExpandoRowLocalServiceUtil.addRow((long)expandoTable.getTableId(), (long)CounterLocalServiceUtil.increment());
        this._updateFields(expandoTable, expandoRow.getClassPK(), fields);
        DDMStorageLinkLocalServiceUtil.addStorageLink((long)expandoTable.getClassNameId(), (long)expandoRow.getRowId(), (long)ddmStructureId, (ServiceContext)serviceContext);
        return expandoRow.getRowId();
    }

    protected void doDeleteByClass(long classPK) throws Exception {
        ExpandoRowLocalServiceUtil.deleteRow((long)classPK);
        DDMStorageLinkLocalServiceUtil.deleteClassStorageLink((long)classPK);
    }

    protected void doDeleteByDDMStructure(long ddmStructureId) throws Exception {
        List ddmStorageLinks = DDMStorageLinkLocalServiceUtil.getStructureStorageLinks((long)ddmStructureId);
        for (DDMStorageLink ddmStorageLink : ddmStorageLinks) {
            ExpandoRowLocalServiceUtil.deleteRow((long)ddmStorageLink.getClassPK());
        }
        DDMStorageLinkLocalServiceUtil.deleteStructureStorageLinks((long)ddmStructureId);
    }

    protected List<Fields> doGetFieldsListByClasses(long ddmStructureId, long[] classPKs, List<String> fieldNames, OrderByComparator orderByComparator) throws Exception {
        return this._doQuery(ddmStructureId, classPKs, fieldNames, null, orderByComparator);
    }

    protected List<Fields> doGetFieldsListByDDMStructure(long ddmStructureId, List<String> fieldNames, OrderByComparator orderByComparator) throws Exception {
        return this._doQuery(ddmStructureId, fieldNames, null, orderByComparator);
    }

    protected Map<Long, Fields> doGetFieldsMapByClasses(long ddmStructureId, long[] classPKs, List<String> fieldNames) throws Exception {
        return this._doQuery(ddmStructureId, classPKs, fieldNames);
    }

    protected List<Fields> doQuery(long ddmStructureId, List<String> fieldNames, Condition condition, OrderByComparator orderByComparator) throws Exception {
        return this._doQuery(ddmStructureId, fieldNames, condition, orderByComparator);
    }

    protected int doQueryCount(long ddmStructureId, Condition condition) throws Exception {
        long[] expandoRowIds;
        Expression expression = null;
        if (condition != null) {
            expression = this._parseExpression(condition);
        }
        int count = 0;
        long[] lArray = expandoRowIds = this._getExpandoRowIds(ddmStructureId);
        int n = expandoRowIds.length;
        int n2 = 0;
        while (n2 < n) {
            long expandoRowId = lArray[n2];
            List expandoValues = ExpandoValueLocalServiceUtil.getRowValues((long)expandoRowId);
            if (expression == null || expression != null && this._booleanValueOf(expression, expandoValues)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    protected void doUpdate(long classPK, Fields fields, boolean mergeFields, ServiceContext serviceContext) throws Exception {
        ExpandoRow expandoRow = ExpandoRowLocalServiceUtil.getRow((long)classPK);
        DDMStorageLink ddmStorageLink = DDMStorageLinkLocalServiceUtil.getClassStorageLink((long)expandoRow.getRowId());
        ExpandoTable expandoTable = this._getExpandoTable(expandoRow.getCompanyId(), ddmStorageLink.getStructureId(), fields);
        List expandoColumns = ExpandoColumnLocalServiceUtil.getColumns((long)expandoTable.getTableId());
        if (!mergeFields) {
            for (ExpandoColumn expandoColumn : expandoColumns) {
                if (fields.contains(expandoColumn.getName())) continue;
                ExpandoValueLocalServiceUtil.deleteValue((long)expandoColumn.getColumnId(), (long)expandoRow.getRowId());
            }
        }
        this._updateFields(expandoTable, expandoRow.getClassPK(), fields);
    }

    private boolean _booleanValueOf(Expression expression, List<ExpandoValue> expandoValues) {
        try {
            StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
            standardEvaluationContext.setBeanResolver((BeanResolver)new ExpandoValueBeanResolver(expandoValues));
            return (Boolean)expression.getValue((EvaluationContext)standardEvaluationContext, Boolean.class);
        }
        catch (EvaluationException ee) {
            _log.error((Object)"Unable to evaluate expression", (Throwable)ee);
            return false;
        }
    }

    private void _checkExpandoColumns(long ddmStructureId, ExpandoTable expandoTable, Fields fields) throws PortalException, SystemException {
        for (String name : fields.getNames()) {
            ExpandoColumn expandoColumn = ExpandoColumnLocalServiceUtil.getColumn((long)expandoTable.getTableId(), (String)name);
            if (expandoColumn != null) continue;
            int type = this._getExpandoColumnType(ddmStructureId, name);
            ExpandoColumnLocalServiceUtil.addColumn((long)expandoTable.getTableId(), (String)name, (int)type);
        }
    }

    private List<Fields> _doQuery(long ddmStructureId, List<String> fieldNames, Condition condition, OrderByComparator orderByComparator) throws Exception {
        return this._doQuery(ddmStructureId, this._getExpandoRowIds(ddmStructureId), fieldNames, condition, orderByComparator);
    }

    private Map<Long, Fields> _doQuery(long ddmStructureId, long[] classPKs, List<String> fieldNames) throws Exception {
        HashMap<Long, Fields> fieldsMap = new HashMap<Long, Fields>();
        List<Fields> fieldsList = this._doQuery(ddmStructureId, classPKs, fieldNames, null, null);
        int i = 0;
        while (i < fieldsList.size()) {
            Fields fields = fieldsList.get(i);
            fieldsMap.put(classPKs[i], fields);
            ++i;
        }
        return fieldsMap;
    }

    private List<Fields> _doQuery(long ddmStructureId, long[] expandoRowIds, List<String> fieldNames, Condition condition, OrderByComparator orderByComparator) throws Exception {
        ArrayList<Fields> fieldsList = new ArrayList<Fields>();
        Expression expression = null;
        if (condition != null) {
            expression = this._parseExpression(condition);
        }
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        long[] lArray = expandoRowIds;
        int n = expandoRowIds.length;
        int n2 = 0;
        while (n2 < n) {
            long expandoRowId = lArray[n2];
            List expandoValues = ExpandoValueLocalServiceUtil.getRowValues((long)expandoRowId);
            if (expression == null || expression != null && this._booleanValueOf(expression, expandoValues)) {
                Fields fields = new Fields();
                for (ExpandoValue expandoValue : expandoValues) {
                    ExpandoColumn column = expandoValue.getColumn();
                    String fieldName = column.getName();
                    Serializable fieldValue = expandoValue.getSerializable();
                    if (!ddmStructure.hasField(fieldName) || fieldNames != null && (fieldNames == null || !fieldNames.contains(fieldName))) continue;
                    Field field = new Field(ddmStructureId, fieldName, fieldValue);
                    fields.put(field);
                }
                fieldsList.add(fields);
            }
            ++n2;
        }
        if (orderByComparator != null) {
            Collections.sort(fieldsList, orderByComparator);
        }
        return fieldsList;
    }

    private int _getExpandoColumnType(long ddmStructureId, String name) throws PortalException, SystemException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        String fieldDataType = ddmStructure.getFieldDataType(name);
        if (fieldDataType.equals("boolean")) {
            return 1;
        }
        if (fieldDataType.equals("date")) {
            return 3;
        }
        if (fieldDataType.equals("double")) {
            return 5;
        }
        if (fieldDataType.equals("float")) {
            return 7;
        }
        if (fieldDataType.equals("integer")) {
            return 9;
        }
        if (fieldDataType.equals("long")) {
            return 11;
        }
        if (fieldDataType.equals("number")) {
            return 17;
        }
        if (fieldDataType.equals("short")) {
            return 13;
        }
        return 15;
    }

    private long[] _getExpandoRowIds(long ddmStructureId) throws SystemException {
        ArrayList<Long> expandoRowIds = new ArrayList<Long>();
        List ddmStorageLinks = DDMStorageLinkLocalServiceUtil.getStructureStorageLinks((long)ddmStructureId);
        for (DDMStorageLink ddmStorageLink : ddmStorageLinks) {
            expandoRowIds.add(ddmStorageLink.getClassPK());
        }
        return ArrayUtil.toArray((Long[])expandoRowIds.toArray(new Long[expandoRowIds.size()]));
    }

    private ExpandoTable _getExpandoTable(long companyId, long ddmStructureId, Fields fields) throws PortalException, SystemException {
        ExpandoTable expandoTable = null;
        long classNameId = PortalUtil.getClassNameId((String)ExpandoStorageAdapter.class.getName());
        try {
            expandoTable = ExpandoTableLocalServiceUtil.getTable((long)companyId, (long)classNameId, (String)String.valueOf(ddmStructureId));
        }
        catch (NoSuchTableException noSuchTableException) {
            expandoTable = ExpandoTableLocalServiceUtil.addTable((long)companyId, (long)classNameId, (String)String.valueOf(ddmStructureId));
        }
        this._checkExpandoColumns(ddmStructureId, expandoTable, fields);
        return expandoTable;
    }

    private Expression _parseExpression(Condition condition) {
        String expression = this._toExpression(condition);
        try {
            SpelExpressionParser expressionParser = new SpelExpressionParser();
            return expressionParser.parseExpression(expression);
        }
        catch (ParseException pe) {
            _log.error((Object)("Unable to parse expression " + expression), (Throwable)pe);
            return null;
        }
    }

    private String _toExpression(Condition condition) {
        if (condition.isJunction()) {
            Junction junction = (Junction)condition;
            return "(".concat(this._toExpression(junction)).concat(")");
        }
        FieldCondition fieldCondition = (FieldCondition)condition;
        return this._toExpression(fieldCondition);
    }

    private String _toExpression(FieldCondition fieldCondition) {
        StringBundler sb = new StringBundler(5);
        sb.append("(@");
        sb.append(fieldCondition.getName());
        ComparisonOperator comparisonOperator = fieldCondition.getComparisonOperator();
        if (comparisonOperator.equals((Object)ComparisonOperator.LIKE)) {
            sb.append(".data matches ");
        } else {
            sb.append(".data == ");
        }
        String value = StringUtil.quote((String)String.valueOf(fieldCondition.getValue()));
        sb.append(value);
        sb.append(")");
        return sb.toString();
    }

    private String _toExpression(Junction junction) {
        StringBundler sb = new StringBundler();
        LogicalOperator logicalOperator = junction.getLogicalOperator();
        Iterator itr = junction.iterator();
        while (itr.hasNext()) {
            Condition condition = (Condition)itr.next();
            sb.append(this._toExpression(condition));
            if (!itr.hasNext()) continue;
            sb.append(" ");
            sb.append(logicalOperator.toString());
            sb.append(" ");
        }
        return sb.toString();
    }

    private void _updateFields(ExpandoTable expandoTable, long classPK, Fields fields) throws PortalException, SystemException {
        for (Field field : fields) {
            ExpandoValueLocalServiceUtil.addValue((long)expandoTable.getCompanyId(), (String)ExpandoStorageAdapter.class.getName(), (String)expandoTable.getName(), (String)field.getName(), (long)classPK, (Object)field.getValue());
        }
    }
}

