/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.BaseFieldRenderer;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import java.io.Serializable;
import java.util.Locale;

public class DocumentLibraryFieldRenderer
extends BaseFieldRenderer {
    private static Log _log = LogFactoryUtil.getLog(DocumentLibraryFieldRenderer.class);

    protected String doRender(ThemeDisplay themeDisplay, Field field) {
        Serializable fieldValue = field.getValue();
        if (Validator.isNull((Object)fieldValue) || fieldValue.equals(JSONFactoryUtil.getNullJSON())) {
            return "";
        }
        JSONObject fieldValueJSONObject = null;
        try {
            fieldValueJSONObject = JSONFactoryUtil.createJSONObject((String)String.valueOf(fieldValue));
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsone);
            }
            return "";
        }
        long fileEntryGroupId = fieldValueJSONObject.getLong("groupId");
        String fileEntryUUID = fieldValueJSONObject.getString("uuid");
        try {
            FileEntry fileEntry = DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)fileEntryUUID, (long)fileEntryGroupId);
            return fileEntry.getTitle();
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                return LanguageUtil.format((Locale)themeDisplay.getLocale(), (String)"is-temporarily-unavailable", (Object)"content");
            }
            return "";
        }
    }
}

