/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMTemplateServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMPermission;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMTemplatePermission;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDMTemplateServiceImpl
extends DDMTemplateServiceBaseImpl {
    public DDMTemplate addTemplate(long groupId, long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, ServiceContext serviceContext) throws PortalException, SystemException {
        String ddmResource = GetterUtil.getString((Object)serviceContext.getAttribute("ddmResource"));
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmResource, "ADD_TEMPLATE");
        return this.ddmTemplateLocalService.addTemplate(this.getUserId(), groupId, structureId, nameMap, descriptionMap, type, mode, language, script, serviceContext);
    }

    public List<DDMTemplate> copyTemplates(long structureId, long newStructureId, String type, ServiceContext serviceContext) throws PortalException, SystemException {
        String ddmResource = GetterUtil.getString((Object)serviceContext.getAttribute("ddmResource"));
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmResource, "ADD_TEMPLATE");
        return this.ddmTemplateLocalService.copyTemplates(this.getUserId(), structureId, newStructureId, type, serviceContext);
    }

    public void deleteTemplate(long templateId) throws PortalException, SystemException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "DELETE");
        this.ddmTemplateLocalService.deleteTemplate(templateId);
    }

    public DDMTemplate getTemplate(long templateId) throws PortalException, SystemException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplateLocalService.getTemplate(templateId);
    }

    public List<DDMTemplate> getTemplates(long structureId, String type, String mode) throws SystemException {
        return this.ddmTemplatePersistence.findByS_T_M(structureId, type, mode);
    }

    public DDMTemplate updateTemplate(long templateId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "UPDATE");
        return this.ddmTemplateLocalService.updateTemplate(templateId, nameMap, descriptionMap, type, mode, language, script, serviceContext);
    }
}

