/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMStructureServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMPermission;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMStructurePermission;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDMStructureServiceImpl
extends DDMStructureServiceBaseImpl {
    public DDMStructure addStructure(long groupId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, String storageType, int type, ServiceContext serviceContext) throws PortalException, SystemException {
        String ddmResource = GetterUtil.getString((Object)serviceContext.getAttribute("ddmResource"));
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmResource, "ADD_STRUCTURE");
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, classNameId, structureKey, nameMap, descriptionMap, xsd, storageType, type, serviceContext);
    }

    public DDMStructure copyStructure(long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException, SystemException {
        String ddmResource = GetterUtil.getString((Object)serviceContext.getAttribute("ddmResource"));
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmResource, "ADD_STRUCTURE");
        return this.ddmStructureLocalService.copyStructure(this.getUserId(), structureId, nameMap, descriptionMap, serviceContext);
    }

    public void deleteStructure(long structureId) throws PortalException, SystemException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "DELETE");
        this.ddmStructureLocalService.deleteStructure(structureId);
    }

    public DDMStructure fetchStructure(long groupId, String structureKey) throws PortalException, SystemException {
        DDMStructure ddmStructure = this.ddmStructurePersistence.fetchByG_S(groupId, structureKey);
        if (ddmStructure != null) {
            DDMStructurePermission.check(this.getPermissionChecker(), ddmStructure, "VIEW");
        }
        return ddmStructure;
    }

    public DDMStructure getStructure(long structureId) throws PortalException, SystemException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure updateStructure(long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(structureId, nameMap, descriptionMap, xsd, serviceContext);
    }

    public DDMStructure updateStructure(long groupId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructurePermission.check(this.getPermissionChecker(), groupId, structureKey, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(groupId, structureKey, nameMap, descriptionMap, xsd, serviceContext);
    }
}

