/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.RequiredStructureException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateElementException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateStructureKeyException;
import com.liferay.portlet.dynamicdatamapping.StructureNameException;
import com.liferay.portlet.dynamicdatamapping.StructureXsdException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMStructureLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDMStructureLocalServiceImpl
extends DDMStructureLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DDMStructureLocalServiceImpl.class);

    public DDMStructure addStructure(long userId, long groupId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, String storageType, int type, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (Validator.isNull((String)structureKey)) {
            structureKey = String.valueOf(this.counterLocalService.increment());
        }
        try {
            xsd = DDMXMLUtil.formatXML((String)xsd);
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
        Date now = new Date();
        this.validate(groupId, structureKey, nameMap, xsd);
        long structureId = this.counterLocalService.increment();
        DDMStructure structure = this.ddmStructurePersistence.create(structureId);
        structure.setUuid(serviceContext.getUuid());
        structure.setGroupId(serviceContext.getScopeGroupId());
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setCreateDate(serviceContext.getCreateDate(now));
        structure.setModifiedDate(serviceContext.getModifiedDate(now));
        structure.setClassNameId(classNameId);
        structure.setStructureKey(structureKey);
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setXsd(xsd);
        structure.setStorageType(storageType);
        structure.setType(type);
        this.ddmStructurePersistence.update((BaseModel)structure, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addStructureResources(structure, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addStructureResources(structure, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return structure;
    }

    public void addStructureResources(DDMStructure structure, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), DDMStructure.class.getName(), structure.getStructureId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addStructureResources(DDMStructure structure, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), DDMStructure.class.getName(), structure.getStructureId(), groupPermissions, guestPermissions);
    }

    public DDMStructure copyStructure(long userId, long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure structure = this.getStructure(structureId);
        return this.addStructure(userId, structure.getGroupId(), structure.getClassNameId(), null, nameMap, descriptionMap, structure.getXsd(), structure.getStorageType(), structure.getType(), serviceContext);
    }

    public void deleteStructure(DDMStructure structure) throws PortalException, SystemException {
        if (this.ddmStructureLinkPersistence.countByStructureId(structure.getStructureId()) > 0) {
            throw new RequiredStructureException();
        }
        this.ddmStructurePersistence.remove((BaseModel)structure);
        this.resourceLocalService.deleteResource(structure.getCompanyId(), DDMStructure.class.getName(), 4, structure.getStructureId());
    }

    public void deleteStructure(long structureId) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        this.deleteStructure(structure);
    }

    public void deleteStructure(long groupId, String structureKey) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.findByG_S(groupId, structureKey);
        this.deleteStructure(structure);
    }

    public void deleteStructures(long groupId) throws PortalException, SystemException {
        List structures = this.ddmStructurePersistence.findByGroupId(groupId);
        for (DDMStructure structure : structures) {
            this.deleteStructure(structure);
        }
    }

    public DDMStructure fetchStructure(long structureId) throws SystemException {
        return this.ddmStructurePersistence.fetchByPrimaryKey(structureId);
    }

    public DDMStructure fetchStructure(long groupId, String structureKey) throws SystemException {
        return this.ddmStructurePersistence.fetchByG_S(groupId, structureKey);
    }

    public List<DDMStructure> getClassStructures(long classNameId) throws SystemException {
        return this.ddmStructurePersistence.findByClassNameId(classNameId);
    }

    public List<DDMStructure> getClassStructures(long classNameId, int start, int end) throws SystemException {
        return this.ddmStructurePersistence.findByClassNameId(classNameId, start, end);
    }

    public List<DDMStructure> getClassStructures(long classNameId, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmStructurePersistence.findByClassNameId(classNameId, -1, -1, orderByComparator);
    }

    public List<DDMStructure> getDLFileEntryTypeStructures(long dlFileEntryTypeId) throws SystemException {
        return this.dlFileEntryTypePersistence.getDDMStructures(dlFileEntryTypeId);
    }

    public DDMStructure getStructure(long structureId) throws PortalException, SystemException {
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure getStructure(long groupId, String structureKey) throws PortalException, SystemException {
        return this.ddmStructurePersistence.findByG_S(groupId, structureKey);
    }

    public List<DDMStructure> getStructure(long groupId, String name, String description) throws SystemException {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    public List<DDMStructure> getStructureEntries() throws SystemException {
        return this.ddmStructurePersistence.findAll();
    }

    public List<DDMStructure> getStructureEntries(long groupId) throws SystemException {
        return this.ddmStructurePersistence.findByGroupId(groupId);
    }

    public List<DDMStructure> getStructureEntries(long groupId, int start, int end) throws SystemException {
        return this.ddmStructurePersistence.findByGroupId(groupId, start, end);
    }

    public int getStructureEntriesCount(long groupId) throws SystemException {
        return this.ddmStructurePersistence.countByGroupId(groupId);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long[] classNameIds, String keywords, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmStructureFinder.findByKeywords(companyId, groupIds, classNameIds, keywords, start, end, orderByComparator);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long[] classNameIds, String name, String description, String storageType, int type, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmStructureFinder.findByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, storageType, type, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, String keywords) throws SystemException {
        return this.ddmStructureFinder.countByKeywords(companyId, groupIds, classNameIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, String name, String description, String storageType, int type, boolean andOperator) throws SystemException {
        return this.ddmStructureFinder.countByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, storageType, type, andOperator);
    }

    public DDMStructure updateStructure(long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.doUpdateStructure(nameMap, descriptionMap, xsd, serviceContext, structure);
    }

    public DDMStructure updateStructure(long groupId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.findByG_S(groupId, structureKey);
        return this.doUpdateStructure(nameMap, descriptionMap, xsd, serviceContext, structure);
    }

    protected void appendNewStructureRequiredFields(DDMStructure structure, Document templateDocument) {
        String xsd = structure.getXsd();
        Document structureDocument = null;
        try {
            structureDocument = SAXReaderUtil.read((String)xsd);
        }
        catch (DocumentException de) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)de, (Throwable)de);
            }
            return;
        }
        Element templateElement = templateDocument.getRootElement();
        XPath structureXPath = SAXReaderUtil.createXPath((String)"//dynamic-element[.//meta-data/entry[@name=\"required\"]=\"true\"]");
        List nodes = structureXPath.selectNodes((Object)structureDocument);
        for (Element element : nodes) {
            String name = element.attributeValue("name");
            XPath templateXPath = SAXReaderUtil.createXPath((String)("//dynamic-element[@name=\"" + name + "\"]"));
            if (templateXPath.booleanValueOf((Object)templateDocument)) continue;
            templateElement.add(element.createCopy());
        }
    }

    protected DDMStructure doUpdateStructure(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext, DDMStructure structure) throws PortalException, SystemException {
        try {
            xsd = DDMXMLUtil.formatXML((String)xsd);
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
        this.validate(nameMap, xsd);
        structure.setModifiedDate(serviceContext.getModifiedDate(null));
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setXsd(xsd);
        this.ddmStructurePersistence.update((BaseModel)structure, false);
        this.syncStructureTemplatesFields(structure);
        return structure;
    }

    protected void syncStructureTemplatesFields(DDMStructure structure) throws PortalException, SystemException {
        List templates = this.ddmTemplateLocalService.getTemplates(structure.getStructureId(), "detail");
        for (DDMTemplate template : templates) {
            String script = template.getScript();
            Document templateDocument = null;
            try {
                templateDocument = SAXReaderUtil.read((String)script);
            }
            catch (DocumentException de) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)de, (Throwable)de);
                continue;
            }
            Element templateRootElement = templateDocument.getRootElement();
            this.syncStructureTemplatesFields(template, templateRootElement);
            this.appendNewStructureRequiredFields(structure, templateDocument);
            try {
                script = DDMXMLUtil.formatXML((String)templateDocument.asXML());
            }
            catch (Exception exception) {
                throw new StructureXsdException();
            }
            template.setScript(script);
            this.ddmTemplatePersistence.update((BaseModel)template, false);
        }
    }

    protected void syncStructureTemplatesFields(DDMTemplate template, Element templateElement) throws PortalException, SystemException {
        DDMStructure structure = template.getStructure();
        List dynamicElementElements = templateElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            String dataType = dynamicElementElement.attributeValue("dataType");
            String fieldName = dynamicElementElement.attributeValue("name");
            if (Validator.isNull((String)dataType)) continue;
            if (!structure.hasField(fieldName)) {
                templateElement.remove(dynamicElementElement);
                continue;
            }
            String mode = template.getMode();
            if (mode.equals("create")) {
                boolean fieldRequired = structure.getFieldRequired(fieldName);
                List metadataElements = dynamicElementElement.elements("meta-data");
                for (Element metadataElement : metadataElements) {
                    for (Element metadataEntryElement : metadataElement.elements()) {
                        String attributeName = metadataEntryElement.attributeValue("name");
                        if (!fieldRequired || !attributeName.equals("required")) continue;
                        metadataEntryElement.setText("true");
                    }
                }
            }
            this.syncStructureTemplatesFields(template, dynamicElementElement);
        }
    }

    protected void validate(List<Element> elements, Set<String> names) throws PortalException {
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("meta-data")) continue;
            String name = element.attributeValue("name", "");
            String type = element.attributeValue("type", "");
            if (Validator.isNull((String)name) || name.startsWith("reserved")) {
                throw new StructureXsdException();
            }
            char[] charArray = name.toCharArray();
            int i = 0;
            while (i < charArray.length) {
                if (!Character.isLetterOrDigit(charArray[i]) && charArray[i] != '-' && charArray[i] != '_') {
                    throw new StructureXsdException();
                }
                ++i;
            }
            String path = name;
            Element parentElement = element.getParent();
            while (!parentElement.isRootElement()) {
                path = String.valueOf(parentElement.attributeValue("name", "")) + "/" + path;
                parentElement = parentElement.getParent();
            }
            if (names.contains(path = path.toLowerCase())) {
                throw new StructureDuplicateElementException();
            }
            names.add(path);
            if (Validator.isNull((String)type)) {
                throw new StructureXsdException();
            }
            this.validate(element.elements(), names);
        }
    }

    protected void validate(long groupId, String structureKey, Map<Locale, String> nameMap, String xsd) throws PortalException, SystemException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_S(groupId, structureKey);
        if (structure != null) {
            throw new StructureDuplicateStructureKeyException();
        }
        this.validate(nameMap, xsd);
    }

    protected void validate(Map<Locale, String> nameMap, String xsd) throws PortalException {
        this.validateName(nameMap);
        if (Validator.isNull((String)xsd)) {
            throw new StructureXsdException();
        }
        try {
            ArrayList<Element> elements = new ArrayList<Element>();
            Document document = SAXReaderUtil.read((String)xsd);
            Element rootElement = document.getRootElement();
            if (rootElement.elements().isEmpty()) {
                throw new StructureXsdException();
            }
            elements.addAll(rootElement.elements());
            HashSet<String> elNames = new HashSet<String>();
            this.validate(elements, elNames);
        }
        catch (StructureDuplicateElementException fdsee) {
            throw fdsee;
        }
        catch (StructureXsdException sxe) {
            throw sxe;
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
    }

    protected void validateName(Map<Locale, String> nameMap) throws PortalException {
        String name = nameMap.get(LocaleUtil.getDefault());
        if (Validator.isNull((String)name)) {
            throw new StructureNameException();
        }
    }
}

